/* 
  USAGE:   cykl  FILE COMMAND

  The following REXX program displays does forever (till Ctrl/C or kill):
    - waits till FILE changes its size or time (i.e. till saving on the disk)
    - then it runs COMMAND

  IMPORTANT: if COMMAND is .cmd file, then it must be COMMAND = call the_command

  Main purpose with example:
  cykl seminar.tex cslatex seminar
    => - wait till you save file  seminar.tex  from the editor, then run 
         LaTeX on it (and dvipm updates the page, WONDERFUL TeX-ING!
  Another example:
  cykl hello.c call make

  Problems(?): CPU load measured by some apps is 100%. How to cheat them?
  Try to use cykl!.cmd.

  Written by Petr Mikulik@sci.muni.cz, Brno, Dec 1995 / Jan 1996
  Je to muj prvni REXX program, hura, a konecne jede!
*/

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

parse arg WhichFile WhichCommand
Call On Halt Name SignalHandler

/* convert slashes to backslahes if exist in the filename */
/* do forever i=pos('/',WhichFile) if (i=0) then leave WhichFile=overlay('\',WhichFile,i) end */
WhichFile = translate(WhichFile,'\','/') /* convert from unix format */

OldTime = ' '
OldSize = ' '
do forever
  call SysFileTree WhichFile, 'file', 'FT'
  NewTime = translate(word(file.1,1))
  NewSize = translate(word(file.1,2))
  if ((Compare(NewTime,OldTime)\=0) | (Compare(NewSize,OldSize)\=0)) then 
    do 
    call SysFileTree WhichFile, 'file', 'FT' /* cannot Old := New   */
    OldTime = translate(word(file.1,1))      /* due to strange zero */
    OldSize = translate(word(file.1,2))      /* filesize            */
    WhichCommand
    say "Cykl: Waiting for file change... (or Ctrl/C)"
    end
end
SignalHandler:
