/* 
  USAGE:   cykl!  FILE COMMAND

  The following REXX program does forever (till Ctrl/C or kill):
    - waits till FILE changes its size or time (i.e. till saving on the disk)
    - then it runs COMMAND

  IMPORTANT: if COMMAND is .cmd file, then it must be COMMAND = call the_command

  Requirements: priority.exe program from fm2utils (or any equivalent). 
    This makes the difference between cykl!.cmd and cykl.cmd

  Main purpose with example:
  cykl! seminar.tex call cslatex seminar
    => - wait till you save file  seminar.tex  from the editor, then run 
         LaTeX on it (and dvipm updates the page, WONDERFUL TeX-ING!

  Another example:
  cykl! hello.c make

  Written by Petr Mikulik@sci.muni.cz, Brno, Dec 1995/Jan 1996
  Je to muj prvni REXX program, hura, a konecne jede!
*/

/*'@echo off'*/
call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

Call On Halt Name SignalHandler
parse arg WhichFile WhichCommand

WhichFile = translate(WhichFile,'\','/') /* convert from unix format */

OldTime = ' '
OldSize = ' '
do forever
  call SysFileTree WhichFile, 'file', 'FT'
  OldTime = translate(word(file.1,1))
  OldSize = translate(word(file.1,2))
  WhichCommand
  say "-----------------------------------------------------"
  say "Cykl: Waiting for file change... (or close or Ctrl/C)"
  priority 1 0 call cykl_in.cmd WhichFile OldTime OldSize
end
end
SignalHandler:
