/* solaris.io    IO porting code for Sun sparc1 on Solaris OS*/
 
#include <stdio.h>
#include <stdlib.h>
#include <curses.h>
#include <term.h>
#include <string.h>
#include <ctype.h>
#include <unistd.h>

/*----------------------------------------------------------------------
**                M A C R O S
**----------------------------------------------------------------------
*/
 
#define io_MAX_VALID_CHARACTER 126
#define io_MIN_VALID_CHARACTER  32
#define io_MIXED_CASE_FILENAMES 1

#define io_CTRL_A 1
#define io_CTRL_B 2
#define io_CTRL_C 3
#define io_CTRL_D 4
#define io_CTRL_E 5
#define io_CTRL_F 6
#define io_CTRL_G 7
#define io_CTRL_H 8
#define io_CTRL_I 9
#define io_CTRL_J 10
#define io_CTRL_K 11
#define io_CTRL_L 12
#define io_CTRL_M 13
#define io_CTRL_N 14
#define io_CTRL_O 15
#define io_CTRL_P 16
#define io_CTRL_Q 17
#define io_CTRL_R 18
#define io_CTRL_T 20
#define io_CTRL_U 21
#define io_CTRL_V 22
#define io_CTRL_W 23
#define io_CTRL_X 24
#define io_CTRL_Y 25
#define io_CTRL_Z 26
#define io_ESCAPE 27
 
#define io_F1 KEY_F(1)
#define io_F2 KEY_F(2)
#define io_F3 KEY_F(3)
#define io_F4 KEY_F(4)
#define io_F5 KEY_F(5)
#define io_F6 KEY_F(6)
#define io_F7 KEY_F(7)
#define io_F8 KEY_F(8)
#define io_F9 KEY_F(9)
#define io_F10 KEY_F(10)
 
#define io_PAGEUP    KEY_PPAGE
#define io_PAGEDOWN  KEY_NPAGE
#define io_UP        KEY_UP
#define io_DOWN      KEY_DOWN
#define io_RIGHT     KEY_RIGHT
#define io_LEFT      KEY_LEFT
#define io_BACKSPACE KEY_BACKSPACE
#define io_HOME      KEY_HOME
#define io_END       5
#define io_TAB       9
#define io_ENTER     KEY_ENTER
#define io_DELETE    KEY_DC 

#define io_A 65
#define io_B 66
#define io_C 67
#define io_D 68
#define io_E 69
#define io_F 70
#define io_G 71
#define io_H 72
#define io_I 73
#define io_J 74
#define io_K 75
#define io_L 76
#define io_M 77
#define io_N 78
#define io_O 79
#define io_P 80
#define io_Q 81
#define io_R 82
#define io_S 83
#define io_T 84
#define io_U 85
#define io_V 86
#define io_W 87
#define io_X 88
#define io_Y 89
#define io_Z 90


#define io_a 97
#define io_b 98
#define io_c 99
#define io_d 100
#define io_e 101
#define io_f 102
#define io_g 103
#define io_h 104
#define io_i 105
#define io_j 106
#define io_k 107
#define io_l 108
#define io_m 109
#define io_n 110
#define io_o 111
#define io_p 112
#define io_q 113
#define io_r 114
#define io_s 115
#define io_t 116
#define io_u 117
#define io_v 118
#define io_w 119
#define io_x 120
#define io_y 121
#define io_z 122

#define io_MINUS 45
#define io_STAR 42
#define io_PLUS 43
#define io_SLASH 47
#define io_CARET 94
#define io_SPACE 32
#define io_EQUAL 61

#define io_CSR_INSERT     1
#define io_CSR_BLANK      0
#define io_CSR_TYPEOVER  -1

 
#define io_printf            printw
#define io_gotoxy(a,b)       move((b)-1,(a)-1)
#define io_clrscr()          clear();refresh()
#define io_refresh()         refresh()
#define io_inchar()          getch()
 
#define io_flush_keyboard()  fflush(stdin)
#define io_unlink            unlink
#define io_puts              addstr
#define io_putc              addch

char obuf[2000];
 
void io_init(void);
void io_end(void);
 
void io_init(void)
{
   int i;
 
   setbuf(stdout,obuf);
 
   initscr();
   clear();
   nonl();
   cbreak();
   noecho();
   keypad( stdscr, TRUE );
   intrflush( stdscr, FALSE );
/*   stdscr->_nodelay = 0; */  /* may need _notimeout = 0 or 1 */
   stdscr->_delay = -1;
/*   stdscr->_use_keypad=0; */
   stdscr->_scroll = 0;
}
 
void io_end(void)
{
   clear();
   refresh();
   endwin();
}
 

