Attribute VB_Name = "SECURITY_inc"
' definition for encrypt/decrypt
Public Const ENCRYPT_LEVEL_0 = 0
Public Const ENCRYPT_LEVEL_1 = 1
Public Const ENCRYPT_LEVEL_2 = 2
Public Const ENCRYPT_LEVEL_3 = 3
Public Const ENCRYPT_LEVEL_4 = 4

' definition for FILECRC32
Public Const OPEN_MODE_BINARY = 0
Public Const OPEN_MODE_TEXT = 1

#If Win16 Then

' structure for serialization
Type tagSERIALDATA
   Description1      As String * 50       'serialization description 1
   Description2      As String * 50       'serialization description 2
   Number            As Long              'serialization number
   Dummy             As String * 50       'reserved for future use
End Type

' structure for media-id
Type tagDOSMEDIAID
   InfoLevel            As Integer
   SerialNumber         As Long
   VolLabel             As String * 11
   FileSysType          As String * 8
End Type

#Else

' structure for serialization
Type tagSERIALDATA
   Description1      As String * 52       'serialization description 1
   Description2      As String * 52       'serialization description 2
   Number            As Long              'serialization number
   Dummy             As String * 52       'reserved for future use
End Type

' structure for media-id
Type tagDOSMEDIAID
   InfoLevel            As String * 2     'use cCVI for integer conversion
   SerialNumber         As String * 4     'use cCVL for long conversion
   VolLabel             As String * 11
   FileSysType          As String * 8
End Type

#End If

#If Win16 Then

Declare Function cGetVersion Lib "mcsec-16.dll" () As Single

Declare Function cIsSerial Lib "mcsec-16.dll" (ByVal file1 As String) As Integer
Declare Function cSerialGet Lib "mcsec-16.dll" (ByVal file As String, SERIALDATA As tagSERIALDATA) As Integer
Declare Function cSerialInc Lib "mcsec-16.dll" (ByVal file As String, ByVal Increment As Long) As Integer
Declare Function cSerialPut Lib "mcsec-16.dll" (ByVal file As String, SERIALDATA As tagSERIALDATA) As Integer
Declare Function cSerialRmv Lib "mcsec-16.dll" (ByVal file As String) As Integer

Declare Function cHashMD5 Lib "mcsec-16.dll" (Text As String) As String
Declare Function cRegistrationKey Lib "mcsec-16.dll" (ByVal RegString As String, ByVal RegCode As Long) As Long

Declare Function cFileCRC32 Lib "mcsec-16.dll" (ByVal lpFilename As String, ByVal Mode As Integer) As Long
Declare Function cStringCRC32 Lib "mcsec-16.dll" (Txt As String) As Long

Declare Function cDecrypt Lib "mcsec-16.dll" (Txt As String, password As String, ByVal level As Integer) As String
Declare Function cEncrypt Lib "mcsec-16.dll" (Txt As String, password As String, ByVal level As Integer) As String

Declare Function cFileDecrypt Lib "mcsec-16.dll" (ByVal file1 As String, ByVal file2 As String, password As String, ByVal level As Integer) As Long
Declare Function cFileEncrypt Lib "mcsec-16.dll" (ByVal file1 As String, ByVal file2 As String, password As String, ByVal level As Integer) As Long

Declare Function cDOSGetMediaID Lib "mcsec-16.dll" (ByVal nDrive As String, DOSMEDIAID As tagDOSMEDIAID) As Integer
Declare Function cDOSSetMediaID Lib "mcsec-16.dll" (ByVal nDrive As String, DOSMEDIAID As tagDOSMEDIAID) As Integer

#Else

Declare Function cGetVersion Lib "mcsec-32.dll" () As Single

Declare Function cIsSerial Lib "mcsec-32.dll" (ByVal file1 As String) As Integer
Declare Function cSerialGet Lib "mcsec-32.dll" (ByVal file As String, SERIALDATA As tagSERIALDATA) As Integer
Declare Function cSerialInc Lib "mcsec-32.dll" (ByVal file As String, ByVal Increment As Long) As Integer
Declare Function cSerialPut Lib "mcsec-32.dll" (ByVal file As String, SERIALDATA As tagSERIALDATA) As Integer
Declare Function cSerialRmv Lib "mcsec-32.dll" (ByVal file As String) As Integer

Declare Function cHashMD5 Lib "mcsec-32.dll" (Text As String) As String
Declare Function cRegistrationKey Lib "mcsec-32.dll" (ByVal RegString As String, ByVal RegCode As Long) As Long

Declare Function cFileCRC32 Lib "mcsec-32.dll" (ByVal lpFilename As String, ByVal Mode As Integer) As Long
Declare Function cStringCRC32 Lib "mcsec-32.dll" (Txt As String) As Long

Declare Function cDecrypt Lib "mcsec-32.dll" (Txt As String, password As String, ByVal level As Integer) As String
Declare Function cEncrypt Lib "mcsec-32.dll" (Txt As String, password As String, ByVal level As Integer) As String

Declare Function cFileDecrypt Lib "mcsec-32.dll" (ByVal file1 As String, ByVal file2 As String, password As String, ByVal level As Integer) As Long
Declare Function cFileEncrypt Lib "mcsec-32.dll" (ByVal file1 As String, ByVal file2 As String, password As String, ByVal level As Integer) As Long

Declare Function cDOSGetMediaID Lib "mcsec-32.dll" (ByVal nDrive As String, DOSMEDIAID As tagDOSMEDIAID) As Integer
Declare Function cDOSSetMediaID Lib "mcsec-32.dll" (ByVal nDrive As String, DOSMEDIAID As tagDOSMEDIAID) As Integer

#End If
