/* 
 *  WHERE.C - path functions.
 *
 *
 *
 *  Comments:
 *
 *  07/15/95 (Tim Norman) ---------------------------------------------------
 *    started.
 *
 *  08/08/95 (Matt Rains) ---------------------------------------------------
 *    i have cleaned up the source code. changes now bring this source into
 *    guidelines for recommended programming practice.
 *
 *  12/12/95 (Steffan Kaiser & Tim Norman) ----------------------------------
 *    added some patches to fix some things and make more efficient
 *
 *  1/6/96 (Tim Norman) -----------------------------------------------------
 *    fixed a stupid pointer mistake...  Thanks to everyone who noticed it!
 *
 */

#include <dos.h>
#include <dir.h>
#include <stdlib.h>
#include <string.h>

/*
 *
 *  get paths from env. var.
 *
 */
void get_paths(char *paths[129])
{
   char *p;                     /* pointer to path */
   char *tmp;
   static char path[140];       /* path with .\ added to it */
   int count, pos;              /* counters */

   /* getenv() returns a pointer to a string containing the environment of
      the program. then add the current directory to the search path, put in 
      new variable */

   p = getenv("PATH"); 
   strcpy(path, ".;"); 
   strcat(path, p);    

   /* set the first search path to point to the whole path (will add NULL 
      terminator in right spot later */

   paths[0] = path; 
   pos = 0;
   count = 1;

   while(path[pos] != 0) /* step through chars in path */
   {
      if(path[pos] == ';')
      {
         path[pos] = 0; /* terminate it and inc. the path pointer */

         if(path[pos + 1])
         {
            paths[count] = &path[pos + 1];
            count++;
         }
      }
      pos++;
   }

   paths[count] = 0; /* last path points to NULL */

   count = 0;

   while(paths[count]) /* strip backslash from end of paths */
   {
      tmp = &paths[count][strlen(paths[count]) - 1];

      if(*tmp == '\\')
      {
         *tmp = 0;
      }

      count++;
   }

   /* paths is now an array of pointers to all the search paths */

   return;
}

/*
 *
 *  searches for file using path info.
 *
 */
int find_which(char *paths[129], char *fname, char *fullname)
{
   struct ffblk f; /* directory search structure */

   int count;
   int tryall; /* whether to try all extensions */
   int extcount;
   char *extp;
   static char ext[3][5] = {".COM", ".EXE", ".BAT"};

   count = 0;

   /* is there an extension and is it in the last path component? */
   tryall = !(extp = strrchr (fname, '.')) || strpbrk (extp+1, "\\/");

   /* if a path is already specified, then just try tacking on .com, .exe */
   if (strstr (fname, "\\") || fname[1] == ':')
   {
      if (tryall == 0)
      {
	 strcpy (fullname, fname);
	 return 1;
      }

      extp = stpcpy (fullname, fname);

      for (extcount = 0; extcount < 3; extcount++)
      {
	 strcat (extp, ext[extcount]);

	 if (findfirst (fullname, &f, 7) == 0)
	   return 1;
      }
   }
   else while(paths[count]) /* cycle through paths */
   {
      if(tryall)
      {
	 /* create base filename w/o extensions */
	 /* stpcpy non-ANSI... might want to change this */
	 extp = stpcpy (stpcpy (stpcpy (fullname, paths[count]), "\\"), fname);

	 for (extcount = 0; extcount < 3; extcount++)
	 {
	    strcpy (extp, ext[extcount]);

	    if(findfirst(fullname, &f, 7) == 0)
	      return 1;
	 }
      }
      else
      {
	 strcpy(fullname, paths[count]);
	 strcat(fullname, "\\");
	 strcat(fullname, fname);

	 if(findfirst(fullname, &f, 7) == 0)
	   return 1;
      }
      count++;
   }

   return 0;
}
