program Color_Cursors;

{$N-,E-,Q-,S-,R+,I-,O-,F-,P+,T-,X-,V-,B-,A+,G-,D-,L-,Y-}
{$M 1024,0,0}

(* compiled in Borland Turbo Pascal 7.0 for DOS *)

uses crt;

label Start;

var
Background,Foreground : shortint;
Choice : char;

procedure Usage;

begin
textcolor(7);
textbackground(0);
write('                                                                                ');
if paramstr(1) <> '?' then write(' Wrong input, man.                                                              ');
write('                                                                                ');
write(' Usage:   Color B F                                                             ');
write('          where B is for background and is a whole number from 0 thru 7,        ');
write('          and F is for foreground and is a whole number from 0 thru 15.         ');
write('          The two numbers cannot match.                                         ');
write('                                                                                ');

if paramstr(1) <> '?' then
begin
write('          To get this screen for help at anytime without comment, Enter         ');
write('          this:  Color ?  from the DOS prompt.                                  ');
write('                                                                                ');
end;

write(' Example: Color 1 14                                                            ');
write('                                                                                ');
write(' This program changes the background and foreground colors of DOS from the      ');
write(' command-line. Not a Tsr. Especially good for use in batch files, to set        ');
write(' the colors upon return to DOS. Below are the color codings:                    ');
textcolor(1);
write(' 1');
textcolor(2);
write(' 2');
textcolor(3);
write(' 3');
textcolor(4);
write(' 4');
textcolor(5);
write(' 5');
textcolor(6);
write(' 6');
textcolor(7);
write(' 7');
textcolor(8);
write(' 8');
textcolor(9);
write(' 9');
textcolor(10);
write(' 10');
textcolor(11);
write(' 11');
textcolor(12);
write(' 12');
textcolor(13);
write(' 13');
textcolor(14);
write(' 14');
textcolor(15);
write(' 15                                            ');
textcolor(7);
write(' The first one, 0 for black, doesn''t show, but it works too. Finally, for       ');
write(' this program to work, to change the colors of DOS, you can''t run any kind      ');
write(' of ANSI device driver from Config.sys. Check Config.sys for something like     ');
write(' Device=Ansi.Sys, etc. Remove the line if you can.                              ');
write('                                                                                ');
halt;
end;  (* ends help screen, parameters can only be  ?  or wrong *)

procedure Exit_to_DOS;

begin
textbackground(Background);
textcolor(Foreground);
clrscr;
writeln;
writeln;
writeln(' If it didn''t work, you''re probably using an ANSI device driver.');
writeln;
writeln(' If you want a normal DOS screen back, enter the DOS command CLS.');
writeln;
writeln(' You entered ',BackGround,' for background and ',ForeGround,' for foreground.');
writeln;
halt;
end;

begin  (* Main *)  
if paramcount = 0 then begin textbackground(0); textcolor(7); goto Start; end;

if paramcount <> 2 then Usage; (* Help screen in procedure Usage, *)                           
                               (* Begin the command-line version *)
                               
if paramstr(1) = '0' then Background := 0
else if paramstr(1) = '1' then Background := 1
else if paramstr(1) = '2' then Background := 2
else if paramstr(1) = '3' then Background := 3
else if paramstr(1) = '4' then Background := 4
else if paramstr(1) = '5' then Background := 5
else if paramstr(1) = '6' then Background := 6
else if paramstr(1) = '7' then Background := 7
else Usage;

if paramstr(2) = '0' then Foreground := 0
else if paramstr(2) = '1' then Foreground := 1
else if paramstr(2) = '2' then Foreground := 2
else if paramstr(2) = '3' then Foreground := 3
else if paramstr(2) = '4' then Foreground := 4
else if paramstr(2) = '5' then Foreground := 5
else if paramstr(2) = '6' then Foreground := 6
else if paramstr(2) = '7' then Foreground := 7
else if paramstr(2) = '8' then Foreground := 8
else if paramstr(2) = '9' then Foreground := 9
else if paramstr(2) = '10' then Foreground := 10
else if paramstr(2) = '11' then Foreground := 11
else if paramstr(2) = '12' then Foreground := 12
else if paramstr(2) = '13' then Foreground := 13
else if paramstr(2) = '14' then Foreground := 14
else if paramstr(2) = '15' then Foreground := 15
else Usage;

if Background = Foreground then Usage;

textbackground(BackGround);
textcolor(ForeGround);
clrscr;
exit;  (* Successful parameters, exit to Dos with new colors from command line *)

(* Begin the menu-driven part of the program *)
Start:
clrscr;
writeln;
writeln('This program changes the color of DOS and some of its command-line programs,');
writeln('such as DIR, PkZip, MEM/C, LIST, etc. However, for ColorDos to work, you can''t');
writeln('run Ansi.Sys or any other type of ANSI driver from the Config.Sys boot-up file.');
writeln('Check Config.Sys for a line such as Device=Ansi.Sys, or Device=Zansi.Sys, etc.');
writeln('Remove it if you can. Below are your choices on background and foreground. To');
writeln('return to a default, text mode DOS screen, you just put the command CLS. Also,');
writeln('many programs destroy the colors, and you''ll want to run Color with parameters.');
writeln('You will get two prompts, the first one is to choose background. The 2nd one is');
writeln('to choose foreground. The backgrounds are 0 thru 7, with 0 being black. The');
writeln('foregrounds are 0 thru 15. All colors except black are shown below. You can''t');
writeln('enter the same number for background and foreground (obviously). Then you may');
writeln('view a sample, or exit to DOS in your choice of colors. From the sample you may');
writeln('exit to DOS in your colors, or return to the menu to try others. Here they are:');
textcolor(1);
write('1 ');
textcolor(2);
write('2 ');
textcolor(3);
write('3 ');
textcolor(4);
write('4 ');
textcolor(5);
write('5 ');
textcolor(6);
write('6 ');
textcolor(7);
write('7 ');
textcolor(8);
write('8 ');
textcolor(9);
write('9 ');
textcolor(10);
write('10 ');
textcolor(11);
write('11 ');
textcolor(12);
write('12 ');
textcolor(13);
write('13 ');
textcolor(14);
write('14 ');
textcolor(15);
write('15');
textcolor(7);
writeln('  (the first one, 0 black, doesn''t show).');
writeln('Help is avalaible for using Color quicker on the command-line, Enter this at');
writeln('the DOS Prompt:  Color ?  To exit now in these colors, hit Ctrl-Break.');
reset(input);
writeln;
write('Enter Background:  (0-7) > ');
if not eoln(input) then
read(BackGround) else goto Start;
if ioresult = 106 then goto Start;
if (Background < 0) or (Background > 7) then goto Start;

reset(input);
write('Enter Foreground: (0-15) > ');
if not eoln(input) then
read(ForeGround)
else goto Start;
if ioresult = 106 then goto Start;
if (Foreground < 0) or (Foreground > 15) then goto Start;
if Foreground = Background then goto Start;

writeln;
write('View a sample? (Y/N) ');
Choice := readkey;
case Choice of
'y','Y' :
begin
writeln;
textbackground(Background);
textcolor(Foreground);
writeln;
write(' SAMPLE TEXT ');
textcolor(7);
textbackground(0);
write('  Return to DOS with these colors? (Y/N) ');
Choice := readkey;

case Choice of
'y','Y' : Exit_to_DOS;
'n','N' : goto Start;
else begin write(' ....wrong key....'); writeln; exit; end;
end;
end; (* Ends 2nd case statement *)

'n','N' : Exit_to_DOS;
else goto Start;
end; (* Ends 1st case statement *)

end.