/* MCI REXX Sample #2 */
/* Sample REXX Script */
/* this script shows you how to query the capabilities of a CD device */
/* you can use this script to determine which software functions      */
/* will be available for your users.                                  */

rc = RXFUNCADD('mciRxInit','MCIAPI','mciRxInit')
InitRC = mciRxInit()

/* Open the CD */

rc = mciRxSendString("open cdaudio alias supercd wait", 'Retst', '0', '0')
rc = mciRxSendString("capability supercd can eject wait", 'Retst', '0', '0')
If (Retst='TRUE') Then
  say 'CD can perform software ejection'
ELSE
  say 'CD can not perform software ejection'
rc = mciRxSendString("capability supercd can lockeject wait", 'Retst', '0', '0')
If (Retst='TRUE') Then
  say 'CD can prevent manual ejection of the CD'
ELSE
  say 'CD can not prevent manual ejection of the CD'

/* Some CD's can actually record.  However, current OS/2 Warp drivers don't */
/* support this option                                                      */

rc = mciRxSendString("capability supercd can record wait", 'Retst', '0', '0')
If (Retst='TRUE') Then
  say 'CD is read/writable'
ELSE
  say 'CD is not read/writable'

/* Many older or lower-end CD's don't support volume control-check and   */
/* find out what hardware capabilities are available.                    */

rc = mciRxSendString("capability supercd can setvolume wait", 'Retst', '0', '0')
If (Retst='TRUE') Then
  say 'CD can setvolume'
ELSE
  say 'CD can not set volume'

/* Digital Transfer lets your CD send data directly from the CD to your  */
/* sound card without ANY loss in quality.  However, this option is very */
/* CPU intensive--use with care                                          */




rc = mciRxSendString("capability supercd can stream wait", 'Retst', '0', '0')
If (Retst='TRUE') Then
  say 'CD can do a digital transfer to your systems sound card'
ELSE
  say 'CD can not do a digital transfer to your systems sound card'



rc = mciRxSendString("close supercd wait", 'Retst', '0', '0')
say 'Finished SuperCD capabilities'
exit

