Attribute VB_Name = "T2WIN_16_DEF"
Option Explicit

' definition for win.ini section
Global Const GET_TIME_SEPARATOR = 1
Global Const GET_DATE_SEPARATOR = 2
Global Const GET_TIME_FORMAT = 3
Global Const GET_DATE_FORMAT = 4
Global Const GET_CURRENCY = 5
Global Const GET_LANGUAGE = 6
Global Const GET_COUNTRY = 7
Global Const GET_COUNTRY_CODE = 8
Global Const GET_LIST_SEPARATOR = 9
Global Const GET_DEFAULT_PRINTER = 10

' definition for drive type
Global Const DRIVE_UNKNOW = 0
Global Const DRIVE_REMOVABLE = 2
Global Const DRIVE_FIXED = 3
Global Const DRIVE_REMOTE = 4
Global Const DRIVE_CDROM = 20

' definition for file attributes
Global Const A_NORMAL = &H0             'Normal file - No read/write restrictions
Global Const A_RDONLY = &H1             'Read only file
Global Const A_HIDDEN = &H2             'Hidden file
Global Const A_SYSTEM = &H4             'System file
Global Const A_VOLID = &H8              'Volume ID file
Global Const A_SUBDIR = &H10            'Subdirectory
Global Const A_ARCH = &H20              'Archive file
Global Const A_NORMAL_ARCHIVE = &HFE    'Normal, Archive
Global Const A_ALL = &HFF               'Normal, Archive, Read-Only, Hidden, System

' definition for encrypt/decrypt
Global Const ENCRYPT_LEVEL_0 = 0
Global Const ENCRYPT_LEVEL_1 = 1
Global Const ENCRYPT_LEVEL_2 = 2
Global Const ENCRYPT_LEVEL_3 = 3
Global Const ENCRYPT_LEVEL_4 = 4

' definition for FILECRC32
Global Const OPEN_MODE_BINARY = 0
Global Const OPEN_MODE_TEXT = 1

' definition for ARRAYONDISK
Global Const PUT_ARRAY_ON_DISK = 0
Global Const GET_ARRAY_ON_DISK = 1

' definition for big numbers
Global Const BIG_ADD = 0
Global Const BIG_SUB = 1
Global Const BIG_MUL = 2

' definition for file version information
Global Const VER_VERSION_PRODUCT = -1
Global Const VER_VERSION_FILE = 0
Global Const VER_COMPANY_NAME = 1
Global Const VER_FILE_DESCRIPTION = 2
Global Const VER_FILE_VERSION = 3
Global Const VER_INTERNAL_NAME = 4
Global Const VER_LEGAL_COPYRIGHT = 5
Global Const VER_LEGAL_TRADEMARKS = 6
Global Const VER_PRODUCT_NAME = 7
Global Const VER_PRODUCT_VERSION = 8

' definition for language in multi-language management
Global Const LNG_FRENCH = 1
Global Const LNG_DUTCH = 2
Global Const LNG_GERMAN = 3
Global Const LNG_ENGLISH = 4
Global Const LNG_ITALIAN = 5
Global Const LNG_SPANISH = 6
Global Const LNG_CATALAN = 7
Global Const LNG_POLISH = 8

' definition for message position in multi-language message box
Global Const MB_MESSAGE_LEFT = 0
Global Const MB_MESSAGE_CENTER = 8192
Global Const MB_MESSAGE_RIGHT = 16384

' definition for timeout management in multi-language message box
Global Const MB_TIMEOUT_2 = 32768
Global Const MB_TIMEOUT_4 = 2 * MB_TIMEOUT_2
Global Const MB_TIMEOUT_8 = 2 * MB_TIMEOUT_4
Global Const MB_TIMEOUT_16 = 2 * MB_TIMEOUT_8

Global Const MB_TIMEOUT_6 = MB_TIMEOUT_2 Or MB_TIMEOUT_4
Global Const MB_TIMEOUT_10 = MB_TIMEOUT_2 Or MB_TIMEOUT_8
Global Const MB_TIMEOUT_12 = MB_TIMEOUT_4 Or MB_TIMEOUT_8
Global Const MB_TIMEOUT_14 = MB_TIMEOUT_2 Or MB_TIMEOUT_4 Or MB_TIMEOUT_8
Global Const MB_TIMEOUT_18 = MB_TIMEOUT_2 Or MB_TIMEOUT_16
Global Const MB_TIMEOUT_20 = MB_TIMEOUT_4 Or MB_TIMEOUT_16
Global Const MB_TIMEOUT_22 = MB_TIMEOUT_2 Or MB_TIMEOUT_4 Or MB_TIMEOUT_16
Global Const MB_TIMEOUT_24 = MB_TIMEOUT_8 Or MB_TIMEOUT_16
Global Const MB_TIMEOUT_26 = MB_TIMEOUT_2 Or MB_TIMEOUT_8 Or MB_TIMEOUT_16
Global Const MB_TIMEOUT_28 = MB_TIMEOUT_4 Or MB_TIMEOUT_8 Or MB_TIMEOUT_16
Global Const MB_TIMEOUT_30 = MB_TIMEOUT_2 Or MB_TIMEOUT_4 Or MB_TIMEOUT_8 Or MB_TIMEOUT_16

Global Const MB_DISPLAY_TIMEOUT = 524288

' definition for properties for language management
Global Const RS_CAPTION = 1
Global Const RS_TEXT = 2
Global Const RS_DATAFIELD = 4
Global Const RS_DATASOURCE = 8
Global Const RS_TAG = 16
Global Const RS_MENU = 32
Global Const RS_ALL = 255

' definition for accessing methods in OBJECT controls (ocx)
Global Const OBJ_MTD_CLEAR = 0

' definition for accessing properties in OBJECT controls (ocx or vbx)
Global Const OBJ_CAPTION = 0
Global Const OBJ_CLASS = 1
Global Const OBJ_CONTAINER = 2
Global Const OBJ_DATAFIELD = 3
Global Const OBJ_FORM = 4
Global Const OBJ_INDEX = 5
Global Const OBJ_NAME = 6
Global Const OBJ_NAMEINDEX = 7
Global Const OBJ_TAG = 8
Global Const OBJ_TEXT = 9

' definition for error type for PATTERNMATCHEXT
Global Const MATCH_HEXA = 17
Global Const MATCH_INTERNAL_ERROR = 16
Global Const MATCH_PATTERN = 15
Global Const MATCH_LITERAL = 14
Global Const MATCH_RANGE = 13
Global Const MATCH_ABORT = 12
Global Const MATCH_END = 11
Global Const MATCH_VALID = -1

Global Const PATTERN_VALID = 0
Global Const PATTERN_INVALID = 1
Global Const PATTERN_ESC = 2
Global Const PATTERN_RANGE = 3
Global Const PATTERN_CLOSE = 4
Global Const PATTERN_EMPTY = 5
Global Const PATTERN_INTERNAL_ERROR = 6
Global Const PATTERN_HEXA = 7

' definition for error type for ISFILENAMEVALID
Global Const IFV_ERROR = 0
Global Const IFV_NAME_TOO_LONG = 1
Global Const IFV_EXT_TOO_LONG = 2
Global Const IFV_TOO_MANY_BACKSLASH = 3
Global Const IFV_BAD_DRIVE_LETTER = 4
Global Const IFV_BAD_COLON_POS = 5
Global Const IFV_EXT_WITHOUT_NAME = 6

' definition for variable type in DISK ARRAY
Global Const DA_BYTE = 1
Global Const DA_TYPE = 0
Global Const DA_INTEGER = -2
Global Const DA_LONG = -3
Global Const DA_SINGLE = -4
Global Const DA_DOUBLE = -5
Global Const DA_CURRENCY = -6

' definition for error type in DISK ARRAY
Global Const DA_NO_ERROR = True
Global Const DA_EMPTY_FILENAME = 1
Global Const DA_BAD_FILENAME = 2
Global Const DA_CAN_KILL_FILE = 3
Global Const DA_CAN_NOT_OPEN_FILE = 4
Global Const DA_FILE_NOT_FOUND = 5
Global Const DA_BAD_TYPE = 6
Global Const DA_BAD_ROWS = 7
Global Const DA_BAD_COLS = 8
Global Const DA_BAD_SHEETS = 9
Global Const DA_CAN_NOT_WRITE_HEADER = 10
Global Const DA_CAN_NOT_WRITE_PART = 11
Global Const DA_CAN_NOT_WRITE_REMAIN = 12
Global Const DA_CAN_NOT_READ_HEADER = 13
Global Const DA_HEADER_SIZE = 14
Global Const DA_BAD_SIGNATURE = 15
Global Const DA_FILE_SIZE_MISMATCH = 16
Global Const DA_CAN_NOT_SEEK = 17
Global Const DA_INVALID_HANDLE = 18
Global Const DA_CAN_NOT_READ_PART = 19
Global Const DA_CAN_NOT_READ_REMAIN = 20

' definition for error type in HUGE MEMORY ARRAY
Global Const HMA_NO_ERROR = True
Global Const HMA_NO_MEMORY = 1
Global Const HMA_BAD_TYPE = 2
Global Const HMA_BAD_ROWS = 3
Global Const HMA_BAD_COLS = 4
Global Const HMA_BAD_SHEETS = 5
Global Const HMA_INVALID_HANDLE = 6

' definition for error type in SERIAL DATA
Global Const SD_SERIAL_NOT_FOUND = 1
Global Const SD_CAN_NOT_OPEN_FILE = 2

' definition for File I/O
Global Const EOFILE = -1
Global Const SEEK_CUR = 1
Global Const SEEK_END = 2
Global Const SEEK_SET = 0

' definition for file sort
Global Const SORT_ASCENDING = 1
Global Const SORT_DESCENDING = 2
Global Const SORT_CASE_SENSITIVE = 4
Global Const SORT_CASE_INSENSITIVE = 8

' definition for compress/expand
Global Const LZH_ENCODE = True
Global Const LZH_DECODE = False

' definition for PROPERNAME2
Global Const PN_UPPERCASE = 1
Global Const PN_PUNCTUATION = 2
Global Const PN_KEEP_ORIGINAL = 4
Global Const PN_ONLY_LEADER_SPACE = 8

' definition for matrix fill
Global Const MATRIX_ZERO = 0
Global Const MATRIX_UNIT = 1

' definition for FX picture
Global Const FX_HORIZONTAL = 1
Global Const FX_VERTICAL = 2
Global Const FX_DIAGONAL_SQUARE = 3
Global Const FX_RECTANGLE = 4

' structure for splittin path
Type tagSPLITPATH
   nDrive            As String
   nDir              As String
   nName             As String
   nExt              As String
End Type

' structure for file version information
Type tagFILEVERSIONINFO
   VersionProduct    As String
   VersionFile       As String
   CompanyName       As String
   FileDescription   As String
   FileVersion       As String
   InternalName      As String
   LegalCopyright    As String
   LegalTrademarks   As String
   Comments          As String
   ProductName       As String
   ProductVersion    As String
End Type

' structure for file attributes
Type FileAttributeType
   ErrNo             As Integer
   Archive           As Integer
   Hidden            As Integer
   Normal            As Integer
   ReadOnly          As Integer
   SubDir            As Integer
   System            As Integer
   VolId             As Integer
End Type

' structure for VB array
Type ArrayType
   Bounds            As Long
   LBound            As Integer
   UBound            As Integer
   ElemSize          As Integer
   IndexCount        As Integer
   TotalElem         As Integer
End Type

' structure for modules
Type tagMODULEENTRY
   dwSize            As Long
   szModule          As String * 10
   hModule           As Integer
   wcUsage           As Integer
   szExePath         As String * 256
   wNext             As Integer
End Type

' structure for tasks
Type tagTASKENTRY
   dwSize            As Long
   hTask             As Integer
   hTaskParent       As Integer
   hInst             As Integer
   hModule           As Integer
   wSS               As Integer
   wSP               As Integer
   wStackTop         As Integer
   wStackMinimum     As Integer
   wStackBottom      As Integer
   wcEvents          As Integer
   hQueue            As Integer
   szModule          As String * 10
   wPSPOffset        As Integer
   hNext             As Integer
End Type

' structure for disk array
Type tagDISKARRAY
   daSize            As Integer           'size of the type'd
   signature         As String * 7        'signature
   nFilename         As String * 64       'name of the file
   nType             As Integer           'variable type
   nRows             As Long              'number of rows
   nCols             As Long              'number of cols
   nSheets           As Long              'number of sheets
   rHandle           As Integer           'returned handle for use with other functions
   rElementSize      As Integer           'returned size of a element
   rFileSize         As Long              'returned size of the file
   rParts            As Long              'returned total part
   rRemain           As Long              'returned size of the remain part
   rSheetSize        As Long              'size of a sheet
   rOffset1          As Long              'returned offset 1
   rOffset2          As Long              'returned offset 2
   rTime             As Long              'time for the last correct transaction
   nIsTyped          As Integer           'is nType a type'd variable
   Dummy             As String * 7        'reserved for future use
End Type

' structure for multiple disk array
Type tagMULTIPLEDISKARRAY
   daSize               As Integer        'size of the structure
   signature            As String * 7     'signature
   nFilename            As String * 64    'name of the file
   nType(1 To 20)       As Integer        'standard variable type (for 20 arrays)
   nIsTyped(1 To 20)    As Integer        'is a type'd (for 20 arrays)
   nRows(1 To 20)       As Long           'number of rows (for 20 arrays)
   nCols(1 To 20)       As Long           'number of cols (for 20 arrays)
   nSheets(1 To 20)     As Long           'number of sheets (for 20 arrays)
   rHandle              As Integer        'returned handle for use with other functions
   rFileSize            As Long           'returned size of the file
   rElementSz(1 To 20)  As Integer        'returned size of a element (for 20 arrays)
   rSheetSz(1 To 20)    As Long           'size of a sheet (for 20 arrays)
   rOffsetPos(1 To 20)  As Long           'position of each array in the file (for 20 arrays)
   rOffset1             As Long           'returned offset 1
   rOffset2             As Long           'returned offset 2
   rTime                As Long           'time for the last correct transaction
   Dummy                As String * 29    'reserved for future use
End Type

' structure for huge memory array
Type tagHMA
   daSize            As Integer           'size of the type'd
   nType             As Integer           'variable type
   nRows             As Long              'number of rows
   nCols             As Long              'number of cols
   nSheets           As Long              'number of sheets
   rHandle           As Integer           'returned handle for use with other functions
   rElementSize      As Long              'returned size of a element
   rMemorySize       As Long              'returned size of the memory used
   rParts            As Long              'returned total part
   rRemain           As Long              'returned size of the remain part
   rSheetSize        As Long              'size of a sheet
   rOffset           As Long              'returned offset
   nIsTyped          As Integer           'is nType a type'd variable
   Dummy             As String * 20       'reserved for future use
End Type

' structure for serialization
Type tagSERIALDATA
   Description1      As String * 50       'serialization description 1
   Description2      As String * 50       'serialization description 2
   Number            As Long              'serialization number
   Dummy             As String * 50       'reserved for future use
End Type

' structure for 2-D geometry types
Type tagVECTOR2
   x                 As Double
   y                 As Double
End Type

' structure for 3-D geometry types
Type tagVECTOR3
   x                 As Double
   y                 As Double
   z                 As Double
End Type

' structure for get/set Media ID
Type tagMEDIAID
   InfoLevel         As Integer
   SerialNumber      As Long
   VolLabel          As String * 11
   FileSysType       As String * 8
End Type

' structure for Get Control Rectangle
Type tagRECT
   Left              As Integer
   Top               As Integer
   Right             As Integer
   Bottom            As Integer
End Type

' structure for 3D-Meter
Type tag3DMeter
   CrtValue          As Long              'current value
   MaxValue          As Long              'maximum value
   BackColor         As Long
   ForeColor         As Long
   Polygon           As Integer           '0  : rectangle, 1 : triangle, 2 : trapezium, 3 : ellipse , 4 : bars
   BarSize           As Integer           'size of a bar (polygon = 4) (in pixel : min=1,max=20,default=10)
   SpaceBars         As Integer           'space between bars (polygon = 4) (in pixel : min=1,max=4,default=2)
   Direction         As Integer           '0  : horizontal, other : vertical
   Threed            As Integer           '-1 : indented, 1 : raised
   Thickness         As Integer
   Percent           As Integer           'internal use, do not change
   OldPolygon        As Integer           'internal use, do not change
   OldDirection      As Integer           'internal use, do not change
   OldThreeD         As Integer           'internal use, do not change
   HatchBrush        As Integer           '-1 : solid brush, 0 : hor., 1 : ver., 2 : downward diag., 3 : upward diag., 4 : cross, 5 : diag.cross
End Type

' structure for File Information
Type tagFILEINFO
   fSize             As Long              'size of the file
   fDate             As Long              'date of the file (scalar date)
   fTime             As Long              'time of the file (scalar time)
   fAttribute        As Integer           'attribute of the file
End Type
   
Rem Don't Remove It
Declare Sub c3D Lib "t2win-16.dll" (ByVal Ctl As Control, ByVal Method As Integer, ByVal Thickness As Integer)
Declare Sub c3DMeter Lib "t2win-16.dll" (ByVal Ctl As Control, Meter As tag3DMeter)
Declare Function cAddD Lib "t2win-16.dll" (array() As Double, ByVal nValue As Double) As Integer
Declare Function cAddDigit Lib "t2win-16.dll" (Txt As String) As Integer
Declare Function cAddI Lib "t2win-16.dll" (array() As Integer, ByVal nValue As Integer) As Integer
Declare Function cAddL Lib "t2win-16.dll" (array() As Long, ByVal nValue As Long) As Integer
Declare Function cAddS Lib "t2win-16.dll" (array() As Single, ByVal nValue As Single) As Integer
Declare Function cAddTime Lib "t2win-16.dll" (ByVal Hr As Integer) As Integer
Declare Function cAddTwoTimes Lib "t2win-16.dll" (ByVal Time1 As String, ByVal Time2 As String) As String
Declare Function cAlign Lib "t2win-16.dll" (Txt As String, ByVal TypeAlign As Integer, ByVal NewLength As Integer) As String
Declare Function cAllSubDirectories Lib "t2win-16.dll" (ByVal lpBaseDirectory As String, nDir As Integer) As String
Declare Function cAndToken Lib "t2win-16.dll" (ByVal Txt As String, ByVal Token As String) As Integer
Declare Function cAndTokenIn Lib "t2win-16.dll" (ByVal Txt As String, ByVal Token As String, ByVal Separator As String) As Integer
Declare Function cArabicToRoman Lib "t2win-16.dll" (Var As Variant) As String
Declare Sub cArrangeDesktopIcons Lib "t2win-16.dll" ()
Declare Function cArrayOnDisk Lib "t2win-16.dll" (ByVal file As String, array() As Any, ByVal GetPut As Integer) As Long
Declare Function cArrayPrm Lib "t2win-16.dll" (array() As Any, nArray As Any) As Integer
Declare Function cArrayStringOnDisk Lib "t2win-16.dll" (ByVal file As String, array() As String, ByVal GetPut As Integer, rRecords As Long) As Long
Declare Function cArrayToComboBox Lib "t2win-16.dll" (ByVal hWnd As Integer, array() As String) As Integer
Declare Function cArrayToListBox Lib "t2win-16.dll" (ByVal hWnd As Integer, array() As String) As Integer
Declare Function cB2I Lib "t2win-16.dll" (ByVal Txt As String) As Integer
Declare Function cB2L Lib "t2win-16.dll" (ByVal Txt As String) As Long
Declare Function cBaseConversion Lib "t2win-16.dll" (ByVal Num As String, ByVal RadixIn As Integer, ByVal RadixOut As Integer) As String
Declare Function cBetween Lib "t2win-16.dll" (Var As Variant, Var1 As Variant, Var2 As Variant) As Integer
Declare Function cBigAdd Lib "t2win-16.dll" (Num1 As String, Num2 As String) As String
Declare Function cBigDiv Lib "t2win-16.dll" (Num1 As String, Num2 As String) As String
Declare Function cBigMul Lib "t2win-16.dll" (Num1 As String, Num2 As String) As String
Declare Function cBigNum Lib "t2win-16.dll" (ByVal n1 As String, ByVal op As Integer, ByVal n2 As String) As String
Declare Function cBigSub Lib "t2win-16.dll" (Num1 As String, Num2 As String) As String
Declare Function cBigFmt Lib "t2win-16.dll" (Num As String, ByVal Length As Integer) As String
Declare Function cBlockCharFromLeft Lib "t2win-16.dll" (Txt As String, ByVal Position As Integer) As String
Declare Function cBlockCharFromRight Lib "t2win-16.dll" (Txt As String, ByVal Position As Integer) As String
Declare Sub cCenterWindow Lib "t2win-16.dll" (ByVal hWnd As Integer)
Declare Sub cChangeChars Lib "t2win-16.dll" (Txt As String, CharSet As String, NewCharSet As String)
Declare Sub cChangeCharsUntil Lib "t2win-16.dll" (Txt As String, CharSet As String, NewCharSet As String, nUntil As String)
Declare Sub cChangeTaskName Lib "t2win-16.dll" (ByVal hWnd As Integer, ByVal Text As String)
Declare Function cChDir Lib "t2win-16.dll" (ByVal lpDir As String) As Integer
Declare Function cChDrive Lib "t2win-16.dll" (ByVal lpDrive As String) As Integer
Declare Function cCheckChars Lib "t2win-16.dll" (Txt As String, CharSet As String) As Integer
Declare Function cCheckMinuteChange Lib "t2win-16.dll" () As Integer
Declare Function cCheckNumericity Lib "t2win-16.dll" (Txt As String) As Integer
Declare Function cCheckSecondChange Lib "t2win-16.dll" () As Integer
Declare Function cCheckTime Lib "t2win-16.dll" (ByVal Hr As Integer, ByVal Hr1 As Integer, ByVal Hr2 As Integer) As Integer
Declare Function cCheckWait Lib "t2win-16.dll" (ByVal nTimer As Integer) As Integer
Declare Function cCloseAllEditForm Lib "t2win-16.dll" () As Integer
Declare Function cHashMD5 Lib "t2win-16.dll" (Text As String) As String
Declare Function cCmpFileAttribute Lib "t2win-16.dll" (ByVal file1 As String, ByVal file2 As String) As Integer
Declare Function cCmpFileContents Lib "t2win-16.dll" (ByVal file1 As String, ByVal file2 As String, ByVal Sensitivity As Integer) As Integer
Declare Function cCmpFileSize Lib "t2win-16.dll" (ByVal file1 As String, ByVal file2 As String) As Integer
Declare Function cCmpFileTime Lib "t2win-16.dll" (ByVal file1 As String, ByVal file2 As String) As Integer
Declare Sub cCnvASCIItoEBCDIC Lib "t2win-16.dll" (Txt As String)
Declare Sub cCnvEBCDICtoASCII Lib "t2win-16.dll" (Txt As String)
Declare Function cCombination Lib "t2win-16.dll" (ByVal nItems As Integer, ByVal mTimes As Integer) As Double
Declare Function cCompact Lib "t2win-16.dll" (Txt As String) As String
Declare Function cCompareTypeString Lib "t2win-16.dll" Alias "cTypesCompare" (TypeSrc As Any, ByVal Dst As String, ByVal lenTypeSrc As Integer) As Integer
Declare Function cCompareStringType Lib "t2win-16.dll" Alias "cTypesCompare" (ByVal Src As String, TypeDst As Any, ByVal lenTypeSrc As Integer) As Integer
Declare Function cCompress Lib "t2win-16.dll" (Txt As String) As String
Declare Function cCompressTab Lib "t2win-16.dll" (Txt As String, ByVal nTab As Integer) As String
Declare Sub cCtl3D Lib "t2win-16.dll" (ByVal Ctl As Control, ByVal LeftTopColor As Long, ByVal RightBottomColor As Long, ByVal Thickness As Integer)
Declare Function cConvert Lib "t2win-16.dll" (Value As String, ByVal MaskFrom As String, ByVal MaskTo As String, ByVal Size As Integer) As String
Declare Function cCount Lib "t2win-16.dll" (Txt As String, Separator As String) As Integer
Declare Function cCountDirectories Lib "t2win-16.dll" (ByVal lpFilename As String) As Integer
Declare Function cCountFiles Lib "t2win-16.dll" (ByVal lpFilename As String) As Integer
Declare Function cCountI Lib "t2win-16.dll" (array() As Integer, ByVal Value As Integer) As Long
Declare Function cCountL Lib "t2win-16.dll" (array() As Long, ByVal Value As Long) As Long
Declare Function cCountS Lib "t2win-16.dll" (array() As Single, ByVal Value As Single) As Long
Declare Function cCountD Lib "t2win-16.dll" (array() As Double, ByVal Value As Double) As Long
Declare Function cCplAlpha Lib "t2win-16.dll" (Txt As String) As String
Declare Function cCplDigit Lib "t2win-16.dll" (Txt As String) As String
Declare Function cCreateAndFill Lib "t2win-16.dll" (ByVal Length As Integer, Txt As String) As String
Declare Function cCreateBits Lib "t2win-16.dll" (ByVal nBits As Integer) As String
Declare Function cCurrentTime Lib "t2win-16.dll" () As Integer
Declare Function cCVB Lib "t2win-16.dll" (Value As String) As Integer
Declare Function cCVC Lib "t2win-16.dll" (Value As String) As Currency
Declare Function cCVD Lib "t2win-16.dll" (Value As String) As Double
Declare Function cCVI Lib "t2win-16.dll" (Value As String) As Integer
Declare Function cCVL Lib "t2win-16.dll" (Value As String) As Long
Declare Function cCVS Lib "t2win-16.dll" (Value As String) As Single
Declare Function cDAClear Lib "t2win-16.dll" (DISKARRAY As tagDISKARRAY) As Integer
Declare Function cDAClearCol Lib "t2win-16.dll" (DISKARRAY As tagDISKARRAY, ByVal Col As Long, ByVal sheet As Long) As Integer
Declare Function cDAClearRow Lib "t2win-16.dll" (DISKARRAY As tagDISKARRAY, ByVal Row As Long, ByVal sheet As Long) As Integer
Declare Function cDAClearSheet Lib "t2win-16.dll" (DISKARRAY As tagDISKARRAY, ByVal sheet As Long) As Integer
Declare Sub cDAClose Lib "t2win-16.dll" (DISKARRAY As tagDISKARRAY, ByVal DeleteFile As Integer)
Declare Function cDACreate Lib "t2win-16.dll" (DISKARRAY As tagDISKARRAY, ByVal CreateOrUse As Integer) As Integer
Declare Function cDAGet Lib "t2win-16.dll" (DISKARRAY As tagDISKARRAY, ByVal Row As Long, ByVal Col As Long, ByVal sheet As Long) As Variant
Declare Sub cDAGetType Lib "t2win-16.dll" (DISKARRAY As tagDISKARRAY, ByVal Row As Long, ByVal Col As Long, ByVal sheet As Long, nType As Any)
Declare Sub cDAPut Lib "t2win-16.dll" (DISKARRAY As tagDISKARRAY, ByVal Row As Long, ByVal Col As Long, ByVal sheet As Long, Var As Variant)
Declare Sub cDAPutType Lib "t2win-16.dll" (DISKARRAY As tagDISKARRAY, ByVal Row As Long, ByVal Col As Long, ByVal sheet As Long, nType As Any)
Declare Sub cDArGet Lib "t2win-16.dll" (DISKARRAY As tagDISKARRAY, ByVal Col As Long, Var As Variant)
Declare Sub cDArGetType Lib "t2win-16.dll" (DISKARRAY As tagDISKARRAY, ByVal Col As Long, nType As Any)
Declare Sub cDArPut Lib "t2win-16.dll" (DISKARRAY As tagDISKARRAY, ByVal Col As Long, Var As Variant)
Declare Sub cDArPutType Lib "t2win-16.dll" (DISKARRAY As tagDISKARRAY, ByVal Col As Long, nType As Any)
Declare Function cDAsClearCol Lib "t2win-16.dll" (DISKARRAY As tagDISKARRAY, ByVal Col As Long) As Integer
Declare Function cDAsClearRow Lib "t2win-16.dll" (DISKARRAY As tagDISKARRAY, ByVal Row As Long) As Integer
Declare Sub cDAsGet Lib "t2win-16.dll" (DISKARRAY As tagDISKARRAY, ByVal Row As Long, ByVal Col As Long, Var As Variant)
Declare Sub cDAsGetType Lib "t2win-16.dll" (DISKARRAY As tagDISKARRAY, ByVal Row As Long, ByVal Col As Long, nType As Any)
Declare Sub cDAsPut Lib "t2win-16.dll" (DISKARRAY As tagDISKARRAY, ByVal Row As Long, ByVal Col As Long, Var As Variant)
Declare Sub cDAsPutType Lib "t2win-16.dll" (DISKARRAY As tagDISKARRAY, ByVal Row As Long, ByVal Col As Long, nType As Any)
Declare Function cDateToScalar Lib "t2win-16.dll" (ByVal nYear As Integer, ByVal nMonth As Integer, ByVal nDay As Integer) As Long
Declare Function cDayOfWeek Lib "t2win-16.dll" (ByVal nYear As Integer, ByVal nMonth As Integer, ByVal nDay As Integer, ByVal nISO As Integer) As Integer
Declare Function cDayOfYear Lib "t2win-16.dll" (ByVal nYear As Integer, ByVal nMonth As Integer, ByVal nDay As Integer) As Integer
Declare Function cDaysInMonth Lib "t2win-16.dll" (ByVal nYear As Integer, ByVal nMonth As Integer) As Integer
Declare Sub cDecrI Lib "t2win-16.dll" (Value As Integer)
Declare Sub cDecrL Lib "t2win-16.dll" (Value As Long)
Declare Function cDecrypt Lib "t2win-16.dll" (Txt As String, password As String, ByVal level As Integer) As String
Declare Function cDeviationD Lib "t2win-16.dll" (array() As Double) As Double
Declare Function cDeviationI Lib "t2win-16.dll" (array() As Integer) As Double
Declare Function cDeviationL Lib "t2win-16.dll" (array() As Long) As Double
Declare Function cDeviationS Lib "t2win-16.dll" (array() As Single) As Double
Declare Sub cDisableCtlRedraw Lib "t2win-16.dll" (Obj As Object)
Declare Sub cDisableFI Lib "t2win-16.dll" (Obj As Object)
Declare Sub cDisableForm Lib "t2win-16.dll" (ByVal hWnd As Integer)
Declare Sub cDisableRedraw Lib "t2win-16.dll" (ByVal hWnd As Integer)
Declare Function cDOSGetMediaID Lib "t2win-16.dll" (ByVal nDrive As String, MEDIAID As tagMEDIAID) As Integer
Declare Function cDOSGetVolumeLabel Lib "t2win-16.dll" (ByVal nDrive As String) As String
Declare Function cDOSSetMediaID Lib "t2win-16.dll" (ByVal nDrive As String, MEDIAID As tagMEDIAID) As Integer
Declare Function cDOSSetVolumeLabel Lib "t2win-16.dll" (ByVal nDrive As String, ByVal nVolumeLabel As String) As Integer
Declare Sub cEnableCtlRedraw Lib "t2win-16.dll" (Obj As Object)
Declare Sub cEnableFI Lib "t2win-16.dll" (Obj As Object)
Declare Sub cEnableForm Lib "t2win-16.dll" (ByVal hWnd As Integer)
Declare Sub cEnableRedraw Lib "t2win-16.dll" (ByVal hWnd As Integer)
Declare Function cEncrypt Lib "t2win-16.dll" (Txt As String, password As String, ByVal level As Integer) As String
Declare Function cEXEnameActiveWindow Lib "t2win-16.dll" () As String
Declare Function cEXEnameWindow Lib "t2win-16.dll" (ByVal hModule As Integer) As String
Declare Function cEXEnameTask Lib "t2win-16.dll" (ByVal nFilename As String) As String
Declare Function cExitWindowsAndExecute Lib "t2win-16.dll" (ByVal lpszExe As String, ByVal lpszParams As String) As Integer
Declare Function cExpandTab Lib "t2win-16.dll" (Txt As String, ByVal nTab As Integer) As String
Declare Function cFileChangeChars Lib "t2win-16.dll" (ByVal nFilename As String, CharSet As String, NewCharSet As String, ByVal nFileTemp As String) As Long
Declare Function cFileCompress Lib "t2win-16.dll" (ByVal file1 As String, ByVal file2 As String) As Long
Declare Function cFileCompressTab Lib "t2win-16.dll" (ByVal file1 As String, ByVal file2 As String, ByVal nTab As Integer) As Long
Declare Function cFileCopy Lib "t2win-16.dll" (ByVal file1 As String, ByVal file2 As String) As Long
Declare Function cFileCRC32 Lib "t2win-16.dll" (ByVal lpFilename As String, ByVal Mode As Integer) As Long
Declare Function cFileDateCreated Lib "t2win-16.dll" (ByVal lpFilename As String) As String
Declare Function cFileDecrypt Lib "t2win-16.dll" (ByVal file1 As String, ByVal file2 As String, password As String, ByVal level As Integer) As Long
Declare Function cFileDrive Lib "t2win-16.dll" (ByVal lpFilename As String) As String
Declare Function cFileEncrypt Lib "t2win-16.dll" (ByVal file1 As String, ByVal file2 As String, password As String, ByVal level As Integer) As Long
Declare Function cFileExpand Lib "t2win-16.dll" (ByVal file1 As String, ByVal file2 As String) As Long
Declare Function cFileExpandTab Lib "t2win-16.dll" (ByVal file1 As String, ByVal file2 As String, ByVal nTab As Integer) As Long
Declare Function cFileFilter Lib "t2win-16.dll" (ByVal file1 As String, ByVal file2 As String, Filter As String) As Long
Declare Function cFileFilterNot Lib "t2win-16.dll" (ByVal file1 As String, ByVal file2 As String, Filter As String) As Long
Declare Function cFileGetAttrib Lib "t2win-16.dll" (ByVal nFilename As String, nFileAttribute As Any) As Integer
Declare Function cFileLastDateAccess Lib "t2win-16.dll" (ByVal lpFilename As String) As String
Declare Function cFileLastDateModified Lib "t2win-16.dll" (ByVal lpFilename As String) As String
Declare Function cFileLastTimeAccess Lib "t2win-16.dll" (ByVal lpFilename As String) As String
Declare Function cFileLastTimeModified Lib "t2win-16.dll" (ByVal lpFilename As String) As String
Declare Function cFileLineCount Lib "t2win-16.dll" (ByVal lpFilename As String) As Long
Declare Function cFileMerge Lib "t2win-16.dll" (ByVal file1 As String, ByVal file2 As String, ByVal fileTo As String) As Long
Declare Function cFilePathExists Lib "t2win-16.dll" (ByVal lpFilename As String) As Integer
Declare Function cFileResetAllAttrib Lib "t2win-16.dll" (ByVal nFilename As String) As Integer
Declare Function cFileResetArchive Lib "t2win-16.dll" (ByVal nFilename As String) As Integer
Declare Function cFileResetFlag Lib "t2win-16.dll" (ByVal nFilename As String, ByVal nStatus As Integer) As Integer
Declare Function cFileResetHidden Lib "t2win-16.dll" (ByVal nFilename As String) As Integer
Declare Function cFileResetReadOnly Lib "t2win-16.dll" (ByVal nFilename As String) As Integer
Declare Function cFileResetSystem Lib "t2win-16.dll" (ByVal nFilename As String) As Integer
Declare Function cFileSearch Lib "t2win-16.dll" (ByVal nFilename As String, ByVal Search As String, ByVal Sensitivity As Integer) As Long
Declare Function cFileSearchAndReplace Lib "t2win-16.dll" (ByVal nFilename As String, ByVal Search As String, ByVal Replace As String, ByVal nFileTemp As String, ByVal Sensitivity As Integer) As Long
Declare Function cFileSearchCount Lib "t2win-16.dll" (ByVal nFilename As String, ByVal Search As String, ByVal Sensitivity As Integer) As Long
Declare Function cFileSetAllAttrib Lib "t2win-16.dll" (ByVal nFilename As String) As Integer
Declare Function cFileSetArchive Lib "t2win-16.dll" (ByVal nFilename As String) As Integer
Declare Function cFileSetAttrib Lib "t2win-16.dll" (ByVal nFilename As String, nFileAttribute As Any) As Integer
Declare Function cFileSetFlag Lib "t2win-16.dll" (ByVal nFilename As String, ByVal nStatus As Integer) As Integer
Declare Function cFileSetHidden Lib "t2win-16.dll" (ByVal nFilename As String) As Integer
Declare Function cFileSetReadOnly Lib "t2win-16.dll" (ByVal nFilename As String) As Integer
Declare Function cFileSetSystem Lib "t2win-16.dll" (ByVal nFilename As String) As Integer
Declare Function cFilesInDirectory Lib "t2win-16.dll" (ByVal nFilename As String, ByVal FirstNext As Integer) As String
Declare Function cFilesInDirOnDisk Lib "t2win-16.dll" (ByVal nFile As String, ByVal nFilename As String, ByVal nAttribute As Integer) As Integer
Declare Function cFilesInDirToArray Lib "t2win-16.dll" (ByVal nFilename As String, ByVal nAttribute As Integer, array() As String) As Integer
Declare Function cFilesInfoInDir Lib "t2win-16.dll" (ByVal nFilename As String, FILEINFO As tagFILEINFO, ByVal FirstNext As Integer) As String
Declare Function cFileSize Lib "t2win-16.dll" (ByVal lpFilename As String) As Long
Declare Function cFileSort Lib "t2win-16.dll" (ByVal FileIn As String, ByVal FileOut As String, ByVal SortMethod As Integer, ByVal RecordLength As Long, ByVal KeyOffset As Long, ByVal KeyLength As Long, rRecords As Integer) As Long
Declare Function cFilesSize Lib "t2win-16.dll" (ByVal nFilename As String) As Long
Declare Function cFilesSizeOnDisk Lib "t2win-16.dll" (ByVal nFilename As String) As Long
Declare Function cFilesSlack Lib "t2win-16.dll" (ByVal nFilename As String, Size1 As Long, Size2 As Long) As Integer
Declare Function cFileStatistics Lib "t2win-16.dll" (ByVal nFilename As String, nLines As Long, nWords As Long, nChars As Long) As Long
Declare Function cFileTimeCreated Lib "t2win-16.dll" (ByVal lpFilename As String) As String
Declare Function cFileToComboBox Lib "t2win-16.dll" (ByVal hWnd As Integer, ByVal nFile As String) As Integer
Declare Function cFileToListBox Lib "t2win-16.dll" (ByVal hWnd As Integer, ByVal nFile As String) As Integer
Declare Function cFileToUpper Lib "t2win-16.dll" (ByVal file1 As String, ByVal file2 As String) As Long
Declare Function cFileToLower Lib "t2win-16.dll" (ByVal file1 As String, ByVal file2 As String) As Long
Declare Sub cFill Lib "t2win-16.dll" (Txt As String, Fill As String)
Declare Function cFillD Lib "t2win-16.dll" (array() As Double, ByVal nValue As Double) As Integer
Declare Function cFillI Lib "t2win-16.dll" (array() As Integer, ByVal nValue As Integer) As Integer
Declare Function cFillL Lib "t2win-16.dll" (array() As Long, ByVal nValue As Long) As Integer
Declare Function cFillS Lib "t2win-16.dll" (array() As Single, ByVal nValue As Single) As Integer
Declare Function cFillIncrD Lib "t2win-16.dll" (array() As Double, ByVal nValue As Double, ByVal Increment As Double) As Integer
Declare Function cFillIncrI Lib "t2win-16.dll" (array() As Integer, ByVal nValue As Integer, ByVal Increment As Integer) As Integer
Declare Function cFillIncrL Lib "t2win-16.dll" (array() As Long, ByVal nValue As Long, ByVal Increment As Long) As Integer
Declare Function cFillIncrS Lib "t2win-16.dll" (array() As Single, ByVal nValue As Single, ByVal Increment As Single) As Integer
Declare Function cFilterBlocks Lib "t2win-16.dll" (Txt As String, Delimitor As String) As String
Declare Function cFilterChars Lib "t2win-16.dll" (Txt As String, CharSet As String) As String
Declare Function cFilterFirstChars Lib "t2win-16.dll" (Txt As String, CharSet As String) As String
Declare Function cFilterNotChars Lib "t2win-16.dll" (Txt As String, CharSet As String) As String
Declare Function cFindBitReset Lib "t2win-16.dll" (Txt As String, ByVal Position As Integer) As Integer
Declare Function cFindBitSet Lib "t2win-16.dll" (Txt As String, ByVal Position As Integer) As Integer
Declare Function cFindFileInEnv Lib "t2win-16.dll" (ByVal lpFilename As String, ByVal lpEnv As String) As Integer
Declare Function cFindFileInPath Lib "t2win-16.dll" (ByVal lpFilename As String) As Integer
Declare Function cFloppyInfo Lib "t2win-16.dll" (ByVal nDrive As String, nHeads As Integer, nCylinders As Integer, nSectors As Integer) As Integer
Declare Function cFraction Lib "t2win-16.dll" (ByVal nValue As Double, nNumerator As Double, nDenominator As Double) As Double
Declare Function cFromBinary Lib "t2win-16.dll" (Text As String) As String
Declare Function cFromBinary2 Lib "t2win-16.dll" (Text As String, Bin As String) As String
Declare Function cFromHexa Lib "t2win-16.dll" (Text As String) As String
Declare Function cFullPath Lib "t2win-16.dll" (ByVal nFilename As String) As String
Declare Function cFXpicture Lib "t2win-16.dll" (ByVal Method As Integer, ByVal hdc1 As Integer, ByVal hbitmap As Integer, ByVal parameter As Integer, ByVal delay As Integer) As Integer
Declare Function cGet Lib "t2win-16.dll" (Txt As String, ByVal Position As Integer) As String
Declare Function cGetAscTime Lib "t2win-16.dll" (ByVal nLanguage As Integer) As String
Declare Function cGetBit Lib "t2win-16.dll" (Txt As String, ByVal Position As Integer) As Integer
Declare Function cGetBlock Lib "t2win-16.dll" (Txt As String, ByVal Position As Integer, ByVal Length As Integer) As String
Declare Function cGetChangeTaskName Lib "t2win-16.dll" (ByVal hWnd As Integer, ByVal Text As String) As String
Declare Function cGetClassName Lib "t2win-16.dll" (ByVal hWnd As Integer) As String
Declare Function cGetCountry Lib "t2win-16.dll" () As String
Declare Function cGetCountryCode Lib "t2win-16.dll" () As String
Declare Function cGetCtlCaption Lib "t2win-16.dll" (Obj As Object) As String
Declare Function cGetCtlClass Lib "t2win-16.dll" (Obj As Object) As String
Declare Function cGetCtlContainer Lib "t2win-16.dll" (Obj As Object) As String
Declare Function cGetCtlDataField Lib "t2win-16.dll" (Obj As Object) As String
Declare Function cGetCtlForm Lib "t2win-16.dll" (Obj As Object) As String
Declare Function cGetCtlIndex Lib "t2win-16.dll" (Obj As Object) As Integer
Declare Function cGetCtlName Lib "t2win-16.dll" (Obj As Object) As String
Declare Function cGetCtlNameIndex Lib "t2win-16.dll" (Obj As Object) As String
Declare Sub cGetCtlRect Lib "t2win-16.dll" (ByVal Ctl As Control, RECT As Any)
Declare Sub cGetCtlRectTwips Lib "t2win-16.dll" (ByVal Ctl As Control, RECT As Any)
Declare Function cGetCtlTag Lib "t2win-16.dll" (Obj As Object) As String
Declare Function cGetCtlTagSized Lib "t2win-16.dll" (Obj As Object, ByVal nSize As Integer) As String
Declare Function cGetCtlText Lib "t2win-16.dll" (Obj As Object) As String
Declare Function cGetCurrency Lib "t2win-16.dll" () As String
Declare Function cGetCurrentDrive Lib "t2win-16.dll" () As String
Declare Function cGetDateFormat Lib "t2win-16.dll" () As String
Declare Function cGetDateSeparator Lib "t2win-16.dll" () As String
Declare Function cGetDefaultCurrentDir Lib "t2win-16.dll" () As String
Declare Function cGetDefaultPrinter Lib "t2win-16.dll" () As String
Declare Function cGetDevices Lib "t2win-16.dll" () As String
Declare Function cGetDiskClusterSize Lib "t2win-16.dll" (ByVal lpDrive As String) As Long
Declare Function cGetDiskFree Lib "t2win-16.dll" (ByVal lpDrive As String) As Long
Declare Function cGetDiskSpace Lib "t2win-16.dll" (ByVal lpDrive As String) As Long
Declare Function cGetDiskUsed Lib "t2win-16.dll" (ByVal lpDrive As String) As Long
Declare Function cGetDriveCurrentDir Lib "t2win-16.dll" (ByVal lpDrive As String) As String
Declare Function cGetDriveType Lib "t2win-16.dll" (ByVal lpDrive As String) As Integer
Declare Function cGetFileVersion Lib "t2win-16.dll" (ByVal FileName As String, ByVal nFonction As Integer) As String
Declare Function cGetFileVersionInfo Lib "t2win-16.dll" (ByVal FileName As String, FILEVERSIONINFO As Any) As Integer
Declare Function cGetFullNameInEnv Lib "t2win-16.dll" (ByVal lpFilename As String, ByVal lpEnv As String) As String
Declare Function cGetFullNameInPath Lib "t2win-16.dll" (ByVal lpFilename As String) As String
Declare Function cGetHourFormat Lib "t2win-16.dll" () As String
Declare Function cGetHwnd Lib "t2win-16.dll" (Obj As Object) As Integer
Declare Function cGetIn Lib "t2win-16.dll" (Txt As String, Separator As String, ByVal Position As Integer) As String
Declare Function cGetIni Lib "t2win-16.dll" (ByVal AppName As String, ByVal szItem As String, ByVal szDefault As String, ByVal InitFile As String) As String
Declare Function cGetInPart Lib "t2win-16.dll" (Txt As String, Separator As String, ByVal Position As Integer) As String
Declare Function cGetInPartR Lib "t2win-16.dll" (Txt As String, Separator As String, ByVal Position As Integer) As String
Declare Function cGetInR Lib "t2win-16.dll" (Txt As String, Separator As String, ByVal Position As Integer) As String
Declare Function cGetLanguage Lib "t2win-16.dll" () As String
Declare Function cGetListSeparator Lib "t2win-16.dll" () As String
Declare Function cGetLongDay Lib "t2win-16.dll" (ByVal nLanguage As Integer, ByVal nDay As Integer) As String
Declare Function cGetLongMonth Lib "t2win-16.dll" (ByVal nLanguage As Integer, ByVal nMonth As Integer) As String
Declare Function cGetNetConnection Lib "t2win-16.dll" (ByVal lpDrive As String, ErrCode As Integer) As String
Declare Function cGetPid Lib "t2win-16.dll" () As Integer
Declare Function cGetPrinterPorts Lib "t2win-16.dll" () As String
Declare Function cGetSectionItems Lib "t2win-16.dll" (ByVal Section As String, ByVal InitFile As String, nItems As Integer) As String
Declare Function cGetShortDay Lib "t2win-16.dll" (ByVal nLanguage As Integer, ByVal nDay As Integer) As String
Declare Function cGetShortMonth Lib "t2win-16.dll" (ByVal nLanguage As Integer, ByVal nMonth As Integer) As String
Declare Function cGetSmallDay Lib "t2win-16.dll" (ByVal nLanguage As Integer, ByVal nDay As Integer) As String
Declare Function cGetSystemDirectory Lib "t2win-16.dll" () As String
Declare Function cGetTaskName Lib "t2win-16.dll" (ByVal hWnd As Integer) As String
Declare Function cGetTimeSeparator Lib "t2win-16.dll" () As String
Declare Function cGetTinyDay Lib "t2win-16.dll" (ByVal nLanguage As Integer, ByVal nDay As Integer) As String
Declare Function cGetTinyMonth Lib "t2win-16.dll" (ByVal nLanguage As Integer, ByVal nMonth As Integer) As String
Declare Function cGetVersion Lib "t2win-16.dll" () As Single
Declare Function cGetWindowsDirectory Lib "t2win-16.dll" () As String
Declare Function cGetWinINI Lib "t2win-16.dll" (ByVal Info As Integer) As String
Declare Function cGetWinSection Lib "t2win-16.dll" (ByVal Section As String) As String
Declare Function cGiveBitPalindrome Lib "t2win-16.dll" () As String
Declare Function cH2I Lib "t2win-16.dll" (ByVal Txt As String) As Integer
Declare Function cH2L Lib "t2win-16.dll" (ByVal Txt As String) As Long
Declare Function cHideAllEditForm Lib "t2win-16.dll" () As Integer
Declare Function cHideDebugForm Lib "t2win-16.dll" () As Integer
Declare Function cHourTo Lib "t2win-16.dll" (Txt As String) As Variant
Declare Function cIfInStr Lib "t2win-16.dll" (Txt As String, Operator As String) As String
Declare Sub cIncrI Lib "t2win-16.dll" (Value As Integer)
Declare Sub cIncrL Lib "t2win-16.dll" (Value As Long)
Declare Function cInsertBlocks Lib "t2win-16.dll" (Txt As String, Insert As String) As String
Declare Function cInsertBlocksBy Lib "t2win-16.dll" (Txt As String, Insert As String, Delimitor As String) As String
Declare Function cInsertByMask Lib "t2win-16.dll" (Txt As String, Mask As String, Insert As String) As String
Declare Function cInsertChars Lib "t2win-16.dll" (Txt As String, ByVal Position As Integer, Insert As String) As String
Declare Function cIntoBalance Lib "t2win-16.dll" (Var As Variant) As String
Declare Function cIntoBalanceFill Lib "t2win-16.dll" (Var As Variant) As String
Declare Function cIntoDate Lib "t2win-16.dll" (ByVal nDate As Long) As String
Declare Function cIntoDateFill Lib "t2win-16.dll" (ByVal nDate As Long) As String
Declare Function cIntoDateNull Lib "t2win-16.dll" (ByVal nDate As Long) As String
Declare Function cIntoFixHour Lib "t2win-16.dll" (Var As Variant, ByVal Length As Integer, ByVal fillZero As Integer, ByVal Centime As Integer) As String
Declare Function cIntoHour Lib "t2win-16.dll" (Var As Variant) As String
Declare Function cIntoVarHour Lib "t2win-16.dll" (Var As Variant) As String
Declare Function cIsAlnum Lib "t2win-16.dll" (Txt As String) As Integer
Declare Function cIsAlpha Lib "t2win-16.dll" (Txt As String) As Integer
Declare Function cIsAscii Lib "t2win-16.dll" (Txt As String) As Integer
Declare Function cIsBalance Lib "t2win-16.dll" (ByVal nHour As Long, ByVal nMinute As Integer, ByVal nSecond As Integer) As Integer
Declare Function cIsBitPalindrome Lib "t2win-16.dll" (Txt As String) As Integer
Declare Function cIsCsym Lib "t2win-16.dll" (Txt As String) As Integer
Declare Function cIsCsymf Lib "t2win-16.dll" (Txt As String) As Integer
Declare Function cIsDate Lib "t2win-16.dll" (ByVal nYear As Integer, ByVal nMonth As Integer, ByVal nDay As Integer) As Integer
Declare Function cIsDigit Lib "t2win-16.dll" (Txt As String) As Integer
Declare Function cIsFileArchive Lib "t2win-16.dll" (ByVal nFilename As String) As Integer
Declare Function cIsFileEmpty Lib "t2win-16.dll" (ByVal nFilename As String) As Integer
Declare Function cIsFileFlag Lib "t2win-16.dll" (ByVal nFilename As String, ByVal nStatus As Integer) As Integer
Declare Function cIsFileHidden Lib "t2win-16.dll" (ByVal nFilename As String) As Integer
Declare Function cIsFileNormal Lib "t2win-16.dll" (ByVal nFilename As String) As Integer
Declare Function cIsFilenameValid Lib "t2win-16.dll" (ByVal nFilename As String) As Integer
Declare Function cIsFileReadOnly Lib "t2win-16.dll" (ByVal nFilename As String) As Integer
Declare Function cIsFileSubDir Lib "t2win-16.dll" (ByVal nFilename As String) As Integer
Declare Function cIsFileSystem Lib "t2win-16.dll" (ByVal nFilename As String) As Integer
Declare Function cIsFileVolId Lib "t2win-16.dll" (ByVal nFilename As String) As Integer
Declare Function cIsFormEnabled Lib "t2win-16.dll" (ByVal hWnd As Integer) As Integer
Declare Function cIsHour Lib "t2win-16.dll" (ByVal nHour As Integer, ByVal nMinute As Integer, ByVal nSecond As Integer) As Integer
Declare Function cIsISBN Lib "t2win-16.dll" (Txt As String) As Integer
Declare Function cIsLeapYear Lib "t2win-16.dll" (ByVal nYear As Integer) As Integer
Declare Function cIsLower Lib "t2win-16.dll" (Txt As String) As Integer
Declare Function cIsPalindrome Lib "t2win-16.dll" (Txt As String) As Integer
Declare Function cIsPunct Lib "t2win-16.dll" (Txt As String) As Integer
Declare Function cIsSerial Lib "t2win-16.dll" (ByVal file1 As String) As Integer
Declare Function cIsSpace Lib "t2win-16.dll" (Txt As String) As Integer
Declare Function cIsUpper Lib "t2win-16.dll" (Txt As String) As Integer
Declare Function cIsXdigit Lib "t2win-16.dll" (Txt As String) As Integer
Declare Function cKillDir Lib "t2win-16.dll" (ByVal lpFilename As String) As Integer
Declare Function cKillDirFilesAll Lib "t2win-16.dll" (ByVal lpDir As String, ByVal lpMask As String) As Integer
Declare Function cKillDirs Lib "t2win-16.dll" (ByVal lpDir As String, ByVal HeaderDirectory As Integer) As Integer
Declare Function cKillFile Lib "t2win-16.dll" (ByVal lpFilename As String) As Integer
Declare Function cKillFileAll Lib "t2win-16.dll" (ByVal lpFilename As String) As Integer
Declare Function cKillFiles Lib "t2win-16.dll" (ByVal lpFilename As String) As Integer
Declare Function cKillFilesAll Lib "t2win-16.dll" (ByVal lpFilename As String) As Integer
Declare Function cLngMsgBox Lib "t2win-16.dll" (ByVal nLanguage As Integer, ByVal Message As String, ByVal Button As Long, ByVal Title As String) As Integer
Declare Sub cLngBoxMsg Lib "t2win-16.dll" Alias "cLngMsgBox" (ByVal nLanguage As Integer, ByVal Message As String, ByVal Button As Long, ByVal Title As String)
Declare Function cLngInpBox Lib "t2win-16.dll" (ByVal nLanguage As Integer, ByVal Message As String, ByVal Title As String, ByVal Default As String) As String
Declare Sub cLngSysMenu Lib "t2win-16.dll" (ByVal nLanguage As Integer, ByVal hWnd As Integer)
Declare Function cLrc Lib "t2win-16.dll" (Txt As String) As String
Declare Function cMakeDir Lib "t2win-16.dll" (ByVal lpFilename As String) As Integer
Declare Function cMakeMultipleDir Lib "t2win-16.dll" (ByVal lpFilename As String) As Integer
Declare Function cMakePath Lib "t2win-16.dll" (ByVal nDrive As String, ByVal nDir As String, ByVal nFilename As String, ByVal Ext As String) As String
Declare Sub cMatrixAdd Lib "t2win-16.dll" (ByVal Size As Integer, ArrayA() As Double, ArrayB() As Double, ArrayC() As Double)
Declare Function cMatrixCoFactor Lib "t2win-16.dll" (ByVal Size As Integer, ArrayA() As Double, ByVal Row As Integer, ByVal Col As Integer) As Double
Declare Function cMatrixCompare Lib "t2win-16.dll" (ByVal Size As Integer, ArrayA() As Double, ArrayC() As Double) As Integer
Declare Sub cMatrixCopy Lib "t2win-16.dll" (ByVal Size As Integer, ArrayA() As Double, ArrayC() As Double)
Declare Function cMatrixDet Lib "t2win-16.dll" (ByVal Size As Integer, ArrayA() As Double) As Double
Declare Function cMatrixFill Lib "t2win-16.dll" (ByVal Size As Integer, ArrayA() As Double, ByVal nInit As Integer) As Integer
Declare Function cMatrixInv Lib "t2win-16.dll" (ByVal Size As Integer, ArrayA() As Double, ArrayC() As Double) As Integer
Declare Function cMatrixMinor Lib "t2win-16.dll" (ByVal Size As Integer, ArrayA() As Double, ByVal Row As Integer, ByVal Col As Integer) As Double
Declare Sub cMatrixMul Lib "t2win-16.dll" (ByVal Size As Integer, ArrayA() As Double, ArrayB() As Double, ArrayC() As Double)
Declare Sub cMatrixSub Lib "t2win-16.dll" (ByVal Size As Integer, ArrayA() As Double, ArrayB() As Double, ArrayC() As Double)
Declare Function cMatrixSymToeplitz Lib "t2win-16.dll" (ByVal Size As Integer, ArrayA() As Double, ArrayC() As Double) As Integer
Declare Sub cMatrixTranspose Lib "t2win-16.dll" (ByVal Size As Integer, ArrayA() As Double, ArrayC() As Double)
Declare Function cMax Lib "t2win-16.dll" (Var1 As Variant, Var2 As Variant) As Variant
Declare Function cMaxD Lib "t2win-16.dll" (array() As Double) As Double
Declare Function cMaxI Lib "t2win-16.dll" (array() As Integer) As Integer
Declare Function cMaxL Lib "t2win-16.dll" (array() As Long) As Long
Declare Function cMaxS Lib "t2win-16.dll" (array() As Single) As Single
Declare Function cMDAClear Lib "t2win-16.dll" (ByVal array As Integer, MULTIPLEDISKARRAY As tagMULTIPLEDISKARRAY) As Integer
Declare Function cMDAClearCol Lib "t2win-16.dll" (ByVal array As Integer, MULTIPLEDISKARRAY As tagMULTIPLEDISKARRAY, ByVal Col As Long, ByVal sheet As Long) As Integer
Declare Function cMDAClearRow Lib "t2win-16.dll" (ByVal array As Integer, MULTIPLEDISKARRAY As tagMULTIPLEDISKARRAY, ByVal Row As Long, ByVal sheet As Long) As Integer
Declare Function cMDAClearSheet Lib "t2win-16.dll" (ByVal array As Integer, MULTIPLEDISKARRAY As tagMULTIPLEDISKARRAY, ByVal sheet As Long) As Integer
Declare Sub cMDAClose Lib "t2win-16.dll" (MULTIPLEDISKARRAY As tagMULTIPLEDISKARRAY, ByVal DeleteFile As Integer)
Declare Function cMDACreate Lib "t2win-16.dll" (MULTIPLEDISKARRAY As tagMULTIPLEDISKARRAY, ByVal CreateOrUse As Integer) As Integer
Declare Function cMDAGet Lib "t2win-16.dll" (ByVal array As Integer, MULTIPLEDISKARRAY As tagMULTIPLEDISKARRAY, ByVal Row As Long, ByVal Col As Long, ByVal sheet As Long) As Variant
Declare Sub cMDAGetType Lib "t2win-16.dll" (ByVal array As Integer, MULTIPLEDISKARRAY As tagMULTIPLEDISKARRAY, ByVal Row As Long, ByVal Col As Long, ByVal sheet As Long, nType As Any)
Declare Sub cMDAPut Lib "t2win-16.dll" (ByVal array As Integer, MULTIPLEDISKARRAY As tagMULTIPLEDISKARRAY, ByVal Row As Long, ByVal Col As Long, ByVal sheet As Long, Var As Variant)
Declare Sub cMDAPutType Lib "t2win-16.dll" (ByVal array As Integer, MULTIPLEDISKARRAY As tagMULTIPLEDISKARRAY, ByVal Row As Long, ByVal Col As Long, ByVal sheet As Long, nType As Any)
Declare Sub cMDArGet Lib "t2win-16.dll" (ByVal array As Integer, MULTIPLEDISKARRAY As tagMULTIPLEDISKARRAY, ByVal Col As Long, Var As Variant)
Declare Sub cMDArGetType Lib "t2win-16.dll" (ByVal array As Integer, MULTIPLEDISKARRAY As tagMULTIPLEDISKARRAY, ByVal Col As Long, nType As Any)
Declare Sub cMDArPut Lib "t2win-16.dll" (ByVal array As Integer, MULTIPLEDISKARRAY As tagMULTIPLEDISKARRAY, ByVal Col As Long, Var As Variant)
Declare Sub cMDArPutType Lib "t2win-16.dll" (ByVal array As Integer, MULTIPLEDISKARRAY As tagMULTIPLEDISKARRAY, ByVal Col As Long, nType As Any)
Declare Function cMDAsClearCol Lib "t2win-16.dll" (ByVal array As Integer, MULTIPLEDISKARRAY As tagMULTIPLEDISKARRAY, ByVal Col As Long) As Integer
Declare Function cMDAsClearRow Lib "t2win-16.dll" (ByVal array As Integer, MULTIPLEDISKARRAY As tagMULTIPLEDISKARRAY, ByVal Row As Long) As Integer
Declare Sub cMDAsGet Lib "t2win-16.dll" (ByVal array As Integer, MULTIPLEDISKARRAY As tagMULTIPLEDISKARRAY, ByVal Row As Long, ByVal Col As Long, Var As Variant)
Declare Sub cMDAsGetType Lib "t2win-16.dll" (ByVal array As Integer, MULTIPLEDISKARRAY As tagMULTIPLEDISKARRAY, ByVal Row As Long, ByVal Col As Long, nType As Any)
Declare Sub cMDAsPut Lib "t2win-16.dll" (ByVal array As Integer, MULTIPLEDISKARRAY As tagMULTIPLEDISKARRAY, ByVal Row As Long, ByVal Col As Long, Var As Variant)
Declare Sub cMDAsPutType Lib "t2win-16.dll" (ByVal array As Integer, MULTIPLEDISKARRAY As tagMULTIPLEDISKARRAY, ByVal Row As Long, ByVal Col As Long, nType As Any)
Declare Function cMeanD Lib "t2win-16.dll" (array() As Double) As Double
Declare Function cMeanI Lib "t2win-16.dll" (array() As Integer) As Double
Declare Function cMeanL Lib "t2win-16.dll" (array() As Long) As Double
Declare Function cMeanS Lib "t2win-16.dll" (array() As Single) As Double
Declare Function cMin Lib "t2win-16.dll" (Var1 As Variant, Var2 As Variant) As Variant
Declare Function cMinD Lib "t2win-16.dll" (array() As Double) As Double
Declare Function cMinI Lib "t2win-16.dll" (array() As Integer) As Integer
Declare Function cMinL Lib "t2win-16.dll" (array() As Long) As Long
Declare Function cMinS Lib "t2win-16.dll" (array() As Single) As Single
Declare Function cMixChars Lib "t2win-16.dll" (Txt As String) As String
Declare Function cMKB Lib "t2win-16.dll" (ByVal Value As Integer) As String
Declare Function cMKC Lib "t2win-16.dll" (ByVal Value As Currency) As String
Declare Function cMKD Lib "t2win-16.dll" (ByVal Value As Double) As String
Declare Function cMKI Lib "t2win-16.dll" (ByVal Value As Integer) As String
Declare Function cMKL Lib "t2win-16.dll" (ByVal Value As Long) As String
Declare Function cMKN Lib "t2win-16.dll" (ByVal Value As String) As String
Declare Function cMKS Lib "t2win-16.dll" (ByVal Value As Single) As String
Declare Function cModuleFind Lib "t2win-16.dll" (MODULEENTRY As Any, ByVal ModuleName As String) As Integer
Declare Function cModules Lib "t2win-16.dll" (MODULEENTRY As Any, ByVal FirstNext As Integer) As Integer
Declare Function cMorse Lib "t2win-16.dll" (ByVal morse As String) As String
Declare Function cNexthWnd Lib "t2win-16.dll" (ByVal hWnd As Integer) As Integer
Declare Function cNumDigit Lib "t2win-16.dll" (Txt As String) As Integer
Declare Function cOneCharFromLeft Lib "t2win-16.dll" (Txt As String, ByVal Position As Integer) As String
Declare Function cOneCharFromRight Lib "t2win-16.dll" (Txt As String, ByVal Position As Integer) As String
Declare Function cOrToken Lib "t2win-16.dll" (ByVal Txt As String, ByVal Token As String) As Integer
Declare Function cOrTokenIn Lib "t2win-16.dll" (ByVal Txt As String, ByVal Token As String, ByVal Separator As String) As Integer
Declare Function cPatternMatch Lib "t2win-16.dll" (ByVal Txt As String, ByVal pattern As String) As Integer
Declare Function cPatternExtMatch Lib "t2win-16.dll" (ByVal Txt As String, ByVal pattern As String) As Integer
Declare Function cProperName Lib "t2win-16.dll" (Txt As String) As String
Declare Function cProperName2 Lib "t2win-16.dll" (Txt As String, ByVal TokenToUse As String, ByVal Options As Integer) As String
Declare Sub cPutIni Lib "t2win-16.dll" (ByVal AppName As String, ByVal szItem As String, ByVal szDefault As String, ByVal InitFile As String)
Declare Function cRcsCountFileDir Lib "t2win-16.dll" (ByVal FileOrDir As Integer, ByVal FirstFileOrDir As String, ByVal MaskDir As String, ByVal Recurse As Integer) As Integer
Declare Function cRcsFilesSize Lib "t2win-16.dll" (ByVal FirstDir As String, ByVal MaskDir As String, ByVal Recurse As Integer) As Long
Declare Function cRcsFilesSizeOnDisk Lib "t2win-16.dll" (ByVal FirstDir As String, ByVal MaskDir As String, ByVal Recurse As Integer) As Long
Declare Function cRcsFilesSlack Lib "t2win-16.dll" (ByVal FirstDir As String, ByVal MaskDir As String, ByVal Recurse As Integer, Size1 As Long, Size2 As Long) As Integer
Declare Function cReadBasisTimer Lib "t2win-16.dll" () As Long
Declare Function cReadCtlLanguage Lib "t2win-16.dll" (Frm As Form, ByVal Property As Integer, ByVal FileLanguage As String) As Integer
Declare Function cReadCtlLanguageExt Lib "t2win-16.dll" (Frm As Form, ByVal Property As Integer, ByVal FileLanguage As String) As Integer
Declare Function cReadTimer Lib "t2win-16.dll" (ByVal nTimer As Integer) As Long
Declare Function cRebootSystem Lib "t2win-16.dll" () As Integer
Declare Function cRegistrationKey Lib "t2win-16.dll" (ByVal RegString As String, ByVal RegCode As Long) As Long
Declare Function cRemoveBlockChar Lib "t2win-16.dll" (Txt As String, ByVal Position As Integer, ByVal Length As Integer) As String
Declare Function cRemoveOneChar Lib "t2win-16.dll" (Txt As String, ByVal Position As Integer) As String
Declare Function cRenameFile Lib "t2win-16.dll" (ByVal lpFilename1 As String, ByVal lpFilename2 As String) As Integer
Declare Sub cResetCapture Lib "t2win-16.dll" ()
Declare Function cResizeString Lib "t2win-16.dll" (Txt As String, ByVal NewLength As Integer) As String
Declare Function cResizeStringAndFill Lib "t2win-16.dll" (Txt As String, ByVal NewLength As Integer, Fill As String) As String
Declare Function cRestartWindows Lib "t2win-16.dll" () As Integer
Declare Function cReverse Lib "t2win-16.dll" (Txt As String) As String
Declare Sub cReverseAllBits Lib "t2win-16.dll" (Txt As String)
Declare Sub cReverseAllBitsByChar Lib "t2win-16.dll" (Txt As String)
Declare Function cReverseSortD Lib "t2win-16.dll" (array() As Double) As Integer
Declare Function cReverseSortI Lib "t2win-16.dll" (array() As Integer) As Integer
Declare Function cReverseSortL Lib "t2win-16.dll" (array() As Long) As Integer
Declare Function cReverseSortS Lib "t2win-16.dll" (array() As Single) As Integer
Declare Function cReverseSortStr Lib "t2win-16.dll" (Txt As String, ByVal nItem As Integer, ByVal ItemLength As Integer) As Integer
Declare Sub cRndInit Lib "t2win-16.dll" (ByVal nRnd As Long)
Declare Function cRnd Lib "t2win-16.dll" () As Double
Declare Function cRndD Lib "t2win-16.dll" () As Double
Declare Function cRndI Lib "t2win-16.dll" () As Integer
Declare Function cRndL Lib "t2win-16.dll" () As Long
Declare Function cRndS Lib "t2win-16.dll" () As Single
Declare Function cRomanToArabic Lib "t2win-16.dll" (Txt As String) As Variant
Declare Function cSaveCtlLanguage Lib "t2win-16.dll" (Frm As Form, ByVal Property As Integer, ByVal FileLanguage As String) As Integer
Declare Function cSaveCtlLanguageExt Lib "t2win-16.dll" (Frm As Form, ByVal Property As Integer, ByVal FileLanguage As String) As Integer
Declare Sub cScalarToDate Lib "t2win-16.dll" (ByVal Scalar As Long, nYear As Integer, nMonth As Integer, nDay As Integer)
Declare Sub cScalarToTime Lib "t2win-16.dll" (ByVal Scalar As Long, nHour As Integer, nMin As Integer, nSec As Integer)
Declare Function cScrollL Lib "t2win-16.dll" (Txt As String) As String
Declare Function cScrollR Lib "t2win-16.dll" (Txt As String) As String
Declare Function cSearchI Lib "t2win-16.dll" (array() As Integer, ByVal Value As Integer) As Long
Declare Function cSearchL Lib "t2win-16.dll" (array() As Long, ByVal Value As Long) As Long
Declare Function cSearchS Lib "t2win-16.dll" (array() As Single, ByVal Value As Single) As Long
Declare Function cSearchD Lib "t2win-16.dll" (array() As Double, ByVal Value As Double) As Long
Declare Sub cSetAllBits Lib "t2win-16.dll" (Txt As String, ByVal Value As Integer)
Declare Sub cSetBit Lib "t2win-16.dll" (Txt As String, ByVal Position As Integer, ByVal Value As Integer)
Declare Sub cSetBitToFalse Lib "t2win-16.dll" (Txt As String, ByVal Position As Integer)
Declare Sub cSetBitToTrue Lib "t2win-16.dll" (Txt As String, ByVal Position As Integer)
Declare Sub cSetCapture Lib "t2win-16.dll" (ByVal hWnd As Integer)
Declare Sub cSetCtlCaption Lib "t2win-16.dll" (Obj As Object, ByVal Text As String)
Declare Sub cSetCtlDataField Lib "t2win-16.dll" (Obj As Object, ByVal Text As String)
Declare Sub cSetCtlTag Lib "t2win-16.dll" (Obj As Object, ByVal Text As String)
Declare Sub cSetCtlText Lib "t2win-16.dll" (Obj As Object, ByVal Text As String)
Declare Function cSetD Lib "t2win-16.dll" (array() As Double, ByVal nValue As Double) As Integer
Declare Sub cSetDefaultSeparator Lib "t2win-16.dll" (Separator As String)
Declare Function cSetHandleCount Lib "t2win-16.dll" (ByVal nHandle As Integer) As Integer
Declare Function cSetI Lib "t2win-16.dll" (array() As Integer, ByVal nValue As Integer) As Integer
Declare Function cSetL Lib "t2win-16.dll" (array() As Long, ByVal nValue As Long) As Integer
Declare Function cSerialGet Lib "t2win-16.dll" (ByVal file As String, SERIALDATA As tagSERIALDATA) As Integer
Declare Function cSerialInc Lib "t2win-16.dll" (ByVal file As String, ByVal Increment As Long) As Integer
Declare Function cSerialPut Lib "t2win-16.dll" (ByVal file As String, SERIALDATA As tagSERIALDATA) As Integer
Declare Function cSerialRmv Lib "t2win-16.dll" (ByVal file As String) As Integer
Declare Function cSetS Lib "t2win-16.dll" (array() As Single, ByVal nValue As Single) As Integer
Declare Sub cSetWait Lib "t2win-16.dll" (ByVal nTimer As Integer, ByVal nValue As Long)
Declare Function cSgn Lib "t2win-16.dll" (ByVal Value As Integer) As Integer
Declare Sub cShowWindow Lib "t2win-16.dll" (ByVal hWnd As Integer, ByVal Method As Integer, ByVal interval As Integer)
Declare Function cSleep Lib "t2win-16.dll" (ByVal delay As Long) As Integer
Declare Function cSortD Lib "t2win-16.dll" (array() As Double) As Integer
Declare Function cSortI Lib "t2win-16.dll" (array() As Integer) As Integer
Declare Function cSortL Lib "t2win-16.dll" (array() As Long) As Integer
Declare Function cSortS Lib "t2win-16.dll" (array() As Single) As Integer
Declare Function cSortStr Lib "t2win-16.dll" (Txt As String, ByVal nItem As Integer, ByVal ItemLength As Integer) As Integer
Declare Function cSpellMoney Lib "t2win-16.dll" (ByVal Value As Double, ByVal Units As String, ByVal Cents As String) As String
Declare Function cSplitPath Lib "t2win-16.dll" (ByVal nFilename As String, SPLITPATH As Any) As Integer
Declare Sub cStartBasisTimer Lib "t2win-16.dll" ()
Declare Sub cStartTimer Lib "t2win-16.dll" (ByVal nTimer As Integer)
Declare Sub cStartWait Lib "t2win-16.dll" (ByVal nTimer As Integer)
Declare Sub cStopBasisTimer Lib "t2win-16.dll" ()
Declare Function cStopTimer Lib "t2win-16.dll" (ByVal nTimer As Integer) As Long
Declare Function cStringCompress Lib "t2win-16.dll" (Txt As String) As String
Declare Function cStringCRC32 Lib "t2win-16.dll" (Txt As String) As Long
Declare Function cStringExpand Lib "t2win-16.dll" (Txt As String) As String
Declare Function cStringSAR Lib "t2win-16.dll" (ByVal Txt As String, ByVal Search As String, ByVal Replace As String, ByVal Sensitivity As Integer) As String
Declare Sub cStringToType Lib "t2win-16.dll" Alias "cTypesCopy" (ByVal Src As String, TypeDst As Any, ByVal lenTypeSrc As Integer)
Declare Function cSubDirectory Lib "t2win-16.dll" (ByVal nFilename As String, ByVal FirstNext As Integer) As String
Declare Function cSumD Lib "t2win-16.dll" (array() As Double) As Double
Declare Function cSumI Lib "t2win-16.dll" (array() As Integer) As Double
Declare Function cSumL Lib "t2win-16.dll" (array() As Long) As Double
Declare Function cSumS Lib "t2win-16.dll" (array() As Single) As Double
Declare Sub cSysMenuChange Lib "t2win-16.dll" (ByVal hWnd As Integer, ByVal Position As Integer, ByVal NewMessage As String)
Declare Sub cSwapD Lib "t2win-16.dll" (swap1 As Double, swap2 As Double)
Declare Sub cSwapI Lib "t2win-16.dll" (swap1 As Integer, swap2 As Integer)
Declare Sub cSwapL Lib "t2win-16.dll" (swap1 As Long, swap2 As Long)
Declare Sub cSwapS Lib "t2win-16.dll" (swap1 As Single, swap2 As Single)
Declare Sub cSwapStr Lib "t2win-16.dll" (swap1 As String, swap2 As String)
Declare Function cTaskFind Lib "t2win-16.dll" (TASKENTRY As Any, ByVal hTask As Integer) As Integer
Declare Function cTasks Lib "t2win-16.dll" (TASKENTRY As Any, ByVal FirstNext As Integer) As Integer
Declare Function cTimeBetween Lib "t2win-16.dll" (ByVal Hr1 As Integer, ByVal Hr2 As Integer) As Integer
Declare Function cTimerClose Lib "t2win-16.dll" (ByVal TimerHandle As Integer) As Integer
Declare Function cTimerOpen Lib "t2win-16.dll" () As Integer
Declare Function cTimerRead Lib "t2win-16.dll" (ByVal TimerHandle As Integer) As Long
Declare Function cTimerStart Lib "t2win-16.dll" (ByVal TimerHandle As Integer) As Integer
Declare Function cTimeToScalar Lib "t2win-16.dll" (ByVal nHour As Integer, ByVal nMin As Integer, ByVal nSec As Integer) As Long
Declare Function cToBinary Lib "t2win-16.dll" (Text As String) As String
Declare Function cToBinary2 Lib "t2win-16.dll" (Text As String, Bin As String) As String
Declare Sub cToggleAllBits Lib "t2win-16.dll" (Txt As String)
Declare Sub cToggleBit Lib "t2win-16.dll" (Txt As String, ByVal Position As Integer)
Declare Function cToHexa Lib "t2win-16.dll" (Text As String) As String
Declare Function cTokenIn Lib "t2win-16.dll" (Txt As String, Separator As String, ByVal Position As Integer) As String
Declare Function cTrueBetween Lib "t2win-16.dll" (Var As Variant, Var1 As Variant, Var2 As Variant) As Integer
Declare Function cTruncatePath Lib "t2win-16.dll" (ByVal nFilename As String, ByVal NewLength As Integer) As String
Declare Sub cTypeClear Lib "t2win-16.dll" (TypeSrc As Any, ByVal lenTypeSrc As Integer)
Declare Function cTypeMid Lib "t2win-16.dll" (TypeSrc As Any, ByVal offset As Integer, ByVal Length As Integer) As String
Declare Function cTypesCompare Lib "t2win-16.dll" (Type1 As Any, Type2 As Any, ByVal lenType1 As Integer) As Integer
Declare Sub cTypesCopy Lib "t2win-16.dll" (TypeSrc As Any, TypeDst As Any, ByVal lenTypeSrc As Integer)
Declare Function cTypeTransfert Lib "t2win-16.dll" (TypeSrc As Any, ByVal lenTypeSrc As Integer) As String
Declare Sub cTypeToString Lib "t2win-16.dll" Alias "cTypesCopy" (TypeSrc As Any, ByVal Dst As String, ByVal lenTypeSrc As Integer)
Declare Function cUncompact Lib "t2win-16.dll" (Txt As String) As String
Declare Function cUnHideAllEditForm Lib "t2win-16.dll" () As Integer
Declare Function cUnHideDebugForm Lib "t2win-16.dll" () As Integer
Declare Function cUniqueFileName Lib "t2win-16.dll" (Txt As String) As String
Declare Sub cUnloadDLL Lib "t2win-16.dll" (ByVal hMod As Integer)
Declare Function cWalkThruWindow Lib "t2win-16.dll" (Class As String, Caption As String, OwnerHwnd As Integer, OwnerClass As String, OwnerCaption As String, ByVal FirstNext As Integer) As Integer
Declare Function cWeekOfYear Lib "t2win-16.dll" (ByVal nYear As Integer, ByVal nMonth As Integer, ByVal nDay As Integer, ByVal nISO As Integer) As Integer

Declare Sub cPushID Lib "t2win-16.dll" (IDArray As Integer, ByVal nID As Integer)
Declare Sub cPopID Lib "t2win-16.dll" (IDArray As Integer, ByVal nID As Integer)
Declare Sub cPopLastID Lib "t2win-16.dll" (IDArray As Integer)
Declare Function cGetID Lib "t2win-16.dll" (IDArray As Integer, ByVal nPosition As Integer) As Integer
Declare Sub cClearID Lib "t2win-16.dll" (IDArray As Integer)

' File I/O, direct routines issued from C functionnalities
Declare Function cFopen Lib "t2win-16.dll" (ByVal file As String, ByVal Mode As String) As Long
Declare Function cFclose Lib "t2win-16.dll" (ByVal IOstream As Long) As Integer
Declare Function cFgetc Lib "t2win-16.dll" (ByVal IOstream As Long) As Integer
Declare Function cFputc Lib "t2win-16.dll" (ByVal char As Integer, ByVal IOstream As Long) As Integer
Declare Function cFputs Lib "t2win-16.dll" (ByVal Txt As String, ByVal IOstream As Long) As Integer
Declare Function cFgets Lib "t2win-16.dll" (Txt As String, ByVal Length As Integer, ByVal IOstream As Long) As Integer
Declare Function cFwrite Lib "t2win-16.dll" (Txt As String, ByVal IOstream As Long) As Integer
Declare Function cFread Lib "t2win-16.dll" (Txt As String, ByVal Length As Integer, ByVal IOstream As Long) As Integer
Declare Function cFcloseall Lib "t2win-16.dll" () As Integer
Declare Function cFflush Lib "t2win-16.dll" (ByVal IOstream As Long) As Integer
Declare Function cFflushall Lib "t2win-16.dll" () As Integer
Declare Function cFeof Lib "t2win-16.dll" (ByVal IOstream As Long) As Integer
Declare Function cFerror Lib "t2win-16.dll" (ByVal IOstream As Long) As Integer
Declare Sub cFclearerr Lib "t2win-16.dll" (ByVal IOstream As Long)
Declare Function cFseek Lib "t2win-16.dll" (ByVal IOstream As Long, ByVal offset As Long, ByVal origin As Integer) As Integer
Declare Function cFtell Lib "t2win-16.dll" (ByVal IOstream As Long) As Long
Declare Sub cFrewind Lib "t2win-16.dll" (ByVal IOstream As Long)

' Functions for calculating interest rate
Declare Function cAtoF Lib "t2win-16.dll" (ByVal Interest As Double, ByVal N As Integer) As Double
Declare Function cAtoFC Lib "t2win-16.dll" (ByVal Rates As Double, ByVal N As Integer) As Double
Declare Function cAtoP Lib "t2win-16.dll" (ByVal Interest As Double, ByVal N As Integer) As Double
Declare Function cAtoPC Lib "t2win-16.dll" (ByVal Rates As Double, ByVal N As Integer) As Double
Declare Function cFtoA Lib "t2win-16.dll" (ByVal Interest As Double, ByVal N As Integer) As Double
Declare Function cFtoAC Lib "t2win-16.dll" (ByVal Rates As Double, ByVal N As Integer) As Double
Declare Function cFtoP Lib "t2win-16.dll" (ByVal Interest As Double, ByVal N As Integer) As Double
Declare Function cFtoPC Lib "t2win-16.dll" (ByVal Rates As Double, ByVal N As Integer) As Double
Declare Function cPtoA Lib "t2win-16.dll" (ByVal Interest As Double, ByVal N As Integer) As Double
Declare Function cPtoAC Lib "t2win-16.dll" (ByVal Rates As Double, ByVal N As Integer) As Double
Declare Function cPtoF Lib "t2win-16.dll" (ByVal Interest As Double, ByVal N As Integer) As Double
Declare Function cPtoFC Lib "t2win-16.dll" (ByVal Rates As Double, ByVal N As Integer) As Double

' Functions for calculating 2-D geometry
Declare Sub cV2Add Lib "t2win-16.dll" (u As tagVECTOR2, v As tagVECTOR2, w As tagVECTOR2)
Declare Sub cV2Sub Lib "t2win-16.dll" (u As tagVECTOR2, v As tagVECTOR2, w As tagVECTOR2)
Declare Sub cV2Combine Lib "t2win-16.dll" (u As tagVECTOR2, ByVal c1 As Double, v As tagVECTOR2, ByVal c2 As Double, w As tagVECTOR2)
Declare Sub cV2Copy Lib "t2win-16.dll" (u As tagVECTOR2, w As tagVECTOR2)
Declare Function cV2Dot Lib "t2win-16.dll" (u As tagVECTOR2, v As tagVECTOR2) As Double
Declare Function cV2Length Lib "t2win-16.dll" (u As tagVECTOR2) As Double
Declare Function cV2LengthSquared Lib "t2win-16.dll" (u As tagVECTOR2) As Double
Declare Sub cV2LinearIp Lib "t2win-16.dll" (lo As tagVECTOR2, hi As tagVECTOR2, ByVal alpha As Double, w As tagVECTOR2)
Declare Sub cV2Mul Lib "t2win-16.dll" (u As tagVECTOR2, v As tagVECTOR2, w As tagVECTOR2)
Declare Sub cV2Neg Lib "t2win-16.dll" (u As tagVECTOR2)
Declare Sub cV2Normalized Lib "t2win-16.dll" (u As tagVECTOR2)
Declare Sub cV2Ortho Lib "t2win-16.dll" (u As tagVECTOR2, w As tagVECTOR2)
Declare Sub cV2ScaledNewLength Lib "t2win-16.dll" (u As tagVECTOR2, ByVal newlen As Double)
Declare Function cV2SegmentLength Lib "t2win-16.dll" (p As tagVECTOR2, q As tagVECTOR2) As Double

' Functions for calculating 3-D geometry
Declare Sub cV3Add Lib "t2win-16.dll" (u As tagVECTOR3, v As tagVECTOR3, w As tagVECTOR3)
Declare Sub cV3Sub Lib "t2win-16.dll" (u As tagVECTOR3, v As tagVECTOR3, w As tagVECTOR3)
Declare Sub cV3Combine Lib "t2win-16.dll" (u As tagVECTOR3, ByVal c1 As Double, v As tagVECTOR3, ByVal c2 As Double, w As tagVECTOR3)
Declare Sub cV3Copy Lib "t2win-16.dll" (u As tagVECTOR3, w As tagVECTOR3)
Declare Sub cV3Cross Lib "t2win-16.dll" (u As tagVECTOR3, v As tagVECTOR3, w As tagVECTOR3)
Declare Function cV3Dot Lib "t2win-16.dll" (u As tagVECTOR3, v As tagVECTOR3) As Double
Declare Function cV3Length Lib "t2win-16.dll" (u As tagVECTOR3) As Double
Declare Function cV3LengthSquared Lib "t2win-16.dll" (u As tagVECTOR3) As Double
Declare Sub cV3LinearIp Lib "t2win-16.dll" (lo As tagVECTOR3, hi As tagVECTOR3, ByVal alpha As Double, w As tagVECTOR3)
Declare Sub cV3Mul Lib "t2win-16.dll" (u As tagVECTOR3, v As tagVECTOR3, w As tagVECTOR3)
Declare Sub cV3Neg Lib "t2win-16.dll" (u As tagVECTOR3)
Declare Sub cV3Normalized Lib "t2win-16.dll" (u As tagVECTOR3)
Declare Sub cV3ScaledNewLength Lib "t2win-16.dll" (u As tagVECTOR3, ByVal newlen As Double)
Declare Function cV3SegmentLength Lib "t2win-16.dll" (p As tagVECTOR3, q As tagVECTOR3) As Double

' Functions for Huge String management
Declare Function cHugeStrAdd Lib "t2win-16.dll" (ByVal hsHandle As Integer, hsText As String) As Integer
Declare Function cHugeStrAddress Lib "t2win-16.dll" (ByVal hsHandle As Integer) As Long
Declare Function cHugeStrAppend Lib "t2win-16.dll" (ByVal hsHandle As Integer, hsText As String) As Integer
Declare Function cHugeStrBlocks Lib "t2win-16.dll" (ByVal hsHandle As Integer) As Long
Declare Function cHugeStrClear Lib "t2win-16.dll" (ByVal hsHandle As Integer) As Integer
Declare Function cHugeStrCreate Lib "t2win-16.dll" (ByVal hsSize As Long) As Integer
Declare Function cHugeStrFree Lib "t2win-16.dll" (ByVal hsHandle As Integer) As Integer
Declare Function cHugeStrGetNP Lib "t2win-16.dll" (ByVal hsHandle As Integer) As Long
Declare Function cHugeStrGetWP Lib "t2win-16.dll" (ByVal hsHandle As Integer) As Long
Declare Function cHugeStrLength Lib "t2win-16.dll" (ByVal hsHandle As Integer) As Long
Declare Function cHugeStrMid Lib "t2win-16.dll" (ByVal hsHandle As Integer, ByVal hsStart As Long, ByVal hsLength As Long) As String
Declare Function cHugeStrNext Lib "t2win-16.dll" (ByVal hsHandle As Integer, ByVal hsNext As Long) As String
Declare Function cHugeStrOnDisk Lib "t2win-16.dll" (ByVal hsHandle As Integer, ByVal hsFile As String, ByVal hsGetPut As Integer) As Long
Declare Function cHugeStrRead Lib "t2win-16.dll" (ByVal hsHandle As Integer, ByVal hsBlock As Long) As String
Declare Function cHugeStrSetNP Lib "t2win-16.dll" (ByVal hsHandle As Integer, ByVal hsPtr As Long) As Integer
Declare Function cHugeStrSetWP Lib "t2win-16.dll" (ByVal hsHandle As Integer, ByVal hsPtr As Long) As Integer
Declare Function cHugeStrSize Lib "t2win-16.dll" (ByVal hsHandle As Integer) As Long

' Functions for Huge Memory Array management
Declare Function cHMAClear Lib "t2win-16.dll" (HMA As tagHMA) As Integer
Declare Function cHMAClearCol Lib "t2win-16.dll" (HMA As tagHMA, ByVal Col As Long, ByVal sheet As Long) As Integer
Declare Function cHMAClearRow Lib "t2win-16.dll" (HMA As tagHMA, ByVal Row As Long, ByVal sheet As Long) As Integer
Declare Function cHMAClearSheet Lib "t2win-16.dll" (HMA As tagHMA, ByVal sheet As Long) As Integer
Declare Function cHMACreate Lib "t2win-16.dll" (HMA As tagHMA) As Integer
Declare Function cHMAFree Lib "t2win-16.dll" (HMA As tagHMA) As Integer
Declare Function cHMAGet Lib "t2win-16.dll" (HMA As tagHMA, ByVal Row As Long, ByVal Col As Long, ByVal sheet As Long) As Variant
Declare Sub cHMAGetType Lib "t2win-16.dll" (HMA As tagHMA, ByVal Row As Long, ByVal Col As Long, ByVal sheet As Long, nType As Any)
Declare Sub cHMAPut Lib "t2win-16.dll" (HMA As tagHMA, ByVal Row As Long, ByVal Col As Long, ByVal sheet As Long, Var As Variant)
Declare Sub cHMAPutType Lib "t2win-16.dll" (HMA As tagHMA, ByVal Row As Long, ByVal Col As Long, ByVal sheet As Long, nType As Any)
Declare Sub cHMArGet Lib "t2win-16.dll" (HMA As tagHMA, ByVal Col As Long, Var As Variant)
Declare Sub cHMArGetType Lib "t2win-16.dll" (HMA As tagHMA, ByVal Col As Long, nType As Any)
Declare Sub cHMArPut Lib "t2win-16.dll" (HMA As tagHMA, ByVal Col As Long, Var As Variant)
Declare Sub cHMArPutType Lib "t2win-16.dll" (HMA As tagHMA, ByVal Col As Long, nType As Any)
Declare Sub cHMAsGet Lib "t2win-16.dll" (HMA As tagHMA, ByVal Row As Long, ByVal Col As Long, Var As Variant)
Declare Sub cHMAsGetType Lib "t2win-16.dll" (HMA As tagHMA, ByVal Row As Long, ByVal Col As Long, nType As Any)
Declare Sub cHMAsPut Lib "t2win-16.dll" (HMA As tagHMA, ByVal Row As Long, ByVal Col As Long, Var As Variant)
Declare Sub cHMAsPutType Lib "t2win-16.dll" (HMA As tagHMA, ByVal Row As Long, ByVal Col As Long, nType As Any)
Declare Function cHMAsClearCol Lib "t2win-16.dll" (HMA As tagHMA, ByVal Col As Long) As Integer
Declare Function cHMAsClearRow Lib "t2win-16.dll" (HMA As tagHMA, ByVal Row As Long) As Integer
Declare Function cHMAOnDisk Lib "t2win-16.dll" (HMA As tagHMA, ByVal hsFile As String, ByVal hsGetPut As Integer) As Long

' functions for accessing OCX and VBX custom controls
Declare Sub cObjectMethodByPos Lib "t2win-16.dll" (Obj As Object, ByVal Property As Integer, lpPut As Variant)
Declare Function cObjectGetPropertyByPos Lib "t2win-16.dll" (Obj As Object, ByVal Property As Integer) As Variant
Declare Sub cObjectPutPropertyByPos Lib "t2win-16.dll" (Obj As Object, ByVal Property As Integer, lpPut As Variant)
Declare Sub cObjectMethodByName Lib "t2win-16.dll" (Obj As Object, ByVal Property As String, lpPut As Variant)
Declare Function cObjectGetPropertyByName Lib "t2win-16.dll" (Obj As Object, ByVal Property As String) As Variant
Declare Sub cObjectPutPropertyByName Lib "t2win-16.dll" (Obj As Object, ByVal Property As String, lpPut As Variant)

