unit Fdemo15;

interface

uses WinTypes, WinProcs, Classes, Graphics, Forms, Controls, Buttons,
  StdCtrls, PrnWin, ExtCtrls, DBTables, DB, Printers, DBCtrls, CB_Types;

type
  TForm15 = class(TForm)
    Bevel1: TBevel;
    Memo1: TMemo;
    Table1: TTable;
    Table2: TTable;
    Query1: TQuery;
    Query2: TQuery;
    Query3: TQuery;
    DataSource1: TDataSource;
    DataSource2: TDataSource;
    DataSource3: TDataSource;
    DataSource4: TDataSource;
    DataSource5: TDataSource;
    Query1SpeciesNo: TFloatField;
    Query1Category: TStringField;
    Query1Common_Name: TStringField;
    Table1NAME: TStringField;
    Table1SIZE: TSmallintField;
    Table1WEIGHT: TSmallintField;
    Table1AREA: TStringField;
    Query2Name: TStringField;
    Query2Capital: TStringField;
    Query2Continent: TStringField;
    Query2Population: TFloatField;
    Query3Company: TStringField;
    Query3Phone: TStringField;
    Query3LastInvoiceDate: TDateTimeField;
    Preview: TBitBtn;
    Exit: TBitBtn;
    Table2IND_CODE: TSmallintField;
    Table2IND_NAME: TStringField;
    Table2LONG_NAME: TStringField;
    Table1BMP: TBlobField;
    DBImage1: TDBImage;
    DBImage2: TDBImage;
    Query1Graphic: TGraphicField;
    PrintWin1: TPrintWin;
    procedure PreviewClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form15: TForm15;

implementation

{$R *.DFM}

procedure TForm15.PreviewClick(Sender: TObject);
var
	i: Integer;
   Right, Bottom, Top: Real;
begin
   PrintWin1.BeginPrint;

   { This will take a bit of programming! }

   { Set a nice big font }
   PrintWin1.NewFont ('Arial',20,True,True,True); { The 3 True's are for Bold,
                                                   Italic and Underline }

   { And change the color to Red }
   PrintWin1.SetTheTextColor (RGB(255,0,0));

   { Draw the text in the Center of the page }
   PrintWin1.DrawText( 1.0,poCenter,'A 4-Page Demo for TPrintWin');

   { Draw the first table }
   PrintWin1.NewFont ('Arial',14,False,False,True);
   PrintWin1.SetTheTextColor (RGB(0,0,255));
   PrintWin1.DrawText( 2.0,poLeft,'Here is a list of animals from Table1');
   PrintWin1.DrawTable( 2.3, poLeft, Table1, True, False);

   { Draw the 2nd table }
   PrintWin1.SetTheTextColor (RGB(0,0,255));
   PrintWin1.DrawText( 4.6,poLeft,'Here is another Table');
   PrintWin1.DrawTable( 5.0, poLeft, Table2, True, False);

   { Draw the 2nd table again}
   PrintWin1.SetTheTextColor (RGB(0,0,0));
   PrintWin1.DrawText( 2.0,poRight,'Repeating Table2');
   PrintWin1.DrawTable( 2.3, poRight, Table2, True, False);

   { And the 1st Query }
   PrintWin1.SetTheTextColor (RGB(0,255,0));
   PrintWin1.DrawText( 4.6,poRight,'Here is a Query');
   PrintWin1.DrawQuery( 5.0, poRight, Query1, True, False);

   { And Draw some lines in different colors, added some Printer info }
   Bottom := PrintWin1.PageHeight - 1;
   Top := Bottom - 1.5;
   Right := 1.01;
   for i := 0 to 30 do begin
   	if i mod 3 = 0 then
   		PrintWin1.SelectPen(1, RGB(255,0,0));
   	if i mod 3 = 1 then
   		PrintWin1.SelectPen(1, RGB(0,255,0));
   	if i mod 3 = 2 then
   		PrintWin1.SelectPen(1, RGB(0,0,255));

      PrintWin1.DrawLine( 0.5, Top, Right, Bottom);
      Top := Top + 0.03;
      Right := Right + 0.07;
      Bottom := Bottom - 0.03;

      PrintWin1.DrawLine( 0.5, Bottom, Right, Top);
   end;

   { And Frame them nicely }
   Bottom := PrintWin1.PageHeight - 1;
   Top := Bottom - 1.5;
   PrintWin1.SetTheTextColor (RGB(0,0,255));
   PrintWin1.DrawText(Top - 0.3,poLeft,'Draw a few lines');
   PrintWin1.DrawLine(0.5,Top,Right,Top);
   PrintWin1.DrawLine(0.5,Bottom,Right,Bottom);
   PrintWin1.DrawLine(0.5,Top,0.5,Bottom);
   PrintWin1.DrawLine(Right,Top,Right,Bottom);

   { Print a Bitmap }
   PrintWin1.DrawText(Top - 0.3,poRight,'Draw an Image');
   PrintWin1.PrintBitmap(PrintWin1.PageWidth -2.5,Top,2,2,DBImage1.Picture.Bitmap);

   { Now we switch the header on again }
   PrintWin1.HeaderEnabled := True;
   PrintWin1.HeaderFilled := True;
   PrintWin1.HeaderOutlined := True;
   PrintWin1.HeaderStringCenter := 'Ah, Now we have a header again';

   { And go on to the second page }
   PrintWin1.NewPage;

   { Draw the text in the Center of the 2nd page }
   PrintWin1.NewFont ('Arial',20,True,True,True);
   PrintWin1.DrawText( 1.6,poCenter,'2nd Page of a 4-Page Demo for TPrintWin');

   { Draw the 2nd Query }
   PrintWin1.NewFont ('Arial',14,False,False,True);
   PrintWin1.SetTheTextColor (RGB(0,0,255));
   PrintWin1.DrawText( 2.3,poCenter,'Name some countries in North America');
   PrintWin1.DrawText( 2.6,poCenter,'and keep to the Center');
   PrintWin1.DrawQuery( 3, poCenter, Query2, False, False);

   { Draw the 2nd Query }
   PrintWin1.NewFont ('Arial',14,True,False,True);
   PrintWin1.SetTheTextColor (RGB(255,0,0));
   PrintWin1.DrawText( 5.6,poCenter,'And now I have to make some phone calls');
   PrintWin1.DrawText( 6,poCenter,'and keep to the Center');
   PrintWin1.DrawQuery( 6.3, poCenter, Query3, False, False);

   { and Maybe just add a single Record from the phone calls query }
   PrintWin1.NewFont ('Arial',14,True,False,True);
   PrintWin1.SetTheTextColor (RGB(0,0,0));
   PrintWin1.DrawText( 8,poLeft,'And now for a single record');
   PrintWin1.NewFont ('Arial',14,False,True,False);
   PrintWin1.DrawQueryRecord( 1, 8.3, Query3);

   { And go on to the 3rd page }
   PrintWin1.NewPage;

   { Here we need a heading }
   PrintWin1.NewFont ('Arial',20,True,True,True);
   PrintWin1.DrawText( 1.6,poCenter,'3rd Page of a 4-Page Demo for TPrintWin');

   { Now we need an image, We might as well use some animals from
     table1
     Note: The DBImage component is used to extract the bitmap and
     TPrintWin Prints it}

   { First draw a grid }
   PrintWin1.NewFont ('Arial',14,True,False,False);
   PrintWin1.DrawGrid(0.5,2.3,2.3,2.3,3,3);
   for i := 0 to 2 do begin
     PrintWin1.DrawTextAt( 0.8,2.4+(2.3*i),Table1Name.AsString);
     PrintWin1.PrintBitmap(0.8,2.8+(2.3*i),1.6,1.6,DBImage1.Picture.Bitmap);
     Table1.Next;

     { There are only 7 images in the table, so return }
     if i < 2 then begin
        PrintWin1.DrawTextAt( 3.1,2.4+(2.3*i),Table1Name.AsString);
        PrintWin1.PrintBitmap(3.1,2.8+(2.3*i),1.6,1.6,DBImage1.Picture.Bitmap);
        Table1.Next;
        PrintWin1.DrawTextAt( 5.4,2.4+(2.3*i),Table1Name.AsString);
        PrintWin1.PrintBitmap(5.4,2.8+(2.3*i),1.6,1.6,DBImage1.Picture.Bitmap);
        Table1.Next;
     end;
   end;

   { And go on to the 4rd page and get the BLOB's from the Query}
   PrintWin1.NewPage;

   { Here we need a heading }
   PrintWin1.NewFont ('Arial',14,True,True,True);
   PrintWin1.DrawText( 1.6,poCenter,'4th Page of a 4-Page Demo for TPrintWin');
   for i := 0 to 2 do begin
     PrintWin1.PrintBitmap(1,2.6+(2.3*i),1.6,1.6,DBImage2.Picture.Bitmap);
     Query1.Next;

     PrintWin1.PrintBitmap(3.3,2.6+(2.3*i),1.6,1.6,DBImage2.Picture.Bitmap);
     Query1.Next;
     PrintWin1.PrintBitmap(5.6,2.6+(2.3*i),1.6,1.6,DBImage2.Picture.Bitmap);
     Query1.Next;
   end;


   PrintWin1.EndPrint;
end;

end.
