unit Fdemo09;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  StdCtrls, Forms, DBCtrls, DB, DBGrids, Buttons, PrnWin, DBTables, Grids,
  Mask, ExtCtrls, Printers,  Funcs, FuncsDB, CB_Types;

type
  TForm09 = class(TForm)
    ScrollBox: TScrollBox;
    Label1: TLabel;
    EditCustNo: TDBEdit;
    Label2: TLabel;
    EditCompany: TDBEdit;
    Label3: TLabel;
    EditAddr: TDBEdit;
    Label4: TLabel;
    EditAddr2: TDBEdit;
    Label5: TLabel;
    EditCity: TDBEdit;
    Label6: TLabel;
    EditState: TDBEdit;
    Label7: TLabel;
    EditZip: TDBEdit;
    Label8: TLabel;
    EditCountry: TDBEdit;
    Label9: TLabel;
    EditPhone: TDBEdit;
    Label10: TLabel;
    EditFAX: TDBEdit;
    Label11: TLabel;
    EditTaxRate: TDBEdit;
    Label12: TLabel;
    EditContact: TDBEdit;
    Label13: TLabel;
    EditLastInvoiceDate: TDBEdit;
    DBGrid1: TDBGrid;
    DBNavigator: TDBNavigator;
    Panel1: TPanel;
    DataSource1: TDataSource;
    Panel2: TPanel;
    Panel3: TPanel;
    Table1: TTable;
    Table2: TTable;
    DataSource2: TDataSource;
    Table2OrderNo: TFloatField;
    Table2CustNo: TFloatField;
    Table2SaleDate: TDateTimeField;
    Table2ShipDate: TDateTimeField;
    Table2ShipVIA: TStringField;
    Table2Terms: TStringField;
    Table2PaymentMethod: TStringField;
    Table2ItemsTotal: TCurrencyField;
    Table2AmountPaid: TCurrencyField;
    Preview: TBitBtn;
    Print: TBitBtn;
    Exit: TBitBtn;
    PrintWin1: TPrintWin;
    procedure FormCreate(Sender: TObject);
    procedure PreviewClick(Sender: TObject);
    procedure PrintClick(Sender: TObject);
  private
	  procedure DoShow;
  public
  end;

var
  Form09: TForm09;

implementation

{$R *.DFM}

procedure TForm09.FormCreate(Sender: TObject);
begin
  Table1.Open;
  Table2.Open;
end;

procedure TForm09.PreviewClick(Sender: TObject);
begin
  PrintWin1.OutputTo := poViewer;
	DoShow;
end;

procedure TForm09.PrintClick(Sender: TObject);
begin
  PrintWin1.OutputTo := poPrinter;
	DoShow;
end;


procedure TForm09.DoShow;
var
	y: Integer;
begin
   PrintWin1.BeginPrint;
{   PrintWin1.SelectSolidBrush (RGB(128,255,255));}
   PrintWin1.NewFont ('Arial',20,True,True,True);
   PrintWin1.SetTheTextColor (RGB(255,0,0));
   PrintWin1.DrawText( 1.0,poCenter,'The Customer');

        PrintWin1.NewFont ('Arial',16,False,False,False);
   PrintWin1.SetTheTextColor (RGB(0,0,255));
   PrintWin1.DrawWindow( 1.6,poCenter,ScrollBox);


   y := PrintWin1.GetWindowBottom( 180,500,ScrollBox ) + 50;

   PrintWin1.SelectPen (2, RGB(255,0,0));

   PrintWin1.NewFont ('Arial',20,True,True,True);
   PrintWin1.SetTheTextColor (RGB(255,0,0));
   PrintWin1.DrawText( 4.5,poCenter,'The Orders');
   Y := y+150;
   PrintWin1.SetFrameStyle(frThinThick);

        PrintWin1.NewFont ('Arial',16,False,True,False);
   PrintWin1.SetTheTextColor (RGB(0,0,255));
   PrintWin1.DrawTable( 5,poCenter, Table2, True, False);

   PrintWin1.SelectSolidBrush (RGB(255,0,0));
   PrintWin1.SelectHatchedBrush ( RGB(255,255,0), HS_CROSS);
   PrintWin1.DrawEllipse( 0.6, 8.3, 2.6, 9.3);


   PrintWin1.SelectPen (2, RGB(0,0,0));
   PrintWin1.DrawArc( 3.3, 8.3, 5.6, 9.3 ,4.0, 8.6, 5.0, 9.0 );

   PrintWin1.NewFont ('Arial',16,True,True,True);
   PrintWin1.SetTheTextColor (RGB(0,0,255));
   PrintWin1.DrawText( 8,poLeft,'Left Aligned');
   PrintWin1.DrawText( 8,poCenter,'Centered');
   PrintWin1.DrawText( 8,poRight,'Right Aligned');

   PrintWin1.SetFrameStyle(frThickThin);
   PrintWin1.DrawRect( 6.8, 7.6, poLeft,1);

   PrintWin1.SelectHatchedBrush ( RGB(255,255,0), HS_DIAGCROSS);
   PrintWin1.DrawRect( 6.8, 7.6, poCenter,1);

   PrintWin1.SelectSolidBrush ( RGB(255,0,255));
   PrintWin1.DrawRect( 6.8, 7.6, poRight,1);

   PrintWin1.EndPrint;
end;



end.
