unit Fdemo08;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  StdCtrls, Forms, DBCtrls, DB, DBGrids, DBTables, Grids, ExtCtrls, Printers,
  PrnWin, Buttons, CB_Types;

type
  TForm08 = class(TForm)
    DBGrid1: TDBGrid;
    DBGrid2: TDBGrid;
    DBNavigator: TDBNavigator;
    Panel1: TPanel;
    DataSource1: TDataSource;
    Panel2: TPanel;
    Panel3: TPanel;
    Table1: TTable;
    Table2: TTable;
    DataSource2: TDataSource;
    Label9: TLabel;
    Table1CustNo: TFloatField;
    Table1Company: TStringField;
    Table1Contact: TStringField;
    Table1LastInvoiceDate: TDateTimeField;
    Table2OrderNo: TFloatField;
    Table2CustNo: TFloatField;
    Table2SaleDate: TDateTimeField;
    Table2ShipDate: TDateTimeField;
    Table2ItemsTotal: TCurrencyField;
    Table2AmountPaid: TCurrencyField;
    Preview: TBitBtn;
    Exit: TBitBtn;
    PrintWin1: TPrintWin;
    procedure FormCreate(Sender: TObject);
    procedure PreviewClick(Sender: TObject);
    procedure ExitClick(Sender: TObject);
  private
    { private declarations }
  public
end;

var
  Form08: TForm08;

implementation

{$R *.DFM}

procedure TForm08.FormCreate(Sender: TObject);
begin
  Table1.Open;
  Table2.Open;
end;

procedure TForm08.PreviewClick(Sender: TObject);
var
	y: Integer;
   Str: String;
begin
   PrintWin1.BeginPrint;
   PrintWin1.NewFont ('Arial',20,True,True,True);
   PrintWin1.SetTheTextColor (RGB(255,0,0));
   PrintWin1.DrawText( 1.5,poCenter,'The Customer');

   PrintWin1.NewFont ('Arial',14,False,False,False);
   PrintWin1.SetTheTextColor (RGB(0,0,0));

   Str := Table1.FieldByName('CustNo').AsString;


   { Tell the table to do only the current record }
   with Table1 do
   begin
      SetRangeStart; { Set the beginning key }
      FieldByName('CustNo').AsString := Str;
      SetRangeEnd; { Set the ending key }
      FieldByName('CustNo').AsString := Str;
      ApplyRange; { Tell the dataset to establish the range }
   end;



   PrintWin1.DrawTable( 2.1,poCenter, Table1, True, False);

   Table1.CancelRange;

   PrintWin1.SelectPen (2, RGB(255,0,0));

   PrintWin1.NewFont ('Arial',20,True,True,True);
   PrintWin1.SetTheTextColor (RGB(255,0,0));
   PrintWin1.DrawText( 4.0,poCenter,'The Orders');
   PrintWin1.SetFrameStyle(frThinThick);

   PrintWin1.NewFont ('Arial',14,False,True,False);
   PrintWin1.SetTheTextColor (RGB(0,0,0));
   PrintWin1.DrawTable( 4.6,poCenter, Table2, True, False);

   PrintWin1.EndPrint;
end;


procedure TForm08.ExitClick(Sender: TObject);
begin
	Close;
end;

end.