unit Fdemo05;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  StdCtrls, Forms, DBCtrls, DB, DBTables, Mask, ExtCtrls, Grids, DBGrids,
  Buttons, PrnWin, HRuler, Totals, CB_Types;

type
  TForm05 = class(TForm)
    ScrollBox: TScrollBox;
    EditCustNo: TDBEdit;
    EditOrderNo: TDBEdit;
    EditSaleDate: TDBEdit;
    EditShipDate: TDBEdit;
    EditShipToPhone: TDBEdit;
    EditShipVIA: TDBEdit;
    EditPO: TDBEdit;
    EditTerms: TDBEdit;
    EditPaymentMethod: TDBEdit;
    DBNavigator: TDBNavigator;
    Panel1: TPanel;
    DataSource1: TDataSource;
    Panel2: TPanel;
    Table1: TTable;
    Table2: TTable;
    DataSource2: TDataSource;
    DBGrid1: TDBGrid;
    Table3: TTable;
    DataSource3: TDataSource;
    PrintWin1: TPrintWin;
    Print: TBitBtn;
    Table3OrderNo: TFloatField;
    Table3ItemNo: TFloatField;
    Table3PartNo: TFloatField;
    Table3Qty: TIntegerField;
    Table3Discount: TFloatField;
    Edit1: TEdit;
    Edit2: TEdit;
    Edit3: TEdit;
    Edit4: TEdit;
    Edit5: TEdit;
    Edit6: TEdit;
    Edit7: TEdit;
    Edit8: TEdit;
    Edit9: TEdit;
    DataSource4: TDataSource;
    Table4: TTable;
    Table4PartNo: TFloatField;
    Table4VendorNo: TFloatField;
    Table4Description: TStringField;
    Table4OnHand: TFloatField;
    Table4OnOrder: TFloatField;
    Table4Cost: TCurrencyField;
    Table4ListPrice: TCurrencyField;
    Table3ListPrice: TCurrencyField;
    Table3Total: TCurrencyField;
    Label1: TLabel;
    Edit19: TEdit;
    DBEdit1: TDBEdit;
    Edit20: TEdit;
    Edit21: TEdit;
    Panel3: TPanel;
    Shape2: TShape;
    Panel5: TPanel;
    DBEdit9: TDBEdit;
    DBEdit10: TDBEdit;
    DBEdit11: TDBEdit;
    DBEdit12: TDBEdit;
    DBEdit13: TDBEdit;
    DBEdit14: TDBEdit;
    DBEdit15: TDBEdit;
    Panel4: TPanel;
    DBEdit2: TDBEdit;
    DBEdit3: TDBEdit;
    DBEdit4: TDBEdit;
    DBEdit5: TDBEdit;
    DBEdit6: TDBEdit;
    DBEdit7: TDBEdit;
    DBEdit8: TDBEdit;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Shape3: TShape;
    Exit: TBitBtn;
    ShowTotal1: TShowTotal;
    ShowTotal2: TShowTotal;
    ShowTotal3: TShowTotal;
    ShowTotal4: TShowTotal;
    ShowTotal5: TShowTotal;
    Table3Description: TStringField;
    Label7: TLabel;
    ShowTotal6: TShowTotal;
    ShowTotal7: TShowTotal;
    ShowTotal8: TShowTotal;
    ShowTotal9: TShowTotal;
    ShowTotal10: TShowTotal;
    ShowTotal11: TShowTotal;
    ShowTotal12: TShowTotal;
    ShowTotal13: TShowTotal;
    Memo2: TMemo;
    Label2: TLabel;
    Label8: TLabel;
    Image1: TImage;
    Preview: TBitBtn;
    procedure FormCreate(Sender: TObject);
    procedure PrintClick(Sender: TObject);
    procedure PrintWin1PrintHeader(Sender: TObject);
    procedure Table3CalcFields(DataSet: TDataset);
    procedure ExitClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure PreviewClick(Sender: TObject);
  private
    { private declarations }
  public
    { public declarations }
  end;

var
  Form05: TForm05;

implementation

{$R *.DFM}

procedure TForm05.FormCreate(Sender: TObject);
begin
  Table1.Open;
  Table2.Open;
  Table3.Open;
  Table4.Open;
end;

procedure TForm05.PrintClick(Sender: TObject);
begin
	PrintWin1.OutputTo := poPrinter;
	PrintWin1.BeginPrint;

	PrintWin1.SetColumnWidth ( DBGrid1, 'ItemNo', 0.75);
  PrintWin1.SetColumnWidth ( DBGrid1, 'PartNo', 0.75);
  PrintWin1.SetColumnWidth ( DBGrid1, 'Description', 1.5);
  PrintWin1.SetColumnWidth ( DBGrid1, 'Qty', 0.5);
  PrintWin1.SetColumnWidth ( DBGrid1, 'List Price', 0.75);
  PrintWin1.SetColumnWidth ( DBGrid1, 'Discount', 0.75);
  PrintWin1.SetColumnWidth ( DBGrid1, 'Total', 1);
  PrintWin1.DrawWindowMultiple( 1, 1, ScrollBox);

  PrintWin1.EndPrint;
end;

procedure TForm05.PrintWin1PrintHeader(Sender: TObject);
var
	Tot: Real;
  Cur: Real;
begin
	if PrintWin1.IsLastPage then begin
  	Tot := PrintWin1.GetRunningTotal (DBGrid1, 'Total');

     { Say tax = 10% }
     Cur := Tot * 0.1;
  	ShowTotal2.Text := FormatFloat('$ #,##0.00',Cur);
     Tot := Tot + Cur;

     { Add Freight say fixed }
     Cur := 100.0;
  	ShowTotal3.Text := FormatFloat('$ #,##0.00',Cur);
     Tot := Tot + Cur;

		{ Misc = 0 }
     Cur := 0.00;
  	ShowTotal4.Text := FormatFloat('$ #,##0.00',Cur);
  	ShowTotal5.Text := FormatFloat('$ #,##0.00',Tot);
  end;
end;

procedure TForm05.Table3CalcFields(DataSet: TDataset);
var
	St: Boolean;
begin

  Table3ListPrice.Value := Table4ListPrice.Value;
  Table3Total.Value := Table3ListPrice.Value * Table3Qty.Value;

 	Table4.Active := True;
 	Table4.GoToKey;
  Table4.FindKey([Table3PartNo.AsString]);
 	Table3Description.Value := Table4Description.Value;
end;

procedure TForm05.ExitClick(Sender: TObject);
begin
	Close;
end;

procedure TForm05.FormActivate(Sender: TObject);
begin
	ShowTotal1.Text := '0.00';
end;


procedure TForm05.PreviewClick(Sender: TObject);
begin
  PrintWin1.OutputTo := poViewer;
  PrintWin1.BeginPrint;

  PrintWin1.SetColumnWidth ( DBGrid1, 'ItemNo', 0.75);
  PrintWin1.SetColumnWidth ( DBGrid1, 'PartNo', 0.75);
  PrintWin1.SetColumnWidth ( DBGrid1, 'Description', 1.5);
  PrintWin1.SetColumnWidth ( DBGrid1, 'Qty', 0.5);
  PrintWin1.SetColumnWidth ( DBGrid1, 'List Price', 0.75);
  PrintWin1.SetColumnWidth ( DBGrid1, 'Discount', 0.75);
  PrintWin1.SetColumnWidth ( DBGrid1, 'Total', 1);
  PrintWin1.DrawWindowMultiple( 1, 1, ScrollBox);

  PrintWin1.EndPrint;

end;

end.
