/*** runtest ***/

#include "windows.h"
#include "stdio.h"
#include "pcl4w.h"
#include "sioerror.h"
#include "paint.h"
#include "line.h"
#include "runtest.h"

extern HWND hMainWnd;
extern int  OnLineFlag;
extern char Temp[1024];

#define TEST_SIZE 62

/* private */

static char TestSet[TEST_SIZE+1];
static int  NbrRuns = 16;
static int  TestLength = 0;
static int  TxBase = 0;
static int  RxBase = 0;
static int  TestRun = 0;

/* public */

int RunTest(int Port)
{int i;
 int n;
 int c;
 int rc;

 /* initialize */
 TxBase = SioInfo('T');
 RxBase = SioInfo('R');
 if(TestLength==0)
   {/* build TestSet[] array */
    for(i=0;i<26;i++) TestSet[i] = 'A'+i;
    for(i=0;i<26;i++) TestSet[26+i] = 'a'+i;
    for(i=0;i<10;i++) TestSet[52+i] = '0'+i;
    TestSet[62] = '\0';
   }

 /* check for loopback adapter */
 SioRxClear(Port);
 SioTxClear(Port);
 SioPutc(Port,'$');
 if( (char)SioGetc(Port,9) != '$')
   {DisplayLine("Loopback not detected. See Instructions.");
    return FALSE;
   }

 /* run the test */
 sprintf(Temp,"\nTest Run %d\n", ++TestRun);
 DisplayLine(Temp);
 sprintf(Temp,"Test Set: %s",TestSet);
 DisplayString(Temp);

 /* send test sets */
 DisplayString("\n  Sending set: ");
 for(i=0;i<NbrRuns;i++)
    {/* send test set again */
     sprintf(Temp,"%d ",i);
     DisplayString(Temp);
     for(n=0;n<TEST_SIZE;n++)
        {c = TestSet[n];
         SioPutc(Port,(char)c);
        }
    }

 /* receive test sets */
 DisplayString("\nReceiving set: ");
 for(i=0;i<NbrRuns;i++)
    {/* receive next test set */
     for(n=0;n<TEST_SIZE;n++)
        {rc = SioGetc(Port,36);
         if(rc<0)
            {SioError(rc,"SioGetc:");
             sprintf(Temp,"%d bytes in COM%d RX queue\n", SioRxQue(Port),1+Port );
             DisplayLine(Temp);
             sprintf(Temp,"%d bytes in COM%d TX queue\n", SioTxQue(Port),1+Port );
             DisplayLine(Temp);
             sprintf(Temp,"%d RX interrupts\n",SioInfo('R') - RxBase );
             DisplayLine(Temp);
             return FALSE;
            }
         /* compare character */
         if((char)rc!=TestSet[n])
           {sprintf(Temp,"\nERROR: Expecting '%c'(0x%x), received '%c'(0x%x)\n",
              (char)rc,(char)rc,TestSet[n],TestSet[n]);
            DisplayLine(Temp);
            return FALSE;
           }
        } /* end-for(n) */
     sprintf(Temp,"%d ",i);
     DisplayString(Temp);
    } /* end-for(i) */

 /* look at results */
 DisplayLine("");
 /* check RX FIFO */
 TestLength = NbrRuns * TEST_SIZE;
 i = SioInfo('R');
 sprintf(Temp,"%3d RX interrupts on %d incoming bytes: ", i-RxBase,TestLength);
 DisplayString(Temp);
 if(i-RxBase<TestLength) DisplayLine("RX FIFO is operational");
 else DisplayLine("RX FIFO is NOT operational [or not 16550 UART]");
 if(SioInfo('I'))
    {/* check TX FIFO */
     i = SioInfo('T');
     sprintf(Temp,"%3d TX interrupts on %d outgoing bytes: ", i-TxBase,TestLength);
     DisplayString(Temp);
     if(i-TxBase<TestLength) DisplayLine("TX FIFO is operational");
     else DisplayLine("TX FIFO is NOT operational [or not 16550 UART]");
    }
 DisplayLine("SUCCESS: Test AOK !");
 return TRUE;
}
