Listing 1 - Definitions for the scanner and token classes
that can look ahead at most one token.

//
// scanner.h
//
// Copyright (C) 1996 by Dan Saks.
// May be copied for private, non-commercial use,
// provided this copyright notice remains intact.
// All other rights reserved.
//

#ifndef SCANNER_H_INCLUDED
#define SCANNER_H_INCLUDED

#include <iostream.h>
#include <limits.h>
#include <string>

class token
    {
    friend class scanner;
public:
    enum category
        {
        AMPERSAND = '&',
        COMMA = ',',
        ...
        };
    token();
    string text() const;
    category kind() const;
private:
    token(category, const string &);
    category the_kind;
    string the_text;
    };

const char *image(token::category);

class scanner
    {
public:
    scanner(istream &);
    token get();
    token unget();
    token current() const;
    void reset();
private:
    token scan();
    token previous_token;
    token current_token;
    token next_token;
    istream &in_stream;
    struct pair
        {
        char const *text;
        token::category kind;
        };
    static pair const keyword[];
    scanner(const scanner &);
    scanner &operator=(const scanner &);
    };

//
// inline function definitions ...
//

#endif

