#ifndef nmpipe_h
#define nmpipe_h

#include <windows.h>

const DWORD nmpipeDefaultTimeOut = 2000;
const DWORD nmpipeDefaultRetries = 100;

enum nmpipe_eRetcode {
    nmpipeOK = 0,
    nmpipeError,
    nmpipeTimeOut,
    nmpipeDisconnect,
    nmpipeEvent
};

// base class for named pipes
class nmpipe_cNamedPipe {
protected:
    BOOL       bInError;
    HANDLE     hPipe;
    OVERLAPPED Overlap;

    nmpipe_eRetcode BlockForIO(HANDLE, DWORD, DWORD);
    nmpipe_eRetcode GetAvailableData(DWORD);

    nmpipe_cNamedPipe();

public:
    virtual ~nmpipe_cNamedPipe();

    nmpipe_eRetcode Read(void *, DWORD, DWORD = nmpipeDefaultTimeOut);
    nmpipe_eRetcode Write(const void *, DWORD, DWORD = nmpipeDefaultTimeOut);

    BOOL InError() { return bInError; };
};

// client-side named pipe class
class nmpipe_cConnector : public nmpipe_cNamedPipe {
public:
    nmpipe_cConnector(const char *, int = nmpipeDefaultRetries);
    virtual ~nmpipe_cConnector();
};

// server-side named pipe class
class nmpipe_cListener : public nmpipe_cNamedPipe {
protected:
    HANDLE hEventShutdown;

public:
    nmpipe_cListener(const char *, HANDLE, DWORD = nmpipeDefaultTimeOut);
    virtual ~nmpipe_cListener();

    nmpipe_eRetcode Connect(DWORD = nmpipeDefaultTimeOut);
    nmpipe_eRetcode Disconnect();
};

#endif
