#include <i86.h>
#include <string.h>

#include "defines.hpp"

#include "dpmi.hpp"

void* DPMI_FreeAccess ( void* Adress , DWORD Count ) {
    union REGS Regs;
    struct SREGS SegRegs;
    memset ( &SegRegs , 0 , sizeof ( SegRegs ) );
    Regs.w.ax = 0x0800;
    Regs.w.bx = WORD( (DWORD)Adress >> 16 );
    Regs.w.cx = WORD( (DWORD)Adress );
    Regs.w.si = WORD( Count >> 16 );
    Regs.w.di = WORD( Count );
    int386x ( 0x31 , &Regs , &Regs , &SegRegs );
    return (void*)( ( (DWORD)(Regs.w.bx) << 16 ) + Regs.w.cx );
};

void DPMI_CloseAccess ( void* Adress ) {
    union REGS Regs;
    struct SREGS SegRegs;
    memset ( &SegRegs , 0 , sizeof ( SegRegs ) );
    Regs.w.ax = 0x0801;
    Regs.w.bx = WORD( (DWORD)Adress >> 16 );
    Regs.w.cx = WORD( (DWORD)Adress );
    int386x ( 0x31 , &Regs , &Regs , &SegRegs );
};

WORD DPMI_GetSelector ( void* Adress ) {
    union REGS Regs;
    struct SREGS SegRegs;
    memset ( &SegRegs , 0 , sizeof ( SegRegs ) );
    Regs.w.ax = 0x0000;
    Regs.w.cx = 1;
    int386x ( 0x31 , &Regs , &Regs , &SegRegs );
    WORD Selector = Regs.w.ax;
    Regs.w.ax = 0x0007;
    Regs.w.bx = Selector;
    Regs.w.cx = WORD( (DWORD)Adress >> 16 );
    Regs.w.dx = WORD( (DWORD)Adress );
    int386x ( 0x31 , &Regs , &Regs , &SegRegs );
    Regs.w.ax = 0x0008;
    Regs.w.bx = Selector;
    Regs.w.cx = 0xFFFF;
    Regs.w.dx = 0xFFFF;
    int386x ( 0x31 , &Regs , &Regs , &SegRegs );
    return Selector;
};

void DPMI_FreeSelector ( WORD Selector ) {
    union REGS Regs;
    struct SREGS SegRegs;
    memset ( &SegRegs , 0 , sizeof ( SegRegs ) );
    Regs.w.ax = 0x0001;
    Regs.w.bx = Selector;
    int386x ( 0x31 , &Regs , &Regs , &SegRegs );
};

