struct _3D_Matrix {
    double MXX,MXY,MXZ;
    double MYX,MYY,MYZ;
    double MZX,MZY,MZZ;
};

class _3D_Point {
    public:
    _3D_Point() {};
    _3D_Point( long A, long B, long C ) { X = A; Y = B; Z = C; };
    double X,Y,Z;
    long PX,PY;
    double D;
    char V;
};

class _3D_Object {
    public:
    double D;
    char V;
    virtual void PrepareDraw(){};
    virtual void Draw(){};
};

enum _3D_Triangle_Typ { FlatShaded, FlatShadedZBuf,
                         GouraudShaded, GouraudShadedZBuf,
                         Textured, TexturedZBuf };
enum _3D_Triangle_SideTyp { Singlesided, Doublesided };
enum _3D_Triangle_MidPointTyp { Average, Rectangle, RectFourTri };

class _3D_Triangle : public _3D_Object {
    public:
    _3D_Triangle(){};
    _3D_Triangle( long, long, long, DWORD = 0, _3D_Triangle_SideTyp = Singlesided,
                  _3D_Triangle_MidPointTyp = Average, _3D_Triangle_Typ = GouraudShaded );
    _3D_Triangle( long, long, long, long, long, long, long, long, long, void*,
                  _3D_Triangle_SideTyp = Singlesided, _3D_Triangle_MidPointTyp = Average,
                  _3D_Triangle_Typ = Textured );

    long PA,PB,PC;

    long Color;

    void *Texture;
    long TXA,TYA,TXB,TYB,TXC,TYC;

    _3D_Triangle_Typ TriangleTyp;
    _3D_Triangle_SideTyp SideTyp;
    _3D_Triangle_MidPointTyp MidPointTyp;

    Boolean CalcDistance;

    double NX,NY,NZ;
    double MX,MY,MZ;

    virtual void PrepareDraw();
    virtual void Draw();

    void CalcNormal();
    void CalcMidPoint();
    void CommonInit();
};

void _3D_InitMatrix_Rotate( _3D_Matrix &M,
                            double sinPhi, double cosPhi,
                            double sinGamma, double cosGamma,
                            double sinOmega, double cosOmega );
void _3D_InitRotation();

void _3D_SetEye( double X, double Y, double Z );
void _3D_SetEye_Globe( double MX, double MY, double MZ, double Rad );
void _3D_SetVParams( long MidX, long MidY, long MulX, long MulY );
void _3D_SetAlpha( double A );
void _3D_SetPhi( double A );
void _3D_SetGamma( double A );
void _3D_SetOmega( double A );

long _3D_NewPoint( double, double, double );
double _3D_Point_GetX( long P );
double _3D_Point_GetY( long P );
double _3D_Point_GetZ( long P );
void _3D_ProjectPoints( long = -1, long = -1 );

void _3D_RotatePointsForward( long Start, long End,
                              double MX, double MY, double MZ, _3D_Matrix M );

void _3D_NewObject( _3D_Object* );
void _3D_DrawObjects();
void _3D_PrepareObjects();
void _3D_SortObjects();
void _3D_SortObjectsZ();

extern void (*_3D_TexturedTriangle) ( long, long, long, long, long, long, long, long,
                                      long, long, long, long, void* );
extern void (*_3D_FlatTriangle) ( long, long ,long, long, long, long, DWORD );
extern void (*_3D_GouraudTriangle) ( long, long, DWORD, long, long, DWORD, long, long, DWORD );
extern void (*_3D_FlatTriangleZBuf) ( long, long, double, long, long, double,
                                        long, long, double, DWORD );
extern void (*_3D_GouraudTriangleZBuf) ( long, long, double, DWORD, long, long,
                                           double, DWORD, long, long, double, DWORD );
extern void (*_3D_TexturedTriangleZBuf) ( long, long, long, long, double,
                                           long, long, long, long, double,
                                           long, long, long, long, double, void* );
extern DWORD (*_3D_DistColor) ( double, DWORD );

extern double _3D_ScreenDistance;
extern double _3D_EyeX, _3D_EyeY , _3D_EyeZ;
extern double _3D_Alpha, _3D_SINAlpha, _3D_COSAlpha;
extern double _3D_Phi, _3D_SINPhi, _3D_COSPhi, _3D_SINnPhi, _3D_COSnPhi;
extern double _3D_Gamma, _3D_SINGamma, _3D_COSGamma, _3D_SINnGamma, _3D_COSnGamma;
extern double _3D_Omega, _3D_SINOmega, _3D_COSOmega, _3D_SINnOmega, _3D_COSnOmega;

typedef void (*_3D_PointFunc)( _3D_Point& );
void _3D_ForAllPointsDo( _3D_PointFunc P );

