/****
 SW.CMD == SWitch.CMD (REXX) for OS/2 [XYOS2SHL.ZIP]    6/3/96
 SWitch focus between running OS/2 [DOS|WIN3x] processes

 SW.CMD calls PMSW.EXE, which is located in BootDrive:/OS2/MDOS
 Usage:   sw.cmd process name mask [/c]
            spaces permitted in "process name mask"
            optional argument "/c" attempts to terminate (EXIT)
              the parent process after focus is SWitched
            special process name "#" = NoOperation
****/

'@echo off'

if RxFuncQuery("SysLoadFuncs") then do
  call RxFuncAdd "SysLoadFuncs","RexxUtil","SysLoadFuncs"
  call SysLoadFuncs
  end

qexist=rxqueue("create","KILLPROC")
call rxqueue "delete",qexist
if qexist\="KILLPROC" then do
  call rxqueue "delete","KILLPROC"
  exit
  end

alias=''
switchtitle=''
quit='no'

parse arg alias

hlp=translate(alias)
if hlp='?'|hlp='/?'|hlp='-?'|hlp='HELP' then call Help

exuent=pos('/C',translate(alias))

if exuent>0 then do
  alias=substr(alias,1,exuent-1)
  alias=strip(alias)
  quit='yes'
  end

/*  User Aliases ͻ */
/*   Enter aliases (synonyms) in following form:                  */
/*     if alias='' then switchtitle=''           [show TaskList]  */
/*     if alias='' then switchtitle='#'          [#=NoOperation]  */
/*     if alias='' then switchtitle='XyWrite'                     */
/*     if alias='' then do; switchtitle='XyWin'; quit='yes'; end  */
/*     if alias='q' then quit='yes' [kill process;show TaskList]  */
/*     if alias='d' then switchtitle='Desktop'                    */
/*     if alias='ed' then switchtitle='editor.exe'                */
/*     if alias='w' then switchtitle='XyWin'                      */
/*   One alias per line.  Case sEnSiTiVe.                         */
/*FF---------- DO  NOT  WRITE  ABOVE  THIS  LINE! ----------- */
if alias = '' then switchtitle = ''             /* display TaskList */
if alias = 'd' then switchtitle = 'Desktop'
if alias = 'f' then switchtitle = 'FullScreen OS/2 Command Session'
if alias = 'w' then switchtitle = 'XyWin'
if alias = 'x' then switchtitle = 'XyWrite'
if alias = 'p' then switchtitle = 'Post Road Mailer'
if alias = 'f f' then switchtitle = 'FaxWorks Fax Win'
if alias = 'f r' then switchtitle = 'FaxWorks Status Win'
if alias = 'y' then do; switchtitle = 'XyWrite'; quit='yes'; end
/*                                                                */
/* ͼ */

BootDrive=''
if length(BootDrive)=0 then call Help
SwitchFile=BootDrive||':\OS2\MDOS\PMSW.EXE'

/* PMSW return codes */
/* 2=ERROR: error occurred during processing */
/* 1=READY: "/r" switch suppressed focus     */
/* 0=FOCUS: named process given focus        */

if switchtitle='' then switchtitle=alias
if switchtitle\=''&switchtitle\='#' then do
  SwitchFile' *'switchtitle'* /r'
  if rc\=1 then signal tl
  SwitchFile' *'switchtitle'*'
  end
else if switchtitle\='#' then do
  tl:
  BootDrive||':\OS2\MDOS\TL.EXE'
  say "No process named ""*"switchtitle"*"" found"
  call Help
  end

quit=translate(quit)
if quit='YES' then do
  call rxqueue "create","KILLPROC"
  'exit'
  end
return

HELP:
  say
  say 'SW.CMD [XYOS2SHL.ZIP]  R.J.Holmgren  6/3/96'
  say 'SWitch focus between already-running processes,'
  say '  from DOS or OS/2 command lines'
  say
  say 'Usage:  SW process name mask [/C]'
  say '  where process name = title in Ctrl-Esc Task List'
  say '  [/C] terminates calling command line process after focus is SWitched'
  say
  say 'Run INSTALL.CMD to install Xy-OS/2 Shell.'
  say 'SW.CMD calls PMSW.EXE by Bruce E. Hgman,'
  say '  which is located in BootDrive:\OS2\MDOS'
  exit
RETURN

