/* REXX */

/* Load RexxUtil extensions */
if RxFuncQuery("SysLoadFuncs") then do
    say "loading RexxUtil extensions..."
    call RxFuncAdd "SysLoadFuncs","RexxUtil","SysLoadFuncs"
    if result \= "0" then do
        say "error loading RexxUtil.dll"
        exit
    end
    call SysLoadFuncs
end

/* ask user about directories etc. */
Call SysCls
say
say "NFTP Version 0.80 installation"
say
say "This script will do the following:"
say "1) copy required files into the directory you specified;"
say "2) set up default settings in nftp.ini"
say "3) create two objects on your desktop:"
say "   one for NFTP itself and another for its manual."
say

numlangs = 12
lang.1  = "English   "
lang.2  = "Russian   "
lang.3  = "Chinese   "
lang.4  = "Spanish   "
lang.5  = "Swedish   "
lang.6  = "Hungarian "
lang.7  = "German    "
lang.8  = "Danish    "
lang.9  = "Japanese  "
lang.10 = "Norwegian "
lang.11 = "Italian   "
lang.12 = "Brazilian "
lang.13 = "          "
lang.14 = "          "
lang.15 = "          "

choose_language:
    
say "Enter no. of language you wish to install:"
do i = 1 to numlangs by 3
    i1 = i + 1
    i2 = i + 2
    say right(i,2)")" lang.i "    " right(i1,2)")" lang.i1 "    " right(i2,2)")" lang.i2
end
say "Empty line entered will abort installation."
parse pull langno .
if langno = "" then exit
if (langno > numlangs) | (langno < 1) then do
    say "The number you entered is outside of range"
    say
    signal choose_language
end
language = lang.langno

say
say "Enter destination directory (where NFTP files will be installed)."
say "If you wish to install NFTP into the subtree (eg, ""d:\apps\tcpip\nftp"")"
say "you have to create upper directory first (""d:\apps\tcpip"" in the"
say "above example). Enter ""."" to install into the current directory."
say "Empty line entered will abort installation."
parse pull destpath .
if destpath = "" then exit

say
say "Enter default path for downloads (e.g., ""d:\tmp"")."
say "This directory should reside on HPFS drive or you'll be unable"
say "to download files which are not 8.3-compliant."
parse pull dlpath .

say
say "Enter your e-mail address (to be used as a password for anonymous logins):"
parse pull email .
if email = "" then exit

destpath = strip(destpath, "T", "\")
dlpath = strip(dlpath, "T", "\")

/* verify choices */
say
say copies("-", 75)
say "Installing NFTP into the directory :" destpath
say "NFTP language                      :" language
if dlpath <> "" then ,
    say "Default download directory is      :" dlpath
say "Your e-mail address                :" email
say
say "Press Ctrl-C to abort or any other key to continue"
say
'@pause >nul'
say

/* creating target directories if necessary */
if destpath <> "." then
do
    call SysFileTree destpath, "srch", "D"
    if srch.0 = 0 then do
        rc = SysMkDir(destpath)
        if rc <> 0 then do
            say "Fatal error: cannot create directory" destpath
            exit
        end
    end
end

if (dlpath <> ".") & (dlpath <> "") then
do
    call SysFileTree dlpath, "srch", "D"
    if srch.0 = 0 then do
        rc = SysMkDir(dlpath)
        if rc <> 0 then do
            say "Fatal error: cannot create directory" dlpath
            exit
        end
    end
end
    
/* copying NFTP files */
if destpath <> "." then
do
    '@copy nftp.exe'     destpath'\nftp.exe     >nul'
    '@copy nftp.ico'     destpath'\nftp.ico     >nul'
    '@copy nftp-opt.exe' destpath'\nftp-opt.exe >nul'
    '@copy keynames.exe' destpath'\keynames.exe >nul'
    '@copy nftp-man.htm' destpath'\nftp-man.htm >nul'
    '@copy nftp-man.ps'  destpath'\nftp-man.ps  >nul'
    '@copy nftp-man.txt' destpath'\nftp-man.txt >nul'
    '@copy nftp-man.ico' destpath'\nftp-man.ico >nul'
    '@copy *.dll'        destpath'\ >nul'
    say "Files were copied to" destpath
end

if destpath = "." then destpath = directory()
if dlpath = "." then dlpath = directory()
    
/* making sure we will not overwrite existing nftp.mrk */
if stream(destpath"\nftp.mrk", "C", "QUERY EXISTS") == "" then
    '@copy nftp.m 'destpath'\nftp.mrk >nul'

/* checking 'nftp.ini' presence */
newinifile = destpath"\nftp.ini"
if stream(destpath"\nftp.ini", "C", "QUERY EXISTS") <> "" then 
do
    say destpath"\nftp.ini already exists."
    say "File ""nftp.new"" will be created in the" destpath
    say "Please examine it and add new options to your"
    say "existing configuration file"
    newinifile = destpath"\nftp.new"
end
call SysFileDelete newinifile

/* creating new 'nftp.ini' and customizing it slightly */
signal off notready
do forever
    lin = linein("nftp.i")
    newlin = lin
    if left(lin,1) <> ";" then
    do
        if substr(lin,1,19) = 'anonymous-password=' then
            newlin = 'anonymous-password="'email'"'
        if substr(lin,1,19) = 'log-transfers-name=' then
            newlin = 'log-transfers-name="'destpath'\nftp.fls"'
        if substr(lin,1,22) = 'default-download-path=' then
            newlin = 'default-download-path="'dlpath'"'
        if substr(lin,1,15) = 'bookmarks-file=' then
            newlin = 'bookmarks-file="'destpath'\nftp.mrk"'
    end
    rc = lineout(newinifile, newlin)
    if lin = "" & left(stream("nftp.i"),5) <> "READY" then leave
end
call stream "nftp.i", "C", "CLOSE"
call stream newinifile, "C", "CLOSE"

/* creating nftp.cmd */

cmdfile = destpath"\nftp.cmd"
rc = lineout(cmdfile, "@set NFTP_LANG="strip(left(language,7)))
rc = lineout(cmdfile, "@"destpath"\nftp.exe %1 %2 %3 %4 %5 %6")
call stream cmdfile, "C", "CLOSE"

/* creating WPS objects */
say
settings = 'EXENAME='destpath'\nftp.cmd;STARTUPDIR='dlpath';PARAMETERS=[FTP server to log in?];PROGTYPE=WINDOWABLEVIO;NOAUTOCLOSE=YES;MINIMIZED=NO;ICONFILE=nftp.ico'
rc = SysCreateObject('WPProgram', 'NFTP', '<WP_DESKTOP>', settings, 'replace')
if rc != 1 then say "Cannot create program object"
else            say "Program       object was created"

settings = 'EXENAME=explore.exe;PARAMETERS=-q 'destpath'\nftp-man.htm;PROGTYPE=PM;MINIMIZED=NO;ICONFILE=nftp-man.ico'
rc = SysCreateObject('WPProgram', 'NFTP manual', '<WP_DESKTOP>', settings, 'replace')
if rc != 1 then say "Cannot create documentation object"
else            say "Documentation object was created"

/* looks like we're done... */
say
say "Installation complete."
say "You can customize "destpath"\nftp.ini according your preferences."
say
say "If you don't have EMX runtime support installed, copy emx.dll into"
say "any directory specified in your LIBPATH. File 'emx.dll' provided"
say "with NFTP version 0.80 has version number ""0.9b, fixlevel 5""."
say "Read NFTP documentation about obtaining complete EMX runtime support"
say "package and its source code."
say
'@pause'
Exit
