/*****************************************************************************/
/*                                                                           */
/*                 (C) Copyright 1991-1996  Alberto Pasquale                 */
/*                                                                           */
/*                   A L L   R I G H T S   R E S E R V E D                   */
/*                                                                           */
/*****************************************************************************/
/*                                                                           */
/*   How to contact the author:  Alberto Pasquale of 2:332/504@fidonet       */
/*                               alberto.pasquale@mo.nettuno.it              */
/*                               Viale Verdi 106                             */
/*                               41100 Modena                                */
/*                               Italy                                       */
/*                                                                           */
/*****************************************************************************/

// NeFeat.H

// This include file is for use by the developers who want to write a
// Feature DLL for NEF.

// In the case you _really_ need some "wider" interface to NEF,
// please feel free to ask the author.


#ifndef _NEFEAT_H_
#define _NEFEAT_H_

#include <os2def.h>

                // for dest of FeatOut, bitwise

#define FO_LOG  0x01 // send output to the log
#define FO_CRT  0x02 // send output to the screen
#define FO_BOTH 0x03 // send output to both log and screen

typedef VOID (* APIENTRY FeatOut) (UCHAR dest, CHAR prty, PCSZ format, ...);

// Function to write output to screen and/or log.
// prty is the log priority char, usually one of "!*#: ".
// prty is ignored for output to screen.
// format and ... are the formatting string and parameters as in printf.
// Heading and trailing \n are ignored for log entry.


APIRET APIENTRY Init (FeatOut prnf);

#define NFI_OK  0x00000000      // Normal termination
#define NFI_ERR 0x00000001      // Initialization error

// Mandatory.
// This function is called during cfg file parsing, when the
// FeatureLoad statement is encountered and the DLL loaded.
// The prnf function pointer can be used to output messages to
// screen and log file.
// Must return NFI_OK on successful initialization.


APIRET APIENTRY ParseCfg (PCSZ clnline);

#define NFP_OK  0x00000000      // Normal termination
#define NFP_ERR 0x00000001      // Fatal Cfg Error

// This function is called by NEF when it finds a "Feature" configuration
// statement.  The entire line, after the "Feature" statement, is passed
// via the clnline pointer.
// This string is guaranteed without tabs, comments,
// trailing space and newline.
// This function must normally return NFP_OK.
// If NEF must exit with a "Cfg Error" errorlevel, this function
// must return NFP_ERR.
// In any case this function might use the prnf function to write
// something to the screen and log file.


APIRET APIENTRY BeforeNefToss (PCSZ fullname, PCSZ Tag, PCSZ Desc);

#define BNT_OK  0x00000000      // Normal termination
#define BNT_BAD 0x00000001      // TIC must be renamed BAD

// This function is called after NEF has parsed the TIC file, before
// it starts tossing the associated file.

// PCSZ fullname    Complete name (with path) of the file.
// PCSZ Tag         Area Tag.
// PCSZ Desc        Description for the file, as for announcements.
//                  Multiple lines are separated by '\r'.
// This function should normally return BNT_OK;
// if the file must be processed as BAD, return BNT_BAD.


typedef struct {
    USHORT zone;
    USHORT net;
    USHORT node;
    USHORT point;
} _ADR;


// structure with TIC data to be used (not modified) by AfterNefToss.

// Please note that all the strings containing lines from TICs (desc,
// ldesc etc.) are a simple concatenation of the TIC lines, including
// the heading keyword and terminating '\n'.

// The string pointers are never NULL: if there is no entry, they point
// to an empty string.

            // definitions for the bits of the flags field.

#define TDF_CRCused     0x0001      // crc field is valid
#define TDF_PassThru    0x0002      // The area is Pass Through
#define TDF_NewArea     0x0004      // The area has just been created


typedef struct {
    USHORT  struct_size;        // Size of this structure.
    USHORT  flags;              // Misc flags.
    PCSZ    areatag;            // Area TAG.
    PCSZ    areapath;           // Area path, terminated by '\'.
    PCSZ    file;               // File name (no path).
    PCSZ    replaces;           // File to be replaced.
    LONG    size;               // Size of file.
    ULONG   crc;                // CRC32 of file.
    _ADR    from;               // System we received the file from.
    _ADR    origin;             // System that hatched the file.
    PCSZ    pwd;                // Password.
    PCSZ    adesc;              // Description for announcement,
                                // lines separated by '\r'.
    PCSZ    desc;               // "Desc" lines.
    PCSZ    ldesc;              // "LDesc" lines.
    PCSZ    path;               // "Path" lines.
    PCSZ    seenby;             // "Seenby" lines.
    PCSZ    unknown;            // Unrecognized lines.
} _TICDATA;


APIRET APIENTRY AfterNefToss (_TICDATA *td);

#define ANT_OK          0x00000000  // normal termination.
#define ANT_NoFilesBbs  0x00000001  // do not update files.bbs.
#define ANT_NoAnnounce  0x00000002  // do not announce this file.

// This function is called after NEF has tossed the file, before
// it updates the files.bbs entry.

// The value returned by this function is to be processed as a group of
// bitwise flags.

#endif
