/*
 * Example of how a rexx file can operate on a list file created by
 * FM/2 (the list file should contain filenames only, one per line).
 *
 * This example can be editted at the boxed comment area below and
 * used with FM/2 Commands containing the %! metastring.
 *
 * Call as "%c /C <drive:\path\>EXAMPLE.CMD %!" (exclude quotes)
 *  (for example:  %c /C e:\fm2\EXAMPLES.CMD %!)
 */

/* suppress echo from "batch" commands */
'@Echo off'
/* clear screen (GPs). */
'@cls'

listfile = ''
/* get name of listfile from command line. */
parse arg listfile

/* if no listfile name was given, issue help and exit. */
if listfile = '' then
do
  say 'Give the name of a listfile as an argument to this REXX script.'
  say 'A listfile is a text file that contains full filenames, one per line.'
  exit
end

/* for debugging purposes: */
say 'Name of our listfile is "'listfile'".'

/* see if the listfile given exists -- exit with error message if not */
rc = stream(listfile,'C','QUERY EXISTS')
if rc = '' then
do
  say 'File "'listfile'" doesn''t exist.'
  exit
end

/* attempt to open the listfile given on the command line */
rc = stream(listfile,'C','OPEN')

/* if open was successful, enter loop */
if rc = 'READY:' then
do

  counter = 0     /* initialize counter */

  /* read each line of the listfile into filename */
  do while lines(listfile) = 1
    filename = linein(listfile)

    /* remove any leading/trailing blanks */
    filename = strip(filename,'b')

    /* process only non-blank strings */
    if filename \= '' then


    /*************************************************************
     * here you would do something to/with the file in filename. *
     * since this is only an example, we'll just print the name. *
     *************************************************************/

    do
      say filename          /* useful for debugging  */
      counter = counter + 1 /* count files processed */
    end

    /*************************************************************
     * end of area where you'd do your special processing.       *
     *************************************************************/

  end

  /* close the listfile. */
  rc = stream(listfile,'C','CLOSE')

  /* remove the listfile -- checks to disallow wildcards in name (GPs). */
  if (pos('*',listfile) = 0) & (pos('?',listfile) = 0) then
  do
    'del "'listfile'" 1>NUL 2>NUL'
  end

end
else
do
  say 'Error opening "'listfile'".'
  exit
end

/* we're done. */
say '  **I processed 'counter' objects.'
