/* REXX *********************************************/
/*                                                  */
/* Program name: DELSAVES                           */
/* Function    : Delete Backup after successfully   */
/*               installation                       */
/*               example for the post-install-      */
/*               successful exit                    */
/*                                                  */
/* Syntax      : Call from the INSTALL.DAT via:     */
/*    START_REXX_BY_SUCCESSFUL=DELSAVES dest_path   */
/*                                                  */
/* Changes     :                                    */
/*                                                  */
/* Made use of GREED.  21 May 1996 / 21:22:36   JRK */
/****************************************************/
Parse Arg destPath
/*-------------(Write lines into file)--------------*/
filename    = destPath'\install.log'
rc = LineOut( filename, 'Destination Directory:' destPath)

/*==============(Exception handling)================*/
Signal On Failure Name CLEARUP
Signal On Halt    Name CLEARUP
Signal On Syntax  Name CLEARUP

/*==========(Initialize RexxUtil support)===========*/
If RxFuncQuery('SysLoadFuncs') Then Do
  Call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
  Call SysLoadFuncs
End /* If RxFuncQuery... */

/*--------------(Save directory)---------------*/
directory = destPath||'\SAVEPREV'
/*-----------(Find file/Set attributes)-------------*/
rc = SysFileTree( directory||'\*.*', fileList, 'FO' )
Do i = 1 To fileList.0
  /*------------------(Delete file)-------------------*/
  delRC = SysFileDelete( fileList.i )
End /* If ... */

/*-------------(Remove directory)--------------*/
rc = SysRmDir( directory )

/*================(End this program)================*/
Return

CLEARUP:
  Say 'GREED001E - Break, Failure or Syntax Error'
Return
