{  DCTTag v0.05  -  DctTag.Pas  -  June 11, 1996.                 }
{  Copyright 1995, 1996 by Dan Traczynski.  All rights reserved.  }

{    This door will select ten random taglines from a tagline file and      }
{ prompt the user on which one to append to his message.  He can also add   }
{ his own tagline, or abort without any changes to his message.  The door   }
{ will work with any BBS program that uses the MSGTMP file format (RA,      }
{ SuperBBS, Concord[?], etc.).                                              }
{                                                                           }
{    The code compiles under Turbo Pascal 7.0 and some units do not include }
{ the source (such as DDPlus.Tpu).  The reason for this is that I am unsure }
{ of the copyrights on the door driver I used, so rather than distributing  }
{ the modified source code, I am simply going to include the compiled units }
{ along with it.                                                            }
{                                                                           }
{    You may do what you like with this code, but if you make any changes   }
{ to the program, you cannot distribute the modified code or compiled       }
{ executable to anyone without my prior consent.                            }
{                                                                           }
{ And now for the disclaimer...                                             }
{                                                                           }
{    The author, Daniel Traczynski, will take no responsibility to anything }
{ that this program may or may not do to your system.  Although the program }
{ has been tested thoroughly, no guarantee can be given that it will do     }
{ what it was made to do.  Nevertheless, if anything should happen, the     }
{ user is totally responsible and the author will be under no obligations   }
{ whatsoever.  By using this program and/or source code, you agree to this  }
{ disclaimer.                                                               }

Program DCTTag;

{$R-}{$S+}{$I+}{$N-}{$M 65520,16384,16384}

Uses Crt, DDPlus, TagUnit;

Var Y      : Word;
    Z      : Integer;
    TMP    : String;
    Good,
    ReDisp : Boolean;
    Cur    : Byte;

Procedure Init;
Begin
 If Not FileExists('MSGTMP') Then Begin
  WriteLn('MSGTMP not found, program aborted.');
  Halt;
 End;
 InitDoorDriver;
 If Graphics > 2 Then AnsiOn := True;
 Header;
 TagsAvail := 0;
 GetTags;
End;

Procedure Disp;
Begin
  X := WhereX;
  SGoto_XY(4, 6 + Cur);
  Set_Foreground(15);
  Set_Background(6);
  SWrite(' ' + Tag[Cur]);
  SClrEol;
  SGoto_XY(31, 21);
  Set_Background(0);
End;

Procedure Clear;
Begin
  X := WhereX;
  SGoto_XY(4, 6 + Cur);
  WriteKewl(' ' + Tag[Cur]);
  SClrEol;
End;

Begin
 Init;
 SWriteLn('[1;30m[11D[37m'#13#10);
 Good := False;
 ReDisp := True;
 Cur := 1;
 Repeat
  If ReDisp Then DisplayTags;
  ReDisp := True;
  Disp;
  Repeat
    SRead_Char(Ch);
    Ch := UpCase(Ch);
    If Ch = #3 Then Begin { Just broke out of chat so redraw bottom of screen }
      SGoto_XY(1, 18);
      If Not NoDefined Then SWriteLn('[0;1;47m[0;31;47mR[1;30m[0;36m Select a random tagline from the ten above.');
      SWriteLn('[0;1;47m[0;31;47mS[1;30m[0;36m Search for more taglines.');
      SWriteLn('');
      TimeWarn;
      SWrite('[0mY[1mour [0mC[1mhoice [30m([0mESC[1;30m=[0mN[1mo [0mT[1magline[30m)[0m? ');
      Current_Foreground := 7;
    End;
  Until Ch In ['0'..'9', #27, 'A', 'R', 'S', ^E, ^S, ^X, ^D, #13];
  Case Ch Of
    ^E, ^S: Begin
              Clear;
              If Cur = 1 Then Cur := 10 Else Dec(Cur);
              ReDisp := False;
            End;
    ^D, ^X: Begin
              Clear;
              If Cur = 10 Then Cur := 1 Else Inc(Cur);
              ReDisp := False;
            End;
    'R': Begin
           SWriteLn('Random');
           WriteTag(Tag[Random(10) + 1], 0);
           Good := True;
         End;
    'S': Begin
           ClearTagList;
           SGoto_XY(2, 5);
           SWrite('[1;30m[0m[11D');
           GetTags;
           SWriteLn('[1;30m[11D[37m'#13#10);
         End;
    #27: Begin
           SWriteLn('Abort'#13#10);
           SWriteLn('[0mS[1maving [0mM[1message [0mW[1mithout [0mT[1magline[30m...');
           Current_Foreground := 8;
         End;
    'A': If Not NoDefined Then Begin
           CustomTag(TMP);
           If (TMP <> '') Then Good := True;
         End;
    #13: Begin
           Str(Cur, Tmp);
           SWriteLn(Tmp);
           WriteTag(Tag[Cur], 0);
           Good := True;
         End;
    '0'..'9':
         Begin
           SWriteLn(Ch);
           Val(Ch, X, Z);
           If X = 0 Then X := 10;
           WriteTag(Tag[X], 0);
           Good := True;
         End;
    Else ReDisp := False;
  End;
 Until (Good) Or (Ch = #27);
 X := WhereX;
 Y := WhereY;
 Window(1, 1, 80, NumLines);
 TextBackground(0);
 GotoXY(1, NumLines);
 ClrEol;
 GotoXY(X, Y);
End.