{  DCTTag v0.05 Compilation Utility -  Compile.Pas  -  June 11, 1996.  }
{  Copyright 1995, 1996 by Dan Traczynski.  All rights reserved.       }

Uses Crt;

Type Str72    = String[72];

Var CurClr,
    X, Y      : Byte;
    Filename,
    Tmp       : String;
    Ch        : Char;
    Decomp    : Boolean;
    TmpStr    : Str72;

Procedure DispHelp;
Begin
 WriteLn('COMPILE [Drive:][Path]<File Name> [/?] [/D]');
 WriteLn;
 WriteLn('  [Drive][Path]<File Name>   Specifies tagline text file to compile.');
 WriteLn('  /?      Displays help screen.');
 WriteLn('  /D      Decompile DCTTAG.TAG to <File Name>.');
 WriteLn;
 WriteLn('The tagline file must be a plain ASCII text file, and each line can');
 WriteLn('be no longer than 72 characters.');
 Halt(0);
End;

Procedure InvalidSwitch;
Begin
  Write('Invalid Switch - ');
  TextColor(15);
  WriteLn(Tmp);
  TextColor(CurClr);
  Halt(0);
End;

Procedure InvalidFileName;
Begin
  Write('Invalid File Name - ');
  TextColor(15);
  WriteLn(Tmp);
  TextColor(CurClr);
  Halt(0);
End;

Procedure Compile;
Var InpFile : Text;
    OutFile : File Of Str72;
Begin
 Assign(InpFile, Filename);
 {$I-} Reset(InpFile); {$I+}
 If IOResult <> 0 Then Begin
   Write('File '); TextColor(15); Write(Filename); TextColor(7);
   WriteLn(' does not exist.'); TextColor(CurClr); Halt(0);
   Close(InpFile);
 End;
 Assign(OutFile, 'DCTTAG.TAG');
 {$I-} Reset(OutFile); {$I+}
 If IOResult = 0 Then Begin
   Write('DCTTAG.TAG already exists.  Overwrite (');
   TextColor(15); Write('Y'); TextColor(7); Write('es/');
   TextColor(15); Write('N'); TextColor(7); Write('o/');
   TextColor(15); Write('A'); TextColor(7); Write('ppend)? ');
   Repeat
     Ch := UpCase(ReadKey);
   Until Ch In ['Y', 'N', 'A'];
   WriteLn(Ch);
   WriteLn;
   Case Ch Of
     'N': Begin
            Close(InpFile);
            Close(OutFile);
            WriteLn('Tagline file not compiled.');
            Halt(1);
          End;
     'A': Begin
            Reset(OutFile);
            Seek(Outfile, FileSize(Outfile));
            WriteLn('Appending ', FileName, ' to DCTTAG.TAG...');
          End;
     Else Begin
            ReWrite(OutFile);
            WriteLn('Compiling ', FileName, ' to DCTTAG.TAG...');
          End;
   End;
 End Else Begin
   ReWrite(OutFile);
   WriteLn('Compiling ', Filename, ' to DCTTAG.TAG...');
 End;
 While Not Eof(InpFile) Do Begin
   ReadLn(InpFile, TmpStr);
   If TmpStr <> '' Then Write(OutFile, TmpStr);
 End;
 WriteLn('All done!');
 WriteLn;
 WriteLn(FileSize(OutFile), ' taglines compiled.');
 Close(InpFile);
 Close(OutFile);
End;

Procedure Decompile;
Var InpFile   : File Of Str72;
    OutFile   : Text;
Begin
 Assign(InpFile, 'DCTTAG.TAG');
 {$I-} Reset(InpFile); {$I+}
 If IOResult <> 0 Then Begin
   Write('File '); TextColor(15); Write('DCTTAG.TAG'); TextColor(7);
   WriteLn(' does not exist.'); TextColor(CurClr); Halt(0);
   Close(InpFile);
 End;
 Assign(OutFile, Filename);
 {$I-} Reset(OutFile); {$I+}
 If IOResult = 0 Then Begin
   Write(Filename, ' already exists.  Overwrite (Y/N)? ');
   Repeat
     Ch := UpCase(ReadKey);
   Until Ch In ['Y', 'N'];
   WriteLn(Ch);
   WriteLn;
   If Ch = 'N' Then Begin
     Close(InpFile);
     Close(OutFile);
     WriteLn('Tagline file not decompiled.');
     Halt(1);
   End;
 End;
 ReWrite(OutFile);
 WriteLn('Decompiling DCTTAG.TAG to ', Filename, '...');
 While Not Eof(InpFile) Do Begin
   Read(InpFile, TmpStr);
   WriteLn(OutFile, TmpStr);
 End;
 WriteLn('All done!');
 WriteLn;
 WriteLn(FileSize(InpFile), ' taglines decompiled.');
 Close(InpFile);
 Close(OutFile);
End;

Begin
 CurClr := TextAttr;
 Decomp := False;
 Filename := '';
 TextColor(7);
 TextBackground(0);
 WriteLn('DCTTag v0.05 Tagline Compilation Utility.');
 WriteLn;
 If (ParamCount = 0) Then
   DispHelp
 Else
   For X := 1 To ParamCount Do Begin
     Tmp := ParamStr(X);
     For Y := 1 To Length(Tmp) Do Tmp[Y] := UpCase(Tmp[Y]);
     If (Tmp = '/?') Then
       DispHelp
     Else If (Tmp = '/D') Then
       Decomp := True
     Else If (Tmp[1] = '/') Then Begin
       InvalidSwitch;
     End Else If Filename = '' Then Begin
       If (Pos('?', Tmp) > 0) Or (Pos('*', Tmp) > 0) Then InvalidFilename;
       Filename := Tmp;
     End;
   End; {for x=1 to paramcount}
 If Filename = '' Then Begin
  WriteLn('No file specified.');
  Halt(0);
 End;
 If Filename = 'DCTTAG.TAG' Then Begin
  WriteLn('Source and destination files cannot be the same.');
  Halt(0);
 End;
 If Decomp Then Decompile Else Compile;
End.