/*********************************************************************** 

   THIS REXX PROGRAM IS FOR USE WITH ZOC AND FAXWORKS 


 - HOW TO USE --------------------------------------------------------

   Below these instructions is a line containing an EXIT command.  

   Removing this line will (probably) turn off FaxWorks' receive mode 
   when ZOC is started and will turn it back on when ZOC is closed.

   If it doesn't work, it is probably time for you to deal with REXX 
   (if you didn't already).


 - CALL-ARGUMENTS -----------------------------------------------------

   It is called with the following arguments:
       When ZOC starts:            OPEN 
       Before a device is opened:  DEVOPEN '<DeviceName>' '<DeviceOpts>'
       After a device was closed:  DEVCLOSE '<DeviceName>' 
       When ZOC is exits:          CLOSE

   The DeviceName is the same as it appears in ZOC (eg. SERIAL/MODEM).

   The DeviceOpts are undocumented, so you need a bit of experimenting
   with them (see debugging).  However, since they are probably only 
   used to determine the com port, here is how to parse the MODEM/SERIAL 
   options:

    /+ if serial, get com port +/
    if Event="DEVOPEN" & DeviceName="SERIAL/MODEM" then do
        parse value DeviceOpts with "[" id "]" serport ":" baud "-" opts "|" 
        serport= translate(serport)  /+ uppercase +/
        call lineout "zocevent.trc", "OPEN OF "serport" DETECTED"
    end if



 - PROGRAMMING --------------------------------------------------------

   None of the ZOC commands work here (because ZOCEVENT.CMD is called 
   before initialization and after cleanup of ZOC subsystems).


 - DEBUGGING ----------------------------------------------------------

   Unfortunately you can't use SAY or TRACE, but writing debugging 
   information to a file with 'call lineout ...' might help:
       call lineout "zocevent.trc", event "#" DeviceName "#" DeviceOpts

   Additionally, for testing purposes you can call the script from 
   the command line with the same parameters that ZOC would use:
       C:\ZOC> SCRIPT\ZOCEVENT "OPENDEV" "SERIAL/MODEM" "[1]COM3:38400-8N1|"

***********************************************************************/


/**********************************************************************/
/* The line below exits at once -- remove it to make it all work      */
/**********************************************************************/

exit  /* >>>>>>>  to make it all work delete this line <<<<<<<<<<< */



/**********************************************************************/
/* Parse the command line arguments (as described above)              */
/**********************************************************************/
parse arg Event " '" DeviceName "'" "'" DeviceOpts "'"



/**********************************************************************/
/* Find out where FaxWorks is installed                               */
/**********************************************************************/
call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs
faxdir= SysIni("USER", "Fax", "ExeDir")
faxdir= left(faxdir,length(faxdir)-1)  /* remove trailing nul */
faxrcv= faxdir||"fxrcv"


/**********************************************************************/
/* Here comes the big action ...                                      */
/**********************************************************************/
select 
    /* if ZOC was started *********************************************/
    when Event="OPEN" then do
        faxrcv "-off"
    end /* if */

    /* if a ZOC-device will be opened **********************************/
    when Event="DEVOPEN" then do
        /* nothing yet */
    end /* if */

    /* if a ZOC-device was closed **************************************/
    when Event="DEVCLOSE" then do
        /* nothing yet */
    end /* if */

    /* if ZOC was closed ***********************************************/
    when Event="CLOSE" then do    /* if ZOC closed */
        faxrcv "-on"
    end /* if */

end /* select */

exit
