/************************************************************
 *** OS2: This file contains additional routines          ***
 ***      only needed in the OS/2-version.                ***
 ***                                                      ***
 ***   last modified: 07/28/92                            ***
 ***   Authors:  Thilo Schuster (term@godot.stgt.sub.org) ***
 ***         Herbert Neugebauer (haen@veces.stgt.sub.org) ***
 ***                                                      ***
 ***  please send bug reports to term@godot or haen@veces ***
 ***                                                      ***
 ***  Remark: the things in os2patch.c are used in every  ***
 ***          executable, os2trn.c only in trn            ***
 ************************************************************/

#define OS2_TRN_C

#include <stdio.h>
#include <stdlib.h>
#include <strings.h>
#include <termio.h>
#include <time.h>
#include "EXTERN.h"
#include "config.h"
#include "common.h"
#include "intrp.h"
#include "util.h"
#include "os2patch.h"
#include "term.h"

/*** We need prototypes for some functions ***/
extern char *filexp(char *s);
extern char *headname;

/*** And some global variables, defined somewhere else ***/
extern ART_POS savefrom;
extern FILE    *actfp;

/***************************************************
 ** This function was written to replace the      **
 ** shell-script newsetup. It reads the active    **
 ** file and writes out a .newsrc file, by        **
 ** taking every group out of the active-file     **
 ** strip off the numbers after the name and      **
 ** adding a ":", so all groups are marked as     **
 ** subscribed.                                   **
 ***************************************************/

int make_newsrc(char *rcname, char *activename)
{  FILE *activefile, *rcfile;
   char tmpbuffer[80];
   char *tmpcharptr;

   if ((activefile = fos2open(activename,"r")) == NULL)
   {  fprintf(stderr,"Cannot open the ACTIVE-file.\n");
      fflush(stderr);
      return 1;   /** not successful **/
   }
   else
   {  if ((rcfile = fos2open(rcname,"w")) == NULL)
      {  fprintf(stderr,"Cannot create the .newsrc-file.\n");
         fflush(stderr);
         return 1;  /** not successful **/
      }
      else
      {  while(fgets(tmpbuffer,80,activefile))    /** read a line **/
         {  if (strtok(tmpbuffer," \r\n"))        /** cut out ng-name **/
               fprintf(rcfile,"%s:\n",tmpbuffer); /** write out name+':' **/
            else
            {  fprintf(stderr,"Perhaps bogus newsgroup-line, didn't write out the group!\n");
               fprintf(stderr,"  line:%s\n",tmpbuffer);
               fflush(stderr);
            }
         }
         fclose(rcfile);
         fclose(activefile);
      }
   }

   return 0;   /*success*/
}


/***************************************************
 ** This function was written to replace the      **
 ** shell-script's mbox.saver and norm.saver      **
 ***************************************************/

int article_saver(bool mailbox, char *fromname, char *tosavename)
{   char tmpbuffer[1023+1];     /** make it long because of long From-lines*/
    char *tmpptr;
    int  nobjread;
    FILE *readfile, *writefile;
    bool newfile = FALSE;
    time_t timeinseconds;

    if (!fromname)
       strcpy(tmpbuffer,filexp("%A"));
    else
       strcpy(tmpbuffer,fromname);
    if ((readfile = fos2open(tmpbuffer, "r")) == NULL)
    {   fprintf(stderr,"Cannot open article %s for input!\n",tmpbuffer);
    	fflush(stderr);
        return 1;
    }
    if (!tosavename)
       strcpy(tmpbuffer,filexp("%b"));
    else
       strcpy(tmpbuffer,tosavename);
    if ((writefile = fos2open(tmpbuffer, "r+")) == NULL)
    {  if ((writefile = fos2open(tmpbuffer, "w")) == NULL)
       {  if (mailbox)
             fprintf(stderr,"Cannot open mailbox %s for output!\n",tmpbuffer);
          else
             fprintf(stderr,"Cannot open file %s for output!\n",tmpbuffer);
          fclose(readfile);
          fflush(stderr);
          return 1;
       }
       else newfile = TRUE;
    }
    if (!newfile)
    {  fseek(writefile, 0l, SEEK_END);    /* go to end of file (append) */
       fprintf(writefile,"\n");
    }

/*** OS2: there is a difference between the saver-commands "s" and "w".
          The global variable "savefrom" contains a byte-offset for
          the input-file, which can be used to strip the header off
          when the user used the w-command. But we only use this
          feature if we save an article (this routine is also
          used to save outgoing mail or post to the users
          out-mailboxes)                                      ***/
    if (!fromname)
        if (savefrom)
            fseek(readfile,savefrom,SEEK_SET);

    if (mailbox)
    {
       /*** Create a From-line with the date of the article via
            filexp("%T") filexp("%[date]"). If this doesn't work,
            take easy default data.   ***/
       
       tmpptr = filexp("%T");           
       if ( (tmpptr == NULL) || (strlen(tmpptr) < 3) || (fromname))
           fprintf(writefile,"From %s",uupc_rc_settings.domain);
       else
           fprintf(writefile,"From %s",tmpptr);

       tmpptr = filexp("%[date]");
       if ( (tmpptr == NULL) || (strlen(tmpptr) < 3) || (fromname))
       {   timeinseconds = time(NULL);
           strftime(tmpbuffer,255,"%a, %d %b %y %H:%M:%S %Z",
                                  localtime(&timeinseconds));
           fprintf(writefile," %s\n", tmpbuffer);
       }
       else
           fprintf(writefile," %s\n",tmpptr);
    }
/*** OS2: We had a serious problem with this combination of commands.
          The destination filled up the entire disk under certain
          circumstances. The second problem was, that fget's
          changed special characters, so that the save did not
          work for binary (I want to say uuencoded) files ***/
/*    while(fgets(tmpbuffer, 511, readfile))   */
/*          fprintf(writefile,tmpbuffer);      */

    while(!feof(readfile)) {
        nobjread = fread(tmpbuffer, 1, 80, readfile);
        fwrite(tmpbuffer, 1, nobjread, writefile);
    }

    fprintf(writefile,"\n");
    fclose(writefile);
    fclose(readfile);

    return 0;
}



/**************************************************
 ** this function will replace the shellscripts  **
 ** Rnmail. It will use the already prepared     **
 ** header and include the signature. It will    **
 ** also ask the user for a prepared text which  **
 ** will then be included. It will use the       **
 ** UUPC-Program "rmail" to send the mail.       **
 **************************************************/

void mail_reply(void)
{   FILE *header_fp, *include_fp, *signature_fp;
    char tmpbuffer[255+1];
    char cmd;
    int  linecounter;
    bool includesig = FALSE;

    if (strlen(uupc_rc_settings.signature) > 0) {
        /* Now check if the signature setting containes a fully
           qualified filename (that means including path) */
	if ((uupc_rc_settings.signature[0] == '/') ||
	    (uupc_rc_settings.signature[0] == '\\') ||
	    (uupc_rc_settings.signature[2] == '/') ||
	    (uupc_rc_settings.signature[2] == '\\')  )
            sprintf(tmpbuffer,"%s", uupc_rc_settings.signature);
        else
            sprintf(tmpbuffer,"%s/%s",uupc_rc_settings.home,
                                  uupc_rc_settings.signature);
        if (signature_fp = fopen(tmpbuffer,"r"))
           includesig = TRUE;
    }
    printf("\n\n");
    standout();
    echo();
    printf("Prepared file to include [NONE]:");
    un_standout();
    printf(" ");
    fflush(stdout);
/* Rupa -- new input routine       */    
/*    fgets(tmpbuffer,255, stdin); */
    getstring(tmpbuffer,255);
    noecho();
    tmpbuffer[strlen(tmpbuffer) - 1 ] = '\0';
    if(strlen(tmpbuffer) != 0) {
        if(include_fp = fopen(tmpbuffer,"r")) {
            if ((header_fp = fopen(headname,"r+")) != NULL) {
                fseek(header_fp,0l,SEEK_END);
                while(fgets(tmpbuffer,255,include_fp)) {
                    fprintf(header_fp,"%s",tmpbuffer); }
                if (includesig) {
                   printf("\nIncluding Signature...\n");
				   fflush(stdout);
                   /* fprintf(header_fp,"\n\n--\n"); */
                   while(fgets(tmpbuffer,255,signature_fp)) {
                       fprintf(header_fp,"%s",tmpbuffer); }
                }
                fclose(header_fp);
            }
            else
               printf("\nCannot open %s\n",tmpbuffer);
               fflush(stdout);
            fclose(include_fp);
        }
        if (includesig) fclose(signature_fp);
    } else {
        if (includesig) {
            if ((header_fp = fopen(headname,"r+")) != NULL) {
                printf("\nIncluding Signature...\n");
                fflush(stdout);
                fseek(header_fp,0l,SEEK_END);
                /* fprintf(header_fp,"\n\n--\n"); */
                while(fgets(tmpbuffer,255,signature_fp))
                    fprintf(header_fp,"%s",tmpbuffer);
                fclose(header_fp);
            }
            fclose(signature_fp);
        }
        sprintf(tmpbuffer, uupc_rc_settings.editor, headname);
        /* printf("Invoking %s\n",tmpbuffer); */
        fflush(stdout);
        termlib_reset();
        system(tmpbuffer);
        termlib_init();
        un_standout();
    }

    cmd = ' ';
    while((cmd != 's')&&(cmd != 'S')&&(cmd != 'a')&&(cmd != 'A')) {
        printf("\n");
        standout();
        printf("Send, abort, edit, or list ?");
        un_standout();
        printf(" ");
        fflush(stdout);
        cmd = _read_kbd(0,1,0);
        printf("\n");
        switch(cmd) {
            case 's': case 'S':
                /* Now we check how our rmailpath looks like. We want to
                   be as configurable here as possible. If non of the
                   configuration file includes the rmail setting, the TRN
                   startup code sets this to "rmail.exe", in which case
                   we have to supply the command line parameters for rmail
                   here.
                   The user can also specify the complete path to the
                   executable without any command line option, in which
                   case we also have to set the appropriate parameters here.
                   The third possibility is that the user specifies the
                   complete command line setup. In this case the user
                   supplied command must include all necessary parameters. */

                /* The check is not complicated, we just look if the rmail
                   setting includes "%s" in which case we assume the third
                   method. If the first or second method is used, doesn't
                   matter, we have to do exactly the same. */

		if (strstr(uupc_rc_settings.rmailpath, "%s") == NULL)
		{   /* OK, no %s is in the setting, so we assume that
		       either method 1 or 2 is used. */
                    sprintf(tmpbuffer,"%s -f %s -t",
                                uupc_rc_settings.rmailpath,
                                headname);
		}
		else
		{   /* OK, we found %s in the setting, so we assume that
		       method 3 is used. */
                    sprintf(tmpbuffer, uupc_rc_settings.rmailpath,
                                headname);
		}
                change_sl2bsl(tmpbuffer);
                /* printf("\nInvoking %s\n",tmpbuffer); */
		        fflush(stdout);
                system(tmpbuffer);
                if (strlen(uupc_rc_settings.mailsent) > 0) {
                    sprintf(tmpbuffer,"%s/%s",uupc_rc_settings.home,
                                              uupc_rc_settings.mailsent);
                    /* printf("\nSaving mail to %s\n",tmpbuffer); */
			        fflush(stdout);
                    if (article_saver(TRUE,headname,tmpbuffer))
                        printf("\nCannot save letter to %s\n",tmpbuffer);
                }
		        fflush(stdout);
                break;
            case 'a': case 'A':
                strcpy(tmpbuffer,uupc_rc_settings.home);
                strcat(tmpbuffer,"/dead.let");
                printf("\nSaving letter to %s\n",tmpbuffer);
		        fflush(stdout);
                if (article_saver(TRUE,headname,tmpbuffer))
                   printf("\nCannot save letter to %s\n",tmpbuffer);
		        fflush(stdout);
                break;
            case 'e': case 'E':
                sprintf(tmpbuffer, uupc_rc_settings.editor, headname);
                /* printf("\nInvoking %s\n",tmpbuffer); */
                termlib_reset();
		        fflush(stdout);
                system(tmpbuffer);
                termlib_init();
                break;
            case 'l': case 'L':
                printf("\n");
                if(header_fp = fopen(headname,"r")) {
                    linecounter = 0;
                    cmd = ' ';
                    while((fgets(tmpbuffer,255,header_fp)) &&
                          (cmd != 'q') && (cmd != 'Q'))
                    {   linecounter += 1 + (strlen(tmpbuffer) / 80);
                        printf("%s",tmpbuffer);
                        if (linecounter >= LINES - 1)
                        {   linecounter = 0;
reask_more:
                            standout();
                            printf("--more--");
                            un_standout();
			    fflush(stdout);
                            cmd = _read_kbd(0,1,0);
                            carriage_return();
                            erase_eol();
                            if ((cmd == 'h') || (cmd == 'H'))
                            {
                                printf("\nPress q to quit browsing or any other key to continue.\n");
				goto reask_more;
			    }
                        }
                    }
	            fclose(header_fp);
                }
                break;
            default :
                puts("\nType s to send the message, a to abort and append the message");
                puts("to dead.let, e to edit the message again, l to list the message.");
		        fflush(stdout);
                break;
        }
    }
}



/**************************************************
 ** this function will replace the shellscripts  **
 ** Pnews and Pnews.header. It will use the      **
 ** header and include the signature. It will    **
 ** also ask the user for a prepared text which  **
 ** will then be included.                       **
 **************************************************/

void article_poster(void)
{   FILE *header_fp, *include_fp, *signature_fp, *tmp_fp;
    char tmpbuffer[255+1];
    char dshortname[20+1], dlongname[20+1], xshortname[12+1], xlongname[12+1];
    char cmd;
    int  linecounter;
    bool includesig = FALSE;
    time_t timeinseconds;

    if (strlen(uupc_rc_settings.signature) > 0) {
        /* Now check if the signature setting containes a fully
           qualified filename (that means including path) */
	if ((uupc_rc_settings.signature[0] == '/') ||
	    (uupc_rc_settings.signature[0] == '\\') ||
	    (uupc_rc_settings.signature[2] == '/') ||
	    (uupc_rc_settings.signature[2] == '\\')  )
            sprintf(tmpbuffer,"%s", uupc_rc_settings.signature);
        else
            sprintf(tmpbuffer,"%s/%s",uupc_rc_settings.home,
                                  uupc_rc_settings.signature);
        if (signature_fp = fopen(tmpbuffer,"r"))
           includesig = TRUE;
    }
    printf("\n\n");
    standout();
    echo();
    printf("Prepared file to include [NONE]:");
    noecho();
    un_standout();
    printf(" ");
    fflush(stdout);
/* Rupa -- new input routine */    
/*    fgets(tmpbuffer,255, stdin); */
    getstring(tmpbuffer,255);
    tmpbuffer[strlen(tmpbuffer) - 1 ] = '\0';
    if(strlen(tmpbuffer) != 0) {
        if(include_fp = fopen(tmpbuffer,"r")) {
            if ((header_fp = fopen(headname,"r+")) != NULL) {
                fseek(header_fp,0l,SEEK_END);
                while(fgets(tmpbuffer,255,include_fp)) {
                    fprintf(header_fp,"%s",tmpbuffer); }
                if (includesig) {
                   printf("\nIncluding Signature...\n");
                   fflush(stdout);
                   /* fprintf(header_fp,"\n\n--\n"); */
                   while(fgets(tmpbuffer,255,signature_fp)) {
                       fprintf(header_fp,"%s",tmpbuffer); }
                }
                fclose(header_fp);
            }
            else
               printf("\nCannot open %s\n",tmpbuffer);
            fflush(stdout);
            fclose(include_fp);
        }
        if (includesig) fclose(signature_fp);
    } else {
        if (includesig) {
            if ((header_fp = fopen(headname,"r+")) != NULL) {
                printf("\nIncluding Signature...\n");
                fflush(stdout);
                fseek(header_fp,0l,SEEK_END);
                /* fprintf(header_fp,"\n\n--\n"); */
                while(fgets(tmpbuffer,255,signature_fp))
                    fprintf(header_fp,"%s",tmpbuffer);
                fclose(header_fp);
            }
            fclose(signature_fp);
        }
	/* change / to \ */
	change_sl2bsl(headname);
        sprintf(tmpbuffer, uupc_rc_settings.editor, headname);
        /* printf("Invoking %s\n",tmpbuffer); */
        termlib_reset();
        fflush(stdout);
        system(tmpbuffer);
        termlib_init();
        un_standout();
    }

    cmd = ' ';
    while((cmd != 's')&&(cmd != 'S')&&(cmd != 'a')&&(cmd != 'A')) {
        printf("\n");
        standout();
        printf("Send, abort, edit, or list ?");
        un_standout();
        printf(" ");
        fflush(stdout);
        cmd = _read_kbd(0,1,0);
        printf("\n");
        switch(cmd) {
            case 's': case 'S':
#ifndef USE_NNTP
                /* When posting using inews under OS/2, we're getting in
                   in trouble. inews spools the article to the host system
                   and posts the article locally. When posting locally it
                   also has to update the active file. The problem is that
                   TRN keeps the active file open all the time. Inews wants
                   to be on the save side and wants to rename the old file
                   before writing out the new version. This is not possible
                   if TRN keeps the file open and inews issues an error
                   message. So we try to close the active file and
                   reread it directly after posting the article. */
		if (actfp != NULL)
		    fclose(actfp);
#endif
		safecpy(tmpbuffer,filexp(getval("NEWSPOSTER",NEWSPOSTER)),
			sizeof tmpbuffer);
/*	        sprintf(tmpbuffer,"inews %s", headname); */
		change_sl2bsl(tmpbuffer);
		/* printf("Invoking %s\n",tmpbuffer); */
		fflush(stdout);
		system(tmpbuffer);
#ifndef USE_NNTP
		/* This not opens the active file, it also rereads the file
		   and hopefully recognizes the new article. Hopefully
		   this works and other parts of TRN don't fail because
		   of the "unexpected" reread. */
		ngdata_init();
#endif
                sprintf(tmpbuffer,"%s/Postings",uupc_rc_settings.home);
                printf("\nSaving article to %s\n",tmpbuffer);
	        fflush(stdout);
                if (article_saver(TRUE,headname,tmpbuffer))
                    printf("\nCannot save article as letter to %s\n",tmpbuffer);
                unlink(headname);
		        fflush(stdout);
                break;
            case 'a': case 'A':
                strcpy(tmpbuffer,uupc_rc_settings.home);
                strcat(tmpbuffer,"/deadpost.let");
                printf("\nSaving to %s\n",tmpbuffer);
		        fflush(stdout);
                if (article_saver(TRUE,headname,tmpbuffer))
                   printf("\nCannot save letter to %s\n",tmpbuffer);
		        fflush(stdout);
                break;
            case 'e': case 'E':
                sprintf(tmpbuffer, uupc_rc_settings.editor, headname);
                /* printf("\nInvoking %s\n",tmpbuffer); */
                termlib_reset();
		        fflush(stdout);
                system(tmpbuffer);
                termlib_init();
                break;
            case 'l': case 'L':
                printf("\n");
                if(header_fp = fopen(headname,"r")) {
                    linecounter = 0;
                    cmd = ' ';
                    while((fgets(tmpbuffer,255,header_fp)) &&
                          (cmd != 'q') && (cmd != 'Q'))
                    {   linecounter += 1 + (strlen(tmpbuffer) / 80);
                        printf("%s",tmpbuffer);
                        if (linecounter >= LINES - 1)
                        {   linecounter = 0;
reask_more:
                            standout();
                            printf("--more--");
                            un_standout();
			    fflush(stdout);
                            cmd = _read_kbd(0,1,0);
                            carriage_return();
                            erase_eol();
                            if ((cmd == 'h') || (cmd == 'H'))
                            {
                                printf("\nPress q to quit browsing or any other key to continue.\n");
				goto reask_more;
			    }
                        }
                    }
	            fclose(header_fp);
                }
                break;
            default :
                puts("\nType s to send the article, a to abort and append the article");
                puts("to deadpost.let, e to edit the article again, l to list the article.");
                fflush(stdout);
                break;
        }
    }
}




/**************************************************
 ** this function will replace the shellscript   **
 ** newsgroups. It will use the .newsrc-file     **
 ** to search for unsubscribed newsgroups. It    **
 ** will use the ! or : characters to find out   **
 ** if newsgroup is subscribed or not.           **
 **************************************************/

int unsub_group(char *pattern)
{   char tmpbuffer[255+1];
    int  counter;
    FILE *newsrcfp;

    strcpy(tmpbuffer,filexp(RCNAME));
    if ((newsrcfp = fos2open(tmpbuffer,"r")) == NULL) {
        printf("Cannot open .newsrc!\n");
        fflush(stdout);
        return 1;
    }

    printf("Completely unsubscribed Newsgroups:\n");
    while (fgets(tmpbuffer,255,newsrcfp)) {
/*** OS2: I don't know why, but strtok didn't work ***/
        for (counter = 0; (tmpbuffer[counter] != '\0') &&
                          (tmpbuffer[counter] != ':')      ; counter++)
            if (tmpbuffer[counter] == '!') {
                tmpbuffer[counter] = '\0';
                tmpbuffer[counter+1] = '\0';
                if (strlen(pattern) < 1)
                    printf("%s\n",tmpbuffer);
                else
                    if (strstr(tmpbuffer,pattern)) printf("%s\n",tmpbuffer);
            }
    }
    fflush(stdout);

    fclose(newsrcfp);
    return 0;
}

int getstring(char *buf, int len) {
  char *curpos=buf;
  int finished=FALSE;
  char ch;

  while(!finished) {
    ch = _read_kbd(0,1,0);
    switch (ch) {
    case '\n':
    case '\r':
      *curpos = '\0';  /* null terminate the string */
      finished = TRUE;
      break;
    case NULL:
      _read_kbd(0,1,0);             /* eat the extra char for extended keys */
      break;
    case '':
      if(curpos != buf) {  /* don't wanna screw around if at front! */
	curpos--;
	putchar(ch);       /* clear char */
	putchar(' ');
	putchar(ch) FLUSH;
      }
      break;
    default:               /* we use the char */
      if((curpos-buf) < (len-1)) { /* make sure we don't go beyond the limit */
	*curpos = ch;
	putchar(ch) FLUSH;
	curpos++;
      }
    }
  }
  return(curpos - buf);
}

