/* 


	pmwin.h (emx+gcc) 

	1994,95 Giovanni Iachello
	This is freeware software. You can use or modify it as you wish,
	provided that the part of code that I wrote remains freeware.
	Freeware means that the source code must be available on request 
	to anyone.
	You must also include this notice in all files derived from this
	file.


*/
#ifndef _PMWIN_H_
#define _PMWIN_H_

#define INCL_WIN
#define INCL_DOSPROCESS
#define OS2EMX_PLAIN_CHAR
#include <os2.h>

#include <stdlib.h>
#include <stddef.h>

#include "pmsys.h"
#include "pmgpi.h"

#undef assert
#ifdef NODEBUG
#define assert(ignore) ((void)0)
#else
#define assert(x) ((void)((x) || (DoAssert((PCSZ)#x,(PCSZ)__FILE__,__LINE__),1)))
#endif


void DoAssert(PCSZ msg,PCSZ file,unsigned line);

void ErrBox(PCSZ msg,...);

struct PMEvent;
class PMRect;
class PMPoint;
class PMPresSpace;
class PMWin;
class PMMainWin;
class PMHelpWin;
class PMApp;
class PMThread;
class PMAnchorBlock;   // class that creates basic window message handling functions
class PMWindowThread;
class PMDialog;
class PMControl;
class PMListBox;
class PMEntryField;

struct WINCREATEARGS {
	HWND hwndParent;
	HWND hwndOwner;
	ULONG flStyle;
    ULONG flCreateFlags;
    PCSZ pszClientClass;
    PCSZ pszTitle;
    ULONG styleClient;
    HMODULE hmod; 
    ULONG idResources;
    PHWND phwndClient;
// additional WinCreateWindow parameters
	LONG x,y,cx,cy;
	HWND hwndInsertBehind;
	ULONG id;
	PVOID pCtlData,pPresParams;
// register class part
	HAB hab;
	PCSZ pszClassName;
	PFNWP pfnWndProc;
    ULONG flClassStyle;
    ULONG cbWindowData;
};

////////////////////////////////////////////////////////////////////////////

MRESULT PMWndProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2);

MRESULT PMDlgProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2);

////////////////////////////////////////////////////////////////////////////


struct PMEvent {
	ULONG msg;
	MPARAM mp1;
	MPARAM mp2;
	MRESULT ret;
	PCHRMSG charmsg;
	PMSEMSG mousemsg;
	PMEvent(ULONG m,MPARAM n,MPARAM l,PCHRMSG c=NULL,PMSEMSG ms=NULL) { 
		msg=m; mp1=n; mp2=l; charmsg=c; mousemsg=ms; ret=0;
	}

};

/////////////////////////////////////////////////////////////////////////////

class PMWin {
protected:
	PFNWP oldproc;
	WINCREATEARGS *createArgs;
	HWND hwnd,hwndFrame;
	PMAnchorBlock ab;
	virtual BOOL dispachEvent(PMEvent & event);
	friend MRESULT PMWndProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2);
	friend MRESULT PMDlgProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2);

public:
	PMWin(PCSZ classname,HAB iab); // se non viene specificato nessun a.b., prendi App di default
	PMWin(HAB iab); // costruttore semplice per le finestre meno complicate
	virtual ~PMWin();

	HWND getHwnd() { return hwnd; }
	HWND operator () () { return hwnd; }
	operator HWND () { return hwnd; }
	HWND getHwndFrame() { return hwndFrame; }

	virtual BOOL createWin();	
	virtual BOOL destroyWin();	
	virtual MRESULT msgProc(PMEvent& event);

	ULONG msgBox(PCSZ title,PCSZ msg,...);

	BOOL isChild(HWND hwndParent) { return WinIsChild(hwnd,hwndParent); }
	BOOL isEnabled() { return WinIsWindowEnabled(hwnd); }
	BOOL isVisible() { return WinIsWindowVisible(hwnd); }

	virtual MRESULT sendMsg (ULONG msg, MPARAM mp1=0L, MPARAM mp2=0L) 
		{	return WinSendMsg (hwnd, msg, mp1, mp2); }
	BOOL postMsg (ULONG msg, MPARAM mp1=0L, MPARAM mp2=0L) 
		{ 	return WinPostMsg (hwnd, msg, mp1, mp2); }
	virtual MRESULT close(); // manda WM_CLOSE
	BOOL invalidate(BOOL includeChildren) { return WinInvalidateRect(hwnd,NULL,includeChildren); }

	HWND queryCapture(HWND hwndDesktop=HWND_DESKTOP) 
		{	return WinQueryCapture (hwndDesktop); }
	HWND queryFocus(HWND hwndDesktop=HWND_DESKTOP) 
		{ 	return WinQueryFocus (hwndDesktop); }
	BOOL setCapture(HWND hwndDesktop=HWND_DESKTOP) 
		{	return WinSetCapture (hwndDesktop,hwnd); }
	BOOL resetCapture(HWND hwndDesktop=HWND_DESKTOP) 
		{	return WinSetCapture (hwndDesktop,NULLHANDLE); }
	BOOL queryPos(PSWP pswp) 
		{ 	return WinQueryWindowPos (hwnd, pswp); }
	BOOL queryFramePos(PSWP pswp) 
		{ 	return WinQueryWindowPos (hwndFrame, pswp); }
	LONG queryWindowText(LONG cchBufferMax, PCH pchBuffer)
		{ 	return WinQueryWindowText (hwnd,cchBufferMax,pchBuffer); }
	LONG queryWindowTextLenght() 
		{ 	return WinQueryWindowTextLength (hwnd); }
	BOOL setOwner(HWND hwndNewOwner)
		{ 	return WinSetOwner (hwnd,hwndNewOwner); }
	BOOL setParent(HWND hwndNewParent, BOOL fRedraw=FALSE)
		{ 	return WinSetParent (hwnd,hwndNewParent,fRedraw); }
	BOOL setPos(HWND hwndInsertBehind, LONG x, LONG y, LONG cx, LONG cy, ULONG fl=0L)
	  	{ 	return WinSetWindowPos(hwnd,hwndInsertBehind,x,y,cx,cy,fl); }
	BOOL setFramePos(HWND hwndInsertBehind, LONG x, LONG y, LONG cx, LONG cy, ULONG fl=0L)
	  	{ 	return WinSetWindowPos(hwndFrame,hwndInsertBehind,x,y,cx,cy,fl); }
	BOOL setWindowText(PCSZ pszText) 
		{ 	return WinSetWindowText (hwnd,pszText); }
	BOOL setFrameWindowText(PCSZ pszText) 
		{ 	return WinSetWindowText (hwndFrame,pszText); }
	BOOL ptInClient(PMPoint& pt);
		
	BOOL associateHelpInstance (HWND hwndHelpInstance)
		{	return WinAssociateHelpInstance (hwndHelpInstance, hwndFrame); }


	virtual BOOL queryEnd() { return TRUE; } // always exit from window
	virtual BOOL command(USHORT id,USHORT cmddev);
	virtual BOOL create(PMEvent &event);
	virtual BOOL paint();
	virtual BOOL kbd(PMEvent &event);
	virtual BOOL mouse(PMEvent &event);	
	virtual BOOL enable();
	virtual BOOL show();	
	virtual BOOL move();
	virtual BOOL size(SHORT cx,SHORT cy);
	virtual BOOL activate();
	virtual BOOL setfocus();
	virtual BOOL help(PMEvent &event);
	virtual BOOL helpmsg(PMEvent &event);
	virtual BOOL timer();
	virtual BOOL closed(); // ricevuto WM_CLOSE
	virtual BOOL other(PMEvent &event);	
	virtual BOOL initmenu(SHORT id,PMMenu *menu);
};


/////////////////////////////////////////////////////////////////////////////
// PMMainWin aggiunge supporto automatico menu', apertura chiusura files.

// PMMainWin File Flags
//
#define PMMWFF_NOTHING 0
#define PMMWFF_NONE 1
#define PMMWFF_UNTITLED 2
#define PMMWFF_FILE 3

class PMMainWin : public PMWin {
protected:
	char filename[CCHMAXPATH];
	BOOL modified;
	int fileFlags;
	char *caption;
	char *fnFilter,*fsCaption,*flCaption;
	char *fileUntitled,*fileNone;
	BOOL fileKillConfirm();
	void setTitleCaption(); // imposta il titolo della finestra da caption e filename
	PMHelpWin* helpWin;		// finestra a cui chiedere help
public:
	PMMainWin(PCSZ classname,HAB ab,PMHelpWin *ihelpWin=NULL);
	~PMMainWin() { };
	BOOL paint();
	BOOL command(USHORT id,USHORT cmddev);
	BOOL createWin();	
	BOOL destroyWin();	
	virtual BOOL paint(PMPresSpace& ps) { return FALSE; }
//	BOOL helpmsg(PMEvent &event); // ridefinisci la gestione dell'aiuto

	BOOL isFileModified() { return modified; }
	BOOL setModified(BOOL state) { BOOL temp=modified; modified=state; setTitleCaption(); return temp; }

	BOOL queryEnd() { return fileKillConfirm(); } // query file kill confirm
	BOOL closed(); // ricevuto WM_CLOSE, vedi se puo' chiudere
	virtual BOOL fileOpen(PCSZ filename) { return TRUE; }; // restituisce TRUE se tutto Ok
	virtual BOOL fileSave(PCSZ filename) { return TRUE; };
	virtual BOOL filePrint() { return TRUE; };
	virtual BOOL fileNew() { return TRUE; };

	virtual BOOL editCut() {};
	virtual BOOL editCopy() {};
	virtual BOOL editPaste() {};
	virtual BOOL editDelete() {};
	virtual BOOL editUndo() {};
	virtual BOOL editRedo() {};
	virtual BOOL editClear() {};
};

/////////////////////////////////////////////////////////////////////////////

class PMSubclassWin : public PMWin {
//	PFNWP oldproc;
//	friend static MRESULT PMSubclassWndProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2);
public:
	PMSubclassWin(HWND hwndParent, PCSZ pszClass, PCSZ pszName,
	    ULONG flStyle, LONG x, LONG y, LONG cx, LONG cy, HWND hwndOwner,
    	HWND hwndInsertBehind, ULONG id, PVOID pCtlData=NULL, PVOID pPresParams=NULL);
	~PMSubclassWin();

	BOOL createWin();	
//	MRESULT msgProc(PMEvent& event);
};

/////////////////////////////////////////////////////////////////////////////

#endif

