/* mony_api.h   */
/* 24-Jan-96 - original (chh) */

/* contains defines, structures, and prototypes */

#define IOCTL_MONY      0xA1 /* category code for calls to Mony DD */
#define IOCTL_40TH      0x40 /* func code for calls to Mony DD */

/* structures */

        /* Only ax,bx,cx,dx are used (or their sub-regs). */
        /* Pointers are passed via the parm and/or data */
        /* args to DosDevIOCtl as shown in mony_api.c. */

typedef struct _REGPACK {
 union {
  struct {
   UCHAR al;
   UCHAR ah;
  };
  USHORT ax;
 };
 union {
  struct {
   UCHAR bl;
   UCHAR bh;
  };
  USHORT bx;
 };
 union {
  struct {
   UCHAR cl;
   UCHAR ch;
  };
  USHORT cx;
 };
 union {
  struct {
   UCHAR dl;
   UCHAR dh;
  };
  USHORT dx;
 };
} REGPACK; /* IREG (or OREG) */
typedef REGPACK *PREGPACK;

#pragma pack(1) /* it is required that this structure be 64 bytes exactly */

typedef struct _BIOSDATA {
 ULONG  rezPtr ;        // 00 : 0 (default values follow)
 UCHAR  videoMode;      // 04 : 7
 USHORT columns;        // 05 : 80
 USHORT pageSize;       // 07 : 4096
 USHORT startAddr;      // 09 : 0
 USHORT cursorPos[8];   // 11 : 0,0 eight times (low byte=col, high=row)
 UCHAR  cursorEnd;      // 27 : 0x00
 UCHAR  cursorStart;    // 28 : 0x20 init value to disable cursor
 UCHAR  activePage;     // 29 : 0 (0 to pages-1)
 USHORT addr6845;       // 30 : 0x3B4
 UCHAR  crtMode;        // 32 : 9
 UCHAR  rezPalette;     // 33 : 0
 UCHAR  rows;           // 34 : 25
 USHORT charHeight;     // 35 : 14
 UCHAR  activeDCC;      // 37 : 1
 UCHAR  inactiveDCC;    // 38 : 0
 USHORT colors;         // 39 : 0
 UCHAR  pages;          // 41 : 1-8, depending on DEVICE= /p# option
 UCHAR  rasterCode;     // 42 : 1 (348/350 scan lines)
 UCHAR  rezVGA[2];      // 43 : 0,0
 UCHAR  miscInfo;       // 45 : 0x04 (bit5=1 blink enabled, bit2=1 mono display)
 CHAR   rezUnused[16];  // 46 : 0
 USHORT monyVersion;    // 62 : driver version * 1000 (e.g., 1000 is version 1.000)
} BIOSDATA; /* VBD */
typedef BIOSDATA *PBIOSDATA;
#pragma pack()

/* prototypes of functions in mony_api.c */

ULONG MonySetVideoMode (HFILE monyID, UCHAR videoMode);
ULONG MonySetCursorSize (HFILE monyID, UCHAR topLine, UCHAR bottomLine);
ULONG MonySetCursorPos (HFILE monyID, UCHAR page, UCHAR row, UCHAR column);
ULONG MonyGetCursorStatus (HFILE monyID, UCHAR page, PUCHAR row, PUCHAR column, PUCHAR topLine, PUCHAR bottomLine);
ULONG MonySetVideoPage (HFILE monyID, UCHAR page);
ULONG MonyScrollUp (HFILE monyID, UCHAR lines, UCHAR attr, UCHAR r0, UCHAR c0, UCHAR r1, UCHAR c1);
ULONG MonyScrollDown (HFILE monyID, UCHAR lines, UCHAR attr, UCHAR r0, UCHAR c0, UCHAR r1, UCHAR c1);
ULONG MonyGetCharAttrAtCursor (HFILE monyID, UCHAR page, PUCHAR character, PUCHAR attr);
ULONG MonyWriteCharAttrAtCursor (HFILE monyID, UCHAR page, UCHAR character, UCHAR attr, USHORT repCount);
ULONG MonyWriteCharAtCursor (HFILE monyID, UCHAR page, UCHAR character, USHORT repCount);
ULONG MonyWriteCharTTY (HFILE monyID, UCHAR page, UCHAR character);
ULONG MonyGetVideoStatus (HFILE monyID, PUCHAR page, PUCHAR columns, PUCHAR videoMode);
ULONG MonySetBlinkMode (HFILE monyID, UCHAR blink);
ULONG MonySetBellMode (HFILE monyID, USHORT freq, USHORT duration);
ULONG MonyWriteString (HFILE monyID, PSZ strgPtr, UCHAR page, UCHAR attr, UCHAR row, UCHAR col);
ULONG MonyReadBlock (HFILE monyID, PVOID bufferPtr, UCHAR page, UCHAR r0, UCHAR c0, UCHAR rows, UCHAR columns);
ULONG MonyWriteBlock (HFILE monyID, PVOID bufferPtr, UCHAR page, UCHAR r0, UCHAR c0, UCHAR rows, UCHAR columns);
ULONG MonyGetBiosData (HFILE monyID, PBIOSDATA VBDptr);

