/*:VRX         Main
*/
/*  Main
*/
Main:
/*  Process the arguments.
    Get the parent window.
*/
    parse source . calledAs .
    parent = ""
    argCount = arg()
    argOff = 0
    if( calledAs \= "COMMAND" )then do
        if argCount >= 1 then do
            parent = arg(1)
            argCount = argCount - 1
            argOff = 1
        end
    end; else do
        call VROptions 'ImplicitNames'
        call VROptions 'NoEchoQuit'
    end
    InitArgs.0 = argCount
    if( argCount > 0 )then do i = 1 to argCount
        InitArgs.i = arg( i + argOff )
    end
    drop calledAs argCount argOff

/*  Load the windows
*/
    call VRInit
    parse source . . spec
    _VREPrimaryWindowPath = ,
        VRParseFileName( spec, "dpn" ) || ".VRW"
    _VREPrimaryWindow = ,
        VRLoad( parent, _VREPrimaryWindowPath )
    drop parent spec
    if( _VREPrimaryWindow == "" )then do
        call VRMessage "", "Cannot load window:" VRError(), ,
            "Error!"
        _VREReturnValue = 32000
        signal _VRELeaveMain
    end

/*  Process events
*/
    call Init
    signal on halt
    do while( \ VRGet( _VREPrimaryWindow, "Shutdown" ) )
        _VREEvent = VREvent()
        interpret _VREEvent
    end
_VREHalt:
    _VREReturnValue = Fini()
    call VRDestroy _VREPrimaryWindow
_VRELeaveMain:
    call VRFini
exit _VREReturnValue

VRLoadSecondary:
    __vrlsWait = abbrev( 'WAIT', translate(arg(2)), 1 )
    if __vrlsWait then do
        call VRFlush
    end
    __vrlsHWnd = VRLoad( VRWindow(), VRWindowPath(), arg(1) )
    if __vrlsHWnd = '' then signal __vrlsDone
    if __vrlsWait \= 1 then signal __vrlsDone
    call VRSet __vrlsHWnd, 'WindowMode', 'Modal' 
    __vrlsTmp = __vrlsWindows.0
    if( DataType(__vrlsTmp) \= 'NUM' ) then do
        __vrlsTmp = 1
    end
    else do
        __vrlsTmp = __vrlsTmp + 1
    end
    __vrlsWindows.__vrlsTmp = VRWindow( __vrlsHWnd )
    __vrlsWindows.0 = __vrlsTmp
    do while( VRIsValidObject( VRWindow() ) = 1 )
        __vrlsEvent = VREvent()
        interpret __vrlsEvent
    end
    __vrlsTmp = __vrlsWindows.0
    __vrlsWindows.0 = __vrlsTmp - 1
    call VRWindow __vrlsWindows.__vrlsTmp 
    __vrlsHWnd = ''
__vrlsDone:
return __vrlsHWnd

/*:VRX         About_Close
*/
About_Close: 
    call About_Fini
return

/*:VRX         About_Create
*/
About_Create: 
    call About_Init
    ok = VRMethod( "PB_12", "SetFocus" )
    
return

/*:VRX         About_Fini
*/
About_Fini: 
    window = VRInfo( "Window" )
    call VRDestroy window
    drop window
return
/*:VRX         About_Init
*/
About_Init: 
    window = VRInfo( "Object" )
    if( \VRIsChildOf( window, "Notebook" ) ) then do
        call VRMethod window, "CenterWindow"
        call VRSet window, "Visible", 1
        call VRMethod window, "Activate"
    end
    drop window
return

/*:VRX         Basic_Close
*/
Basic_Close: 
    call Basic_Fini
return

/*:VRX         Basic_Create
*/
Basic_Create: 
    call Basic_Init
return

/*:VRX         Basic_Fini
*/
Basic_Fini: 
    window = VRInfo( "Window" )
    call VRDestroy window
    drop window
return
/*:VRX         Basic_Init
*/
Basic_Init: 
    window = VRInfo( "Object" )
    if( \VRIsChildOf( window, "Notebook" ) ) then do
        call VRMethod window, "CenterWindow"
        call VRSet window, "Visible", 1
        call VRMethod window, "Activate"
    end
    drop window
return

/*:VRX         CB_10_Click
*/
CB_10_Click: 
selected = VRGet( "LB_3", "Selected" )

if selected>0 then do
    conf_to.selected=VRGet( "CB_10", "Set" )    
    call CheckFor
end

return

/*:VRX         CB_11_Click
*/
CB_11_Click: 
selected = VRGet( "LB_3", "Selected" )

if selected>0 then do
    conf_origin.selected=VRGet( "CB_11", "Set" )    
    call CheckFor
end

return

/*:VRX         CB_12_Click
*/
CB_12_Click: 
    ok = VRSet( "GB_14", "ForeColor", "<default>" )
return

/*:VRX         CB_12_ContextMenu
*/
CB_12_ContextMenu: 

return

/*:VRX         CB_13_Click
*/
CB_13_Click: 
    ok = VRSet( "GB_17", "ForeColor", "<default>" )
return

/*:VRX         CB_13_ContextMenu
*/
CB_13_ContextMenu: 

return

/*:VRX         CB_14_Click
*/
CB_14_Click: 
    ok = VRSet( "GB_17", "ForeColor", "<default>" )
return

/*:VRX         CB_14_ContextMenu
*/
CB_14_ContextMenu: 

return

/*:VRX         CB_15_Click
*/
CB_15_Click: 
ok = VRSet( "GB_16", "ForeColor", "<default>" )

if VRGet( "CB_15", "Set" )=1 then do
    ok = VRSet( "GB_15", "ForeColor", "<default>" )
end
else do
    ok = VRSet( "GB_15", "ForeColor", "DarkGray" )
end

Call UpdateTagline

return
/*:VRX         CB_15_ContextMenu
*/
CB_15_ContextMenu: 

return

/*:VRX         CB_16_Click
*/
CB_16_Click: 
    ok = VRSet( "GB_18", "ForeColor", "<default>" )
return

/*:VRX         CB_16_ContextMenu
*/
CB_16_ContextMenu: 

return

/*:VRX         CB_17_Click
*/
CB_17_Click: 
ok = VRSet( "GB_22", "ForeColor", "<default>" )

return

/*:VRX         CB_17_ContextMenu
*/
CB_17_ContextMenu: 

return

/*:VRX         CB_18_Click
*/
CB_18_Click: 
    ok = VRSet( "GB_42", "ForeColor", "<default>" )
return

/*:VRX         CB_18_ContextMenu
*/
CB_18_ContextMenu: 

return

/*:VRX         CB_1_Click
*/
CB_1_Click: 
ok = VRSet( "GB_1", "ForeColor", "<default>" )

return

/*:VRX         CB_1_ContextMenu
*/
CB_1_ContextMenu: 

return

/*:VRX         CB_2_Click
*/
CB_2_Click: 
ok = VRSet( "GB_5", "ForeColor", "<default>" )

return

/*:VRX         CB_2_ContextMenu
*/
CB_2_ContextMenu: 

return

/*:VRX         CB_3_Click
*/
CB_3_Click: 
ok = VRSet( "GB_11", "ForeColor", "<default>" )

return

/*:VRX         CB_3_ContextMenu
*/
CB_3_ContextMenu: 

return

/*:VRX         CB_4_Click
*/
CB_4_Click: 
ok = VRSet( "GB_32", "ForeColor", "<default>" )

return

/*:VRX         CB_4_ContextMenu
*/
CB_4_ContextMenu: 

return

/*:VRX         CB_5_Click
*/
CB_5_Click:
 set = VRGet( "CB_5", "Set" )
 ok = VRSet( "SPIN_1", "Value", set-1 )
 ok = VRSet( "GB_3", "ForeColor", "<default>" )
return

/*:VRX         CB_5_ContextMenu
*/
CB_5_ContextMenu: 

return

/*:VRX         CB_6_Click
*/
CB_6_Click: 
 ok = VRSet( "GB_3", "ForeColor", "<default>" )
 set = VRGet( "CB_6", "Set" )
 ok = VRSet( "SPIN_2", "Value", set-1 )
return

/*:VRX         CB_6_ContextMenu
*/
CB_6_ContextMenu: 

return

/*:VRX         CB_7_Click
*/
CB_7_Click: 
selected = VRGet( "LB_3", "Selected" )

if selected>0 then do
    conf_from.selected=VRGet( "CB_7", "Set" )    
    call CheckFor
end

return

/*:VRX         CB_8_Click
*/
CB_8_Click: 
selected = VRGet( "LB_3", "Selected" )

if selected>0 then do
    conf_body.selected=VRGet( "CB_8", "Set" )    
    call CheckFor
end

return

/*:VRX         CB_9_Click
*/
CB_9_Click: 
selected = VRGet( "LB_3", "Selected" )

if selected>0 then do
    conf_subject.selected=VRGet( "CB_9", "Set" )    
    call CheckFor
end

return

/*:VRX         CheckFor
*/
CheckFor: 
            /*set check for: to proper values*/
            if (conf_from.vc_num=0)&(conf_to.vc_num=0)&(conf_body.vc_num=0)&(conf_origin.vc_num=0)&(conf_subject.vc_num=0) then do
                conf_from.vc_num=1
                conf_to.vc_num=1
                conf_body.vc_num=1
                conf_origin.vc_num=1
                conf_subject.vc_num=1
            end

return 0

/*:VRX         Colors_Close
*/
Colors_Close: 
    call Colours_Fini
return

/*:VRX         Colors_Create
*/
Colors_Create: 
    call Colors_Init
    ok = VRMethod( "LB_2", "AddStringList", "ColorSchemeName.",  )
    ok = VRSet( "DT_11_B", "Caption", "Color =" getcolor() )
    call ColorsHelp
return

ColorsHelp:
h="Colors Help"
ok = VRSet( "GB_31", "Caption", h )

h = "Click on a group title to see help for that group. "
h=h "Click on the green title here to see this help screen again."

ok = VRSet( "MLE_5", "Value", h )
return 0
/*:VRX         Colors_Fini
*/
Colors_Fini: 
    window = VRInfo( "Window" )
    call VRDestroy window
    drop window
return
/*:VRX         Colors_Init
*/
Colors_Init: 
    window = VRInfo( "Object" )
    if( \VRIsChildOf( window, "Notebook" ) ) then do
        call VRMethod window, "CenterWindow"
        call VRSet window, "Visible", 1
        call VRMethod window, "Activate"
    end
    drop window
return

/*:VRX         Combo_3_Change
*/
Combo_3_Change: 
    ok = VRSet( "GB_21", "ForeColor", "<default>" )
return

/*:VRX         Combo_3_Click
*/
Combo_3_Click: 
    ok = VRSet( "GB_21", "ForeColor", "<default>" )
return

/*:VRX         Combo_3_ContextMenu
*/
Combo_3_ContextMenu: 

return

/*:VRX         Conferences_Close
*/
Conferences_Close: 
    call sw2_Fini
return

/*:VRX         Conferences_Fini
*/
Conferences_Fini: 
    window = VRInfo( "Window" )
    call VRDestroy window
    drop window
return
/*:VRX         Conferences_Init
*/
Conferences_Init: 
    window = VRInfo( "Object" )
    if( \VRIsChildOf( window, "Notebook" ) ) then do
        call VRMethod window, "CenterWindow"
        call VRSet window, "Visible", 1
        call VRMethod window, "Activate"
    end
    drop window
return

/*:VRX         dropcolor
*/
dropcolor: 

/* TargetWindow = HEADER, MESSAGE, REPLY, SEARCH */
/* color = text value like BLACK or YELLOW */

parse arg TargetWindow color 

select
    when TargetWindow = "HEADER" then do
        ok = VRSet( "DT_9_A", SourceDragColor, color)
        ok = VRSet( "DT_9_B", SourceDragColor, color)
        ok = VRSet( "DT_9_C", SourceDragColor, color)
    end
    when TargetWindow = "REPLY" then do
        ok = VRSet( "DT_10_A", SourceDragColor, color)
        ok = VRSet( "DT_10_B", SourceDragColor, color)
    end
    when TargetWindow = "MESSAGE" then do
        ok = VRSet( "DT_11_A", SourceDragColor, color)
        ok = VRSet( "DT_11_B", SourceDragColor, color)
        ok = VRSet( "DT_11_C", SourceDragColor, color)
    end
    when TargetWindow = "SEARCH" then do
        ok = VRSet( "DT_3_A", SourceDragColor, color)
    end
    otherwise do
    end
 end

ok = VRSet( "DT_11_B", "Caption", "Colors =" getcolor() )

return 0


PutColors:   /*takes a MR2 color string "p" and changes the sample screen */
Parse Upper var p p 
    SourceDragColor="BackColor"
    call dropcolor "MESSAGE" setcolor(X2D(SubStr( p, 1, 1))+1)
    SourceDragColor="ForeColor"
    call dropcolor "MESSAGE" setcolor(X2D(SubStr( p, 2, 1))+1)
    SourceDragColor="BackColor"
    call dropcolor "REPLY"   setcolor(X2D(SubStr( p, 3, 1))+1)
    SourceDragColor="ForeColor"
    call dropcolor "REPLY"   setcolor(X2D(SubStr( p, 4, 1))+1)
    SourceDragColor="BackColor"
    call dropcolor "HEADER"  setcolor(X2D(SubStr( p, 5, 1))+1)
    SourceDragColor="ForeColor"
    call dropcolor "HEADER"  setcolor(X2D(SubStr( p, 6, 1))+1)
    SourceDragColor="BackColor"
    call dropcolor "SEARCH"  setcolor(X2D(SubStr( p, 7, 1))+1)
    SourceDragColor="ForeColor"
    call dropcolor "SEARCH"  setcolor(X2D(SubStr( p, 8, 1))+1)
return 0
/*:VRX         DT_10_A_ContextMenu
*/
DT_10_A_ContextMenu: 

return

/*:VRX         DT_10_A_DragDrop
*/
DT_10_A_DragDrop: 
    call DropColor "REPLY"  setcolor(VRInfo( "SourceIndex" ))
return
/*:VRX         DT_10_B_ContextMenu
*/
DT_10_B_ContextMenu: 

return

/*:VRX         DT_10_B_DragDrop
*/
DT_10_B_DragDrop: 
    call DropColor "REPLY"  setcolor(VRInfo( "SourceIndex" ))
return

/*:VRX         DT_10_ContextMenu
*/
DT_10_ContextMenu: 

return

/*:VRX         DT_11_A_ContextMenu
*/
DT_11_A_ContextMenu: 

return

/*:VRX         DT_11_A_DragDrop
*/
DT_11_A_DragDrop: 
    call DropColor "MESSAGE"  setcolor(VRInfo( "SourceIndex" ))
return

/*:VRX         DT_11_B_ContextMenu
*/
DT_11_B_ContextMenu: 

return

/*:VRX         DT_11_B_DragDrop
*/
DT_11_B_DragDrop: 
    call DropColor "MESSAGE"  setcolor(VRInfo( "SourceIndex" ))
return

/*:VRX         DT_11_C_ContextMenu
*/
DT_11_C_ContextMenu: 

return

/*:VRX         DT_11_C_DragDrop
*/
DT_11_C_DragDrop: 
    call DropColor "MESSAGE"  setcolor(VRInfo( "SourceIndex" ))
return

/*:VRX         DT_20_ContextMenu
*/
DT_20_ContextMenu: 

return

/*:VRX         DT_21_ContextMenu
*/
DT_21_ContextMenu: 

return

/*:VRX         DT_3_A_ContextMenu
*/
DT_3_A_ContextMenu: 

return

/*:VRX         DT_3_A_DragDrop
*/
DT_3_A_DragDrop: 
    call DropColor "SEARCH"  setcolor(VRInfo( "SourceIndex" ))
return

/*:VRX         DT_3_ContextMenu
*/
DT_3_ContextMenu: 

return

/*:VRX         DT_4_ContextMenu
*/
DT_4_ContextMenu: 

return

/*:VRX         DT_7_ContextMenu
*/
DT_7_ContextMenu: 

return

/*:VRX         DT_8_ContextMenu
*/
DT_8_ContextMenu: 

return

/*:VRX         DT_9_A_ContextMenu
*/
DT_9_A_ContextMenu: 

return

/*:VRX         DT_9_A_DragDrop
*/
DT_9_A_DragDrop: 
    call DropColor "HEADER"  setcolor(VRInfo( "SourceIndex" ))
return

/*:VRX         DT_9_B_ContextMenu
*/
DT_9_B_ContextMenu: 

return

/*:VRX         DT_9_B_DragDrop
*/
DT_9_B_DragDrop:
    call DropColor "HEADER"  setcolor(VRInfo( "SourceIndex" ))
return

/*:VRX         DT_9_C_ContextMenu
*/
DT_9_C_ContextMenu: 

return

/*:VRX         DT_9_C_DragDrop
*/
DT_9_C_DragDrop: 
    call DropColor "HEADER"  setcolor(VRInfo( "SourceIndex" ))
return

/*:VRX         DT_9_ContextMenu
*/
DT_9_ContextMenu: 

return

/*:VRX         Editor_Close
*/
Editor_Close: 
    call Editor_Fini
return

/*:VRX         Editor_Create
*/
Editor_Create: 
    call Editor_Init
return

/*:VRX         Editor_Fini
*/
Editor_Fini: 
    window = VRInfo( "Window" )
    call VRDestroy window
    drop window
return
/*:VRX         Editor_Init
*/
Editor_Init: 
    window = VRInfo( "Object" )
    if( \VRIsChildOf( window, "Notebook" ) ) then do
        call VRMethod window, "CenterWindow"
        call VRSet window, "Visible", 1
        call VRMethod window, "Activate"
    end
    drop window
return

/*:VRX         EF_10_Change
*/
EF_10_Change: 
    ok = VRSet( "GB_37", "ForeColor", "<default>" )
return

/*:VRX         EF_10_ContextMenu
*/
EF_10_ContextMenu: 

return

/*:VRX         EF_11_Change
*/
EF_11_Change: 
    ok = VRSet( "GB_38", "ForeColor", "<default>" )
return

/*:VRX         EF_11_ContextMenu
*/
EF_11_ContextMenu: 

return

/*:VRX         EF_12_LostFocus
*/
EF_12_LostFocus: 

selected = VRGet( "LB_3", "Selected" )
if selected>0 then do
    conf_string.selected  = VRGet( "EF_12", "Value" )
end

return

/*:VRX         EF_13_Change
*/
EF_13_Change: 
if VRGet( "EF_13", "Value" )<>"" then
    ok = VRSet( "GB_16", "ForeColor", "<default>" )
return

/*:VRX         EF_13_ContextMenu
*/
EF_13_ContextMenu: 

return

/*:VRX         EF_1_Change
*/
EF_1_Change: 
if VRGet( "EF_1", "Value" )<>"" then
    ok = VRSet( "GB_2", "ForeColor", "<default>" )
return

/*:VRX         EF_1_ContextMenu
*/
EF_1_ContextMenu: 

return

/*:VRX         EF_2_Change
*/
EF_2_Change: 
    ok = VRSet( "GB_35", "ForeColor", "<default>" )
return

/*:VRX         EF_2_ContextMenu
*/
EF_2_ContextMenu: 

return

/*:VRX         EF_35_ContextMenu
*/
EF_35_ContextMenu: 

return

/*:VRX         EF_3_Change
*/
EF_3_Change: 
if VRGet( "EF_3", "Value" )<>"" then
    ok = VRSet( "GB_6", "ForeColor", "<default>" )
return

/*:VRX         EF_3_ContextMenu
*/
EF_3_ContextMenu: 

return

/*:VRX         EF_4_Change
*/
EF_4_Change: 
if VRGet( "EF_4", "Value" )<>"" then
    ok = VRSet( "GB_9", "ForeColor", "<default>" )
return

/*:VRX         EF_4_ContextMenu
*/
EF_4_ContextMenu: 

return

/*:VRX         EF_5_Change
*/
EF_5_Change: 
if VRGet( "EF_5", "Value" )<>"" then
    ok = VRSet( "GB_9", "ForeColor", "<default>" )
return

/*:VRX         EF_5_ContextMenu
*/
EF_5_ContextMenu: 

return

/*:VRX         EF_6_Change
*/
EF_6_Change: 
if VRGet( "EF_6", "Value" )<>"" then
    ok = VRSet( "GB_10", "ForeColor", "<default>" )
return

/*:VRX         EF_6_ContextMenu
*/
EF_6_ContextMenu: 

return

/*:VRX         EF_7_Change
*/
EF_7_Change: 
if VRGet( "EF_7", "Value" )<>"" then
    ok = VRSet( "GB_12", "ForeColor", "<default>" )
return

/*:VRX         EF_7_ContextMenu
*/
EF_7_ContextMenu: 

return

/*:VRX         EF_8_Change
*/
EF_8_Change: 
ok = VRSet( "GB_13", "ForeColor", "<default>" )

return

/*:VRX         EF_8_ContextMenu
*/
EF_8_ContextMenu: 

return

/*:VRX         EF_9_Change
*/
EF_9_Change: 
if VRGet( "EF_9", "Value" )<>"" then
    ok = VRSet( "GB_16", "ForeColor", "<default>" )
return

/*:VRX         EF_9_ContextMenu
*/
EF_9_ContextMenu: 

return

/*:VRX         Equipment_Close
*/
Equipment_Close: 
    call Equipment_Fini
return

/*:VRX         Equipment_Create
*/
Equipment_Create: 
    call Equipment_Init
return

/*:VRX         Equipment_Fini
*/
Equipment_Fini: 
    window = VRInfo( "Window" )
    call VRDestroy window
    drop window
return
/*:VRX         Equipment_Init
*/
Equipment_Init: 
    window = VRInfo( "Object" )
    if( \VRIsChildOf( window, "Notebook" ) ) then do
        call VRMethod window, "CenterWindow"
        call VRSet window, "Visible", 1
        call VRMethod window, "Activate"
    end
    drop window
return

/*:VRX         Fini
*/
Fini:
    window = VRWindow()
    call VRSet window, "Visible", 0
    drop window
return 0

/*:VRX         FKeys_Close
*/
FKeys_Close: 
    call FKeys_Fini
return

/*:VRX         FKeys_Create
*/
FKeys_Create: 
    call FKeys_Init

h="Assign command-line actions to function keys F2 through F10 with ",
  "these INI parameters.  When viewing messages, these commands will ",
  "be invoked if the corresponding key is pressed." CRLF ||,
  "NOTE that the current message is written to the named ReplyFile ",
  "before any command function is invoked.  This allows external ",
  "ASCII viewers and the like to function with the current message's ",
  "data. Examples:" CRLF ,
  "  F2 = list c:\phone.nbr" CRLF,
  "  F3 = q ..\mr2.ini" CRLF,
  " F10 = your command here"

ok = VRSet( "MLE_10", "Value", h )

return

/*:VRX         FKeys_Fini
*/
FKeys_Fini: 
    window = VRInfo( "Window" )
    call VRDestroy window
    drop window
return
/*:VRX         FKeys_Init
*/
FKeys_Init: 
    window = VRInfo( "Object" )
    if( \VRIsChildOf( window, "Notebook" ) ) then do
        call VRMethod window, "CenterWindow"
        call VRSet window, "Visible", 1
        call VRMethod window, "Activate"
    end
    drop window
return

/*:VRX         Folders_Close
*/
Folders_Close: 
    call Folders_Fini
return

/*:VRX         Folders_Create
*/
Folders_Create: 
    call Folders_Init
return

/*:VRX         Folders_Fini
*/
Folders_Fini: 
    window = VRInfo( "Window" )
    call VRDestroy window
    drop window
return
/*:VRX         Folders_Init
*/
Folders_Init: 
    window = VRInfo( "Object" )
    if( \VRIsChildOf( window, "Notebook" ) ) then do
        call VRMethod window, "CenterWindow"
        call VRSet window, "Visible", 1
        call VRMethod window, "Activate"
    end
    drop window
return

/*:VRX         GB_10_Click
*/
GB_10_Click: 

h="Reply Path Description"
ok = VRSet( "DT_6", "Caption", h )

h="Directory where ".Rep" reply packets are built and maintained.",
  " This should match any 'upload' directory specification set inside",
  " your communications package. (Not a requirement, but life is made",
  " a little easier that way).",
  " When using the CHANGE PATH button, just click on any file listed",
  " in your reply packet directory and MIM will get the directory name from there."


ok = VRSet( "MLE_4", "Value", h )

return

/*:VRX         GB_10_ContextMenu
*/
GB_10_ContextMenu: 
    call ToggleGroup
return

/*:VRX         GB_11_Click
*/
GB_11_Click: 

h="Seperator Bar Description"
ok = VRSet( "DT_19", "Caption", h )

h="Specify YES if you wish a horizontal bar to appear between normal"
h=h " and custom conferences when listed for selection."

ok = VRSet( "MLE_1", "Value", h )

return

/*:VRX         GB_11_ContextMenu
*/
GB_11_ContextMenu: 
 call ToggleGroup
return

/*:VRX         GB_12_Click
*/
GB_12_Click: 

h="File Spec Description"
ok = VRSet( "DT_6", "Caption", h )

h="This is the wildcard file specification to use when searching for packets to read.",
  " The default is *.q* meaning that it will search for *.QWK to *.Q99 files."

ok = VRSet( "MLE_4", "Value", h )

return

/*:VRX         GB_12_ContextMenu
*/
GB_12_ContextMenu: 
    call ToggleGroup
return

/*:VRX         GB_13_Click
*/
GB_13_Click: 

h="Reply File Description"
ok = VRSet( "DT_16", "Caption", h )

h = "Temporary file name used when creating replies.  This file can be"
h = h " specified with a full path, making it easier to edit it in a separate"
h = h " window.  For instance, C:\Reply is valid."

ok = VRSet( "MLE_7", "Value", h )


return

/*:VRX         GB_13_ContextMenu
*/
GB_13_ContextMenu: 
     call ToggleGroup
return

/*:VRX         GB_14_Click
*/
GB_14_Click: 
h="Tag Style Description"
ok = VRSet( "DT_14", "Caption", h )

h="This option has been around for a long time; just never documented."
h=h " This controls the type of tearline and tagline characters used. If"
h=h " set to PCBoard (just now changed to the default), you get the"
h=h " customary three dashed followed by the MR/2 identifier surrounded"
h=h " by hi-end ASCII characters ''.  If set to Fidonet mode, underlines"
h=h " replace the dashes, and '*'s are used as delimiters."
h=h " Twoline mode uses a more unique format that allows longer taglines."
h=h " The keyword AutoSense, when it exists, tells MR/2 to determine if"
h=h " the reply is to be a Fidonet-sourced message.  If it is, then Fidonet"
h=h " mode is invoked.  Otherwise, PC-Board style tags are used."

ok = VRSet( "MLE_8", "Value", h )

return

/*:VRX         GB_14_ContextMenu
*/
GB_14_ContextMenu: 
    call ToggleGroup

return

/*:VRX         GB_15_Click
*/
GB_15_Click: 
h="Tag Mode Description"
ok = VRSet( "DT_14", "Caption", h )

h="This sets the tagline file access method.  RANDOM will skip around"
h=h " and randomly select the next tagline.  SEQUENTIAL will perform a"
h=h " RANDOM seek when MR/2 is first loaded, then move sequentially"
h=h " through the file after that."

ok = VRSet( "MLE_8", "Value", h )

return

/*:VRX         GB_15_ContextMenu
*/
GB_15_ContextMenu: 
    call ToggleGroup

return

/*:VRX         GB_16_Click
*/
GB_16_Click: 

h="Tagline Description"
ok = VRSet( "DT_14", "Caption", h )

h="This sets the default tagline for MR2 replies.  This string is placed"
h=h " at the bottom of each reply, before the reply is edited.  You may"
h=h " change the tagline via your editor, while composing your reply."
h=h " Example one accesses a file of multiple taglines."
h=h " The second example provides a fixed, non-changing tagline."

ok = VRSet( "MLE_8", "Value", h )

return

/*:VRX         GB_16_ContextMenu
*/
GB_16_ContextMenu: 
    call ToggleGroup
    if VRGet( "GB_16", "ForeColor" )="<default>" then
        ok = VRSet( "GB_15", "ForeColor", "<default>" )

return

/*:VRX         GB_17_Click
*/
GB_17_Click: 
h="Tagline Identification Description"
ok = VRSet( "DT_14", "Caption", h )

h="SerialInTagline; "
h=h " If you register MR/2, you will be provided with a serialized MR2.ID"
h=h " file.  As a registered user, you have the right to choose whether"
h=h " you wish to display your serial number in your tagline or not."
h=h " Regardless, MR/2 will remove the "NR" (Not Registered) identifier"
h=h " from all your tags."

h=h " SuppressVersionInTagline;"
h=h " This controls tagline generation for registered users only."
h=h " Specifying YES here will create taglines without the MR/2 version"
h=h " number.  You may also suppress the serial number by setting"
h=h " SerialInTag to NO.  These two switches together will cause an"
h=h " MR/2 signiture like: ' * MR/2 * Tagline goes here'"

ok = VRSet( "MLE_8", "Value", h )


return

/*:VRX         GB_17_ContextMenu
*/
GB_17_ContextMenu: 
    call ToggleGroup

return

/*:VRX         GB_18_Click
*/
GB_18_Click: 

h="Old Quotes Description"
ok = VRSet( "DT_5", "Caption", h )


h="When set to YES, MR/2 will not place the quote prefix in front of"
h=h " reply-file lines that already are prefixed with quotes.  This creates"
h=h " (usually) a much cleaner initial reply file."

ok = VRSet( "MLE_3", "Value", h )

return

/*:VRX         GB_18_ContextMenu
*/
GB_18_ContextMenu: 
    call ToggleGroup

return

/*:VRX         GB_19_Click
*/
GB_19_Click: 

h="Smart Wrapping Description"
ok = VRSet( "DT_16", "Caption", h )

h = "SmartWrapping will change the logic used by MR/2 when the edited"
h=h "reply file is saved. If set to NO, the old wrapping method is used."
h=h "When left on, MR/2 will format your NEW text with some intellegence."
h=h "There is logic to differentiate between a 'hard' and "soft" return,"
h=h "and soft returns will be removed if necessary."

h=h "The old technique would simply insert hard returns to make the line"
h=h "fit within the declared wrap column.  The remaining section of the"
h=h "original line would often be short (one or two words) and look out"
h=h "of place, stranded on a line by itself.  The new technique attempts"
h=h "to rewrap the text as a whole and eliminate some of the older"
h=h "method's ugly results."
h=h "Options are YES, NO or FULL.  Full is aggressive, where most of the"
h=h "text is totally rewrapped."

h=h "NOTE: Quoted lines ARE NOT REWRAPPED, these are always considered"
h=h "to be prefixed and terminated by hard returns."

ok = VRSet( "MLE_7", "Value", h )


return

/*:VRX         GB_19_ContextMenu
*/
GB_19_ContextMenu: 
    call ToggleGroup
return

/*:VRX         GB_1_Click
*/
GB_1_Click: 

h="Show Empties Description"
ok = VRSet( "DT_19", "Caption", h )


h="If set to YES, all defined search conferences are listed on the"
h=h " conference selection screen.  Empty conferences are shown with"
h=h " message counts of (0).  If set to NO, empty 'custom' conferences"
h=h " are not listed."


ok = VRSet( "MLE_1", "Value", h )

return

/*:VRX         GB_1_ContextMenu
*/
GB_1_ContextMenu: 
 call ToggleGroup
return

/*:VRX         GB_20_Click
*/
GB_20_Click: 

h="Smart Quoting Description"
ok = VRSet( "DT_5", "Caption", h )

  h='SmartQuoting will "prewrap" the reply file that MR/2 generates,'
h=h " compensating for the user initial prefix string.  In other words,"
h=h " when you first see the reply, the original sender's text will be"
h=h " rewrapped and quoted so as to fit inside the WrapLinesAtColumn"
h=h " defined elsewhere in MR2.INI."
h=h " Options are YES, NO or FULL.  Full is aggressive, where most of the"
h=h " text is totally rewrapped."
h=h " NOTE: that existing quoted lines ARE NOT REWRAPPED."

ok = VRSet( "MLE_3", "Value", h )

return

/*:VRX         GB_20_ContextMenu
*/
GB_20_ContextMenu: 
    call ToggleGroup

return

/*:VRX         GB_21_Click
*/
GB_21_Click: 

h="Quote Body Description"
ok = VRSet( "DT_5", "Caption", h )


h = "Describes how MR/2 will quote the lines of the source message "
h=h " when creating a new reply file.  The optional %i which is the only"
h=h " parameter-type variable supported at this time) will be replaced by"
h=h " the message originator's initials.  The quote prefix may be placed"
h=h " on EachLine or on the "FirstLine" only (subsequent lines indented)."
h=h " Use Paragraph to force the full initial spec on the first line of"
h=h " each paragraph, and blank initials on subsequent lines."

ok = VRSet( "MLE_3", "Value", h )

return

/*:VRX         GB_21_ContextMenu
*/
GB_21_ContextMenu: 
    call ToggleGroup

return

/*:VRX         GB_22_Click
*/
GB_22_Click: 

h="Special Message Header Description"
ok = VRSet( "DT_5", "Caption", h )

h="You may optionally include the message header in a reply file.  This"
h=h " is often used with a clever editor "macro" to create sophisticated"
h=h " quoting styles not natively supported my MR/2.  You must be sure"
h=h " to remove all traces of the header before saving the message, as MR/2"
h=h " makes no attempt to identify or remove it."

ok = VRSet( "MLE_3", "Value", h )

return

/*:VRX         GB_22_ContextMenu
*/
GB_22_ContextMenu: 
    call ToggleGroup

return

/*:VRX         GB_23_Click
*/
GB_23_Click: 

h="Split Long Replies Description"
ok = VRSet( "DT_16", "Caption", h )

h = "MR/2 will split replies into "multiple" message at somewhere around"
h=h "92 lines if left at YES.  Set to NO, no splitting is performed."
h=h "ALTERNATIVELY, you may specify a number here, which will be the"
h=h "equivelent of saying "YES", but sets the split at count to"
h=h "whatever you specify."

ok = VRSet( "MLE_7", "Value", h )


return

/*:VRX         GB_23_ContextMenu
*/
GB_23_ContextMenu: 
    call ToggleGroup
return

/*:VRX         GB_24_Click
*/
GB_24_Click: 

h="Wrap Lines at Column Description"
ok = VRSet( "DT_16", "Caption", h )

h = "This keeps lines within reasonable lengths.  Using the system 'E'"
h=h "editor with word-wrap mode causes some problems.  The text appears"
h=h "to wrap on-screen, but MR/2 has no way of knowing where the editor"
h=h "has determined the wrap should be.  With this option set, lines are"
h=h "word wrapped at this column, avoiding truncated messages."

ok = VRSet( "MLE_7", "Value", h )


return

/*:VRX         GB_24_ContextMenu
*/
GB_24_ContextMenu: 
    call ToggleGroup
return

/*:VRX         GB_25_Click
*/
GB_25_Click: 

h="Old Replies Description"
ok = VRSet( "DT_16", "Caption", h )

h = "If YES is specified, any .REP file that is to be deleted is frist"
h=h "copied to a .OLD file.  If NO is specified, the .REP files are"
h=h "deleted and no backup is performed."

ok = VRSet( "MLE_7", "Value", h )


return

/*:VRX         GB_25_ContextMenu
*/
GB_25_ContextMenu: 
    call ToggleGroup
return

/*:VRX         GB_26_Click
*/
GB_26_Click: 

h="Log Replies Description"
ok = VRSet( "DT_16", "Caption", h )

h = "Controls the creation and maintenance of a reply log.  Set to YES,"
h=h "all replies are logged to an online reply 'folder'.  Set to FULL,"
h=h "copies of the original message preface every reply.  Set to NO, no"
h=h "reply logging is performed.  The reply folder is maintained in a"
h=h "conference named ReplyLog."

ok = VRSet( "MLE_7", "Value", h )

return

/*:VRX         GB_26_ContextMenu
*/
GB_26_ContextMenu: 
    call ToggleGroup
return

/*:VRX         GB_27_Click
*/
GB_27_Click: 

h="Strip Tagline Description"
ok = VRSet( "DT_5", "Caption", h )

h="Used only when SmartQuoting is on.  If set to YES, the quoting will"
h=h " not include the message's tag/origin lines.  Set this to NO to"
h=h " quote the entire message."

ok = VRSet( "MLE_3", "Value", h )

return

/*:VRX         GB_27_ContextMenu
*/
GB_27_ContextMenu: 
    call ToggleGroup

return

/*:VRX         GB_28_Click
*/
GB_28_Click: 

h="Reply Bookmarks Description"
ok = VRSet( "DT_16", "Caption", h )

h = "This flag, if set to YES, sets the last byte of each reply header"
h=h "back to a space before packing the replies.  Any MR/2 bookmark"
h=h "information saved with replies is lost, but some networks may"
h=h "use this byte internally and any non-standard value here might"
h=h "cause problems.  Leave set to NO unless you determine that there"
h=h "is an MR/2-specific problem with your origin lines or end"
h=h "of your replies."


ok = VRSet( "MLE_7", "Value", h )


return

/*:VRX         GB_28_ContextMenu
*/
GB_28_ContextMenu: 
    call ToggleGroup
return

/*:VRX         GB_29_Click
*/
GB_29_Click: 

h="Reassemble Splits Description"
ok = VRSet( "DT_16", "Caption", h )

h = "Controls the Prompt when a reply is to be modified and it is"
h=h "found to be one part of a 'split' message.  If YES is specified,"
h=h "MR/2 will automatically reassemble all the split parts into"
h=h "one single large "whole" for modifications.  If NO is specified,"
h=h "MR/2 will only bring in the one individual part for editing."
h=h "If ASK is specified, MR/2 prompts you for the desired action for"
h=h "each reply you request to modify."

ok = VRSet( "MLE_7", "Value", h )


return

/*:VRX         GB_29_ContextMenu
*/
GB_29_ContextMenu: 
    call ToggleGroup
return

/*:VRX         GB_2_Click
*/
GB_2_Click: 

h="Template File Description"
ok = VRSet( "DT_1", "Caption", h )

h="This is a template file used in the creation of your replies."
h=h " When you reply to any message, MR/2 will format the reply"
h=h " as defined by this file.  This allows for the creation of"
h=h " attribution and signature lines.  Variables are available for"
h=h " accessing source message and system data (e.g., FROM and DATE)."
h=h " See the read.me file and/or MR2.doc for more details."
h=h " A Sample template file is available as example.tf."

ok = VRSet( "MLE_12", "Value", h )

return

/*:VRX         GB_2_ContextMenu
*/
GB_2_ContextMenu: 
 call ToggleGroup
return

/*:VRX         GB_30_Click
*/
GB_30_Click: 
h="Color Scheme Description"
ok = VRSet( "GB_31", "Caption", h )

h = "Click on a desired Color Scheme to see it's effects on the 'Sample Screen'. " crlf,
    "Click on 'Save Scheme' to save an altered color scheme or your own new scheme. " crlf,
    "Click on 'Remove Scheme' to remove the hilighted color scheme. " crlf,
    "Color scheme names and values are save in the MIM2.CFG file."

ok = VRSet( "MLE_5", "Value", h )


return

/*:VRX         GB_31_Click
*/
GB_31_Click: 
    call ColorsHelp
return

/*:VRX         GB_32_Click
*/
GB_32_Click: 

h="Position On Match Description"
ok = VRSet( "DT_19", "Caption", h )

h="This causes the line that caused a message to 'match' to be aligned"
h=h " at the top of the display - as if a search had been performed."
h=h " Set this to NO if you wish to see the top of each message in all"
h=h " custom conferences."

ok = VRSet( "MLE_1", "Value", h )


return

/*:VRX         GB_32_ContextMenu
*/
GB_32_ContextMenu: 
 call ToggleGroup
return

/*:VRX         GB_33_Click
*/
GB_33_Click: 

h="Screen Colors Description"
ok = VRSet( "GB_31", "Caption", h )

h="Drag and drop the desired color over to the sample text area of your choice."
h=h " Colors are are slightly different in fullscreen text mode compared to this PM screen."

ok = VRSet( "MLE_5", "Value", h )

return

/*:VRX         GB_33_ContextMenu
*/
GB_33_ContextMenu: 
    call ToggleGroup

return

/*:VRX         GB_34_Click
*/
GB_34_Click: 

h="Extended Attributes Description"
ok = VRSet( "DT_15", "Caption", h )

h="When preparing to edit reply files, MR/2 can optionally mark these"
h=h " files as type 'Plain Text' so, for example, the 'E' editor will not"
h=h " force you to set the type before saving.  'None' means don't use"
h=h " extended attributes.  'Extended' tells MR/2 to set them."

ok = VRSet( "MLE_9", "Value", h )


return

/*:VRX         GB_34_ContextMenu
*/
GB_34_ContextMenu: 
    call ToggleGroup

return

/*:VRX         GB_35_Click
*/
GB_35_Click: 

h="Editor Description"
ok = VRSet( "DT_15", "Caption", h )

h="This is the command MR2 will use when invoking the editor."
h=h " By default, the MR/2 INTERNAL editor is used.  This is a simple,"
h=h " limited feature editor.  Hey, it works :)"
h=h " The second line shows how to specify that the system PM editor 'e'"
h=h " be used.  Comment out INTERNAL and uncomment this line if desired."
h=h " To use QEdit and pass it a start-up macro (-e parameter), change"
h=h " this line to read:"
h=h "      Editor=q -e\mr2\qstartup.mac"
h=h " Use NONE if you wish to have your editor running in another window."
h=h " MR/2 will not chain to an editor - it merely tells you to switch"
h=h " windows, then waits for you to switch back and press a key."

ok = VRSet( "MLE_9", "Value", h )

return

/*:VRX         GB_35_ContextMenu
*/
GB_35_ContextMenu: 
    call ToggleGroup
return

/*:VRX         GB_36_Click
*/
GB_36_Click: 

h="Mouse Settings Description"
ok = VRSet( "DT_22", "Caption", h )

h="Click one of the mouse groups for detailed information."

ok = VRSet( "MLE_2", "Value", h )

return

/*:VRX         GB_37_Click
*/
GB_37_Click: 

h="PreEdit Description"
ok = VRSet( "DT_15", "Caption", h )

h="This entry may be used to specify a 'pre editing' process for replies."
h=h " If specified, the reply file name is appended to this line and"
h=h " executed as a command line after a reply file has been created but"
h=h " before the editor is loaded.  Allows for user intervention at this"
h=h " point in processing, for such things as fancy quoting utilities."

ok = VRSet( "MLE_9", "Value", h )

return

/*:VRX         GB_37_ContextMenu
*/
GB_37_ContextMenu: 
    call ToggleGroup

return

/*:VRX         GB_38_Click
*/
GB_38_Click: 

h="PostEdit Description"
ok = VRSet( "DT_15", "Caption", h )

h="May be used to specify a 'post editing' process for replies."
h=h " If specified, the reply file name is appended to this line and"
h=h " executed as a command line after a reply file has been edited and saved"
h=h " but before the messages is recorded in the reply file.  Allows for"
h=h " user intervention at this point in processing, for such things as"
h=h " external spelling checkers.  The example here runs ShareSpell, an"
h=h " MS-DOS shareware spell checker, against all finished replies."
h=h " NOTE:  INTERNAL may be specified.  This flags MR/2 to run its"
h=h " internal spelling checker against all finished replies.  This"
h=h " allows automatic access to the built-in spelling checker even"
h=h " when using an external editor."

ok = VRSet( "MLE_9", "Value", h )
return

/*:VRX         GB_38_ContextMenu
*/
GB_38_ContextMenu: 
    call ToggleGroup

return

/*:VRX         GB_39_Click
*/
GB_39_Click: 

h="Mouse Click Speed Description"
ok = VRSet( "DT_22", "Caption", h )

h="The maximum time, in miliseconds, between mouse clicks for them to ",
  "be considered "double" clicks."

ok = VRSet( "MLE_2", "Value", h )

return

/*:VRX         GB_39_ContextMenu
*/
GB_39_ContextMenu: 
    call ToggleGroup
return

/*:VRX         GB_3_Click
*/
GB_3_Click: 

h="Internet/netmail Description"
ok = VRSet( "DT_19", "Caption", h )

h="Use these parameters to declare which conferences, if any, handle",
 " Internet mail and Fidonet netmail, respectively.  For example,",
 " PC-Ohio has Internet mail in conference 5 and Fidonet netmail in",
 " conference 6.  My PC-OHIO.INI file has: Internet=5, Netmail=6.",
 " Nerd' Nook has Netmail in conference in 139 and no Internet",
 " capabilities.  My NerdNook.INI file has the lines:"CRLF,
 "Internet=-1" CRLF "Netmail=139." CRLF ||,
 "The '-1' tells MR/2 that there is no Internet support, and makes",
 " sure that the Internet section template is not referenced.",

ok = VRSet( "MLE_1", "Value", h )

return

/*:VRX         GB_3_ContextMenu
*/
GB_3_ContextMenu: 
 call ToggleGroup
return

/*:VRX         GB_40_Click
*/
GB_40_Click: 

h="Mouse Scroll Speed Description"
ok = VRSet( "DT_22", "Caption", h )

h="Controls the speed of scrolling when you park the mouse on a scroll ",
  "arrow and hold the left mouse button down.  A value of one is the ",
  "fastest you can get right now, if this is too fast for you, raise ",
  "this number.  This represents the number of milliseconds delay before ",
  "MR/2 generates a psuedo mouse click for you. "

ok = VRSet( "MLE_2", "Value", h )

return

/*:VRX         GB_40_ContextMenu
*/
GB_40_ContextMenu: 
    call ToggleGroup
return

/*:VRX         GB_41_Click
*/
GB_41_Click: 

h="Video Description"
ok = VRSet( "DT_22", "Caption", h )

h="Click on one of the video groups for more details." 

ok = VRSet( "MLE_2", "Value", h )

return

/*:VRX         GB_42_Click
*/
GB_42_Click: 

h="Beeper Description"
ok = VRSet( "DT_22", "Caption", h )

h=" Turns the 'beep' when a personal message is displayed off and on. ",
  "Specify YES is you want MR/2 to beep on your personal messages, NO ",
  "for silent running."

ok = VRSet( "MLE_2", "Value", h )

return

/*:VRX         GB_42_ContextMenu
*/
GB_42_ContextMenu: 
    call ToggleGroup
return

/*:VRX         GB_43_Click
*/
GB_43_Click: 

h="Video Description"
ok = VRSet( "DT_22", "Caption", h )

h="Used to control the size of the 'normal' cursor when inside the ",
  "internal editor.  Under some higher-line modes, users have reported ",
  "trouble seeing the cursor.  My attempts to enlarge it solved only ",
  "some of the cases.  By default, the cursor size is 1 or 2 scan lines ",
  "tall in 25 line mode.  When switching to 34 line or greater, the ",
  "cursor size becomes 6 scanlines.  The cursor size for 'overtype' ",
  "cursors if 13 scanlines.  USE THIS OPTION ONLY IF NECCESSARY.  It's ",
  "meant only to solve some specialized, infrequent problems. ",

ok = VRSet( "MLE_2", "Value", h )

return

/*:VRX         GB_43_ContextMenu
*/
GB_43_ContextMenu: 
    call ToggleGroup
return

/*:VRX         GB_44_Click
*/
GB_44_Click: 

h="Video Description"
ok = VRSet( "DT_22", "Caption", h )

h="Specifies the number of lines/screen the display will be set to upon ",
  "entering MR/2.  Possibilities are: 25, 28, 34, 40, 43, 50 or 60. ",
  "You may also toggle through these when on the packet selection screen ",
  "by pressing ALT-V."

ok = VRSet( "MLE_2", "Value", h )

return

/*:VRX         GB_44_ContextMenu
*/
GB_44_ContextMenu: 
    call ToggleGroup
return

/*:VRX         GB_45_Click
*/
GB_45_Click: 

h="Seacrh String"
ok = VRSet( "DT_33", "Caption", h )

h=" Put search strings in double quotes." crlf
h=h "All searches are case insensitive." crlf
h=h "\ = OR" crlf
h=h "& = AND" crlf
h=h "Examples:" crlf
h=h '"Toby" searches for all messages that have the word toby.' crlf
h=h '"Jack"\"Jill" searches for all the messages that have the word jack or the word jill in them.' crlf
h=h '"Jack Sprat"\"Jill of the Jungle" searches for messages that contain the text JACK SPRAT or the words JILL OF THE JUNGLE in them.'

ok = VRSet( "MLE_11", "Value", h )

return

/*:VRX         GB_46_Click
*/
GB_46_Click: 

h="Conf # Description"
ok = VRSet( "DT_33", "Caption", h )

  h="These conferences numbers are searched using the Search string"
h=h " and 'check' settings. When a message matches the criteria then it is"
h=h " put into the virtual conference (the selected one in the Virtual Conference window)."

ok = VRSet( "MLE_11", "Value", h )

return

/*:VRX         GB_47_Click
*/
GB_47_Click: 

h="Hide # Description"
ok = VRSet( "DT_33", "Caption", h )

  h="These are conferences, specified by number, to be"
h=h " 'hidden' from the conferences w/mail selection screen.  You may"
h=h " specify multiple conference numbers."
h=h " All Hide Conference numbers are collected into a single internal"
h=h " list and have a cumulative effect."
h=h " I use this, for example, to hide the dozen or"
h=h " so FORSALE conference I download, as I let my virtual conference"
h=h " builder pick out the message I want to see.  I never go into"
h=h " these conference on an individual basis, hence, I need not see them"
h=h " as readable conference."

ok = VRSet( "MLE_11", "Value", h )

return

/*:VRX         GB_48_Click
*/
GB_48_Click: 

h="Check Description"
ok = VRSet( "DT_33", "Caption", h )

  h="Check off the part of the message that you want searched when a Virtual conference is created." crlf
h=h "Note: at least one of these boxes must be checked."

ok = VRSet( "MLE_11", "Value", h )


return

/*:VRX         GB_49_Click
*/
GB_49_Click: 

h="Template Variables Description"
ok = VRSet( "DT_1", "Caption", h )

h="For use with templates, you can assign or reassign the value of",
 " 10 user-defined variables.  Set V0 through V9 to any text string",
 " you might find handy.  These strings can then be placed in any",
 " template file line.  When a template line using one of these variables",
 " is accessed, the variable (e.g., @V0@) will be replaced with the",
 " string you have assigned to it."

ok = VRSet( "MLE_12", "Value", h )

return

/*:VRX         GB_4_Click
*/
GB_4_Click: 

h="Mouse Mode Description"
ok = VRSet( "DT_22", "Caption", h )

h="Can be set to DoubleClick (the new default) or SingleClick (the ",
  "old way).  Double click will be required to select any entry from ",
  "a selection list.  In SingleClick mode, a single mouse click will ",
  "select an entry.  DoubleClicking is provided for use with the new ",
  "'mouse menus'.  The OFF option hides the mouse cursor from program ",
  "startup.  For users who don't use the mouse, but are tired of ",
  "moving the cursor out of the way. "

ok = VRSet( "MLE_2", "Value", h )

return

/*:VRX         GB_4_ContextMenu
*/
GB_4_ContextMenu: 
    call ToggleGroup
return

/*:VRX         GB_58_Click
*/
GB_58_Click: 

h="Packet Sorting Description"
ok = VRSet( "DT_6", "Caption", h )

h="This controls the sort order in which packets are shown on the",
  " Packet Selection screen.  Possible values are:" crlf,
  "NAME - sort alphabetically" crlf,
  "DESCENDING time within descending date (default)"crlf,
  "ASCENDING time within descending date.",
  " List todays packets first, morning's first,",
  " the afternoon's, then evenings.",
  " This makes .qwk, .qw0, .qw1 list in order."

ok = VRSet( "MLE_4", "Value", h )

return

/*:VRX         GB_58_ContextMenu
*/
GB_58_ContextMenu: 
    call ToggleGroup
return

/*:VRX         GB_59_Click
*/
GB_59_Click: 

h="File Viewer Description"
ok = VRSet( "DT_6", "Caption", h )

h="May be used to specify an external file viewer for viewing news,",
  " bulletins and file lists.  The default is to use the internal viewer."

ok = VRSet( "MLE_4", "Value", h )

return

/*:VRX         GB_59_ContextMenu
*/
GB_59_ContextMenu: 
    call ToggleGroup
return

/*:VRX         GB_5_Click
*/
GB_5_Click: 

h="Display Status Description"
ok = VRSet( "DT_19", "Caption", h )

h="If set to YES, MR/2 will display a search progression string at the"
h=h " bottom of the screen.  This will appear similar to the normal"
h=h " searching status display."

ok = VRSet( "MLE_1", "Value", h )

return

/*:VRX         GB_5_ContextMenu
*/
GB_5_ContextMenu: 
 call ToggleGroup
return

/*:VRX         GB_6_Click
*/
GB_6_Click: 

h="Packet Path Description"
ok = VRSet( "DT_6", "Caption", h )

h="This is where MR2 will look for packets to read.  For convenience,",
  " this path should match any 'download directory' specification set",
  " within your communications package (e.g., c:\dl )" crlf,
  " When using the CHANGE PATH button, just click on any file listed",
  " in your mail packet directory and MIM will get the directory name from there."


ok = VRSet( "MLE_4", "Value", h )

return

/*:VRX         GB_6_ContextMenu
*/
GB_6_ContextMenu: 
    call ToggleGroup

return

/*:VRX         GB_7_Click
*/
GB_7_Click: 

h="VC Description"
ok = VRSet( "DT_33", "Caption", h )

h="Left click to select VC for actions, Right click to disable VC." crlf
h=h " Virtual conference names listed here are made up of messages from"
h=h " other conferences (Conf#) using the selected criteria from the"
h=h " 'search string' and the 'check' items."
h=h " See the SEARCH.INI file that came with MR/2 for more details."

ok = VRSet( "MLE_11", "Value", h )


return

/*:VRX         GB_8_Click
*/
GB_8_Click: 

h="Header Editing Description"
ok = VRSet( "DT_16", "Caption", h )

h = "This controls when the Message header is displayed for editing."
h=h "Options are Before, After or Both."

ok = VRSet( "MLE_7", "Value", h )

return

/*:VRX         GB_8_ContextMenu
*/
GB_8_ContextMenu: 
    call ToggleGroup
return

/*:VRX         GB_9_Click
*/
GB_9_Click: 

h="Archiver Description"
ok = VRSet( "DT_6", "Caption", h )

h="These are the commands used to archive and unarchive your message",
  " packets.  If you use something other than PKZip/UnZip, modify these",
  " commands appropriately." crlf crlf,
  "Zipper=..\msg2rep  and  Unzipper=..\unqwk" crlf,
  "Are used to access a REXX script for packing and unpacking.",
  " These scripts, included, will attempt to auto-detect the",
  " archive method and branch to an appropriate command."

ok = VRSet( "MLE_4", "Value", h )

return

/*:VRX         GB_9_ContextMenu
*/
GB_9_ContextMenu: 
    call ToggleGroup
return

/*:VRX         getcolor
*/
getcolor: 

/*this routine returns the MR/2 color code from the sample screen*/

/*MESSAGE*/
colorcode = convertcolor(VRGet( "DT_11_A", "BackColor" ))
colorcode = colorcode||convertcolor(VRGet( "DT_11_A", "ForeColor" ))

/*REPLY*/
colorcode = colorcode||convertcolor(VRGet( "DT_10_A", "BackColor" ))
colorcode = colorcode||convertcolor(VRGet( "DT_10_A", "ForeColor" ))

/*HEADER*/
colorcode = colorcode||convertcolor(VRGet( "DT_9_A", "BackColor" ))
colorcode = colorcode||convertcolor(VRGet( "DT_9_A", "ForeColor" ))

/*SEARCH*/
colorcode = colorcode||convertcolor(VRGet( "DT_3_A", "BackColor" ))
colorcode = colorcode||convertcolor(VRGet( "DT_3_A", "ForeColor" ))

return colorcode


convertcolor:
parse arg n
select
    when n="Black" then c = "0" 
    when n="DarkBlue" then c = "1"
    when n="DarkGreen" then c = "2"
    when n="DarkCyan" then c = "3"
    when n="DarkRed" then c = "4"
    when n="DarkPink" then c = "5"
    when n="Brown" then c = "6"
    when n="PaleGray" then c = "7"
    when n="DarkGray" then c = "8"
    when n="Blue" then c = "9"
    when n="Green" then c = "A"
    when n="Cyan" then c = "B"
    when n="Red" then c = "C"
    when n="Pink" then c = "D"
    when n="Yellow" then c = "E"
    when n="White" then c = "F"
    otherwise c = "0"
 end
return c

/*:VRX         Halt
*/
Halt:
    signal _VREHalt
return

/*:VRX         Init
*/
Init:
    window = VRWindow()
    call VRMethod window, "CenterWindow"
    call VRSet window, "Visible", 1
    call VRMethod window, "Activate"
    drop window

/*general purpose initialization*/
Version_Number="0.10"
CRLF="0d0a"x
Filename="" /*no filename initially selected*/
CFG_FileName=".\MIM2.CFG"
conf.0=0    /*clear virtual conference pointers*/
Pre_Var=""  /*Pre variable for saving variables in writeini*/
do index=1 to 4 /*initialize previous files*/
  file.index=""
end

/*Read MIM2.CFG file*/
/* initialize color schemes */
/* initialiaze "previous file" listing*/

CFG_FileName = ".\MIM2.CFG"
Index=0
do while LINES(CFG_FileName)
    line  = LineIn( CFG_FileName )
    stripped = Strip( line, "Leading", " " )
    if (Left( stripped, 1) \= "#") & (Pos( "=", stripped)>0) then do  /*check if line should be parsed*/
      variable = Strip(Left(stripped,Pos("=",stripped)-1), "Both", " " )  /* get variable name*/
      Parse Upper var variable v 
      p = Strip(Right(stripped,Length(stripped)-Pos("=",stripped)), "Leading", " " )   /*get parameter*/

        select
            when v = "COLORSCHEME" then do
                if length(p)>9 then do
                    Index=Index+1
                    ColorSchemeValue.Index =  Left(p,8)
                    ColorSchemeName.Index  = Strip(Right(p,Length(p)-8), "Leading", " " ) 
                end
            end

            when v = "FILE1" then do
                file.1=p
            end
            when v = "FILE2" then do
                file.2=p
            end
            when v = "FILE3" then do
                file.3=p
            end
            when v = "FILE4" then do
                file.4=p
            end

            otherwise do
            end
         end
    end     /* end of if not comment checking */
end         /* stop reading file*/

ok=Stream(CFG_FileName,'c','close')

ColorSchemeName.0 = Index



return

/*:VRX         LB_2_Click
*/
LB_2_Click: 
selectedstring = VRGet( "LB_2", "SelectedString" )
do index = 1 to ColorSchemeName.0
    if selectedstring=ColorSchemeName.index then do
        p=ColorSchemeValue.index
        call PutColors
    end
end

return

/*:VRX         LB_3_Click
*/
LB_3_Click: 
    vc_num = VRGet( "LB_3", "Selected" )

if vc_num > 0 then do

    ok = VRMethod( "LB_4", "Clear" )
    do index = 1 to conf.vc_num.0
        position = VRMethod( "LB_4", "AddString", conf.vc_num.index,  )
    end

    ok = VRMethod( "LB_1", "Clear" )
    do index = 1 to conf_hide.vc_num.0
        position = VRMethod( "LB_1", "AddString", conf_hide.vc_num.index,  )
    end

ok = VRSet( "EF_12", "Value", conf_string.vc_num )

call CheckFor
ok = VRSet( "CB_7",  "Set", conf_from.vc_num )
ok = VRSet( "CB_10", "Set", conf_to.vc_num )
ok = VRSet( "CB_8",  "Set", conf_body.vc_num )
ok = VRSet( "CB_11", "Set", conf_origin.vc_num )
ok = VRSet( "CB_9",  "Set", conf_subject.vc_num )

end    

else do
    ok = VRMethod( "LB_4", "Clear" )
    ok = VRMethod( "LB_1", "Clear" )
    ok = VRSet( "EF_12", "Value", "" )
    ok = VRSet( "CB_7",  "Set", 0 )
    ok = VRSet( "CB_10", "Set", 0 )
    ok = VRSet( "CB_8",  "Set", 0 )
    ok = VRSet( "CB_11", "Set", 0 )
    ok = VRSet( "CB_9",  "Set", 0 )
end
   
return

/*:VRX         LB_3_ContextMenu
*/
LB_3_ContextMenu: 
selected = VRGet( "LB_3", "Selected" )
if selected>0 then do

if (left(conf.selected,1)="{") & (right(conf.selected,1)="}") then do
    conf.selected= left(conf.selected,length(conf.selected)-1)
    conf.selected=right(conf.selected,length(conf.selected)-1)
end
else do
    conf.selected="{"||conf.selected||"}"
end

ok = VRMethod( "LB_3", "Delete", selected )
position = VRMethod( "LB_3", "AddString", conf.selected, selected )
ok = VRMethod( "LB_3", "PostEvent", "Click" )
ok = VRSet( "LB_3", "Selected", Selected )

end
else 
    id = VRMessage( VRWindow(), "You must select an item to disable","Deleting unselected Item" , "Information" )

return

/*:VRX         LB_3_DoubleClick
*/
LB_3_DoubleClick: 

    vc_name = VRGet( "LB_3", "SelectedString" )
    selected = VRGet( "LB_3", "Selected" )

    Buttons.1 = "Change"
    Buttons.2 = "Cancel"
    Buttons.0 = 2
    id = VRPrompt( VRWindow(), "", "vc_name", "Change conference name", "Buttons.", 1, 2 )

if id=1 then do
    conf.selected=vc_name
    ok = VRMethod( "LB_3", "Delete", selected )
    position = VRMethod( "LB_3", "AddString", vc_name, selected )
end

return

/*:VRX         LB_3_KeyPress
*/
LB_3_KeyPress: 

if VRGet( "LB_3", "KeyString" )="{Del}" then
    ok = VRMethod( "PB_23", "PostEvent", "Click" )

return

/*:VRX         LeftOver_Close
*/
LeftOver_Close: 
    call LeftOver_Fini
return

/*:VRX         LeftOver_Create
*/
LeftOver_Create: 
    call LeftOver_Init
return

/*:VRX         LeftOver_Fini
*/
LeftOver_Fini: 
    window = VRInfo( "Window" )
    call VRDestroy window
    drop window
return
/*:VRX         LeftOver_Init
*/
LeftOver_Init: 
    window = VRInfo( "Object" )
    if( \VRIsChildOf( window, "Notebook" ) ) then do
        call VRMethod window, "CenterWindow"
        call VRSet window, "Visible", 1
        call VRMethod window, "Activate"
    end
    drop window
return

/*:VRX         Menu_File_Exit_Click
*/
Menu_File_Exit_Click: 
Buttons.1 = "Exit"
Buttons.2 = "Cancel"
Buttons.0 = 2
id = VRMessage( VRWindow(), "Are you sure you want to exit MIM/2?", "Exit", "None", "Buttons.", 1, 2 )

if id=1 then
    ok = VRMethod( "Window1", "PostEvent", close )

return

/*:VRX         Menu_File_File1_Click
*/
Menu_File_File1_Click: 
    FileName = VRGet( "Menu_File_File1", "Caption" )
    Call Open_INI_File
return

/*:VRX         Menu_File_File2_Click
*/
Menu_File_File2_Click: 
    FileName = VRGet( "Menu_File_File2", "Caption" )
    Call Open_INI_File
return

/*:VRX         Menu_File_File3_Click
*/
Menu_File_File3_Click: 
    FileName = VRGet( "Menu_File_File3", "Caption" )
    Call Open_INI_File
return

/*:VRX         Menu_File_File4_Click
*/
Menu_File_File4_Click: 
    FileName = VRGet( "Menu_File_File4", "Caption" )
    Call Open_INI_File
return

/*:VRX         Menu_File_New_Click
*/
Menu_File_New_Click: 
/* clear all variables back to original status */

/*Clear BASIC Page*/
ok = VRSet( "GB_6", "ForeColor", "DarkGray" ) /*packet path*/
ok = VRSet( "EF_3", "Value", "" )
ok = VRSet( "GB_10", "ForeColor", "DarkGray" ) /* reply path*/
ok = VRSet( "EF_6", "Value", "" )
ok = VRSet( "GB_12", "ForeColor", "DarkGray" ) /*filespec*/
ok = VRSet( "EF_7", "Value", "" )
ok = VRSet( "GB_9", "ForeColor", "DarkGray" ) /*archiver*/
ok = VRSet( "EF_5", "Value", "" )
ok = VRSet( "EF_4", "Value", "" )

/*Editor*/
ok = VRSet( "GB_35", "ForeColor", "DarkGray" )
ok = VRSet( "GB_37", "ForeColor", "DarkGray" )
ok = VRSet( "GB_38", "ForeColor", "DarkGray" )
ok = VRSet( "GB_34", "ForeColor", "DarkGray" )

/*Quoting*/
ok = VRSet( "GB_21", "ForeColor", "DarkGray" )
ok = VRSet( "GB_20", "ForeColor", "DarkGray" )
ok = VRSet( "GB_27", "ForeColor", "DarkGray" )
ok = VRSet( "GB_18", "ForeColor", "DarkGray" )
ok = VRSet( "GB_22", "ForeColor", "DarkGray" )

/*Reply*/
ok = VRSet( "GB_13", "ForeColor", "DarkGray" )
ok = VRSet( "GB_8", "ForeColor", "DarkGray" )
ok = VRSet( "GB_19", "ForeColor", "DarkGray" )
ok = VRSet( "GB_26", "ForeColor", "DarkGray" )
ok = VRSet( "GB_23", "ForeColor", "DarkGray" )
ok = VRSet( "GB_29", "ForeColor", "DarkGray" )
ok = VRSet( "GB_24", "ForeColor", "DarkGray" )
ok = VRSet( "GB_28", "ForeColor", "DarkGray" )
ok = VRSet( "GB_25", "ForeColor", "DarkGray" )

/*Colors*/
ok = VRSet( "GB_33", "ForeColor", "DarkGray" )

/*Clear TAGLINE Page*/
ok = VRSet( "GB_16", "ForeColor", "DarkGray" ) /*Tagline*/
ok = VRSet( "CB_15", "Set", 0 )
ok = VRSet( "PB_10", "Visible", 0 )
ok = VRSet( "DT_4", "Caption", "Fixed Tag Line" )
ok = VRSet( "EF_9", "Value", "" )
ok = VRSet( "EF_13", "Value", "" )
ok = VRSet( "GB_17", "ForeColor", "DarkGray" )/*tagline identification text*/
ok = VRSet( "CB_13", "Set", 0 )
ok = VRSet( "CB_14", "Set", 0 )
ok = VRSet( "GB_14", "ForeColor", "DarkGray" )/*tag style*/
ok = VRSet( "GB_15", "ForeColor", "DarkGray" )/*tag mode*/

/*Settings*/
ok = VRSet( "GB_1", "ForeColor", "DarkGray" )
ok = VRSet( "CB_1", "Set", 0 )
ok = VRSet( "GB_5", "ForeColor", "DarkGray" )
ok = VRSet( "CB_2", "Set", 0 )
ok = VRSet( "GB_11", "ForeColor", "DarkGray" )
ok = VRSet( "CB_3", "Set", 0 )
ok = VRSet( "GB_32", "ForeColor", "DarkGray" )
ok = VRSet( "CB_4", "Set", 0 )
ok = VRSet( "GB_2", "ForeColor", "DarkGray" )
ok = VRSet( "EF_1", "Value", "" )
ok = VRSet( "GB_3", "ForeColor", "DarkGray" )
ok = VRSet( "CB_5", "Set", 0 )
ok = VRSet( "CB_6", "Set", 0 )
ok = VRSet( "SPIN_1", "Value", "-1" )
ok = VRSet( "SPIN_2", "Value", "-1" )

/*Leftovers*/
ok = VRSet( "MLE_6", "Value", "" )

/*Virtual Conferences*/
conf.0=0    /*clear virtual conference pointer*/
vc_num=0
ok = VRMethod( "LB_3", "Clear" )  /* Clear the VC lists*/
ok = VRMethod( "LB_4", "Clear" )
ok = VRMethod( "LB_1", "Clear" )
ok = VRSet( "EF_12", "Value", "" )
ok = VRSet( "CB_7",  "Set", 0 )
ok = VRSet( "CB_10", "Set", 0 )
ok = VRSet( "CB_8",  "Set", 0 )
ok = VRSet( "CB_11", "Set", 0 )
ok = VRSet( "CB_9",  "Set", 0 )

/*Equipment page*/
ok = VRSet( "GB_4", "ForeColor", "DarkGray" )
ok = VRSet( "GB_39", "ForeColor", "DarkGray" )
ok = VRSet( "GB_40", "ForeColor", "DarkGray" )
ok = VRSet( "GB_44", "ForeColor", "DarkGray" )
ok = VRSet( "GB_43", "ForeColor", "DarkGray" )
ok = VRSet( "GB_42", "ForeColor", "DarkGray" )

/*Fkeys*/
ok = VRSet( "EF_15", "Value", "" )
ok = VRSet( "EF_16", "Value", "" )
ok = VRSet( "EF_17", "Value", "" )
ok = VRSet( "EF_18", "Value", "" )
ok = VRSet( "EF_19", "Value", "" )
ok = VRSet( "EF_20", "Value", "" )
ok = VRSet( "EF_21", "Value", "" )
ok = VRSet( "EF_22", "Value", "" )
ok = VRSet( "EF_23", "Value", "" )



/*Indicate new (no) filename */
ok = VRSet( "Window1", "Caption", "MIM/2 - Ver" Version_Number )

return


/*:VRX         Menu_File_Open_Click
*/
Menu_File_Open_Click: 
  FileName = VRFileDialog( VRWindow(), "Select an INI file", "Open", "*.INI", , ,  )
  Call Open_INI_File
Return

Open_INI_File:
if FileName<>"" then do
  call Menu_File_New_Click
  call ReadINIFile FileName
  ok = VRSet( "Window1", "Caption", "MIM/2 - Ver" Version_Number FileName)


  call Update_FileNames
end
return

Update_FileNames:
select
    when FileName = File.1 then do
        /*do nothing since the same file has been selected*/
    end
    when FileName = File.2 then do  /*swap 1 and 2*/
        File.2=File.1
        File.1=FileName
    end
    when FileName = File.3 then do
        File.3=File.2
        File.2=File.1
        File.1=FileName
    end
    otherwise do   /*also same when FileName=File.4*/
        File.4=File.3
        File.3=File.2
        File.2=File.1
        File.1=FileName
    end
 end
 File.1=FileName  /* in case none of the above set the value up*/


Update_FileMenu_Bar:        /*Update FileNames on menubar*/
    ok = VRSet( "Menu_File_File1", "Visible", 1 )
    ok = VRSet( "Menu_File_File1", "Caption", File.1 )
 If File.2<>"" then do
    ok = VRSet( "Menu_File_File2", "Visible", 1 )
    ok = VRSet( "Menu_File_File2", "Caption", File.2 )
 end
 If File.3<>"" then do
    ok = VRSet( "Menu_File_File3", "Visible", 1 )
    ok = VRSet( "Menu_File_File3", "Caption", File.3 )
 end
 If File.4<>"" then do
    ok = VRSet( "Menu_File_File4", "Visible", 1 )
    ok = VRSet( "Menu_File_File4", "Caption", File.4 )
 end
 /*Save CFG file*/
 Call SaveCFG

return
/*:VRX         Menu_File_Save_Click
*/
Menu_File_Save_Click: 

caption=VRGet( "Window1", "Caption" )
if Length(caption)>16 then do
    Filename=Right(caption, (Length(Caption)-16))
    Filename=Strip( FileName, "Both", " " )
    end
else
    Filename=""

if FileName<>"" then
    call WriteINIFile FileName
else
    call Menu_File_SaveAs_Click

return

/*:VRX         Menu_File_SaveAs_Click
*/
Menu_File_SaveAs_Click: 

FileName = VRFileDialog( VRWindow(), "Select an INI file", "Open", "*.INI", , ,  )

if FileName<>"" then
    call WriteINIFile FileName

return 0

/*:VRX         Menu_Help_about_Click
*/
Menu_Help_about_Click: 
window = VRLoadSecondary( "About", "W" )

return

/*:VRX         Menu_Help_Doc_Click
*/
Menu_Help_Doc_Click: 
 call VRSet "Window1", "HelpText", "(MIM2.DOC)"
 call VRMethod "Window1", "InvokeHelp"
return


/*:VRX         Menu_Help_Usage_Click
*/
Menu_Help_Usage_Click: 
window = VRLoadSecondary( "Usage", "W" )
return

/*:VRX         Messages_Close
*/
Messages_Close: 
    call Messages_Fini
return

/*:VRX         Messages_Create
*/
Messages_Create: 
    call Messages_Init
return

/*:VRX         Messages_Fini
*/
Messages_Fini: 
    window = VRInfo( "Window" )
    call VRDestroy window
    drop window
return
/*:VRX         Messages_Init
*/
Messages_Init: 
    window = VRInfo( "Object" )
    if( \VRIsChildOf( window, "Notebook" ) ) then do
        call VRMethod window, "CenterWindow"
        call VRSet window, "Visible", 1
        call VRMethod window, "Activate"
    end
    drop window
return

/*:VRX         PB_10_Click
*/
PB_10_Click: 
    ok = VRSet( "GB_16", "ForeColor", "<default>" )
    ok = VRSet( "EF_13", "Value", VRFileDialog( VRWindow(), "Tag file selection", "Open", , , ,  ) )
return

/*:VRX         PB_10_ContextMenu
*/
PB_10_ContextMenu: 

return

/*:VRX         PB_11_ContextMenu
*/
PB_11_ContextMenu: 

return

/*:VRX         PB_12_Click
*/
PB_12_Click: 
ok = VRDestroy( "About" )
return


/*:VRX         PB_13_Click
*/
PB_13_Click: 

selectedstring = VRGet( "LB_2", "SelectedString" )

if selectedstring<>"" then do 
    tempindex=0
    do index = 1 to ColorSchemeName.0
        if ColorSchemeName.Index<>selectedstring then do
            tempindex=tempindex+1
            tempname.tempindex=ColorSchemeName.Index
            tempvalue.tempindex=ColorSchemeValue.Index
        end
    end

    ColorSchemeName.0=tempindex

    do index = 1 to ColorSchemeName.0
        ColorSchemeName.Index=tempname.index
        ColorSchemeValue.Index=tempvalue.index
    end

    /*refresh list*/
    ok = VRMethod( "LB_2", "Clear" )
    ok = VRMethod( "LB_2", "AddStringList", "ColorSchemeName.",  )

    call SaveCFG
end
else 
    ok  = Beep( "400", "100" )


return
/*:VRX         PB_14_Click
*/
PB_14_Click: 
    ok = VRSet( "EF_2", "Value", VRFileDialog( VRWindow(), "Editor Selection", "Open", , , ,  ) )
    ok = VRSet( "RB_32", "Set", 1 )
    ok = VRSet( "GB_35", "ForeColor", "<default>" )
return

/*:VRX         PB_14_ContextMenu
*/
PB_14_ContextMenu: 

return

/*:VRX         PB_15_Click
*/
PB_15_Click: 
    ok = VRSet( "EF_10", "Value", VRFileDialog( VRWindow(), "Pre-Edit Selection", "Open", , , ,  ) )
    ok = VRSet( "RB_35", "Set", 1 )
    ok = VRSet( "GB_37", "ForeColor", "<default>" )
return

/*:VRX         PB_15_ContextMenu
*/
PB_15_ContextMenu: 

return

/*:VRX         PB_16_Click
*/
PB_16_Click: 

Value=""   /*Dialog box will alter this variable*/
PromptCaption="Save Scheme"
PromptTextCaption="Please Enter the Color Scheme Name:"
Prompt_EntryField_Value = VRGet( "LB_2", "SelectedString" )
SelectedString = VRLoadSecondary( "Prompt", "W" )

ColorValue = Right(VRGet( "DT_11_B", "Caption" ),8)

If Value<>"" then
    SelectedString=Value

if SelectedString<>"" then do
    add_the_string=1
    do index = 1 to ColorSchemeName.0
      if SelectedString = ColorSchemeName.index then do
        add_the_string=0  /* name already exists*/
        ColorSchemeValue.Index=ColorValue        
      end
    end
    if add_the_string=1 then do
        ColorSchemeName.0=index
        ColorSchemeName.index=SelectedString
        ColorSchemeValue.Index=ColorValue        
    end

ok = VRMethod( "LB_2", "Clear" )
ok = VRMethod( "LB_2", "AddStringList", "ColorSchemeName.",  )

call SaveCFG

end

return


SaveCFG:    /* save .cfg file*/
CFG_FileName=".\MIM2.CFG"
'del ' CFG_FileName
do index = 1 to ColorSchemeName.0
    count  = LineOut( CFG_FileName, "ColorScheme = " ColorSchemeValue.Index ColorSchemeName.index )
end

do index=1 to 4
    count  = LineOut( CFG_FileName, "File"||Index||"=" File.Index)
end

ok=Stream(CFG_FileName,'c','close')
return 0
/*:VRX         PB_17_Click
*/
PB_17_Click: 
    ok = VRSet( "EF_11", "Value", VRFileDialog( VRWindow(), "Post-Edit Selection", "Open", , , ,  ) )
    ok = VRSet( "RB_37", "Set", 1 )
    ok = VRSet( "GB_38", "ForeColor", "<default>" )
return

/*:VRX         PB_17_ContextMenu
*/
PB_17_ContextMenu: 

return

/*:VRX         PB_18_Click
*/
PB_18_Click: 
    ok = VRSet( "EF_20", "Value", VRFileDialog( VRWindow(), "F7 Key selection", "Open", , , ,  ) )
return

/*:VRX         PB_19_Click
*/
PB_19_Click: 
    ok = VRSet( "EF_21", "Value", VRFileDialog( VRWindow(), "F8 Key selection", "Open", , , ,  ) )
return

/*:VRX         PB_1_Click
*/
PB_1_Click: 
    ok = VRSet( "EF_15", "Value", VRFileDialog( VRWindow(), "F2 Key selection", "Open", , , ,  ) )
return

/*:VRX         PB_20_Click
*/
PB_20_Click: 
    ok = VRSet( "EF_22", "Value", VRFileDialog( VRWindow(), "F9 Key selection", "Open", , , ,  ) )
return

/*:VRX         PB_21_Click
*/
PB_21_Click: 
    ok = VRSet( "EF_23", "Value", VRFileDialog( VRWindow(), "F10 Key selection", "Open", , , ,  ) )
return

/*:VRX         PB_22_Click
*/
PB_22_Click: /*Add Virtual Conference*/

    vc_name=""
    Buttons.1 = "Add"
    Buttons.2 = "Done"
    Buttons.0 = 2
    id = VRPrompt( VRWindow(), "", "vc_name", "Add conference number", "Buttons.", 1, 2 )
    position = VRMethod( "LB_3", "AddString", vc_name,  )

    conf.0=conf.0+1
    last_vc=conf.0
    conf.last_vc.0=0         /*clear conf pointer*/
    conf_hide.last_vc.0=0    /*clear hide conf pointer*/
    conf_string.last_vc=""   /*initialize string to null*/

    conf.last_vc=vc_name

return

/*:VRX         PB_23_Click
*/
PB_23_Click: 
selected = VRGet( "LB_3", "Selected" )

if selected>0 then do

ok = VRMethod( "LB_3", "GetStringList", "items." )

if items.0>0 then do
  selected = VRGet( "LB_3", "Selected" )

  Buttons.1 = "~Delete"
  Buttons.2 = "~Cancel"
  Buttons.0 = 2
  Button_Action = VRMessage( VRWindow(), "Permanently DELETE this virtual conference? ", "Delete Virtual Conference", "None", "Buttons.", 1, 2 )

  if Button_Action=1 then do
    ok = VRMethod( "LB_3", "Delete", selected )

   if conf.0>1 then do

    do index=selected+1 to conf.0
        indexm1=index-1
        /*VC name*/
        conf.indexm1=conf.index
        /*conf numbers*/
        do index2=0 to conf.index.0
            conf.indexm1.index2=conf.index.index2
        end
        /*hide numbers*/
        do index2=0 to conf.index.0
            conf_hide.indexm1.index2=conf_hide.index.index2
        end
        /*check values*/
           conf_from.indexm1=conf_from.index
             conf_to.indexm1=conf_to.index
           conf_body.indexm1=conf_body.index
         conf_origin.indexm1=conf_origin.index
        conf_subject.indexm1=conf_subject.index
        /*string*/
        conf_string.indexm1=conf_string.index
    end

   conf.0=items.0-1
   end

/*set selected virtual conference to first item*/ 
if vc_num>0 then do
   if conf.0>=selected then
    ok = VRSet( "LB_3", "Selected", Selected )
   else
    ok = VRSet( "LB_3", "Selected", conf.0 )

    ok = VRMethod( "LB_3", "PostEvent", "Click" )
    end

  end

end

end /*if selected>0*/

return

/*:VRX         PB_24_Click
*/
PB_24_Click: 
    ok = VRMethod( "LB_4", "GetSelectedList", "selected." )
    ok = VRMethod( "LB_4", "DeleteList", "selected." )
    vc_num = VRGet( "LB_3", "Selected" )
    ok = VRMethod( "LB_4", "GetStringList", "items." )
    do index=0 to items.0
        conf.vc_num.index=items.index
    end
return

/*:VRX         PB_25_Click
*/
PB_25_Click: 

conf_num=""
id=1    /*assume Adding of conf numbers*/
do while id =1
    Buttons.1 = "~Add"
    Buttons.2 = "~Done"
    Buttons.0 = 2
    id = VRPrompt( VRWindow(), "", "conf_num", "Add conference number", "Buttons.", 1, 2 )
    position = VRMethod( "LB_4", "AddString", conf_num,  )
end

ok = VRMethod( "LB_4", "GetStringList", "strings." )
call dupe_check

ok = VRMethod( "LB_4", "Clear" )
ok = VRMethod( "LB_4", "AddStringList", "strings.",  )
ok = VRMethod( "LB_4", "GetStringList", "items." )
do index=0 to items.0
    conf.vc_num.index=items.index
end


return

/*:VRX         PB_26_Click
*/
PB_26_Click: 
    ok = VRMethod( "LB_1", "GetSelectedList", "selected." )
    ok = VRMethod( "LB_1", "DeleteList", "selected." )
    vc_num = VRGet( "LB_3", "Selected" )
    ok = VRMethod( "LB_1", "GetStringList", "items." )
    do index=0 to items.0
        conf_hide.vc_num.index=items.index
    end
return

/*:VRX         PB_27_Click
*/
PB_27_Click: 


conf_num=""
id=1    /*assume Adding of conf numbers*/
do while id =1
    Buttons.1 = "~Add"
    Buttons.2 = "~Done"
    Buttons.0 = 2
    id = VRPrompt( VRWindow(), "", "conf_num", "Add conference number", "Buttons.", 1, 2 )
    position = VRMethod( "LB_1", "AddString", conf_num,  )
end


ok = VRMethod( "LB_1", "GetStringList", "strings." )
call dupe_check

ok = VRMethod( "LB_1", "Clear" )
ok = VRMethod( "LB_1", "AddStringList", "strings.",  )
ok = VRMethod( "LB_1", "GetStringList", "items." )
do index=0 to items.0
    conf_hide.vc_num.index=items.index
end

return

/*:VRX         PB_28_Click
*/
PB_28_Click: 
selected = VRGet( "LB_3", "Selected" )
if (selected \=conf.0)&(selected<>0) then do  /*can't move last item down*/

        selectedp1=selected+1
        /*VC name*/
        save=conf.selectedp1            /*save spot plus1*/
        conf.selectedp1=conf.selected   /*fill spot plus1*/
        conf.selected=save              /*fill spot*/

ok = VRMethod( "LB_3", "Delete", selected )
position = VRMethod( "LB_3", "AddString", conf.selectedp1, selectedp1 )
ok = VRSet( "LB_3", "Selected", selectedp1 )

        /*conf numbers*/
        do index=0 to conf.selectedp1.0 /*save spot plus1*/
            save.index=conf.selectedp1.index
        end
        do index=0 to conf.selected.0 /*fill spot plus1*/
            conf.selectedp1.index=conf.selected.index
        end
        do index=0 to save.0 /*fill spot*/
            conf.selected.index=save.index
        end


        /*hide numbers*/
        do index=0 to conf.selectedp1.0 /*save spot plus1*/
            save.index=conf_hide.selectedp1.index
        end
        do index=0 to conf.selected.0 /*fill spot plus1*/
            conf_hide.selectedp1.index=conf_hide.selected.index
        end
        do index=0 to save.0 /*fill spot*/
            conf_hide.selected.index=save.index
        end

        /*check values*/
                        save=conf_from.selectedp1
        conf_from.selectedp1=conf_from.selected
          conf_from.selected=save

                      save=conf_to.selectedp1
        conf_to.selectedp1=conf_to.selected
          conf_to.selected=save

                        save=conf_body.selectedp1
        conf_body.selectedp1=conf_body.selected
          conf_body.selected=save

                          save=conf_origin.selectedp1
        conf_origin.selectedp1=conf_origin.selected
          conf_origin.selected=save

                      save=conf_subject.selectedp1
        conf_subject.selectedp1=conf_subject.selected
          conf_subject.selected=save

        /*string*/
                          save=conf_string.selectedp1
        conf_string.selectedp1=conf_string.selected
          conf_string.selected=save

ok = VRMethod( "LB_3", "PostEvent", "Click" )

end
else    /*beep if last item was selected to move down*/
    ok  = Beep( "400", "100" )
    
return

/*:VRX         PB_29_Click
*/
PB_29_Click: 
selected = VRGet( "LB_3", "Selected" )
if (selected \=1)&(selected<>0) then do  /*can't move last item down*/

        selectedm1=selected-1
        /*VC name*/
        save=conf.selectedm1            /*save spot plus1*/
        conf.selectedm1=conf.selected   /*fill spot plus1*/
        conf.selected=save              /*fill spot*/

ok = VRMethod( "LB_3", "Delete", selected )
position = VRMethod( "LB_3", "AddString", conf.selectedm1, selectedm1 )
ok = VRSet( "LB_3", "Selected", selectedm1 )

        /*conf numbers*/
        do index=0 to conf.selectedm1.0 /*save spot plus1*/
            save.index=conf.selectedm1.index
        end
        do index=0 to conf.selected.0 /*fill spot plus1*/
            conf.selectedm1.index=conf.selected.index
        end
        do index=0 to save.0 /*fill spot*/
            conf.selected.index=save.index
        end


        /*hide numbers*/
        do index=0 to conf.selectedm1.0 /*save spot plus1*/
            save.index=conf_hide.selectedm1.index
        end
        do index=0 to conf.selected.0 /*fill spot plus1*/
            conf_hide.selectedm1.index=conf_hide.selected.index
        end
        do index=0 to save.0 /*fill spot*/
            conf_hide.selected.index=save.index
        end

        /*check values*/
                        save=conf_from.selectedm1
        conf_from.selectedm1=conf_from.selected
          conf_from.selected=save

                      save=conf_to.selectedm1
        conf_to.selectedm1=conf_to.selected
          conf_to.selected=save

                        save=conf_body.selectedm1
        conf_body.selectedm1=conf_body.selected
          conf_body.selected=save

                          save=conf_origin.selectedm1
        conf_origin.selectedm1=conf_origin.selected
          conf_origin.selected=save

                      save=conf_subject.selectedm1
        conf_subject.selectedm1=conf_subject.selected
          conf_subject.selected=save

        /*string*/
                          save=conf_string.selectedm1
        conf_string.selectedm1=conf_string.selected
          conf_string.selected=save

ok = VRMethod( "LB_3", "PostEvent", "Click" )

end
else    /*beep if last item was selected to move down*/
    ok  = Beep( "400", "100" )

return

/*:VRX         PB_2_Click
*/
PB_2_Click: 
    ok = VRSet( "EF_16", "Value", VRFileDialog( VRWindow(), "F3 Key selection", "Open", , , ,  ) )

return

/*:VRX         PB_30_Click
*/
PB_30_Click: 
ok = VRMethod( "LB_4", "GetSelectedStringList", "selected." )
ok = VRMethod( "LB_1", "AddStringList", "selected.",  )

ok = VRMethod( "LB_4", "GetSelectedList", "selected." )
ok = VRMethod( "LB_4", "DeselectList", "selected." )

ok = VRMethod( "LB_1", "GetStringList", "strings." )
call dupe_check

ok = VRMethod( "LB_1", "Clear" )
ok = VRMethod( "LB_1", "AddStringList", "strings.",  )
ok = VRMethod( "LB_1", "GetStringList", "items." )
do index=0 to items.0
    conf_hide.vc_num.index=items.index
end


return



dupe_check:  /* this three section routine will clear dupes from a variable*/
/*1st clear out dupes*/
if strings.0>1 then do
do index=1 to strings.0-1
    do index2=index+1 to strings.0
        if strings.index=strings.index2 then
            strings.index=""
    end
end

dupe_pack:
/*2nd pack dupes*/
index=1
do index2=1 to strings.0
    if strings.index2<>"" then do
        strings.index=strings.index2
        index=index+1
    end
end

/*3rd set stem.0 value*/
strings.0=index-1


end /*do*/
return

/*:VRX         PB_31_Click
*/
PB_31_Click: 
    ok = VRSet( "EF_1", "Value", VRFileDialog( VRWindow(), "Template File Selection", "Open", , , ,  ) )
    ok = VRSet( "GB_2", "ForeColor", "<default>" )
return

/*:VRX         PB_31_ContextMenu
*/
PB_31_ContextMenu: 

return

/*:VRX         PB_32_Click
*/
PB_32_Click: 
    ok = VRDestroy( "Usage" )
return
/*:VRX         PB_3_Click
*/
PB_3_Click: 

FileName = VRFileDialog( VRWindow(), "Select a Mail packet", "Open", "*.QWK", , ,  )

if FileName<>"" then do
  FilePath=LEFT(FileName,LastPos("\",Filename)-1)
  ok = VRSet( "EF_3", "Value", FilePath )
  ok = VRSet( "GB_6", "ForeColor", "<default>" )
end

return

/*:VRX         PB_3_ContextMenu
*/
PB_3_ContextMenu: 

return

/*:VRX         PB_4_Click
*/
PB_4_Click: 
    ok = VRSet( "EF_17", "Value", VRFileDialog( VRWindow(), "F4 Key selection", "Open", , , ,  ) )
return

/*:VRX         PB_5_Click
*/
PB_5_Click: 
    ok = VRSet( "EF_18", "Value", VRFileDialog( VRWindow(), "F5 Key selection", "Open", , , ,  ) )

return

/*:VRX         PB_6_Click
*/
PB_6_Click: 
    ok = VRSet( "EF_19", "Value", VRFileDialog( VRWindow(), "F6 Key selection", "Open", , , ,  ) )
return

/*:VRX         PB_9_Click
*/
PB_9_Click: 

FileName = VRFileDialog( VRWindow(), "Select a REP packet", "Open", "*.REP", , ,  )

if FileName<>"" then do
  FilePath=LEFT(FileName,LastPos("\",Filename)-1)
  ok = VRSet( "EF_6", "Value", FilePath )
  ok = VRSet( "GB_10", "ForeColor", "<default>" )
end

return

/*:VRX         PB_9_ContextMenu
*/
PB_9_ContextMenu: 

return

/*:VRX         Prompt_Cancel_Click
*/
Prompt_Cancel_Click: 
ok = VRDestroy( "Prompt" )
return

/*:VRX         Prompt_Close
*/
Prompt_Close: 
    call Prompt_Fini
return

/*:VRX         Prompt_Create
*/
Prompt_Create: 
    call Prompt_Init
ok = VRSet( "Prompt", "Caption", PromptCaption )
ok = VRSet( "Prompt_Text", "Caption", PromptTextCaption )
ok = VRSet( "Prompt_EntryField", "Value", Prompt_EntryField_Value )

ok = VRSet( "Prompt_EntryField", "SelectedStart", 1 )
ok = VRSet( "Prompt_EntryField", "SelectedEnd", length(Prompt_EntryField_Value)+1 )

return

/*:VRX         Prompt_Fini
*/
Prompt_Fini: 
    window = VRInfo( "Window" )
    call VRDestroy window
    drop window
return
/*:VRX         Prompt_Init
*/
Prompt_Init: 
    window = VRInfo( "Object" )
    if( \VRIsChildOf( window, "Notebook" ) ) then do
        call VRMethod window, "CenterWindow"
        call VRSet window, "Visible", 1
        call VRMethod window, "Activate"
    end
    drop window
return

/*:VRX         Prompt_OK_Click
*/
Prompt_OK_Click: 
    value = VRGet( "Prompt_EntryField", "Value" )
    ok = VRDestroy( "Prompt" )
return
/*:VRX         Quit
*/
Quit:
    window = VRWindow()
    call VRSet window, "Shutdown", 1
    drop window
return

/*:VRX         Quoting_Close
*/
Quoting_Close: 
    call Quoting_Fini
return

/*:VRX         Quoting_Create
*/
Quoting_Create: 
    call Quoting_Init
return

/*:VRX         Quoting_Fini
*/
Quoting_Fini: 
    window = VRInfo( "Window" )
    call VRDestroy window
    drop window
return
/*:VRX         Quoting_Init
*/
Quoting_Init: 
    window = VRInfo( "Object" )
    if( \VRIsChildOf( window, "Notebook" ) ) then do
        call VRMethod window, "CenterWindow"
        call VRSet window, "Visible", 1
        call VRMethod window, "Activate"
    end
    drop window
return

/*:VRX         RB_10_Click
*/
RB_10_Click: 
ok = VRSet( "GB_29", "ForeColor", "<default>" )
return

/*:VRX         RB_10_ContextMenu
*/
RB_10_ContextMenu: 

return

/*:VRX         RB_11_Click
*/
RB_11_Click: 
ok = VRSet( "GB_19", "ForeColor", "<default>" )
return

/*:VRX         RB_11_ContextMenu
*/
RB_11_ContextMenu: 

return

/*:VRX         RB_12_Click
*/
RB_12_Click: 
ok = VRSet( "GB_19", "ForeColor", "<default>" )
return

/*:VRX         RB_12_ContextMenu
*/
RB_12_ContextMenu: 

return

/*:VRX         RB_13_Click
*/
RB_13_Click: 
ok = VRSet( "GB_19", "ForeColor", "<default>" )

return

/*:VRX         RB_13_ContextMenu
*/
RB_13_ContextMenu: 

return

/*:VRX         RB_14_Click
*/
RB_14_Click: 
ok = VRSet( "GB_20", "ForeColor", "<default>" )
ok = VRSet( "GB_27", "ForeColor", "<default>" )
return

/*:VRX         RB_14_ContextMenu
*/
RB_14_ContextMenu: 

return

/*:VRX         RB_15_Click
*/
RB_15_Click: 
ok = VRSet( "GB_20", "ForeColor", "<default>" )
ok = VRSet( "GB_27", "ForeColor", "DarkGray" )
return

/*:VRX         RB_15_ContextMenu
*/
RB_15_ContextMenu: 

return

/*:VRX         RB_16_Click
*/
RB_16_Click: 
ok = VRSet( "GB_20", "ForeColor", "<default>" )
ok = VRSet( "GB_27", "ForeColor", "<default>" )

return

/*:VRX         RB_16_ContextMenu
*/
RB_16_ContextMenu: 

return

/*:VRX         RB_17_Click
*/
RB_17_Click: 
    ok = VRSet( "GB_21", "ForeColor", "<default>" )
return

/*:VRX         RB_17_ContextMenu
*/
RB_17_ContextMenu: 

return

/*:VRX         RB_18_Click
*/
RB_18_Click: 
    ok = VRSet( "GB_21", "ForeColor", "<default>" )
return

/*:VRX         RB_18_ContextMenu
*/
RB_18_ContextMenu: 

return

/*:VRX         RB_19_Click
*/
RB_19_Click: 
    ok = VRSet( "GB_21", "ForeColor", "<default>" )
return

/*:VRX         RB_19_ContextMenu
*/
RB_19_ContextMenu: 

return

/*:VRX         RB_1_Click
*/
RB_1_Click: 
ok = VRSet( "GB_8", "ForeColor", "<default>" )

return

/*:VRX         RB_1_ContextMenu
*/
RB_1_ContextMenu: 

return

/*:VRX         RB_20_Click
*/
RB_20_Click: 
ok = VRSet( "GB_23", "ForeColor", "<default>" )
return

/*:VRX         RB_20_ContextMenu
*/
RB_20_ContextMenu: 

return

/*:VRX         RB_21_Click
*/
RB_21_Click: 
ok = VRSet( "GB_23", "ForeColor", "<default>" )

return

/*:VRX         RB_21_ContextMenu
*/
RB_21_ContextMenu: 

return

/*:VRX         RB_22_Click
*/
RB_22_Click: 
ok = VRSet( "GB_25", "ForeColor", "<default>" )
return

/*:VRX         RB_22_ContextMenu
*/
RB_22_ContextMenu: 

return

/*:VRX         RB_23_Click
*/
RB_23_Click: 
ok = VRSet( "GB_25", "ForeColor", "<default>" )

return

/*:VRX         RB_23_ContextMenu
*/
RB_23_ContextMenu: 

return

/*:VRX         RB_24_Click
*/
RB_24_Click: 
ok = VRSet( "GB_26", "ForeColor", "<default>" )
return

/*:VRX         RB_24_ContextMenu
*/
RB_24_ContextMenu: 

return

/*:VRX         RB_25_Click
*/
RB_25_Click: 
ok = VRSet( "GB_26", "ForeColor", "<default>" )

return

/*:VRX         RB_25_ContextMenu
*/
RB_25_ContextMenu: 

return

/*:VRX         RB_26_Click
*/
RB_26_Click: 
ok = VRSet( "GB_28", "ForeColor", "<default>" )

return

/*:VRX         RB_26_ContextMenu
*/
RB_26_ContextMenu: 

return

/*:VRX         RB_27_Click
*/
RB_27_Click: 
ok = VRSet( "GB_20", "ForeColor", "<default>" )
ok = VRSet( "GB_27", "ForeColor", "<default>" )
return

/*:VRX         RB_27_ContextMenu
*/
RB_27_ContextMenu: 

return

/*:VRX         RB_28_Click
*/
RB_28_Click: 
ok = VRSet( "GB_20", "ForeColor", "<default>" )
ok = VRSet( "GB_27", "ForeColor", "<default>" )
return

/*:VRX         RB_28_ContextMenu
*/
RB_28_ContextMenu: 

return

/*:VRX         RB_29_Click
*/
RB_29_Click: 
ok = VRSet( "GB_28", "ForeColor", "<default>" )
return

/*:VRX         RB_29_ContextMenu
*/
RB_29_ContextMenu: 

return

/*:VRX         RB_2_Click
*/
RB_2_Click: 
ok = VRSet( "GB_8", "ForeColor", "<default>" )
return

/*:VRX         RB_2_ContextMenu
*/
RB_2_ContextMenu: 

return

/*:VRX         RB_30_Click
*/
RB_30_Click: 
ok = VRSet( "GB_29", "ForeColor", "<default>" )

return

/*:VRX         RB_30_ContextMenu
*/
RB_30_ContextMenu: 

return

/*:VRX         RB_31_Click
*/
RB_31_Click: 
    ok = VRSet( "GB_35", "ForeColor", "<default>" )
return

/*:VRX         RB_31_ContextMenu
*/
RB_31_ContextMenu: 

return

/*:VRX         RB_32_Click
*/
RB_32_Click: 
    ok = VRSet( "GB_35", "ForeColor", "<default>" )
return

/*:VRX         RB_32_ContextMenu
*/
RB_32_ContextMenu: 

return

/*:VRX         RB_33_Click
*/
RB_33_Click: 
    ok = VRSet( "GB_34", "ForeColor", "<default>" )
return

/*:VRX         RB_33_ContextMenu
*/
RB_33_ContextMenu: 

return

/*:VRX         RB_34_Click
*/
RB_34_Click: 
    ok = VRSet( "GB_34", "ForeColor", "<default>" )
return

/*:VRX         RB_34_ContextMenu
*/
RB_34_ContextMenu: 

return

/*:VRX         RB_35_Click
*/
RB_35_Click: 
    ok = VRSet( "GB_37", "ForeColor", "<default>" )
return

/*:VRX         RB_35_ContextMenu
*/
RB_35_ContextMenu: 

return

/*:VRX         RB_36_Click
*/
RB_36_Click: 
    ok = VRSet( "GB_37", "ForeColor", "<default>" )
return

/*:VRX         RB_36_ContextMenu
*/
RB_36_ContextMenu: 

return

/*:VRX         RB_37_Click
*/
RB_37_Click: 
    ok = VRSet( "GB_38", "ForeColor", "<default>" )
return

/*:VRX         RB_37_ContextMenu
*/
RB_37_ContextMenu: 

return

/*:VRX         RB_38_Click
*/
RB_38_Click: 
    ok = VRSet( "GB_38", "ForeColor", "<default>" )
return

/*:VRX         RB_38_ContextMenu
*/
RB_38_ContextMenu: 

return

/*:VRX         RB_39_Click
*/
RB_39_Click: 
    ok = VRSet( "GB_4", "ForeColor", "<default>" )
return

/*:VRX         RB_39_ContextMenu
*/
RB_39_ContextMenu: 

return

/*:VRX         RB_3_Click
*/
RB_3_Click: 
    ok = VRSet( "GB_14", "ForeColor", "<default>" )
return

/*:VRX         RB_3_ContextMenu
*/
RB_3_ContextMenu: 

return

/*:VRX         RB_40_Click
*/
RB_40_Click: 
    ok = VRSet( "GB_4", "ForeColor", "<default>" )
return

/*:VRX         RB_40_ContextMenu
*/
RB_40_ContextMenu: 

return

/*:VRX         RB_41_Click
*/
RB_41_Click: 
    ok = VRSet( "GB_4", "ForeColor", "<default>" )
return

/*:VRX         RB_41_ContextMenu
*/
RB_41_ContextMenu: 

return

/*:VRX         RB_4_Click
*/
RB_4_Click: 
    ok = VRSet( "GB_14", "ForeColor", "<default>" )
return

/*:VRX         RB_4_ContextMenu
*/
RB_4_ContextMenu: 

return

/*:VRX         RB_50_ContextMenu
*/
RB_50_ContextMenu: 

return

/*:VRX         RB_51_ContextMenu
*/
RB_51_ContextMenu: 

return

/*:VRX         RB_52_ContextMenu
*/
RB_52_ContextMenu: 

return

/*:VRX         RB_5_Click
*/
RB_5_Click: 
    ok = VRSet( "GB_14", "ForeColor", "<default>" )
return

/*:VRX         RB_5_ContextMenu
*/
RB_5_ContextMenu: 

return

/*:VRX         RB_6_Click
*/
RB_6_Click: 
    ok = VRSet( "GB_16", "ForeColor", "<default>" )
    ok = VRSet( "GB_15", "ForeColor", "<default>" )
return

/*:VRX         RB_6_ContextMenu
*/
RB_6_ContextMenu: 

return

/*:VRX         RB_7_Click
*/
RB_7_Click: 
    ok = VRSet( "GB_16", "ForeColor", "<default>" )
    ok = VRSet( "GB_15", "ForeColor", "<default>" )
return

/*:VRX         RB_7_ContextMenu
*/
RB_7_ContextMenu: 

return

/*:VRX         RB_8_Click
*/
RB_8_Click: 
ok = VRSet( "GB_8", "ForeColor", "<default>" )
return

/*:VRX         RB_8_ContextMenu
*/
RB_8_ContextMenu: 

return

/*:VRX         RB_9_Click
*/
RB_9_Click: 
ok = VRSet( "GB_29", "ForeColor", "<default>" )
return

/*:VRX         RB_9_ContextMenu
*/
RB_9_ContextMenu: 

return

/*:VRX         ReadIniFile
*/
ReadIniFile: 
Parse arg FileName

/*initialize variables*/
conf.0=0    /*clear virtual conference pointer*/
vc_num=0

do while LINES(FileName)
    line  = LineIn( FileName )
    stripped = Strip( line, "Both", " " )

doit=1  /*assume that there is a variable to be parsed*/

if (Left( stripped, 2) \= "##") & (Left( stripped, 1) = "#") then    /* ignore commented lines*/
  doit=0

if Pos( "=", stripped)=0 then   /*ignore any lines that don't have = signs*/
  doit=0

if doit=1 then do   /*strip out variable and value*/
    if Left( stripped, 2) = "##" then do /* special saved (but not used variables) */
        v_save=1
        variable = Strip(Left(stripped,Pos("=",stripped)-1), "Both", " " )  /* get variable name*/
        variable = right(variable,length(variable)-2)  /*get rid of save comment characters*/
    end
    else do
        v_save=0
        variable = Strip(Left(stripped,Pos("=",stripped)-1), "Both", " " )  /* get variable name*/
    end

    Parse Upper var variable v 
    p = Strip(Right(stripped,Length(stripped)-Pos("=",stripped)), "Both", " " )   /*get parameter*/
end

if (LEFT(v,1)<'A')|(LEFT(v,1)>'Z') then /*only parse variable that start with a letter*/
   doit=0

if doit=1 then do
    select
        when v = "PACKETPATH" then do
            ok = VRSet( "GB_6", "ForeColor", "<default>" )
            ok = VRSet( "EF_3", "Value", p )
        end

        when v = "ZIPPER" then do
            ok = VRSet( "GB_9", "ForeColor", "<default>" )
            ok = VRSet( "EF_5", "Value", p )
        end

        when v = "UNZIPPER" then do
            ok = VRSet( "GB_9", "ForeColor", "<default>" )
            ok = VRSet( "EF_4", "Value", p )            
        end

        when v = "REPLYPATH" then do
            ok = VRSet( "GB_10", "ForeColor", "<default>" )
            ok = VRSet( "EF_6", "Value", p )            
        end

        when v = "EDITOR" then do
            ok = VRSet( "GB_35", "ForeColor", "<default>" )
            Parse Upper var p p 
            if p="INTERNAL" then
                ok = VRSet( "RB_31", "Set", 1 )
            else do
                ok = VRSet( "RB_32", "Set", 1 )
                ok = VRSet( "EF_2", "Value", p )
            end
        end

        when v = "PREEDIT" then do
            ok = VRSet( "GB_37", "ForeColor", "<default>" )
            Parse Upper var p p 
            if p="INTERNAL" then
                ok = VRSet( "RB_36", "Set", 1 )
            else do
                ok = VRSet( "RB_37", "Set", 1 )
                ok = VRSet( "EF_10", "Value", p )
            end
        end

        when v = "POSTEDIT" then do
            ok = VRSet( "GB_38", "ForeColor", "<default>" )
            Parse Upper var p p 
            if p="INTERNAL" then
                ok = VRSet( "RB_38", "Set", 1 )
            else do
                ok = VRSet( "RB_37", "Set", 1 )
                ok = VRSet( "EF_11", "Value", p )
            end
        end


        when v = "FILESPEC" then do
            ok = VRSet( "GB_12", "ForeColor", "<default>" )
            ok = VRSet( "EF_7", "Value", p )            
        end

        when v = "TAGLINE" then do
            ok = VRSet( "GB_16", "ForeColor", "<default>" )
            if LEFT(p,1)="@" then do  /*must be a tagfile*/
                ok = VRSet( "CB_15", "Set", 1 )
                ok = VRSet( "EF_13", "Value", Right(p,Length(p)-1) )
                ok = VRSet( "EF_13", "Visible", 1 )
                ok = VRSet( "EF_9", "Visible", 0 )
            end
            else do
                ok = VRSet( "CB_15", "Set", 0 )
                ok = VRSet( "EF_9", "Value", p )
                ok = VRSet( "EF_13", "Visible", 0 )
                ok = VRSet( "EF_9", "Visible", 1 )
            end
            call UpdateTagline
        end

        when v = "SERIALINTAGLINE" then do
            ok = VRSet( "GB_17", "ForeColor", "<default>" )
            Parse Upper var p p 
            if p="YES" then p=1
            else p=0
            ok = VRSet( "CB_13", "Set", p )
        end

        when v = "SUPPRESSVERSIONINTAGLINE" then do
            ok = VRSet( "GB_17", "ForeColor", "<default>" )
            Parse Upper var p p 
            if p="YES" then p=1
            else p=0
            ok = VRSet( "CB_14", "Set", p )
        end

        when v = "TAGMODE" then do
            ok = VRSet( "GB_15", "ForeColor", "<default>" )
            Parse Upper var p p 
            if p="RANDOM" then p=1
            else p=0
            ok = VRSet( "RB_6", "Set", p )
        end

        when v = "TAGSTYLE" then do
            ok = VRSet( "GB_14", "ForeColor", "<default>" )
            Parse Upper var p p 
            if POS(",",p)>0 then do
                p.1 = Right(p,Length(p)-Pos(",",p))
                if p.1="AUTOSENSE" then
                    ok = VRSet( "CB_12", "Set", 1 )
                else
                    ok = VRSet( "CB_12", "Set", 0 )
                p=LEFT(p,Pos(",",p)-1)
            end
            if p="PCBOARD" then 
                ok = VRSet( "RB_3", "Set", 1 )
            if p="FIDO" then 
                ok = VRSet( "RB_4", "Set", 1 )
            if p="TWOLINE" then 
                ok = VRSet( "RB_5", "Set", 1 )
        end


        when v = "QUOTEBODY" then do
            call VRSet "GB_21", "ForeColor", "<default>"
            Parse Upper var p p 
            if POS(",",p)>0 then do
                p.1 = Right(p,Length(p)-Pos(",",p))
                if p.1="EACHLINE" then
                    ok = VRSet( "RB_17", "Set", 1 )
                if p.1="FIRSTLINE" then
                    ok = VRSet( "RB_18", "Set", 1 )
                if p.1="PARAGRAPH" then
                    ok = VRSet( "RB_19", "Set", 1 )
                p=LEFT(p,Pos(",",p)-1)
            end
            ok = VRSet( "Combo_3", "Value", SUBSTR(p,2,LENGTH(p)-2 ))
        end

        when v = "OLDQUOTEDETECT" then do
            call VRSet "GB_18", "ForeColor", "<default>"
            Parse Upper var p p 
            if p="YES" then p=1
            else p=0
            ok = VRSet( "CB_16", "Set", p )
        end

        when v = "HEADERINQUOTE" then do
            call VRSet "GB_22", "ForeColor", "<default>"
            Parse Upper var p p 
            if p="YES" then p=1
            else p=0
            ok = VRSet( "CB_17", "Set", p )
        end

        when v = "SMARTQUOTING" then do
            call VRSet "GB_20", "ForeColor", "<default>"
            Parse Upper var p p 
            if p="YES" then 
                ok = VRSet( "RB_16", "Set", 1 )
            if p="NO" then 
                ok = VRSet( "RB_15", "Set", 1 )
            if p="FULL" then 
                ok = VRSet( "RB_14", "Set", 1 )
        end

        when v = "REPLYFILE" then do
            call VRSet "GB_13", "ForeColor", "<default>"
            ok = VRSet( "EF_8", "Value", p )
        end

        when v = "HEADEREDITING" then do
            call VRSet "GB_8", "ForeColor", "<default>"
            Parse Upper var p p 
            if p="BEFORE" then 
                ok = VRSet( "RB_1", "Set", 1 )
            if p="AFTER" then 
                ok = VRSet( "RB_2", "Set", 1 )
            if p="BOTH" then 
                ok = VRSet( "RB_8", "Set", 1 )
        end

        when v = "SPLITLONGREPLIES" then do
            call VRSet "GB_23", "ForeColor", "<default>"
            Parse Upper var p p 
            if p="YES" then 
                ok = VRSet( "RB_21", "Set", 1 )
            if p="NO" then 
                ok = VRSet( "RB_20", "Set", 1 )
        end

        when v = "WRAPLINESATCOLUMN" then do
            call VRSet "GB_24", "ForeColor", "<default>"
            ok = VRSet( "SPIN_4", "Value", p )
        end

        when v = "BACKUPOLDREPLIES" then do
            call VRSet "GB_25", "ForeColor", "<default>"
            Parse Upper var p p 
            if p="YES" then 
                ok = VRSet( "RB_23", "Set", 1 )
            if p="NO" then 
                ok = VRSet( "RB_22", "Set", 1 )
        end

        when v = "LOGREPLIES" then do
            call VRSet "GB_26", "ForeColor", "<default>"
            Parse Upper var p p 
            if p="YES" then 
                ok = VRSet( "RB_25", "Set", 1 )
            if p="NO" then 
                ok = VRSet( "RB_24", "Set", 1 )
        end

        when v = "SMARTWRAPPING" then do
            call VRSet "GB_19", "ForeColor", "<default>"
            Parse Upper var p p 
            if p="YES" then 
                ok = VRSet( "RB_13", "Set", 1 )
            if p="NO" then 
                ok = VRSet( "RB_12", "Set", 1 )
            if p="FULL" then 
                ok = VRSet( "RB_11", "Set", 1 )
        end

        when v = "REMOVEREPLYBOOKMARKS" then do
            call VRSet "GB_28", "ForeColor", "<default>"
            Parse Upper var p p 
            if p="NO" then 
                ok = VRSet( "RB_26", "Set", 1 )
            if p="YES" then 
                ok = VRSet( "RB_29", "Set", 1 )
        end

        when v = "REASSEMBLESPLITS" then do
            call VRSET "GB_29", "ForeColor", "<default>"
            Parse Upper var p p 
            if p="ASK" then 
                ok = VRSet( "RB_30", "Set", 1 )
            if p="YES" then 
                ok = VRSet( "RB_10", "Set", 1 )
            if p="NO" then 
                ok = VRSet( "RB_9", "Set", 1 )
        end

        when v = "REPLYSTRIPTAGLINE" then do
            call VRSet "GB_27", "ForeColor", "<default>"
            Parse Upper var p p 
            if p="YES" then 
                ok = VRSet( "RB_28", "Set", 1 )
            if p="NO" then 
                ok = VRSet( "RB_27", "Set", 1 )
        end

        when v = "COLORS" then do
            call VRSet "GB_33", "ForeColor", "<default>"
            call PutColors
        end

        when v = "ATTRIBUTES" then do
            call VRSet "GB_34", "ForeColor", "<default>"
            Parse Upper var p p 
            if p="EXTENDED" then 
                ok = VRSet( "RB_33", "Set", 1 )
            if p="NONE" then 
                ok = VRSet( "RB_34", "Set", 1 )
        end

        when v = "TEMPLATEFILE" then do
            call VRSet "GB_2", "ForeColor", "<default>"
            Parse Upper var p p 
            ok = VRSet( "EF_1", "Value", p )
        end



        when v = "INTERNET" then do
        ok = VRSet( "GB_3", "ForeColor", "<default>" )
            if p=-1 then
                ok = VRSet( "CB_5", "Set", 0 )
            else
                ok = VRSet( "CB_5", "Set", 1 )
            ok = VRSet( "SPIN_1", "Value", p )
        end

        when v = "NETMAIL" then do
        ok = VRSet( "GB_3", "ForeColor", "<default>" )
            if p = -1 then 
                ok = VRSet( "CB_6", "Set", 0 )
            else
                ok = VRSet( "CB_6", "Set", 1 )
            ok = VRSet( "SPIN_2", "Value", p )
        end

        when v = "MAKECONFERENCE" then do
            if v_save=1 then
                p="{"||p||"}"
            position = VRMethod( "LB_3", "AddString", p,  )
            conf.0=conf.0+1            
            vc_num=conf.0
            conf.vc_num=p           /*store the vc name*/
            conf_string.vc_num=""   /*initialize string to null*/
            conf.vc_num.0=0
            conf_hide.vc_num.0=0

            conf_from.vc_num=0
            conf_to.vc_num=0
            conf_body.vc_num=0
            conf_origin.vc_num=0
            conf_subject.vc_num=0

        end

        when v = "CONFERENCES" | v="CONFERENCE" then do

            do while pos(",",p)<>0  /*replace commas with spaces*/
             p= OVERLAY(' ',p,pos(",",p))
            end 

            i=1
            do while length(strip(p))>0
             parse var p conf.vc_num.i p
             i=i+1
            end 

            conf.vc_num.0=i-1
        end

        when v = "STRING" then do
            conf_string.vc_num= p
        end

        when v="CHECK" then do
            do while pos(",",p)<>0  /*replace commas with spaces*/
             p= OVERLAY(' ',p,pos(",",p))
            end 

            do while length(strip(p))>0
                parse upper var p string p
                select
                    when string = "FROM" then do
                        conf_from.vc_num=1
                    end
                    when string = "TO" then do
                        conf_to.vc_num=1
                    end
                    when string = "BODY" then do
                        conf_body.vc_num=1
                    end
                    when string = "ORIGIN" then do
                        conf_origin.vc_num=1
                    end
                    when string = "SUBJECT" then do
                        conf_subject.vc_num=1
                    end
                    otherwise do
                    end
                end
            end 
        end


        when v = "HIDECONFERENCES" then do

            do while pos(",",p)<>0  /*replace commas with spaces*/
             p= OVERLAY(' ',p,pos(",",p))
            end 

            i=1
            do while length(strip(p))>0
             parse var p conf_hide.vc_num.i p
             i=i+1
            end 

            conf_hide.vc_num.0=i-1
        end

        when v = "SHOWEMPTIES" then do
        ok = VRSet( "GB_1", "ForeColor", "<default>" )
            Parse Upper var p p 
            if p="YES" then 
                ok = VRSet( "CB_1", "Set", 1 )
            if p="NO" then 
                ok = VRSet( "CB_1", "Set", 0 )
        end

        when v = "DISPLAYSTATUS" then do
        ok = VRSet( "GB_5", "ForeColor", "<default>" )
            Parse Upper var p p 
            if p="YES" then 
                ok = VRSet( "CB_2", "Set", 1 )
            if p="NO" then 
                ok = VRSet( "CB_2", "Set", 0 )
        end

        when v = "SEPARATERBAR" then do
        ok = VRSet( "GB_11", "ForeColor", "<default>" )
            Parse Upper var p p 
            if p="YES" then 
                ok = VRSet( "CB_3", "Set", 1 )
            if p="NO" then 
                ok = VRSet( "CB_3", "Set", 0 )
        end

        when v = "POSITIONONMATCHLINE" then do
        ok = VRSet( "GB_32", "ForeColor", "<default>" )
            Parse Upper var p p 
            if p="YES" then 
                ok = VRSet( "CB_4", "Set", 1 )
            if p="NO" then 
                ok = VRSet( "CB_4", "Set", 0 )
        end

        when v = "F2" then do
            ok = VRSet( "EF_15", "Value", P )
        end
        when v = "F3" then do
            ok = VRSet( "EF_16", "Value", P )
        end
        when v = "F4" then do
            ok = VRSet( "EF_17", "Value", P )
        end
        when v = "F5" then do
            ok = VRSet( "EF_18", "Value", P )
        end
        when v = "F6" then do
            ok = VRSet( "EF_19", "Value", P )
        end
        when v = "F7" then do
            ok = VRSet( "EF_20", "Value", P )
        end
        when v = "F8" then do
            ok = VRSet( "EF_21", "Value", P )
        end
        when v = "F9" then do
            ok = VRSet( "EF_22", "Value", P )
        end
        when v = "F10" then do
            ok = VRSet( "EF_23", "Value", P )
        end

        when v = "V0" then do
            ok = VRSet( "EF_32", "Value", P )
        end
        when v = "V1" then do
            ok = VRSet( "EF_31", "Value", P )
        end
        when v = "V2" then do
            ok = VRSet( "EF_30", "Value", P )
        end
        when v = "V3" then do
            ok = VRSet( "EF_29", "Value", P )
        end
        when v = "V4" then do
            ok = VRSet( "EF_28", "Value", P )
        end
        when v = "V5" then do
            ok = VRSet( "EF_27", "Value", P )
        end
        when v = "V6" then do
            ok = VRSet( "EF_26", "Value", P )
        end
        when v = "V7" then do
            ok = VRSet( "EF_25", "Value", P )
        end
        when v = "V8" then do
            ok = VRSet( "EF_24", "Value", P )
        end
        when v = "V9" then do
            ok = VRSet( "EF_14", "Value", P )
        end

        when v = "MOUSEMODE" then do
        ok = VRSet( "GB_4", "ForeColor", "<default>" )
        Parse Upper var p p 
        select
            when p = "DOUBLECLICK" then do
                ok = VRSet( "RB_39", "Set", 1 )
            end
            when p = "SINGLECLICK" then do
                ok = VRSet( "RB_40", "Set", 1 )
            end
            when p = "OFF" then do
                ok = VRSet( "RB_41", "Set", 1 )
            end
            otherwise do
            end
        end /* select */
        end

        when v = "MOUSECLICKSPEED" then do
        ok = VRSet( "GB_39", "ForeColor", "<default>" )
        ok = VRSet( "Spin_3", "Value", p )
        end

        when v = "MOUSESCROLLSPEED" then do
        ok = VRSet( "GB_40", "ForeColor", "<default>" )
        ok = VRSet( "Spin_7", "Value", p )
        end

        when v = "VIDEOMODE" then do
        ok = VRSet( "GB_44", "ForeColor", "<default>" )
        ok = VRSet( "SPIN_5", "Value", p )
        end

        when v = "CURSORSIZE" then do
            ok = VRSet( "GB_43", "ForeColor", "<default>" )
            ok = VRSet( "SPIN_6", "Value", p )
        end

        when v = "BEEPONPERSONALS" then do
            ok = VRSet( "GB_42", "ForeColor", "<default>" )
            ok = VRSet( "CB_18", "Set", 1 )
        end

        when v = "PACKETSORT" then do
        Parse Upper var p p  
        ok = VRSet( "GB_58", "ForeColor", "<default>" )
          select
            when p = "NAME" then do
                ok = VRSet( "RB_50", "Set", 1 )
            end
            when p = "DTIME_DDATE" then do
                ok = VRSet( "RB_51", "Set", 1 )
            end
            when p = "ATIME_DDATE" then do
                ok = VRSet( "RB_52", "Set", 1 )
            end
            otherwise do
            end
          end /* select */
        end

        when v = "FILEVIEWER" then do
            ok = VRSet( "EF_35", "Value", P )
        end

        when v = "MESSAGEORDER" then do
        Parse Upper var p p 
        ok = VRSet( "GB_50", "ForeColor", "<default>" )
          select
            when p = "MESSAGENUMBER" then do
                ok = VRSet( "RB_42", "Set", 1 )
            end
            when p = "SUBJECT" then do
                ok = VRSet( "RB_43", "Set", 1 )
            end
            when p = "FROM" then do
                ok = VRSet( "RB_44", "Set", 1 )
            end
            when p = "TO" then do
                ok = VRSet( "RB_45", "Set", 1 )
            end
            when p = "DATETIME" then do
                ok = VRSet( "RB_53", "Set", 1 )
            end
            otherwise do
            end
          end /* select */
        end

/*
FolderOrder
SaveFile
ShowBBSID
SkipReadMessages
AllUpperCase
SortMasterConferences
GoToLastRead
ShowReadPercent
AutoUnpack
#AutoFirstKey
PacketRefresh
SavePointerFiles
#V0
#V1
FolderPath
PurgeAfterCount
PurgeAfterDays
#DoorName
KeepMessageMarks
ExitAtEndOfParameters
#ThreadChangeTone
#NewMessageEditor
#BackDropMaxLines
*/
        otherwise do
            ok = VRMethod( "MLE_6", "Insert", variable || "=" || p || "0d0a"x )
        end
     end

end


end

/*end of reading file*/

/*set selected virtual conference to first item*/ 
if vc_num>0 then do
    ok = VRSet( "LB_3", "Selected", 1 )
    ok = VRMethod( "LB_3", "PostEvent", "Click" )
end


 ok=Stream(FileName,'c','close')

return

/*:VRX         Reply_Close
*/
Reply_Close: 
    call Reply_Fini
return

/*:VRX         Reply_Create
*/
Reply_Create: 
    call Reply_Init
return

/*:VRX         Reply_Fini
*/
Reply_Fini: 
    window = VRInfo( "Window" )
    call VRDestroy window
    drop window
return
/*:VRX         Reply_Init
*/
Reply_Init: 
    window = VRInfo( "Object" )
    if( \VRIsChildOf( window, "Notebook" ) ) then do
        call VRMethod window, "CenterWindow"
        call VRSet window, "Visible", 1
        call VRMethod window, "Activate"
    end
    drop window
return

/*:VRX         setcolor
*/
setcolor: 

/*this routine just returns the color name of a numbered */
/* color between 1-16*/

parse arg c  /* get number*/

select
    when c = 1 then n="Black"
    when c = 2 then n="DarkBlue"
    when c = 3 then n="DarkGreen"
    when c = 4 then n="DarkCyan"
    when c = 5 then n="DarkRed"
    when c = 6 then n="DarkPink"
    when c = 7 then n="Brown"
    when c = 8 then n="PaleGray"
    when c = 9 then n="DarkGray"
    when c = 10 then n="Blue"
    when c = 11 then n="Green"
    when c = 12 then n="Cyan"
    when c = 13 then n="Red"
    when c = 14 then n="Pink"
    when c = 15 then n="Yellow"
    when c = 16 then n="White"
    otherwise n="BLACK"
 end

return n

/*:VRX         Settings_Close
*/
Settings_Close: 
    call SW1_Fini
return

/*:VRX         Settings_Fini
*/
Settings_Fini: 
    window = VRInfo( "Window" )
    call VRDestroy window
    drop window
return
/*:VRX         Settings_Init
*/
Settings_Init: 
    window = VRInfo( "Object" )
    if( \VRIsChildOf( window, "Notebook" ) ) then do
        call VRMethod window, "CenterWindow"
        call VRSet window, "Visible", 1
        call VRMethod window, "Activate"
    end
    drop window
return

/*:VRX         SPIN_1_Change
*/
SPIN_1_Change: 
 ok = VRSet( "GB_3", "ForeColor", "<default>" ) 
if VRGet( "SPIN_1", "Value" )=-1 then do
    ok = VRSet( "CB_5", "Set", 0 )
end
else do
    ok = VRSet( "CB_5", "Set", 1 )
end

return

/*:VRX         SPIN_1_ContextMenu
*/
SPIN_1_ContextMenu: 

return

/*:VRX         SPIN_2_Change
*/
SPIN_2_Change: 
 ok = VRSet( "GB_3", "ForeColor", "<default>" ) 
if VRGet( "SPIN_2", "Value" )=-1 then do
    ok = VRSet( "CB_6", "Set", 0 )
end
else do
    ok = VRSet( "CB_6", "Set", 1 )
end

return

/*:VRX         SPIN_2_ContextMenu
*/
SPIN_2_ContextMenu: 

return

/*:VRX         SPIN_3_Change
*/
SPIN_3_Change: 
ok = VRSet( "GB_39", "ForeColor", "<default>" )

return

/*:VRX         SPIN_3_ContextMenu
*/
SPIN_3_ContextMenu: 

return

/*:VRX         SPIN_4_Change
*/
SPIN_4_Change: 
ok = VRSet( "GB_24", "ForeColor", "<default>" )

return

/*:VRX         SPIN_4_ContextMenu
*/
SPIN_4_ContextMenu: 

return

/*:VRX         SPIN_5_Change
*/
SPIN_5_Change: 
ok = VRSet( "GB_44", "ForeColor", "<default>" )

return

/*:VRX         SPIN_5_ContextMenu
*/
SPIN_5_ContextMenu: 

return

/*:VRX         SPIN_6_Change
*/
SPIN_6_Change: 
ok = VRSet( "GB_43", "ForeColor", "<default>" )

return

/*:VRX         SPIN_6_ContextMenu
*/
SPIN_6_ContextMenu: 

return

/*:VRX         SPIN_7_Change
*/
SPIN_7_Change: 
ok = VRSet( "GB_40", "ForeColor", "<default>" )

return

/*:VRX         SPIN_7_ContextMenu
*/
SPIN_7_ContextMenu: 

return

/*:VRX         Tagline_Close
*/
Tagline_Close: 
    call Tagline_Fini
return

/*:VRX         Tagline_Create
*/
Tagline_Create: 
    call Tagline_Init
    call UpdateTagline
return

/*:VRX         Tagline_Fini
*/
Tagline_Fini: 
    window = VRInfo( "Window" )
    call VRDestroy window
    drop window
return
/*:VRX         Tagline_Init
*/
Tagline_Init: 
    window = VRInfo( "Object" )
    if( \VRIsChildOf( window, "Notebook" ) ) then do
        call VRMethod window, "CenterWindow"
        call VRSet window, "Visible", 1
        call VRMethod window, "Activate"
    end
    drop window
return

/*:VRX         Templates_Close
*/
Templates_Close: 
    call Templates_Fini
return

/*:VRX         Templates_Create
*/
Templates_Create: 
    call Templates_Init
return

/*:VRX         Templates_Fini
*/
Templates_Fini: 
    window = VRInfo( "Window" )
    call VRDestroy window
    drop window
return
/*:VRX         Templates_Init
*/
Templates_Init: 
    window = VRInfo( "Object" )
    if( \VRIsChildOf( window, "Notebook" ) ) then do
        call VRMethod window, "CenterWindow"
        call VRSet window, "Visible", 1
        call VRMethod window, "Activate"
    end
    drop window
return

/*:VRX         ToggleGroup
*/
ToggleGroup: 
if VRGET( VRInfo("Source"), "ForeColor") = "<default>" then
  call VRSET VRInfo("Source"), "ForeColor", DarkGray
else
  call VRSET VRInfo("Source"), "ForeColor", "<default>"

return 0

/*:VRX         UpdateTagline
*/
UpdateTagline: 

if VRGet( "CB_15", "Set" )=1 then do
    ok = VRSet( "DT_4", "Caption", "Tag Line File" )    
    ok = VRSet( "PB_10", "Visible", 1 ) 
    ok = VRSet( "EF_13", "Visible", 1 )
    ok = VRSet( "EF_9", "Visible", 0 )
end
else do
    ok = VRSet( "DT_4", "Caption", "Fixed Tag Line" )    
    ok = VRSet( "PB_10", "Visible", 0 )    
    ok = VRSet( "EF_13", "Visible", 0 )
    ok = VRSet( "EF_9", "Visible", 1 )
end

return

/*:VRX         Usage_Close
*/
Usage_Close: 
    call Usage_Fini
return

/*:VRX         Usage_Create
*/
Usage_Create: 
    call Usage_Init
return

/*:VRX         Usage_Fini
*/
Usage_Fini: 
    window = VRInfo( "Window" )
    call VRDestroy window
    drop window
return
/*:VRX         Usage_Init
*/
Usage_Init: 
    window = VRInfo( "Object" )
    if( \VRIsChildOf( window, "Notebook" ) ) then do
        call VRMethod window, "CenterWindow"
        call VRSet window, "Visible", 1
        call VRMethod window, "Activate"
    end
    drop window
return

/*:VRX         VS_1_DragStart
*/
VS_1_DragStart: 
    SourceDragColor = 'ForeColor'
    dropdest = VRMethod( "VS_1", "StartDrag", , , , , , , ,VRInfo(SourceIndex) ,  )
return

/*:VRX         VS_3_DragStart
*/
VS_3_DragStart: 

SourceDragColor='BackColor'

dropdest = VRMethod( "VS_3", "StartDrag", , , , , , , ,VRInfo(SourceIndex) ,  )

return

/*:VRX         Window1_Close
*/
Window1_Close:
    call Quit
return

/*:VRX         Window1_Create
*/
Window1_Create: 
    ok = VRSet( "Window1", "Caption", "MIM/2 - Ver" Version_Number )
    call Update_FileMenu_Bar        /*Update FileNames on menubar*/
return

/*:VRX         writeinifile
*/
writeinifile: 

parse arg FileName

id = 1  /*Assume overwrite*/

if VRFileExists( FileName ) then do
    Buttons.1 = "Overwrite"
    Buttons.2 = "Backup"
    Buttons.3 = "Cancel"
    Buttons.0 = 3
    id = VRMessage( VRWindow(), "Are you sure you want to overwite " FileName "?", "OverWrite File", "Warning", "Buttons.", 1, 3 )
end

if id=2 then do                 /*backup old file*/
    'copy ' FileName '*.BAK'    /*make the backup file*/
    'del ' FileName             /*delete the old file*/
    id=1                        /*now save the new file*/
end

if id=1 then do     /*check if the user hit the cancel key (then skip writing)*/

/*start writing*/
if VRFileExists( FileName ) then
  'del ' FileName
/*This list is presented in the order that items appear in the MR/2 INI file*/

/*BASIC*/
if VRGet( "GB_6", "ForeColor" )="<default>" then
    count  = LineOut( FileName,"PacketPath=" VRGet( "EF_3", "Value" ))

if VRGet( "GB_9", "ForeColor" )="<default>" then do
    count  = LineOut( FileName,"Zipper=" VRGet( "EF_5", "Value" ))
    count  = LineOut( FileName,"UnZipper=" VRGet( "EF_4", "Value" ))
end

if VRGet( "GB_10", "ForeColor" )="<default>" then
    count  = LineOut( FileName,"ReplyPath=" VRGet( "EF_6", "Value" ))

if VRGet( "GB_12", "ForeColor" )="<default>" then
    count  = LineOut( FileName,"FileSpec=" VRGet( "EF_7", "Value" ))

if VRGet( "GB_58", "ForeColor" )="<default>" then do
select
    when VRGet( "RB_50", "Set" ) = 1 then do
        count  = LineOut( FileName,'PacketSort=Name')
    end
    when VRGet( "RB_51", "Set" ) = 1 then do
        count  = LineOut( FileName,'PacketSort=DTime_DDate')
    end
    when VRGet( "RB_52", "Set" ) = 1 then do
        count  = LineOut( FileName,'PacketSort=ATime_DDate')
    end
    otherwise do
    end
 end
end

if VRGet( "GB_59", "ForeColor" )="<default>" then
    count  = LineOut( FileName,"FileViewer=" VRGet( "EF_35", "Value" ))


/*MESSAGES PAGE*/

if VRGet( "GB_50", "ForeColor" )="<default>" then do
 select
    when VRGet( "RB_42", "Set" ) = 1 then do
        count  = LineOut( FileName,'MessageOrder=MessageNumber')
    end
    when VRGet( "RB_43", "Set" ) = 1 then do
        count  = LineOut( FileName,'MessageOrder=Subject')
    end
    when VRGet( "RB_44", "Set" ) = 1 then do
        count  = LineOut( FileName,'MessageOrder=From')
    end
    when VRGet( "RB_45", "Set" ) = 1 then do
        count  = LineOut( FileName,'MessageOrder=To')
    end
    when VRGet( "RB_53", "Set" ) = 1 then do
        count  = LineOut( FileName,'MessageOrder=DateTime')
    end
    otherwise do
    end
 end
end




/*Editor*/
if VRGet( "GB_35", "ForeColor" )="<default>" then do
    if VRGet( "RB_31", "Set" ) = 1 then
        count  = LineOut( FileName,"Editor=Internal" )
    else
        count  = LineOut( FileName,"Editor=" VRGet( "EF_7", "Value" ))
end

if VRGet( "GB_37", "ForeColor" )="<default>" then 
    if VRGet( "RB_36", "Set" ) = 1 then
        count  = LineOut( FileName,'PreEdit=Internal')   
    else
        count  = LineOut( FileName,'PreEdit=' VRGet( "EF_10", "Value" ))   
    
if VRGet( "GB_38", "ForeColor" )="<default>" then 
    if VRGet( "RB_38", "Set" ) = 1 then
        count  = LineOut( FileName,'PostEdit=Internal')   
    else
        count  = LineOut( FileName,'PostEdit=' VRGet( "EF_11", "Value" ))   

if VRGet( "GB_34", "ForeColor" )="<default>" then 
    if VRGet( "RB_33", "Set" ) = 1 then
        count  = LineOut( FileName,'Attributes=Extended')   
    else
        count  = LineOut( FileName,'Attributes=NONE')   

/*Equipment*/
if VRGet( "GB_4", "ForeColor" )="<default>" then do
select
    when VRGet( "RB_39", "Set" ) = 1 then do
        count  = LineOut( FileName,'MouseMode=DoubleClick')
    end
    when VRGet( "RB_40", "Set" ) = 1 then do
        count  = LineOut( FileName,'MouseMode=SingleClick')
    end
    when VRGet( "RB_41", "Set" ) = 1 then do
        count  = LineOut( FileName,'MouseMode=Off')
    end
    otherwise do
    end
 end
end

if VRGet( "GB_39", "ForeColor" )="<default>" then do
   count  = LineOut( FileName,'MouseClickSpeed='||VRGet( "SPIN_3", "Value" ))
end

if VRGet( "GB_40", "ForeColor" )="<default>" then do
   count  = LineOut( FileName,'MouseScrollSpeed='||VRGet( "SPIN_7", "Value" ))
end

if VRGet( "GB_44", "ForeColor" )="<default>" then do
   count  = LineOut( FileName,'VideoMode='||VRGet( "SPIN_5", "Value" ))
end

if VRGet( "GB_43", "ForeColor" )="<default>" then do
   count  = LineOut( FileName,'CursorSize='||VRGet( "SPIN_6", "Value" ))
end

if VRGet( "GB_42", "ForeColor" )="<default>" then 
  if VRGet( "CB_18", "Set" )=1 then
     count  = LineOut( FileName,'BeepOnPersonals=1')
  else
     count  = LineOut( FileName,'BeepOnPersonals=0')

/* F Keys */
if VRGet( "EF_15", "Value" )<>"" then
     count  = LineOut( FileName,'F2='||VRGet( "EF_15", "Value" ))
if VRGet( "EF_16", "Value" )<>"" then
     count  = LineOut( FileName,'F2='||VRGet( "EF_16", "Value" ))
if VRGet( "EF_17", "Value" )<>"" then
     count  = LineOut( FileName,'F2='||VRGet( "EF_17", "Value" ))
if VRGet( "EF_18", "Value" )<>"" then
     count  = LineOut( FileName,'F2='||VRGet( "EF_18", "Value" ))
if VRGet( "EF_19", "Value" )<>"" then
     count  = LineOut( FileName,'F2='||VRGet( "EF_19", "Value" ))
if VRGet( "EF_20", "Value" )<>"" then
     count  = LineOut( FileName,'F2='||VRGet( "EF_20", "Value" ))
if VRGet( "EF_21", "Value" )<>"" then
     count  = LineOut( FileName,'F2='||VRGet( "EF_21", "Value" ))
if VRGet( "EF_22", "Value" )<>"" then
     count  = LineOut( FileName,'F2='||VRGet( "EF_22", "Value" ))
if VRGet( "EF_23", "Value" )<>"" then
     count  = LineOut( FileName,'F2='||VRGet( "EF_23", "Value" ))

/* Template Page */
if VRGet( "EF_32", "Value" )<>"" then
     count  = LineOut( FileName,'V0='||VRGet( "EF_32", "Value" ))
if VRGet( "EF_31", "Value" )<>"" then
     count  = LineOut( FileName,'V1='||VRGet( "EF_31", "Value" ))
if VRGet( "EF_30", "Value" )<>"" then
     count  = LineOut( FileName,'V2='||VRGet( "EF_30", "Value" ))
if VRGet( "EF_29", "Value" )<>"" then
     count  = LineOut( FileName,'V3='||VRGet( "EF_29", "Value" ))
if VRGet( "EF_28", "Value" )<>"" then
     count  = LineOut( FileName,'V4='||VRGet( "EF_28", "Value" ))
if VRGet( "EF_27", "Value" )<>"" then
     count  = LineOut( FileName,'V5='||VRGet( "EF_27", "Value" ))
if VRGet( "EF_26", "Value" )<>"" then
     count  = LineOut( FileName,'V6='||VRGet( "EF_26", "Value" ))
if VRGet( "EF_25", "Value" )<>"" then
     count  = LineOut( FileName,'V7='||VRGet( "EF_25", "Value" ))
if VRGet( "EF_24", "Value" )<>"" then
     count  = LineOut( FileName,'V8='||VRGet( "EF_24", "Value" ))
if VRGet( "EF_14", "Value" )<>"" then
     count  = LineOut( FileName,'V9='||VRGet( "EF_14", "Value" ))
if VRGet( "GB_2", "ForeColor" )="<default>" then
     count  = LineOut( FileName,'TemplateFile='||VRGet( "EF_1", "Value" ))





/*Quoting*/
if VRGet( "GB_21", "ForeColor" )="<default>" then do
    if VRGet( "RB_17", "Set" ) then
      count  = LineOut( FileName,'QuoteBody="' || VRGet( "Combo_3", "Value" ) || '",EachLine' )
    if VRGet( "RB_18", "Set" ) then
      count  = LineOut( FileName,'QuoteBody="' || VRGet( "Combo_3", "Value" ) || '",FirstLine' ) 
    if VRGet( "RB_19", "Set" ) then
      count  = LineOut( FileName,'QuoteBody="' || VRGet( "Combo_3", "Value" ) || '",Paragraph' ) 
end    

if VRGet( "GB_18", "ForeColor" )="<default>" then do
    if VRGet( "CB_16", "Set" ) = 1 then
        count  = LineOut( FileName,'OldQuoteDetect=Yes')
    else
        count  = LineOut( FileName,'OldQuoteDetect=No')
end

if VRGet( "GB_22", "ForeColor" )="<default>" then do
    if VRGet( "CB_17", "Set" ) = 1 then
        count  = LineOut( FileName,'HeaderInQuote=Yes')
    else
        count  = LineOut( FileName,'HeaderInQuote=No')
end

if VRGet( "GB_20", "ForeColor" )="<default>" then do
select
    when VRGet( "RB_16", "Set" ) = 1 then do
        count  = LineOut( FileName,'SmartQuoting=Yes' )
    end
    when VRGet( "RB_15", "Set" ) = 1 then do
        count  = LineOut( FileName,'SmartQuoting=No')
    end
    when VRGet( "RB_14", "Set" ) = 1 then do
        count  = LineOut( FileName,'SmartQuoting=Full')
    end
    otherwise do  /*must have been selected with no button pressed*/
    end
 end
end

if VRGet( "GB_27", "ForeColor" )="<default>" then do
    if VRGet( "RB_28", "Set" ) = 1 then
        count  = LineOut( FileName,'ReplyStripTagline=Yes')
    else
        count  = LineOut( FileName,'ReplyStripTagline=No')
end

/*REPLY*/
if VRGet( "GB_13", "ForeColor" )="<default>" then
    count  = LineOut( FileName,"ReplyFile=" VRGet( "EF_8", "Value" ))

if VRGet( "GB_8", "ForeColor" )="<default>" then do
    if VRGet( "RB_1", "Set" ) then    
        count  = LineOut( FileName,"HeaderEditing=Before" )
    if VRGet( "RB_2", "Set" ) then    
        count  = LineOut( FileName,"HeaderEditing=After" )
    if VRGet( "RB_8", "Set" ) then    
        count  = LineOut( FileName,"HeaderEditing=Both" )
end

if VRGet( "GB_25", "ForeColor" )="<default>" then do
    if VRGet( "RB_23", "Set" ) = 1 then
        count  = LineOut( FileName,'BackupOldReplies=Yes')
    else
        count  = LineOut( FileName,'BackupOldReplies=No')
end

if VRGet( "GB_26", "ForeColor" )="<default>" then do
    if VRGet( "RB_25", "Set" ) = 1 then
        count  = LineOut( FileName,'LogReplies=Yes')
    else
        count  = LineOut( FileName,'LogReplies=No')
end

if VRGet( "GB_29", "ForeColor" )="<default>" then do
select
    when VRGet( "RB_30", "Set" ) = 1 then do
        count  = LineOut( FileName,'ReassembleSplits=Ask' )
    end
    when VRGet( "RB_10", "Set" ) = 1 then do
        count  = LineOut( FileName,'ReassembleSplits=Yes')
    end
    when VRGet( "RB_9", "Set" ) = 1 then do
        count  = LineOut( FileName,'ReassembleSplits=No')
    end
    otherwise do  /*must have been selected with no button pressed*/
    end
 end
end

if VRGet( "GB_19", "ForeColor" )="<default>" then do
select
    when VRGet( "RB_13", "Set" ) = 1 then do
        count  = LineOut( FileName,'SmartWrapping=Yes' )
    end
    when VRGet( "RB_12", "Set" ) = 1 then do
        count  = LineOut( FileName,'SmartWrapping=No')
    end
    when VRGet( "RB_11", "Set" ) = 1 then do
        count  = LineOut( FileName,'SmartWrapping=Full')
    end
    otherwise do  /*must have been selected with no button pressed*/
    end
 end
end

if VRGet( "GB_24", "ForeColor" )="<default>" then do
    count  = LineOut( FileName,'WrapLinesAtColumn=' VRGet( "SPIN_4", "Value" ))
end

if VRGet( "GB_28", "ForeColor" )="<default>" then do
    if VRGet( "RB_26", "Set" ) = 1 then
        count  = LineOut( FileName,'RemoveReplyBookmarks=Yes')
    else
        count  = LineOut( FileName,'RemoveReplyBookmarks=No')
end

if VRGet( "GB_23", "ForeColor" )="<default>" then do
    if VRGet( "RB_21", "Set" ) = 1 then
        count  = LineOut( FileName,'SplitLongReplies=Yes')
    else
        count  = LineOut( FileName,'SplitLongReplies=No')
end

/*Conference SETTINGS page*/
if VRGet( "GB_1", "ForeColor" )="<default>" then 
    if VRGet( "CB_1", "Set" ) = 1 then
        count  = LineOut( FileName,'ShowEmpties=Yes')   
    else
        count  = LineOut( FileName,'ShowEmpties=No')   

if VRGet( "GB_5", "ForeColor" )="<default>" then 
    if VRGet( "CB_2", "Set" ) = 1 then
        count  = LineOut( FileName,'DisplayStatus=Yes')   
    else
        count  = LineOut( FileName,'DisplayStatus=No')   

if VRGet( "GB_11", "ForeColor" )="<default>" then 
    if VRGet( "CB_3", "Set" ) = 1 then
        count  = LineOut( FileName,'SeparaterBar=Yes')   
    else
        count  = LineOut( FileName,'SeparaterBar=No')   

if VRGet( "GB_32", "ForeColor" )="<default>" then 
    if VRGet( "CB_4", "Set" ) = 1 then
        count  = LineOut( FileName,'PositionOnMatchLine=Yes')   
    else
        count  = LineOut( FileName,'PositionOnMatchLine=No')   

    count  = LineOut( FileName,'Internet=' VRGet( "SPIN_1", "Value" ))   
    count  = LineOut( FileName,'Netmail=' VRGet( "SPIN_2", "Value" ))   



/*Tagline page*/
if VRGet( "GB_16", "ForeColor" )="<default>" then do
    if VRGet( "CB_15", "Set" ) = 1 then
        count  = LineOut( FileName,"TagLine=@" || VRGet( "EF_13", "Value" ))
    else
        count  = LineOut( FileName,"TagLine=" || VRGet( "EF_9", "Value" ))
end

if VRGet( "GB_15", "ForeColor" )="<default>" then do
    if VRGet( "RB_6", "Set" ) = 1 then
        count  = LineOut( FileName,"TagMode=Random")
    else
        count  = LineOut( FileName,"TagMode=Sequential")
end

if VRGet( "GB_17", "ForeColor" )="<default>" then do
    if VRGet( "CB_13", "Set" ) = 1 then
        count  = LineOut( FileName,'SerialInTagline=Yes')
    else
        count  = LineOut( FileName,'SerialInTagline=No')
    if VRGet( "CB_14", "Set" ) = 1 then
        count  = LineOut( FileName,'SuppressVersionInTagline=Yes')
    else
        count  = LineOut( FileName,'SuppressVersionInTagline=No')
end

if VRGet( "GB_14", "ForeColor" )="<default>" then do
    if VRGet( "CB_12", "Set" )=1 then
        string = ",Autosense"
    else
        string=""
    if VRGet( "RB_3", "Set" ) = 1 then
        count  = LineOut( FileName,'TagStyle=PCBoard' string)
    if VRGet( "RB_4", "Set" ) = 1 then
        count  = LineOut( FileName,'TagStyle=Fido' string)
    if VRGet( "RB_5", "Set" ) = 1 then
        count  = LineOut( FileName,'TagStyle=TwoLine' string)
end

/*Colors page*/
if VRGet( "GB_33", "ForeColor" )="<default>" then 
    count  = LineOut( FileName,VRGet( "DT_11_B", "Caption" ))   /* Colors */



/*Conferences*/
if conf.0>0 then do
  do vc_num=1 to conf.0

    if (left(conf.vc_num,1)="{") & (right(conf.vc_num,1)="}") then
        Pre_Var="##"
    else
       Pre_Var=""

    if Pre_Var="##" then do
        string= left(conf.vc_num,length(conf.vc_num)-1)
        string=right(string,length(string)-1)
    end
    else 
        string=conf.vc_num

    count  = LineOut( FileName,Pre_Var||'MakeConference='||string)

     string=""
     do conf_num=1 to conf.vc_num.0
      string=string || conf.vc_num.conf_num || ","
     end
     if string\="" then
       count  = LineOut( FileName,Pre_Var||'Conferences='||left(string,length(string)-1))

     string=""
     do conf_num=1 to conf_hide.vc_num.0
      string=string || conf_hide.vc_num.conf_num || ","
     end
     if string\="" then
       count  = LineOut( FileName,Pre_Var||'HideConferences='||left(string,length(string)-1))

     if length(conf_string.vc_num)>0 then
       count  = LineOut( FileName,Pre_Var||'String='||conf_string.vc_num)

    if ((conf_from.vc_num=1)&(conf_to.vc_num=1)&(conf_body.vc_num=1)&(conf_origin.vc_num=1)&(conf_subject.vc_num=1)) | ((conf_from.vc_num=0)&(conf_to.vc_num=0)&(conf_body.vc_num=0)&(conf_origin.vc_num=0)&(conf_subject.vc_num=0)) then do
    end
    else do
    String="Check="
        if conf_from.vc_num=1 then
            String=String||"From,"
        if conf_to.vc_num=1 then
            String=String||"To,"
        conf_body.vc_num=1
            String=String||"Body,"
        conf_origin.vc_num=1
            String=String||"Origin,"
        conf_subject.vc_num=1
            String=String||"Subject,"
     count  = LineOut( FileName,Pre_Var||Left(String,(Length(String)-1)) )
    end

end /*end of virtual conference writing*/

/*Leftovers Page*/
    count  = LineOut( FileName,VRGet( "MLE_6", "Value" ))   



end /*end writing information to file*/



ok = VRSet( "Window1", "Caption", "MIM/2 - Ver" Version_Number FileName)

ok=Stream(FileName,'c','close')   /*close the file*/

end 

return

