/*********************************************************************/
/* IceBerg IRC REXX Command Script for GTirc.  V 1.10  ?? Jan 96     */
/*********************************************************************/
/* I've removed all the help comments from the script that comes with*/
/* GTirc to save space, refer back to those files for that info.     */
/*********************************************************************/
/* This file sets up all the commands that I have created, or stolen */
/* from other scripts and changed to work with REXX.  It works in    */
/* conjunction with the ICEMSG.CMD script to customize your IRC      */
/* client, add functionality and bring GTirc to a point where it more*/
/* than competes with any other IRC client out there for OS/2.       */
/*********************************************************************/
/* This pair of REXX scripts and the STARTICE.TXT startup file are   */
/* my creation and I retain all copyrights to the files.  They are   */
/* however freely distributable                                      */
/*********************************************************************/

Parse Upper Arg Win Us Prefix Cmd Chan Nick Rest
Parse Arg xWin xUs xPrefix xCmd xChan xNick xRest 
Parse Arg yWin yUs yPrefix yCmd yChan yNick yRest yWall yWall1 

Pool = 'OS2ENVIRONMENT'
ErStr1 = '+++ Syntax +++++'
ErStr2 = '++++ Error +++++'
ErStr3 = '++++++++++++++++'
titlline = '+------------------------IceBerg V 1.10------------------------+'
/*********************************************************************/
/* We see if this is a kick message for us. If so we format and      */
/* display a message in the window and rejoin the channel.           */
/*                                                                   */
/* We send the join command directly to the server because if we     */
/* send it as a normal command using IrcRexxCommand() it will be     */
/* ignored because the kick has not been processed and it thinks     */
/* we are still on the channel.                                      */
/*                                                                   */
/* We return a null string to suppress the kick message so that the  */
/* window for the channel will not be closed.                        */
/*                                                                   */
/*********************************************************************/

if (Cmd = 'KICK' & Nick = Us) then do
   By = substr(Prefix,2)
   Posex = pos('!',By)
   By = substr(By,1,posex - 1)

   Posex = pos(':',xRest)
   Reason = substr(xRest,2)

   Disp = "*** Kicked by" By "(" || Reason || ")"
   IrcRexxDisplay(Disp,Win)

   OutStr = "JOIN" Chan
   IrcRexxSend(OutStr)
   Return ""
End

/*********************************************************************/
/* AutoGreets are lame and obnoxious. So I removed them from         */
/* the script that came with GTirc =:-)                              */
/*********************************************************************/
/* Begin a log file when we join a channel. This feature is disabled */
/* by default. To enable it set the following variable:              */
/*                                            /icevar autolog on     */
/*********************************************************************/

if (Cmd = 'JOIN' & VALUE('autolog',,Pool) = 'ON') then do
   OutStr = "/LOG ON"
   IrcRexxCommand(OutStr,Win)
End

/*********************************************************************/
/* MSG Logger, taken from Wease on IRC                               */
/*********************************************************************/
msglog = value('msglog',,Pool)

if(cmd='PRIVMSG' & CHAN = Us & msglog = 'ON') then do
	n = Value('nummsgs',,Pool) + 1
	Value('nummsgs',n,Pool)
	id = substr(Prefix, 2)
	Posex = pos('!', id)
	id = substr(id,1,posex -1)
	message = ''id' --> 'xNick' 'xRest
	Value('msgbuf.'n,message,Pool)

	if(n > value('msgbufsize',,Pool)) then do
		do i = 1 to n
			nextmsg = value('msgbuf.'i+1,,Pool)
			value('msgbuf.'i,nextmsg,Pool)
		end
		value('nummsgs',n-1,Pool)
	end
	IrcRexxCommand('/not' id 'Your msg has been logged by IceBerg 1.10',Win)
end

/*********************************************************************/
/* Here we're getting all the nicks for channel that we previously   */
/* specified, writing those nicks to an array and then send the msg  */
/* to those nicks                                                    */
/*********************************************************************/

if(yCmd='353' & Value('walling',,Pool) = 'ON') then do
	names. = ''
	names.0 = 0
	cnt = 0
		   nickone = Strip(yWall,L,':')
		   nickpool = nickone yWall1
	do until Nickpool = ''
		   parse var Nickpool tmpWord Nickpool
		   cnt = cnt + 1
		   names.cnt = tmpWord
		   names.0 = cnt
	end
	do cnt = 1 to cnt
		if (Pos("@",names.cnt) = 1) then do   
		   names.cnt = Strip(names.cnt,L,'@')
		end
	end
	nickstr = names.1
	do cnt = 2 to cnt
		nickstr = nickstr || ',' || names.cnt
	end
		   Tempvar = Value('wallmsg',,Pool)
		   Strip(nickstr,B,",")
		   IrcRexxCommand('/msg' nickstr TempVar,Win)
	Value(walling,'OFF',Pool)
	Return 
end

/*********************************************************************/
/* Here we're getting all the channel operators for the channel that */
/* we previously specified, writing their nicks to an array and      */
/* then send the msg to those nicks                                  */
/*********************************************************************/
if(yCmd='353' & Value('walloping',,Pool) = 'ON') then do
	names. = ''
	names.0 = 0
	cnt = 0
	nickone = Strip(yWall,L,':')
	nickpool = nickone yWall1
	do until Nickpool = ''
		   parse var Nickpool tmpWord Nickpool
		   cnt = cnt + 1
		   names.cnt = tmpWord
		   names.0 = cnt
	end
nickstr = ''
	do cnt = 1 to cnt
		if (Pos("@",names.cnt) = 1) then do   
		   cleannick = Strip(names.cnt,L,'@')
		   nickstr = nickstr || cleannick || ','
		end
	end
	Tempvar = Value('wallmsg',,Pool)
	Strip(nickstr,B,",")
	IrcRexxCommand('/msg' nickstr TempVar,Win)
	Value(walloping,'OFF',Pool)
	Return 
end

/*********************************************************************/
/* Handling the incoming channel stats info for display              */
/*********************************************************************/
if (Cmd='353' & Value('cstating',,Pool) = 'ON') then do
	Parse Var xRest channel nicks
	nickcount = Words(nicks)
	opcount = '0'
	marker = Pos('@', nicks)
	if (marker = '0') then do
		opcount = 'None'
	end
	else do
		do until marker = '0'
			marker = Pos('@', nicks, marker + 1)
			opcount = opcount + 1
		end
	end
	IrcRexxDisplay(Copies('*',60),Win)
	IrcRexxDisplay('*' Center('Stats for' channel ':',58) '*',Win)
	IrcRexxDisplay('*' Center('' nickcount 'visible People',58) '*',Win)
	IrcRexxDisplay('*' Center('' opcount 'Channel Operators',58) '*',Win)
	IrcRexxDisplay(Copies('*',60),Win)
	Return ""
end

if (Cmd = '324' & Value('cstating',,Pool) = 'ON') then do
	modes = Strip(yRest,L,'+')
	IrcRexxDisplay('*' Center('Modes for' yNick ':' modes,58) '*',Win)
	Return ""
end

if (Cmd = '321' & Value('cstating',,Pool) = 'ON') then do
	Junk = yRest
	Return ""
end

/* This was added to suppress the Created Time stamp on Undernet till */
/* I can figure out how to convert that time code to something more   */
/* readable by humans                                                 */
if (Cmd = '329' & Value('cstating',,Pool) = 'ON') then do
	Junk = yRest
	Return ""
end

if (Cmd = '322' & Value('cstating',,Pool) = 'ON') then do
	nicktotal = yRest
	topic = yWall yWall1
	topic = Strip(topic, L, ':')
	if (topic = '') then do
		IrcRexxDisplay('*' Center('' yRest 'Total people',58) '*',Win)
		IrcRexxDisplay('*' Center('Topic for' yNick 'is:',58) '*',Win)
		IrcRexxDisplay('*' Center(' No topic has been set!',58) '*',Win)
		IrcRexxDisplay(Copies('*',60),Win)
	end
	else do
		if (Length(topic) > 56) then do
			wordcount = Words(topic)
			halfcount = wordcount % 2
			firsthalf = SubWord(topic, 1, halfcount)
			secondhalf = Subword(topic, halfcount + 1) 
			IrcRexxDisplay('*' Center('' yRest 'Total people',58) '*',Win)
			IrcRexxDisplay('*' Center('Topic for' yNick 'is:',58) '*',Win)
			IrcRexxDisplay('*' Center(firsthalf,56) '*',Win)
			IrcRexxDisplay('*' Center(secondhalf,56) '*',Win)
			IrcRexxDisplay(Copies('*',60),Win)
		end
		else do
			IrcRexxDisplay('*' Center('' yRest 'Total people',58) '*',Win)
			IrcRexxDisplay('*' Center('Topic for' yNick 'is:',58) '*',Win)
			IrcRexxDisplay('*' Center(topic,56) '*',Win)
			IrcRexxDisplay(Copies('*',60),Win)
		end
	end
	Value('cstating','OFF',Pool)
	Return ""
end
/*********************************************************************/
/* Decrypt incoming /crypt messages from other IceBerg users         */
/*********************************************************************/
if (Cmd = 'PRIVMSG' & Nick = ":#IB1.1#") then do
		By = substr(xPrefix,2)
		Posex = pos('!',By)
		By = substr(By,1,posex - 1)
	xice = "abcdefghijklmnopqrstuvwxyz1234567890,.-('"
	yice = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ )?@!#$*&=+\/"'
	icex = "Q2W* (J'K9aFs=df)gz7cE,mR/TltC+vb#yZu6UI@"
	icey = 'OHP!L.N4xM?qw"e3Gr5-A1SnD$B\YiX&o8pVhj0k'
		cryptout = icex || icey
		cryptin = xice || yice
	instr = xRest
		result = Translate(instr, cryptin, cryptout)
		IrcRexxDisplay("#IB1.1# *" || By || "-->" result,Win)
	Return ''
end

/*********************************************************************/
/* Here we're getting all the servers, stopping the process at the   */
/* the 365 message and then writing the array out to a file.         */
/* This creates a servers.lst file for later use with /findsplit     */
/*********************************************************************/

if (Cmd = '364' & Value('srvrget',,Pool) = 'ON') then do
	tempcnt = Value('cnt',,Pool) + 1
	Value('cnt',tempcnt,Pool)
	Value('srvrs.'tempcnt,yNick,Pool)
	Return ''
end

if (Cmd = '365' & Value('srvrget',,Pool) = 'ON') then do
	Value('srvrget','OFF',Pool)
	IrcRexxCommand('/WRITESVR',Win)
	Return ''
end

/*********************************************************************/
/* Here we're getting all the current servers, stopping the process  */
/* at the the 365 message and then writing the array out to a file.  */
/* This creates a current.lst file for later use with /findsplit     */
/*********************************************************************/
if (Cmd = '364' & Value('getcurr',,Pool) = 'ON') then do
	tempcnt = Value('currcnt',,Pool) + 1
	Value('currcnt',tempcnt,Pool)
	Value('currsvrs.'tempcnt,yNick,Pool)
	Return ''
end

if (Cmd = '365' & Value('getcurr',,Pool) = 'ON') then do
	Value('getcurr','OFF',Pool)
	IrcRexxCommand('/WRITECURRSVR',Win)
	Return ''
end

/*********************************************************************/
/* Handle all Auto-op'ing functions for any JOIN msgs received.      */
/*********************************************************************/
if (Cmd = 'JOIN' & Value('autoop',,Pool) = 'ON') then do
Call library
	marker = Pos('!', xPrefix)
	nick = SubStr(xPrefix,1,marker - 1)
	nick = Strip(nick,L,':')
	id = SubStr(xPrefix, marker + 1)
	id = Strip(id,L,'~')
	channel = Strip(xChan,L,':')
	target = id channel
	junk = SysFileSearch(target, 'autoop.lst', 'matches.')
	if (matches.0 > '0') then do
		IrcRexxCommand('/mode' channel '+o' nick,Win)
	end 
	Return 'OK'
end
/*********************************************************************/
/* We don't care about this message so return a non-null string so   */
/* that it will be processed normally.                               */
/*********************************************************************/

Return "OK"

/*********************************************************************/
/* Functions that many of the routines in this script need access to */
/*********************************************************************/

library:
	CALL RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
	CALL SysLoadFuncs
Return