/*********************************************************************/
/* IceBerg IRC REXX Command Script for GTirc.  V 1.10  ?? Jan 1996   */
/*********************************************************************/
/* I've removed all the help comments from the script that comes with*/
/* GTirc to save space, refer back to those files for that info.     */
/*********************************************************************/
/* This file sets up all the commands that I have created, or stolen */
/* from other scripts and changed to work with REXX.  It works in    */
/* conjunction with the IBergMsg.cmd script to customize your IRC    */
/* client, add functionality and bring GTirc to a point where it more*/
/* than competes with any other IRC client out there for OS/2.       */
/*********************************************************************/
/* This pair of REXX scripts and the ICESTART.TXT startup file are   */
/* my creation and I retain all copyrights to the files.  They are   */
/* however freely distributable, read the included documentation for */
/* more information.                                                 */
/*********************************************************************/
Parse Upper Arg Win Us Verb Parm1 Parms
Parse Arg xWin xUs xVerb xParm1 xParms
Parse Arg yWin yUs yVerb yParm1 yParm2 yParms

Pool = 'OS2ENVIRONMENT'

ErStr1 = '+++ Syntax +++++'
ErStr2 = '++++ Error +++++'
ErStr3 = '++++++++++++++++'
titlline = '+------------------------IceBerg V 1.10------------------------+'

/*********************************************************************/
/* We implement an /iceberg command to set and check global rexx     */
/* variables for the scripts to examine for various purposes.        */
/*********************************************************************/

if (Verb = '/ICEBERG') then do
 	if (Parm1 <> '') then do
		if (Parms <> '') then do
			VALUE(Parm1,Parms,Pool)
			ircrexxdisplay(Parm1 'Set to: ' || Parms || '.', win)
			Return ''
		end
		else do
			TempStr = Value(Parm1,,Pool)
			IrcRexxDisplay(Parm1 'Is currently: ' || TempStr || '.', win)
			Return ''
		end
	end
	else do
		IrcRexxDisplay("Once I figure out a way to get and display all",Win)
		IrcRexxDisplay("the defined variables in the Pool.  I'll add",Win)
		IrcRexxDisplay("it in here.",Win)
		Return ''
	end
end

/*********************************************************************/
/* The /WHOM command simply executes a /VERSION and /USERINFO on the */
/* specified nickname.                                               */
/*                            Syntax:  /WHOM nickname                */
/*********************************************************************/

if (Verb = '/WHOM') then do
   if (Parm1 <> '') then do
      OutStr = "/VERSION "  Parm1
      IrcRexxCommand(OutStr,Win)
      OutStr = "/USERINFO " Parm1
      IrcRexxCommand(OutStr,Win)
   end

   else do
      IrcRexxDisplay(ErStr1 "You must provide a users nick that",Win)
      IrcRexxDisplay(ErStr2 "you wish to get info about",Win)
   end

   Return ""
end

/*********************************************************************/
/*          These first few are the original routines I              */
/*  to start figuring out the GTirc REXX interface, they're really   */
/*         very simplistic but worked as a learning tool.            */
/*********************************************************************/

if (Verb = '/IDLE') then do
   if (Parm1 <> '') then do
      OutStr = "/whois"  Parm1 Parm1
      IrcRexxCommand(OutStr,Win)
   end

   else do
      IrcRexxDisplay(ErStr1 "You must provide a users nick that",Win)
      IrcRexxDisplay(ErStr2 "you wish to get idle info about",Win)
   end

   Return ""
end

/* Reverse it! */
if (Verb = '/REVSAY') then do
     if (Parm1 <> '') then do
	OutStr = Reverse(xParm1 xParms)
	IrcRexxCommand(OutStr,Win)
     end

     else do
      IrcRexxDisplay(ErStr1 "You must provide a string of input",Win)
      IrcRexxDisplay(ErStr2 "to be reversed and then sent",Win)
     end
     Return ""
end

/* Reverse in /msg!!  */
if (Verb = '/REVMSG') then do
     if (Parm1 <> '') then do
	OutStr = "/msg" xParm1 Reverse(xParms)
	IrcRexxCommand(OutStr,Win)
     end

     else do
	IrcRexxDisplay(ErStr1, 'You must provide a nick and some text',Win)
	IrcRexxDisplay(ErStr2, 'to be sent to that nick',Win)
     end

     Return ""
end

/* Reverse in a /me!!  */
if (Verb = '/REVME') then do
     if (Parm1 <> '') then do
	OutStr = "/me" Reverse(xParm1 xParms)
	IrcRexxCommand(OutStr,Win)
     end

     else do
      IrcRexxDisplay(ErStr1 'You must provide a string of text that you',Win)
      IrcRexxDisplay(ErStr2 'wish sent as a /me command.',Win)
     end

     Return ""
end

/* Domain who  */
if (Verb = '/DW') then do
     if (Parm1 <> '') then do
	OutStr = "/who *" || xParm1 || "*"
	IrcRexxCommand(OutStr,Win)
     end

     else do
      IrcRexxDisplay(ErStr1 'You must provide a domain that you',Win)
      IrcRexxDisplay(ErStr2 'wish to get user info from',Win)
     end

     Return ""
end

/*********************************************************************/
/*               Beginning of the message logger functions           */
/*                  I got this code from Wease on EFNet              */
/*********************************************************************/

/*    Simple command to reset my message queue   */
if (Verb = '/RESET') then do
   value('nummsgs',0,Pool)
   bufsize = value('msgbufsize',,Pool)
   if(bufsize < 2) then value('msgbufsize',5,Pool)
   IrcRexxDisplay(ErStr3 'Messages have been re-set' ErStr3, win)
   Return ""
end

/* View the Message Queue */
if (Verb = '/LAST') then do
	msglog = value('msglog',,Pool)
	msgnum = value('nummsgs',,Pool)

	ircrexxdisplay(" ",win)
	if (msglog \= 'ON') then ircrexxdisplay("Message Log DISABLED", Win)	

	if (msgnum = 0) then do 
		ircrexxdisplay("No new Messages",win)
		Return ""
	end
	else do
		if (Parm1 = "" | Parm1 > msgnum) then msgdisp = msgnum
            else msgdisp = Parm1
	end

	ircrexxdisplay('Displaying last' msgdisp 'Messages to you:',win)
	ircrexxdisplay(titlline, win)
	do i = msgnum - msgdisp + 1 to msgnum
		text = i':  'value('msgbuf.'i,,Pool)
		ircrexxdisplay(text, win)
	end
	ircrexxdisplay(titlline, win)
Return ""
end

/* Set the Size of the Message Queue */
if (Verb = '/BUFFER') then do
	if (parm1 <> "") then do
		value('msgbufsize', Parm1, Pool)
		IrcRexxDisplay('Msg Buffer Size is now:' Parm1 ||'.', Win)
		return ""
	end
	else do
		bufsize = value('msgbufsize',,Pool)
		IrcRexxDisplay('Msg Buffer Size is:' bufsize ||'.', Win)
		return ""
	end
end

/* Check the number of messages in the buffer */
if (Verb = '/MSGCHK') then do
	msgamount = value('nummsgs',,Pool)
		IrcRexxDisplay('' || msgamount || ' messages are currently in the Buffer.', Win)
		return ""
end

if (Verb = '/GONE') then do
	if (Parm1 <> '') then do
		IrcRexxCommand('/away' xParm1 xParms,Win)
		IrcRexxCommand('/iceberg msglog on',Win)
		Return ''
	end
	else do
		awaymsg = Value(awaymsg,,Pool)
		IrcRexxCommand('/away' awaymsg,Win)
		IrcRexxCommand('/iceberg msglog on',Win)
		Return ''
	end
	Return ''
end

if (Verb = '/BACK') then do
	IrcRexxCommand('/iceberg msglog off',Win)
	IrcRexxCommand('/last',Win)
	IrcRexxCommand('/away',Win)
	Return ''
end


if (Verb = '/SAVEMSGS') then do
	msglog = value('msglog',,Pool)
	msgnum = value('nummsgs',,Pool)
	if (msgnum = 0) then do 
		ircrexxdisplay("No Messages to be saved.",win)
		Return ""
	end
	else do
		if (Parm1 <> '') then do
			ircrexxdisplay('Writing msgs to log file:' Parm1,win)
			LineOut(Parm1, titlline, 1)
			do i = 1 to msgnum
				text = i || ': ' value('msgbuf.'i,,Pool)
				LineOut(Parm1, text)
			end
			LineOut(Parm1, titlline)
			LineOut(Parm1)
			IrcRexxDisplay(Parm1 "written.",Win)
			Return ""
		end
		else do
			Parm1 = "msgssave.txt"
			ircrexxdisplay('Writing msgs to log file: msgssave.txt',win)
			LineOut(Parm1, titlline, 1)
			do i = 1 to msgnum
				text = i || ': ' value('msgbuf.'i,,Pool)
				LineOut(Parm1, text)
			end
			LineOut(Parm1, titlline)
			LineOut(Parm1)
			IrcRexxDisplay(Parm1 "written.",Win)
			Return ""
		end
	end
end


/*    End of the message logger functions  */

/*  Change the default away statement  */
if (Verb = '/AWAYMSG') then do
	if (Parm1 <> '') then do
		Value('awaymsg',xParm1 xParms,Pool)
		TempVar = Value('awaymsg',,Pool)
		IrcRexxDisplay('Away statement changed to:' TempVar,Win)
		Return ''
	end
	else do
		TempVar = Value('awaymsg',,Pool)
		IrcRexxDisplay('Current away statement is:' TempVar,Win)
		Return ''
	end
end

/*********************************************************************/
/* Wall (msg all channel members or ops) - Abuse this one and you'll */
/*                    probably get a swift boot.                     */
/*********************************************************************/

if (Verb = '/WALL') then do
    if (Parm1 <> '') then do
	Value('walling','ON',Pool)
	Value('wallmsg',xParms,Pool)
	Outstr = "/names" xParm1
	IrcRexxCommand(Outstr,Win)
	Return ""
    end

    else do
	IrcRexxDisplay(erstr1 'You must provide a target channel to',Win)
	IrcRexxDisplay(erstr2 'get all the nicks that you want to msg',Win)
	IrcRexxDisplay(erstr3 'and the message to be sent',Win)
	Return ""
    end
Return ""
end

/* Wall (msg all channel operators) - Abuse this  */
/* one and you'll probably get a swift boot.      */

if (Verb = '/WALLOP') then do
    if (Parm1 <> '') then do
	Value('walloping','ON',Pool)
	Value('wallmsg',xParms,Pool)
	Outstr = "/names" xParm1
	IrcRexxCommand(Outstr,Win)
	Return ""
    end

    else do
	IrcRexxDisplay(erstr1 'You must provide a target channel to',Win)
	IrcRexxDisplay(erstr2 'get all the ops-nicks that you want to',Win)
	IrcRexxDisplay(erstr3 'msg and the message to be sent',Win)
	Return ""
    end
Return ""
end

/* Encryption Routines */
if (Verb = '/CRYPT') then do
	if (xParm1 <> '') then do
		xice = "abcdefghijklmnopqrstuvwxyz1234567890,.-('"
		yice = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ )?@!#$*&=+\/"'
		icex = "Q2W* (J'K9aFs=df)gz7cE,mR/TltC+vb#yZu6UI@"
		icey = 'OHP!L.N4xM?qw"e3Gr5-A1SnD$B\YiX&o8pVhj0k'
		cryptin = xice || yice
		cryptout = icex || icey
		instr = xParm1 xParms 
		outstr = Translate(instr, cryptout, cryptin)
			IrcRexxCommand("#IB1.1#" outstr,Win)
	end
	else do
		IrcRexxDisplay(ErStr1 "You must provide some text to be sent to the",Win)
		IrcRexxDisplay(ErStr2 "current channel or query.",Win)
	end		
	Return ""
end

/*********************************************************************/
/*               Custom IceBerg Kick Routines                        */
/*********************************************************************/

if (Verb = '/K') then do
	if (Parm1 <> '') then do
		if (Parm1 = '1' & Parms <> '') then do
			IrcRexxCommand('Number One, lock Photon Torpedoes on' yParm2'',Win)
			IrcRexxCommand('FIRE Photon Torpedoes!!',Win)
			IrcRexxCommand('/KICK' yParm2 'Torpedoed!!!!',Win)
			Return ''
		end
		if (Parm1 = '2') then do
			IrcRexxCommand('Channel scanners have detected a mass of Lame-ness',Win)
			IrcRexxCommand('Initiating a Lame-ectomy',Win)
			IrcRexxCommand('/KICK' yParm2 'This channel is clean.',Win)
			Return ''
		end
		if (Parm1 = '3') then do
			IrcRexxCommand('CHKDSK detected bad sectors in' yParm2 || '.',Win)
			IrcRexxCommand('' || yParm2 ' will be erased, sector will be marked as unusable.',Win)
			IrcRexxCommand('/KICK' yParm2,Win)
			Return ''
		end
		if (Parm1 = '4') then do
			IrcRexxCommand(yParm2 ||': Damn, my boots are getting dull',Win)
			IrcRexxCommand(yParm2 ||': turn around for a second so I can use your pants to shine my boots.',Win)
			IrcRexxCommand('/KICK' yParm2 "Now that's a shine!!",Win)
			Return ''
		end
		if (Parm1 = '5') then do
			IrcRexxCommand(yParm2 ||": There just isn't room enough for the two of us in this channel.",Win)
			IrcRexxCommand(yParm2 ||": So I'm going to fix that situation.",Win)
			IrcRexxCommand('/KICK' yParm2 'Now I got some elbow room!',Win)
			Return ''
		end
		if (Parm1 = '6') then do
			IrcRexxCommand('Searching for file:' yParm2 ||'.Brains.EXE',Win)
			IrcRexxCommand('File Not Found.',Win)
			IrcRexxCommand('/KICK' yParm2 'No Shirt, No Shoes, No Brain, No Service.',Win)
			Return ''
		end
		if (Parm1 = '7') then do
			IrcRexxCommand(yParm2 || ": You've been a VERY Bad User!!!",Win)
			IrcRexxCommand(yUs "slaps" yParm2 || "'s hand and takes away his keyboard.",Win)
			IrcRexxCommand('/KICK' yParm2 'Come back when you can behave.',Win)
			Return ''
		end
		else do
			IrcRexxCommand('/KICK' yParm1 'IceBerg V1.00 Default Kick',Win)
			Return ''
		end
	end
	else do
		IrcRexxDisplay('                 IceBerg V1.00 Customized Kicks',Win)
		IrcRexxDisplay('#1 - Star Trek Kick',Win)
		IrcRexxDisplay('#2 - Channel Scanner Lamer Detection',Win)
		IrcRexxDisplay('#3 - Bad Sector Found',Win)
		IrcRexxDisplay('#4 - Behind Boot Shine',Win)
		IrcRexxDisplay('#5 - Not Enough Room',Win)
		IrcRexxDisplay('#6 - File Not Found',Win)
		IrcRexxDisplay('#7 - Bad User!',Win)
		Return ''
	end
	Return ''
end
/* End Kicks */

/*********************************************************************/
/*        Normal IRC commands shortened for ease of use             */
/*********************************************************************/

if (Verb = '/J') then do
	if (Parm1 <> '') then do
		IrcRexxCommand('/join' xParm1,Win)
		Return ''
	end
	else do
		IrcRexxDisplay(ErStr3 'You must specify a channel name with /j',Win)
		Return ''
	end
end

if (Verb = '/T') then do
	if (Parm1 <> '') then do
		IrcRexxCommand('/topic' xParm1 xParms,Win)
		Return ''
	end
	else do
		IrcRexxCommand('/topic',Win)
		Return ''
	end
end

if (Verb = '/WI') then do
	if (Parm1 <> '') then do
		IrcRexxCommand('/whois' xParm1,Win)
		Return ''
	end
	else do
		IrcRexxDisplay(ErStr3 'You must specify a nick with /wi',Win)
		Return ''
	end
end

if (Verb = '/WW') then do
	if (Parm1 <> '') then do
		IrcRexxCommand('/whowas' xParm1,Win)
		Return ''
	end
	else do
		IrcRexxDisplay(ErStr3 'You must specify a nick with /ww',Win)
		Return ''
	end
end

if (Verb = '/INV') then do
	if (Parm1 <> '') then do
		IrcRexxCommand('/invite' xParm1,Win)
		Return ''
	end
	else do
		IrcRexxDisplay(ErStr3 'You must specify a nick with with /inv',Win)
		Return ''
	end
end

if (Verb = '/LV') then do
	if (Parm1 <> '') then do
		IrcRexxCommand('/leave' Parm1,Win)
		Return ''
	end
	else do
		IrcRexxCommand('/leave',Win)
		Return ''
	end
end

if (Verb = '/CM') then do
	if (Parm1 <> '') then do
		IrcRexxCommand('/mode *' xParm1 xParms,Win)
		Return ''
	end
	else do
		IrcRexxCommand('/mode *',Win)
		Return ''
	end
end

if (Verb = '/UM') then do
	if (Parm1 <> '') then do
		IrcRexxCommand('/mode' Us xParm1,Win)
		Return ''
	end
	else do
		IrcRexxDisplay('A mode change must be specified with /um',Win)
		Return ''
	end
end

/* this makes up for an unsupported /NOTICE command in GTirc */
if (Verb = '/NOT') then do 
     if (Parm1 <> '') then do
	OutStr = "NOTICE" xParm1 ":" || xParms
	IrcRexxSend(OutStr,Win)
     end

     else do
	IrcRexxDisplay(ErStr1, 'You must provide a nick or channel',Win)
	IrcRexxDisplay(ErStr2, 'and some text to be sent to that',Win)
	IrcRexxDisplay(ErStr3, 'nick or channel as a notice',Win)
     end

     Return ""
end
/* End of short versions of normal commands  */

/*********************************************************************/
/*           Commands to simplify use of OS2Bot on #OS/2             */
/*********************************************************************/

if (Verb = '/CALC') then do
	if (Parm1 <> '') then do
		IrcRexxCommand('/msg os2bot calc' xParm1 xParms,Win)
		Return ''
	end
	else do
		IrcRexxDisplay(ErStr1 'You must specify a string to be sent',Win)
		IrcRexxDisplay(ErStr2 'to OS2Bot for evaluation',Win)
		Return ''
	end
end


/*********************************************************************/
/* Help screens - on-line help for IceBerg                           */
/*********************************************************************/

if (Verb = '/ICEHELP') then do
	IrcRexxDisplay(titlline,Win)
	IrcRexxDisplay('/iceberg <variable> [Value] - To set a variable',Win)
	IrcRexxDisplay('/whom <nick> -                Get Version and Userinfo for nick',Win)
	IrcRexxDisplay('/idle <nick> -                Get idle time for nick',Win)
	IrcRexxDisplay('/revsay <text> -              Reverse text and send to channel',Win)
	IrcRexxDisplay('/revmsg <nick> <text> -       Reverse text and msg to nick',Win)
	IrcRexxDisplay('/revme <text> -               Reverse text and say as a /me',Win)
	IrcRexxDisplay('/dw <hostname|IP address> -   /who on the hostname/IP address',Win)
	IrcRexxDisplay('/wall <#channel> <text> -     /msg all channel occupants with text',Win)
	IrcRexxDisplay('/wallop <#channel> <text> -   /msg all channel ops with text',Win)
	IrcRexxDisplay('/calc -                       get a calc from OS2Bot on #os/2',Win)
	IrcRexxDisplay('/icehelp -                    This help display',Win)
	IrcRexxDisplay('/icehelp2 -                   Page 2 of the help display',Win)
	IrcRexxDisplay('/msghlp -                     Help display for the message logging functions',Win)
	IrcRexxDisplay('/nsl <hostname|IP adress> -   Do an OS/2 nslookup on <hostname> or <IP address>',Win)
	IrcRexxDisplay('/crypt <text> -               Encrypt and send text to channel',Win)
	IrcRexxDisplay('/osping <hostname|IP adress>- Do an OS/2 ping on hostname or IP',Win)
	IrcRexxDisplay('/exec <command> -             Run an OS/2 command',Win)
	IrcRexxDisplay('/ossend <command> -           Run an OS/2 command and send to the channel',Win)
	IrcRexxDisplay('/host <hostname|IP adress> -  Run OS/2s host command',Win)
	IrcRexxDisplay('/getservers -                 Get a new "servers.lst" listing',Win)
	IrcRexxDisplay('/findsplit -                  Find any split servers (see IBreadme.txt)',Win)
	IrcRexxDisplay('/addnew -                     Add any new servers found to "servers.lst"',Win)
	IrcRexxDisplay(titlline,Win)
Return ''
end
   /* *** Normal IRC commands that I have shortened/enhanced *** */   
if (Verb = '/ICEHELP2') then do
	IrcRexxDisplay(titlline,Win)
	IrcRexxDisplay('/k [1...7] <nick> -           Do one of the custom kicks or a generic',Win)
	IrcRexxDisplay('                              kick on nick.  Do Just /K for a short',Win)
	IrcRexxDisplay('                              description of the custom kicks',Win)
	IrcRexxDisplay('/j <#channel> -               /JOIN #channel',Win)
	IrcRexxDisplay('/not <nick|#channel> <text> - /NOTICE the nick or channel with text',Win)
	IrcRexxDisplay("/t [text] -                   Display the current channel's topic or",Win)
	IrcRexxDisplay("                              change it to text",Win)
	IrcRexxDisplay('/wi <nick> -                  /WHOIS on nick',Win)
	IrcRexxDisplay('/ww <nick> -                  /WHOWAS on nick',Win)
	IrcRexxDisplay('/inv <nick> -                 Invite nick to current channel',Win)
	IrcRexxDisplay('/lv [#channel] -              Leave the current or specified channel',Win)
	IrcRexxDisplay("/cm [[+|-] modes] -           Change current channel's mode setting",Win)
	IrcRexxDisplay('/um [[+|-] modes] -           Change users mode setting',Win)
	IrcRexxDisplay('/neener <nick> -              Send an ASCII art Neener to nick',Win)
	IrcRexxDisplay('/bulls <nick> -               Describe nick as BS in ASCII art',Win)
	IrcRexxDisplay('/crypt <text> -               Send text with encryption to current channel',Win)
	IrcRexxDisplay('/cstat <#channel> -           Get statistics for #channel',Win)
	IrcRexxDisplay(titlline,Win)
Return ''
end
           /* *** Message logging related commands *** */
if (Verb = '/MSGHELP') then do
	IrcRexxDisplay(titlline,Win)
	IrcRexxDisplay('/reset -                      Reset the message buffer (Pls Refer to IBReadme.txt)',Win)
	IrcRexxDisplay('/last [#] -                   Displays the messages stored, if # is specified',Win)
	IrcRexxDisplay('                              that many messages starting from the last',Win)
	IrcRexxDisplay('                              are displayed',Win)
	IrcRexxDisplay('/buffer [#] -                 Displays or sets (if # is specified) the size of the',Win)
	IrcRexxDisplay('                              message buffer',Win)
	IrcRexxDisplay('/msgchk -                     Display the current number of messages stored',Win)
	IrcRexxDisplay('/gone [awaymsg] -             Turn on the message logger and set the away',Win)
	IrcRexxDisplay('                              flag using the default awaymsg unless',Win)
	IrcRexxDisplay('                              one is specified',Win)
	IrcRexxDisplay('/back -                       Turn off the message logger, unset the away flag',Win)
	IrcRexxDisplay('                              and display any messages stored in the buffer',Win)
	IrcRexxDisplay('/awaymsg <text> -             Change the default awaymsg (not permanent, use the ',Win)
	IrcRexxDisplay('                              Startup Command and IceStart.txt file to make a',Win)
	IrcRexxDisplay('                              permanent default awaymsg',Win)
	IrcRexxDisplay('/savemsgs [filename] -        Save messages in the buffer the filename',Win)
	IrcRexxDisplay(titlline,Win)
Return ''
end

/*********************************************************************/
/*            OK, I had to put some silly stuff in!!                 */
/*********************************************************************/

if (Verb = '/NEENER' & Parm1 <> '') then do
   IrcRexxCommand("Hey, " Parm1 "",Win)
   IrcRexxCommand("         \|/ ____ \|/",Win)
   IrcRexxCommand("         ~@-/ oO \-@~",Win)
   IrcRexxCommand("         /_( \__/ )_\",Win)
   IrcRexxCommand("            \__U_/",Win)
   IrcRexxCommand("    Neener, neener, neener.",Win)
   Return ""
end 

if (Verb = '/BULLS' & Parm1 <> '') then do
   IrcRexxCommand("(__)",Win)
   IrcRexxCommand("|oo|________",Win)
   IrcRexxCommand("\  /        \",Win)
   IrcRexxCommand(" \/      /   \",Win)
   IrcRexxCommand("  \_|____\_|/.\",Win)
   IrcRexxCommand("    ||   YY| o '",Win)
   IrcRexxCommand("    ||    || O <== " Parm1 '',Win)
   IrcRexxCommand("   ^^    ^^",Win)
   Return ""
end

/*********************************************************************/
/*                   OS/2 interface commands                         */
/*********************************************************************/

/* Host function (doing an NSLOOKUP (shortened to /nsl)) */
if (Verb = '/NSL') then do
   CMD = "C:\OS2\CMD.EXE"
   if (Parm1 <> '') then do
       ADDRESS CMD 'nslookup' xParm1 '| rxqueue'
       nr = queued()
       do i=1 to nr
          Parse pull line
          if line <> ' ' Then IrcRexxDisplay(line,Win)
       end
   end
   else do
      IrcRexxDisplay(ErStr1 "You must provide a hostname or IP",Win)
      IrcRexxDisplay(ErStr2 "address that you wish to look up.",Win)
   end

   Return ""
end

/* OS ping function (doing an OS/2 ping) */
if (Verb = '/OSPING') then do
	CMD = "C:\OS2\CMD.EXE"
	if (Parm1 <> '') then do
		ADDRESS CMD 'ping' xParm1 '25 2 | rxqueue'
		nr = queued()
		do i=1 to nr
		Parse pull line
		if line <> ' ' Then IrcRexxDisplay(line,Win)
		end
	end
	else do
		IrcRexxDisplay(ErStr1 "You must provide a hostname or IP",Win)
		IrcRexxDisplay(ErStr2 "address that you wish to ping.",Win)
	end
	Return ""
end

/* OS execute function (doing an OS/2 command) */
if (Verb = '/EXEC') then do
	CMD = "C:\OS2\CMD.EXE"
	if (Parm1 <> '') then do
		ADDRESS CMD xParm1 xParms '| rxqueue'
		nr = queued()
		do i=1 to nr
			Parse pull line
			if line <> ' ' Then IrcRexxDisplay(line,Win)
		end
	end
	else do
		IrcRexxDisplay(ErStr1 "You must provide a command and any appropriate",Win)
		IrcRexxDisplay(ErStr2 "parameters that you wish to run.",Win)
	end
	Return ""
end

/* OS command send function */
if (Verb = '/OSSEND') then do
	CMD = "C:\OS2\CMD.EXE"
	if (Parm1 <> '') then do
		ADDRESS CMD xParm1 xParms '| rxqueue'
		nr = queued()
		do i=1 to nr
			Parse pull line
			if line <> ' ' Then IrcRexxCommand('*OS/2*' line,Win)
		end
	end
	else do
		IrcRexxDisplay(ErStr1 "You must provide a command and any appropriate",Win)
		IrcRexxDisplay(ErStr2 "parameters that you wish to run.",Win)
	end
	Return ""
end

/* OS command send function */
if (Verb = '/OSMSG') then do
	CMD = "C:\OS2\CMD.EXE"
	if (Parm1 <> '') & (Parms <> '') then do
		ADDRESS CMD yParm2 yParms '| rxqueue'
		nr = queued()
		do i=1 to nr
			Parse pull line
			if line <> ' ' Then IrcRexxCommand('/msg' yParm1 line,Win)
		end
	end
	else do
		IrcRexxDisplay(ErStr1 "You must provide a command and any appropriate",Win)
		IrcRexxDisplay(ErStr2 "parameters that you wish to run.",Win)
	end
	Return ""
end

/* Host function (doing a HOST command) */
if (Verb = '/HOST') then do
   CMD = "C:\OS2\CMD.EXE"
   if (Parm1 <> '') then do
       ADDRESS CMD 'host' xParm1 '| rxqueue'
       nr = queued()
       do i=1 to nr
          Parse pull line
          if line <> ' ' Then IrcRexxDisplay(line,Win)
       end
   end
   else do
      IrcRexxDisplay(ErStr1 "You must provide a hostname or IP",Win)
      IrcRexxDisplay(ErStr2 "address that you wish to look up.",Win)
   end

   Return ""
end

/*********************************************************************/
/* Split Finder routines - Now we get into some real functionality!  */
/* Some of these routines are called by other processes in these two */
/* scripts and aren't really for the user.                           */
/*********************************************************************/

if (Verb = '/GETSERVERS') then do
	Value('srvrget','ON',Pool)
	Value('srvrs.','',Pool)
	Value('srvrs.0','0',Pool)
	Value('cnt','0',Pool)
	IrcRexxDisplay('**** Getting list of active servers from the current server',Win)
	IrcRexxSend('LINKS',Win)
	IrcRexxDisplay('**** This may take a few moments, please be patient.',Win)
	Return
end

if (Verb = '/FINDSPLIT') then do
	Value('getcurr','ON',Pool)
	Value('currsvrs.','',Pool)
	Value('currsvrs.0','0',Pool)
	Value('currcnt','0',Pool)
	IrcRexxDisplay('**** Getting list of active servers from the current server',Win)
	IrcRexxSend('LINKS',Win)
	IrcRexxDisplay('**** This may take a few moments, please be patient.',Win)
	Return
end

if (Verb = '/WRITESVR') then do
	CALL library
	rc = SysFileDelete('servers.lst')
	LineOut('servers.lst', '#Begin_List#', 1)
	cnt = Value('cnt',,Pool)
	do s = 1 to cnt
		tempword = Value('srvrs.'s,,Pool)
		LineOut('servers.lst', tempword)
	end
	LineOut('servers.lst')
	IrcRexxDisplay(Value('cnt',,Pool) "Servers written to 'servers.lst'",Win)
	Return ''
end

if (Verb = '/WRITECURRSVR') then do
	CALL library
	rc = SysFileDelete('current.lst')
	LineOut('current.lst', '#Begin_List#', 1)
	cnt = Value('currcnt',,Pool)
	do s = 1 to cnt
		tempword = Value('currsvrs.'s,,Pool)
		LineOut('current.lst', tempword)
	end
	LineOut('current.lst')
	IrcRexxDisplay(Value('cnt',,Pool) "Servers written to 'current.lst'",Win)
	IrcRexxCommand('/SPLITTERS',Win)
	Return
end

if (Verb = '/SPLITTERS') then do
	IrcRexxDisplay('Looking for any split servers.',Win)
	Do While (Lines(servers.lst) = 1)
		tmpline = LineIn(servers.lst)
		if (SysFileSearch(tmpline, current.lst, 'aresult.') = 0) then do
			if (aresult.0 = 0) then do
				IrcRexxDisplay("IB: Currently Split:" tmpline "",Win) 
			end
		end
	end
	IrcRexxCommand('/ADDNEW',Win)
	Return
end

if (Verb = '/ADDNEW') then do
	IrcRexxDisplay('Looking for any new servers',Win)
	Do While (Lines(current.lst) = 1)
		tmpline = LineIn(current.lst)
		if (SysFileSearch(tmpline, servers.lst, 'aresult.') = 0) then do
			if (aresult.0 = 0) then do
				IrcRexxDisplay("IB: New server found & added:" tmpline "",Win) 
				junk = LineOut('servers.lst', tmpline)
				junk = LineOut('servers.lst')
			end
		end
	end
	Return
end

/*********************************************************************/
/* Get and display statistics about a particular channel             */
/*********************************************************************/
if (Verb = '/CSTAT') then do
	if (Parm1 <> '') then do
		Value('cstating','ON',Pool)
		IrcRexxSend('NAMES' xParm1,Win)
		IrcRexxSend('MODE' xParm1,Win)
		IrcRexxSend('LIST' xParm1,Win)
	end
	else do
		Value('cstating','OFF',Pool)
		IrcRexxDisplay(ErStr1 "You must provide a channel that you wish",Win)
		IrcRexxDisplay(ErStr2 "to retreive stats for.",Win)
	end
	Return ""
end

/*********************************************************************/
/* Get and display statistics about a particular channel             */
/* ********************************************************************
if (Verb = '/AUTOOPADD') */


/*********************************************************************/
/* This isn't a command we care about so we pass a non-null string   */
/* so that it will be processed normally                             */
/*********************************************************************/

Return 'OK'

library:
	CALL RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
	CALL SysLoadFuncs
Return