#  $Id: cal2gcal.awk 0.03 1995/09/18 00:00:03 tom Exp $
#
#  cal2gcal.awk:  Very simple, slow and silly `AWK' script for converting
#                   "BSD-calendar(1)" appointments into the `gcal' format.
#
#
#  Copyright (C) 1995 Thomas Esken
#
#  This software doesn't claim completeness, correctness or usability.
#  On principle I will not be liable for any damages or losses (implicit
#  or explicit), which result from using or handling my software.
#  If you use this software, you agree without any exception to this
#  agreement, which binds you LEGALLY !!
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the `GNU General Public License' as published by
#  the `Free Software Foundation'; either version 2, or (at your option)
#  any later version.
#
#  You should have received a copy of the `GNU General Public License'
#  along with this program; if not, write to the:
#    Free Software Foundation
#    59 Temple Place, Suite 330
#    Boston, MA 02111-1307  USA
#
#
BEGIN {
  #
  # Define the field separator used (blank acutally)
  #
  FS = " "
  #
  # Print some leading comment text
  #
  print "; cal2gcal.awk output"
  print ";"
  print "; Absolutely NO warrenty!"
  print ";"
  print ";"
  #
  # Pre-initialize the constructed line
  #
  line = ""
}
#
# Main block
#
{
   datepart = $1
   #
   # Strip leading whitspace characters in text part of appointment
   #
   calcolumn = length($1) + 1
   while (substr($0, calcolumn, 1) ~ /[ \t]/)
     calcolumn++
   textpart = substr($0, calcolumn)
   #
   # Construct the line
   #
   if (substr(datepart, 3, 1) == "/")
    {
      #
      # If line is completed just print it
      #
      if (line != "")
       {
         print line
         line = ""
       }
      month = substr(datepart, 1, 2)
      day = substr(datepart, 4, 2)
      line = "0000" month day " " textpart
    }
   else
    {
      #
      # Strip leading whitspace characters in continuation of
      #   text part of appointment
      #
      calcolumn = 1
      while (substr($0, calcolumn, 1) ~ /[ \t]/)
        calcolumn++
      line = line " " substr($0, calcolumn)
    }
}
