/*
*  gcal_utl.c:  Pool of common functions.
*
*
*  Copyright (C) 1994, 1995 Thomas Esken
*
*  This software doesn't claim completeness, correctness or usability.
*  On principle I will not be liable for any damages or losses (implicit
*  or explicit), which result from using or handling my software.
*  If you use this software, you agree without any exception to this
*  agreement, which binds you LEGALLY !!
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the `GNU General Public License' as published by
*  the `Free Software Foundation'; either version 2, or (at your option)
*  any later version.
*
*  You should have received a copy of the `GNU General Public License'
*  along with this program; if not, write to the:
*    Free Software Foundation
*    59 Temple Place, Suite 330
*    Boston, MA 02111-1307  USA
*/



#ifdef RCSID
static char rcsid[]="$Id: gcal_utl.c 0.39 1995/12/20 00:03:09 tom Exp $";
#endif



/*
*  Include header files
*/
#include "gcal_tai.h"
#if HAVE_CTYPE_H
#  include <ctype.h>
#endif
#if TIME_WITH_SYS_TIME
#  include <sys/time.h>
#  include <time.h>
#else /* !TIME_WITH_SYS_TIME */
#  if HAVE_SYS_TIME_H
#    include <sys/time.h>
#  else /* !HAVE_SYS_TIME_H */
#    include <time.h>
#  endif /* !HAVE_SYS_TIME_H */
#endif /* !TIME_WITH_SYS_TIME */
#include "gcal.h"



/*
*  Function prototypes
*/
#if __cplusplus
extern "C"
{
#endif
/*
************************************************** Defined in `gcal_hdy.c'
*/
IMPORT int
eval_holiday __P_((      int  day,
                   const int  month,
                   const int  year,
                   const int  wd,
                   const Bool forwards));
#if USE_RC
/*
************************************************** Defined in `gcal_rc.c'
*/
IMPORT char *
rc_get_date __P_((      char *ptr_char,
                        Bool *is_weekday_mode,
                        int  *d,
                        int  *m,
                        int  *y,
                        int  *n,
                        int  *len,
                        char *hc,
                        int  *hn,
                        int  *hwd,
                  const char *filename,
                  const int   line,
                  const char *line_buffer,
                  const Bool  on_error_exit));
IMPORT Bool
precomp_nth_wd __P_((      int         diff,
                     const int         wd,
                           int        *n,
                           int        *day,
                           int        *month,
                           int        *year,
                     const Cmode_enum  mode));
IMPORT Bool
precomp_date __P_((      int         diff,
                   const int         wd,
                         int        *day,
                         int        *month,
                   const int         year,
                   const Cmode_enum  mode));
IMPORT void
prev_date __P_((int *day,
                int *month,
                int *year));
IMPORT void
next_date __P_((int *day,
                int *month,
                int *year));
#endif /* USE_RC */
/*
************************************************** Defined in `gcal_tty.c'
*/
IMPORT void
print_text __P_((      FILE       *fp,
                       char       *txt_line,
                 const Dmode_enum  mode));
/*
************************************************** Defined in `gcal_utl.c'
*/
EXPORT void
my_extended_help __P_((      FILE *fp,
                       const int   longopt_symbolic));
EXPORT void
my_basic_help __P_((FILE *fp));
EXPORT void
my_license __P_((      FILE *fp,
                 const char *prgr_id));
EXPORT void
my_version __P_((      FILE *fp,
                 const char *prgr_id));
EXPORT VOID_PTR
my_malloc __P_((const int   amount,
                const int   exit_status,
                const char *module_name,
                const int   module_line,
                const char *var_name,
                const int   var_contents));
EXPORT VOID_PTR
my_realloc __P_((      VOID_PTR  ptr_memblock,
                 const int       amount,
                 const int       exit_status,
                 const char     *module_name,
                 const int       module_line,
                 const char     *var_name,
                 const int       var_contents));
EXPORT void
my_error __P_((const int   exit_status,
               const char *module_name,
               const int   module_line,
               const char *var_name,
               const int   var_contents));
EXPORT int
my_atoi __P_((const char *s));
EXPORT Bool
get_actual_date __P_((void));
EXPORT int
compare_d_m_name __P_((const char       *s,
                       const Cmode_enum  mode));
EXPORT int
asc_sort __P_((const char **a,
               const char **b));
EXPORT int
des_sort __P_((const char **a,
               const char **b));
EXPORT Bool
is_presorted __P_((char **table,
                   int    elems));
EXPORT void
resort __P_((      char **table,
             const int    elems));
#if !USE_GER
EXPORT const char *
day_suffix __P_((int day));
EXPORT const char *
short3_day_name __P_((const int day));
#endif
EXPORT const char *
short_day_name __P_((const int day));
EXPORT const char *
day_name __P_((const int day));
EXPORT const char *
short_month_name __P_((const int month));
EXPORT const char *
month_name __P_((const int month));
EXPORT Ulint
date2num __P_((const int day,
               const int month,
               const int year));
EXPORT Bool
jdate2sdate __P_((      int  jdate,
                  const int  is_leap_year,
                        int *day,
                        int *month));
EXPORT int
weekday_of_date __P_((const int day,
                      const int month,
                      const int year));
EXPORT int
day_of_year __P_((const int day,
                  const int month,
                  const int year));
EXPORT int
days_of_february __P_((const int year));
EXPORT Bool
valid_date __P_((const int day,
                 const int month,
                 const int year));
EXPORT int
week_number __P_((const int day,
                  const int month,
                  const int year));
EXPORT int
weekno2jday __P_((      int week,
                  const int year));
EXPORT int
knuth_easter_formula __P_((const int year));
EXPORT int
julian_gregor_diff __P_((const int day,
                         const int month,
                         const int year));
EXPORT const char *
usage_msg __P_((void));
EXPORT void
put_longopt_description __P_((FILE *fp));
LOCAL const char *
get_longopt_description __P_((const int  longopt_symbolic,
                              const Bool with_larglist));
LOCAL void
my_copyright __P_((      FILE *fp,
                   const char *prgr_id));
LOCAL void
my_help_head_txt __P_((FILE *fp));
LOCAL void
my_help_tail_txt __P_((FILE *fp));
LOCAL int
raw_week_number __P_((const int day,
                      const int month,
                      const int year));
#if __cplusplus
}
#endif



/*
*  Declare public(extern) variables
*/
IMPORT const int    dvec[MONTH_MAX];           /* Amount of days in months' */
IMPORT const int    mvec[MONTH_MAX];           /* Number of past days of month */
IMPORT const Lopt_struct  lopt[];              /* The longoption structure */
IMPORT Hls_struct   ehls2s;                    /* Effective hls 2 start (holiday) */
IMPORT Hls_struct   ehls2e;                    /* Effective hls 2 end (holiday) */
IMPORT int          len_year_max;              /* String length of the maximum year able to compute */
IMPORT int          act_sec;                   /* Actual second */
IMPORT int          act_min;                   /* Actual minute */
IMPORT int          act_hour;                  /* Actual hour */
IMPORT int          act_day;                   /* Actual day */
IMPORT int          act_month;                 /* Actual month */
IMPORT int          act_year;                  /* Actual year */
IMPORT int          buf_ad;                    /* Buffer of actual day */
IMPORT int          buf_am;                    /* Buffer of actual month */
IMPORT int          buf_ay;                    /* Buffer of actual year */
IMPORT int          is_tty;                    /* Is output displayed on a terminal? */
IMPORT int          len_prgr_name;             /* Length of actual program name */
IMPORT char         s[MAXLEN+1];               /* General purpose text buffer */
IMPORT char         s2[MAXLEN+1];              /* General purpose text buffer */
IMPORT char        *prgr_name;                 /* Stores the actual program name */
#ifdef GCAL_EPAGER
IMPORT char        *ext_pager;                 /* Name of external pager program */
#endif
#if USE_RC
IMPORT char        *rc_adate;                  /* Text containing modified actual date %... */
#endif
IMPORT Bool         emu_hls;                   /* Must we emulate the highlighting sequences? */
IMPORT Bool         highlight_flag;            /* -H<yes> or -H<no> */



#ifdef ANSI_PROTO
PUBLIC void
my_extended_help (      FILE *fp,
                  const int   longopt_symbolic)
#else /* !ANSI_PROTO */
   PUBLIC void
my_extended_help (fp, longopt_symbolic)
         FILE *fp;
   const int   longopt_symbolic;
#endif /* !ANSI_PROTO */
/*
   Prints the extended help text to file `fp' using the central
     output function `print_text()' and uses global text buffer
     `s' and `s2' internally.
     if `longopt_symbolic' is set to SYM_NIL, the complete text
     is shown, otherwise the text corresponding to SYM_??? only!
*/
{
   auto Bool  print_hls=(Bool)(is_tty&&highlight_flag&&!emu_hls);


   if (longopt_symbolic == SYM_NIL)
    {
      my_help_head_txt (fp);
#if USE_RC
#  if USE_GER
      sprintf(s, USAGE"%s [[OPTION...] [%cDATUM] [%cDATEI...]] [KOMMANDO]",
              prgr_name, RC_ADATE_CHAR, RSP_CHAR);
#  else /* !USE_GER */
      sprintf(s, USAGE"%s [[OPTION...] [%cDATE] [%cFILE...]] [COMMAND]",
              prgr_name, RC_ADATE_CHAR, RSP_CHAR);
#  endif /* !USE_GER */
#else /* !USE_RC */
#  if USE_GER
      sprintf(s, USAGE"%s [[OPTION...] [%cDATEI...]] [KOMMANDO]", prgr_name, RSP_CHAR);
#  else /* !USE_GER */
      sprintf(s, USAGE"%s [[OPTION...] [%cFILE...]] [COMMAND]", prgr_name, RSP_CHAR);
#  endif /* !USE_GER */
#endif /* !USE_RC */
      print_text (fp, s, INternal);
      print_text (fp, s, INternal);
      print_text (fp, s, INternal);
      if (print_hls)
        strcpy(s, ehls2s.seq);
      strcat(s, "OPTION");
      if (print_hls)
        strcat(s, ehls2e.seq);
      print_text (fp, s, INternal);
    }
#if USE_GER
   switch (longopt_symbolic)
    {
      case SYM_NIL:
      case SYM_HELP:
        sprintf(s, SWITCH"?        %s", get_longopt_description (SYM_HELP, TRUE));
        print_text (fp, s, INternal);
        sprintf(s, SWITCH"h        %s", get_longopt_description (SYM_HELP, TRUE));
        print_text (fp, s, INternal);
        strcpy(s, "          Hilfetext ausgeben und Programm beenden");
        print_text (fp, s, INternal);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s, INternal);
      case SYM_LONG_HELP1:
      case SYM_LONG_HELP2:
        sprintf(s, SWITCH"??       %s", get_longopt_description (SYM_LONG_HELP1, TRUE));
        print_text (fp, s, INternal);
        sprintf(s, SWITCH"hh       %s", get_longopt_description (SYM_LONG_HELP1, TRUE));
        print_text (fp, s, INternal);
        sprintf(s, "          %s", get_longopt_description (SYM_LONG_HELP2, TRUE));
        print_text (fp, s, INternal);
        strcpy(s, "          Erweiterten Hilfetext ausgeben und Programm beenden");
        print_text (fp, s, INternal);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s, INternal);
      case SYM_LICENSE1:
      case SYM_LICENSE2:
      case SYM_LICENSE3:
        sprintf(s, SWITCH"L        %s", get_longopt_description (SYM_LICENSE1, TRUE));
        print_text (fp, s, INternal);
        sprintf(s, "          %s", get_longopt_description (SYM_LICENSE2, TRUE));
        print_text (fp, s, INternal);
        sprintf(s, "          %s", get_longopt_description (SYM_LICENSE3, TRUE));
        print_text (fp, s, INternal);
        strcpy(s, "          Softwarelizenz ausgeben und Programm beenden");
        print_text (fp, s, INternal);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s, INternal);
      case SYM_VERSION:
        sprintf(s, SWITCH"V        %s", get_longopt_description (SYM_VERSION, TRUE));
        print_text (fp, s, INternal);
        strcpy(s, "          Versionsnummer ausgeben und Programm beenden");
        print_text (fp, s, INternal);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s, INternal);
      case SYM_RESPONSE_FILE:
        sprintf(s, SWITCH"R ARG    %s", get_longopt_description (SYM_RESPONSE_FILE, TRUE));
        print_text (fp, s, INternal);
        sprintf(s, "          Antwortdatei f"UE"r die `%cDATEI' Option erzeugen", RSP_CHAR);
        print_text (fp, s, INternal);
        strcpy(s, "   ARG    = Schreibe Argumente der Kommandozeile in Datei ARG");
        print_text (fp, s, INternal);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s, INternal);
#  ifdef GCAL_SHELL
      case SYM_SCRIPT_FILE:
        sprintf(s, SWITCH"S ARG    %s", get_longopt_description (SYM_SCRIPT_FILE, TRUE));
        print_text (fp, s, INternal);
        sprintf(s, "          Shell script mit den Argumenten der Kommandozeile erzeugen");
        print_text (fp, s, INternal);
        strcpy(s, "   ARG    = Dateiname des shell scripts");
        print_text (fp, s, INternal);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s, INternal);
#endif
#  if USE_RC
      case SYM_DATE_VARIABLE1:
      case SYM_DATE_VARIABLE2:
        sprintf(s, SWITCH"v ARG    %s", get_longopt_description (SYM_DATE_VARIABLE1, TRUE));
        print_text (fp, s, INternal);
        sprintf(s, "          %s", get_longopt_description (SYM_DATE_VARIABLE2, TRUE));
        print_text (fp, s, INternal);
        strcpy(s, "          Globale Datumvariable(n) \"dvar->a|b|c|d|f|...|z\" definieren");
        print_text (fp, s, INternal);
        strcpy(s, "   ARG    = Durch `"SEP"' Zeichen getrennte Definitionen der "
               "Form \"dvar"RC_DVAR_ASSIGN"`mmtt'\"");
        print_text (fp, s, INternal);
        strcpy(s, "            z.B.  "SWITCH"v a"RC_DVAR_ASSIGN"1127"SEP"b"RC_DVAR_ASSIGN
               "054   Setze `a' auf 27 Nov und `b' auf 4 Mai");
        print_text (fp, s, INternal);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s, INternal);
#  endif
      case SYM_DEBUG:
        sprintf(s, "          %s", get_longopt_description (SYM_DEBUG, TRUE));
        print_text (fp, s, INternal);
        strcpy(s, "          Einige Debug-Informationen ausgeben");
        print_text (fp, s, INternal);
        strcpy(s, "  [ARG]   = internal    Warnungen bei Erreichen programminterner Maxima");
        print_text (fp, s, INternal);
        strcpy(s, "          = handled     Wie `internal' und zudem gehandhabte Dateinamen");
        print_text (fp, s, INternal);
        strcpy(s, "          = unhandled   Wie `internal' und zudem nicht gehandhabte Dateinamen");
        print_text (fp, s, INternal);
        strcpy(s, "          = all         Wie `handled' und `unhandled' zusammen");
        print_text (fp, s, INternal);
        strcpy(s, "          = abort       Wie `all' und Abbruch bei ungehandhabten Dateinamen");
        print_text (fp, s, INternal);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s, INternal);
      case SYM_TYPE_OF_CALENDAR:
        sprintf(s, SWITCH"i[MOD]   %s", get_longopt_description (SYM_TYPE_OF_CALENDAR, TRUE));
        print_text (fp, s, INternal);
        strcpy(s, "          Spezial-Kalenderformat f"UE"r Kalenderblatt verwenden");
        print_text (fp, s, INternal);
        strcat(s, "  [MOD]   = -   Standard-Kalenderformat f"UE"r Kalenderblatt verwenden");
        print_text (fp, s, INternal);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s, INternal);
      case SYM_SUPPRESS_CALENDAR:
        sprintf(s, SWITCH"u        %s", get_longopt_description (SYM_SUPPRESS_CALENDAR, TRUE));
        print_text (fp, s, INternal);
        strcpy(s, "          Ausgabe des Kalenderblatts explizit unterdr"UE"cken");
        print_text (fp, s, INternal);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s, INternal);
#  if USE_PAGER
      case SYM_PAGER:
        sprintf(s, SWITCH"p        %s", get_longopt_description (SYM_PAGER, TRUE));
        print_text (fp, s, INternal);
#    ifdef GCAL_EPAGER
        if (ext_pager != (char *)NULL)
          sprintf(s, "          Ausgabe durch externen `%s' Paginierer lenken",
                  (*ext_pager == *DIR_SEP) ? strrchr(ext_pager, *DIR_SEP)+1 : ext_pager);
        else
          strcpy(s, "          Ausgabe durch einfachen, internen Paginierer lenken");
#    else /* !GCAL_EPAGER */
        strcpy(s, "          Ausgabe durch einfachen, internen Paginierer lenken");
#    endif /* !GCAL_EPAGER */
        print_text (fp, s, INternal);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s, INternal);
#  endif
      case SYM_DISABLE_HIGHLIGHTING:
        sprintf(s, SWITCH"H no     %s", get_longopt_description (SYM_DISABLE_HIGHLIGHTING, TRUE));
        print_text (fp, s, INternal);
        sprintf(s, "          %s=no",  get_longopt_description (SYM_HIGHLIGHTING, FALSE));
        print_text (fp, s, INternal);
        strcpy(s, "          Text, Feiertag bzw. aktuelles Datum ohne Hervorhebung ausgeben");
        print_text (fp, s, INternal);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s, INternal);
      case SYM_FORCE_HIGHLIGHTING:
        sprintf(s, SWITCH"H yes    %s", get_longopt_description (SYM_FORCE_HIGHLIGHTING, TRUE));
        print_text (fp, s, INternal);
        sprintf(s, "          %s=yes",  get_longopt_description (SYM_HIGHLIGHTING, FALSE));
        print_text (fp, s, INternal);
        strcpy(s, "          Bel"AE"sst Hervorhebungssequenzen in Ausgabe bei Ausgabeumlenkung");
        print_text (fp, s, INternal);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s, INternal);
      case SYM_HIGHLIGHTING:
        sprintf(s, SWITCH"H ARG    %s", get_longopt_description (SYM_HIGHLIGHTING, TRUE));
        print_text (fp, s, INternal);
        strcpy(s, "          Setze Hervorhebungssequenz-Paare 1 (=aktueller Tag) und 2 (=Feiertag)");
        print_text (fp, s, INternal);
        strcpy(s, "   ARG    = Durch `"SEP"' Zeichen getrennte Hervorhebungssequenz-Paare");
        print_text (fp, s, INternal);
        strcpy(s, "            z.B.  "SWITCH"H \\x2"SEP"\\x"
               "AE   Benutze Hex-Wert 2 und AE f"UE"r Sequenz 1");
        print_text (fp, s, INternal);
        strcpy(s, "            z.B.  "SWITCH"H "SEP""SEP"*"SEP
               "*      Benutze Zeichen `*' und `*' f"UE"r Sequenz 2");
        print_text (fp, s, INternal);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s, INternal);
      case SYM_BLOCKS:
        sprintf(s, SWITCH"b ARG    %s", get_longopt_description (SYM_BLOCKS, TRUE));
        print_text (fp, s, INternal);
        strcpy(s, "          Format des Jahreskalenders festlegen");
        print_text (fp, s, INternal);
        strcpy(s, "   ARG    = 1|2|3|4|6|12   Anzahl der Bl"OE"cke");
        print_text (fp, s, INternal);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s, INternal);
      case SYM_CALENDAR_DATES:
        sprintf(s, SWITCH"j[MOD]   %s", get_longopt_description (SYM_CALENDAR_DATES, TRUE));
        print_text (fp, s, INternal);
        strcpy(s, "          Julianisches Datum im Kalenderblatt verwenden");
        print_text (fp, s, INternal);
        strcpy(s, "  [MOD]   = b   Beide Datumnotationen (Standard + Julianisch) verwenden");
        print_text (fp, s, INternal);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s, INternal);
      case SYM_HOLIDAY_DATES:
        sprintf(s, SWITCH"jn[MOD]  %s", get_longopt_description (SYM_HOLIDAY_DATES, TRUE));
        print_text (fp, s, INternal);
        strcpy(s, "          Julianisches Datum in ewiger Feiertagsliste verwenden");
        print_text (fp, s, INternal);
        strcpy(s, "   [MOD]  = b   Beide Datumnotationen (Standard + Julianisch) verwenden");
        print_text (fp, s, INternal);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s, INternal);
#if USE_RC
      case SYM_FIXED_DATES:
        sprintf(s, SWITCH"jc[MOD]  %s", get_longopt_description (SYM_FIXED_DATES, TRUE));
        print_text (fp, s, INternal);
        strcpy(s, "          Julianisches Datum in Terminwarnungsliste verwenden");
        print_text (fp, s, INternal);
        strcpy(s, "   [MOD]  = b   Beide Datumnotationen (Standard + Julianisch) verwenden");
        print_text (fp, s, INternal);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s, INternal);
#endif
      case SYM_STARTING_DAY:
        sprintf(s, SWITCH"s ARG    %s", get_longopt_description (SYM_STARTING_DAY, TRUE));
        print_text (fp, s, INternal);
        strcpy(s, "          Starttag der Woche festlegen");
        print_text (fp, s, INternal);
        sprintf(s, "   ARG    = 0 | %d|%s|%d|%s|...|%d|%s",
                DAY_MIN, short_day_name (DAY_MIN),
                DAY_MIN+1, short_day_name (DAY_MIN+1),
                DAY_MAX, short_day_name (DAY_MAX));
        print_text (fp, s, INternal);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s, INternal);
#  ifdef GCAL_EMAIL
      case SYM_MAIL:
        sprintf(s, SWITCH"m ARG    %s", get_longopt_description (SYM_MAIL, TRUE));
        print_text (fp, s, INternal);
        strcpy(s, "          Versenden der Ausgabe via `"MAIL_PRGR"' Programm an Benutzer");
        print_text (fp, s, INternal);
        strcpy(s, "   ARG    = Email Adresse");
        print_text (fp, s, INternal);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s, INternal);
#  endif
      case SYM_DESC_HOLIDAY_LIST:
      case SYM_HOLIDAY_LIST:
        sprintf(s, SWITCH"n|N[MOD] %s", get_longopt_description (SYM_DESC_HOLIDAY_LIST, TRUE));
        print_text (fp, s, INternal);
        sprintf(s, "          %s", get_longopt_description (SYM_HOLIDAY_LIST, TRUE));
        print_text (fp, s, INternal);
        sprintf(s, "          Ewige Feiertagsliste ausgeben "
                "(Jahr im Bereich: %d...%d)", EASTER_MIN, EASTER_MAX);
        print_text (fp, s, INternal);
        strcpy(s, " n        = Gesetzliche Feiertage und Erinnerungstage");
        print_text (fp, s, INternal);
        strcpy(s, "   N      = Nur gesetzliche Feiertage");
        print_text (fp, s, INternal);
        strcpy(s, "    [MOD] = "DES_LIT"   Absteigend sortiert");
        print_text (fp, s, INternal);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s, INternal);
      case SYM_EXCLUDE_HD_TITLE:
        sprintf(s, SWITCH"X        %s", get_longopt_description (SYM_EXCLUDE_HD_TITLE, TRUE));
        print_text (fp, s, INternal);
        strcpy(s, "          Ewige Feiertagsliste ohne "UUE"berschrift ausgeben");
        print_text (fp, s, INternal);
      default:
        ;   /* Void */
    }
#  if USE_RC
   if (longopt_symbolic == SYM_NIL)
    {
      print_text (fp, s, INternal);
      sprintf(s, "+++ TERMINWARNUNGEN +++");
      print_text (fp, s, INternal);
      print_text (fp, s, INternal);
    }
   switch (longopt_symbolic)
    {
      case SYM_NIL:
      case SYM_LIST_OF_FIXED_DATES:
        sprintf(s, SWITCH"c|C[MOD] %s", get_longopt_description (SYM_LIST_OF_FIXED_DATES, TRUE));
        print_text (fp, s, INternal);
        strcpy(s, "          Benutze Standard Resourcendatei `"PRGR_RC_NAME"' f"UE"r Terminliste");
        print_text (fp, s, INternal);
        strcpy(s, "          Impliziert Warnungszeitraum:  Heute");
        print_text (fp, s, INternal);
        strcpy(s, " c        = Nur die Daten ausgeben, zu denen Termine vorliegen");
        print_text (fp, s, INternal);
        strcpy(s, "   C      = Auch die Daten ausgeben, zu denen keine Termine vorliegen");
        print_text (fp, s, INternal);
      default:
        ;   /* Void */
    }
   if (longopt_symbolic == SYM_NIL)
    {
      strcpy(s, "    [MOD] = Einer oder mehr der folgenden Modifizierer; hier markiert mit #");
      print_text (fp, s, INternal);
      print_text (fp, s, INternal);
    }
   switch (longopt_symbolic)
    {
      case SYM_NIL:
      case SYM_GROUPING_TEXT:
        sprintf(s, "          %s", get_longopt_description (SYM_GROUPING_TEXT, TRUE));
        print_text (fp, s, INternal);
        strcpy(s, "          # g[MOD]       = Benutze Trenntext MOD f"UE"r tageweise Gruppierung");
        print_text (fp, s, INternal);
        print_text (fp, s, INternal);
      default:
        ;   /* Void */
    }
   if (longopt_symbolic == SYM_NIL)
    {
      print_text (fp, s, INternal);
      strcpy(s, "          1. Sortierordnung des Textes");
      print_text (fp, s, INternal);
    }
   switch (longopt_symbolic)
    {
      case SYM_NIL:
      case SYM_DESC_FIXED_DATES:
        sprintf(s, "          %s", get_longopt_description (SYM_DESC_FIXED_DATES, TRUE));
        print_text (fp, s, INternal);
        strcpy(s, "          # "DES_LIT"            = Absteigend sortiert");
        print_text (fp, s, INternal);
      default:
        ;   /* Void */
    }
   if (longopt_symbolic == SYM_NIL)
    {
      print_text (fp, s, INternal);
      strcpy(s, "          2. Darstellung des Textes");
      print_text (fp, s, INternal);
    }
   switch (longopt_symbolic)
    {
      case SYM_NIL:
      case SYM_INCLUDE_FILENAME:
        sprintf(s, "          %s", get_longopt_description (SYM_INCLUDE_FILENAME, TRUE));
        print_text (fp, s, INternal);
        strcpy(s, "          # a            = Herkunft der Terminwarnung ausgeben");
        print_text (fp, s, INternal);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s, INternal);
      case SYM_INCLUDE_HOLIDAY:
        sprintf(s, "          %s", get_longopt_description (SYM_INCLUDE_HOLIDAY, TRUE));
        print_text (fp, s, INternal);
        strcpy(s, "          # e            = Gesetzliche Feiertage und Erinnerungstage einf"UE"gen");
        print_text (fp, s, INternal);
        strcpy(s, "          # E            = Nur gesetzliche Feiertage einf"UE"gen");
        print_text (fp, s, INternal);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s, INternal);
      case SYM_INCLUDE_WEEK_NO:
        sprintf(s, "          %s", get_longopt_description (SYM_INCLUDE_WEEK_NO, TRUE));
        print_text (fp, s, INternal);
        strcpy(s, "          # k            = ISO-Wochennummer ausgeben");
        print_text (fp, s, INternal);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s, INternal);
      case SYM_OMIT_DATE_PART:
        sprintf(s, "          %s", get_longopt_description (SYM_OMIT_DATE_PART, TRUE));
        print_text (fp, s, INternal);
        strcpy(s, "          # o            = Datumfeld nur einmal ausgeben");
        print_text (fp, s, INternal);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s, INternal);
      case SYM_EXCLUDE_RC_TITLE:
        sprintf(s, "          %s", get_longopt_description (SYM_EXCLUDE_RC_TITLE, TRUE));
        print_text (fp, s, INternal);
        strcpy(s, "          # x            = Terminwarnungsliste ohne "UUE"berschrift ausgeben");
        print_text (fp, s, INternal);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s, INternal);
      case SYM_INCLUDE_CONS_NO:
        sprintf(s, "          %s", get_longopt_description (SYM_INCLUDE_CONS_NO, TRUE));
        print_text (fp, s, INternal);
        strcpy(s, "          # z            = Laufende Postennummer ausgeben");
        print_text (fp, s, INternal);
      default:
        ;   /* Void */
    }
   if (longopt_symbolic == SYM_NIL)
    {
      print_text (fp, s, INternal);
      strcpy(s, "          3. Warnungszeitraum");
      print_text (fp, s, INternal);
    }
   switch (longopt_symbolic)
    {
      case SYM_NIL:
      case SYM_INCLUDE_TODAY:
        sprintf(s, "          %s", get_longopt_description (SYM_INCLUDE_TODAY, TRUE));
        print_text (fp, s, INternal);
        strcpy(s, "          # d            = Aktuelles Datum einschliessen bei Datumliste");
        print_text (fp, s, INternal);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s, INternal);
      case SYM_LIST_MODE:
        sprintf(s, "          %s", get_longopt_description (SYM_LIST_MODE, TRUE));
        print_text (fp, s, INternal);
        strcpy(s, "          # l            = Datumliste anstelle Einzeldatum");
        print_text (fp, s, INternal);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s, INternal);
      default:
        ;   /* Void */
    }
   switch (longopt_symbolic)
    {
      case SYM_NIL:
      case SYM_PERIOD:
        sprintf(s, "          %s", get_longopt_description (SYM_PERIOD, TRUE));
        print_text (fp, s, INternal);
        strcpy(s, "          # Nd           = Einzelner absoluter Tag N");
        print_text (fp, s, INternal);
        sprintf(s, "          # %cdN          = Einzelner absoluter Tag N",
                RC_NWD_CHAR);
        print_text (fp, s, INternal);
        print_text (fp, s, INternal);
        strcpy(s, "          # NMOD         = Einzelner Tag N relativ zu heute");
        print_text (fp, s, INternal);
        strcpy(s, "             MOD           = "ASC_LIT"   Vorw"AE"rts");
        print_text (fp, s, INternal);
        strcpy(s, "                           = "DES_LIT"   R"UE"ckw"AE"rts");
        print_text (fp, s, INternal);
        print_text (fp, s, INternal);
        strcpy(s, "          # Nw           = Gesamte Woche N");
        print_text (fp, s, INternal);
        strcpy(s, "                           N = 0        1'te Woche / letzte Woche im Vorjahr");
        print_text (fp, s, INternal);
        strcpy(s, "                           N = 1...52   1'te...52'te Woche (stets)");
        print_text (fp, s, INternal);
        strcpy(s, "                           N = 53       53'te Woche (manchmal)");
        print_text (fp, s, INternal);
        strcpy(s, "                           N = 99       Letzte Woche");
        print_text (fp, s, INternal);
        print_text (fp, s, INternal);
        strcpy(s, "          # `mmtt'       = Einzelner Tag `tt' im Monat `mm'");
        print_text (fp, s, INternal);
        print_text (fp, s, INternal);
        strcpy(s, "          # `mmwww'N     = Einzelner N'ter Wochentag `www' im Monat `mm'");
        print_text (fp, s, INternal);
        strcpy(s, "                           N = 1...4   1'ter...4'ter Wochentag `www' (stets)");
        print_text (fp, s, INternal);
        strcpy(s, "                           N = 5       5'ter Wochentag `www' (manchmal)");
        print_text (fp, s, INternal);
        strcpy(s, "                           N = 9       Letzter Wochentag `www'");
        print_text (fp, s, INternal);
        print_text (fp, s, INternal);
        sprintf(s, "          # %cdN`www'     = Einzelner N'ter Wochentag `www'",
                RC_NWD_CHAR);
        print_text (fp, s, INternal);
        strcpy(s, "                           N = 1...51   1'ter...51'ter Wochentag `www' (stets)");
        print_text (fp, s, INternal);
        strcpy(s, "                           N = 52|53    52|53'ter Wochentag `www' (manchmal)");
        print_text (fp, s, INternal);
        strcpy(s, "                           N = 99       Letzter Wochentag `www'");
        print_text (fp, s, INternal);
        print_text (fp, s, INternal);
        sprintf(s, "          # %cwN`www'     = Einzelner Wochentag `www' der N'ten Woche",
                RC_NWD_CHAR);
        print_text (fp, s, INternal);
        strcpy(s, "                           N = 0        `www' der nicht in der 1'ten Woche ist");
        print_text (fp, s, INternal);
        strcpy(s, "                           N = 1...51   `www' der 1'ten...51'ten Woche (stets)");
        print_text (fp, s, INternal);
        strcpy(s, "                           N = 52|53    `www' der 52|53'ten Woche (manchmal)");
        print_text (fp, s, INternal);
        strcpy(s, "                           N = 99       `www' der letzten Woche");
        print_text (fp, s, INternal);
        print_text (fp, s, INternal);
        sprintf(s, "          # %ce[["ASC_LIT"|"DES_LIT"]N]   = "
                "Einzelner Tag N relativ zu Ostersonntag", RC_HDY_CHAR);
        print_text (fp, s, INternal);
        print_text (fp, s, INternal);
        sprintf(s, "          # %ce["ASC_LIT"|"DES_LIT"]N`www'= "
                "Einzelner N'ter Wochentag relativ zu Ostersonntag", RC_HDY_CHAR);
        print_text (fp, s, INternal);
        print_text (fp, s, INternal);
        sprintf(s, "          # %cv[["ASC_LIT"|"DES_LIT"]N]   = "
                "Einzelner Tag N relativ zur Datumvariablen", RC_HDY_CHAR);
        print_text (fp, s, INternal);
        print_text (fp, s, INternal);
        sprintf(s, "          # %cv["ASC_LIT"|"DES_LIT"]N`www'= "
                "Einzelner N'ter Wochentag relativ zur Datumvariablen", RC_HDY_CHAR);
        print_text (fp, s, INternal);
        print_text (fp, s, INternal);
        strcpy(s, "          # t|T          = Datumliste von morgen");
        print_text (fp, s, INternal);
        print_text (fp, s, INternal);
        strcpy(s, "          # w|W[MOD]     = Datumliste der gesamten Woche");
        print_text (fp, s, INternal);
        strcpy(s, "               [MOD]       = "ASC_LIT"   Liste von morgen bis Ende der Woche");
        print_text (fp, s, INternal);
        strcpy(s, "                           = "DES_LIT"   Liste von gestern bis Anfang der Woche");
        print_text (fp, s, INternal);
        print_text (fp, s, INternal);
        strcpy(s, "          # m|M[MOD]     = Datumliste des gesamten Monats");
        print_text (fp, s, INternal);
        strcpy(s, "               [MOD]       = "ASC_LIT"   Liste von morgen bis Ende des Monats");
        print_text (fp, s, INternal);
        strcpy(s, "                           = "DES_LIT"   Liste von gestern bis Anfang der Monats");
        print_text (fp, s, INternal);
        print_text (fp, s, INternal);
        strcpy(s, "          # y|Y[MOD]     = Liste des gesamten Jahres");
        print_text (fp, s, INternal);
        strcpy(s, "               [MOD]       = "ASC_LIT"   Liste von morgen bis Ende des Jahres");
        print_text (fp, s, INternal);
        strcpy(s, "                           = "DES_LIT"   Liste von gestern bis Anfang des Jahres");
        print_text (fp, s, INternal);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s, INternal);
      case SYM_RESOURCE_FILE:
        sprintf(s, SWITCH"f|F ARG  %s", get_longopt_description (SYM_RESOURCE_FILE, TRUE));
        print_text (fp, s, INternal);
        strcpy(s, "          Benutze alternative Datei(en) anstelle Standard Resourcendatei");
        print_text (fp, s, INternal);
        strcpy(s, "          Impliziert Warnungszeitraum:  Heute");
        print_text (fp, s, INternal);
        strcpy(s, " f        = Nur die Daten ausgeben, zu denen Termine vorliegen");
        print_text (fp, s, INternal);
        strcpy(s, "   F      = Auch die Daten ausgeben, zu denen keine Termine vorliegen");
        print_text (fp, s, INternal);
        strcpy(s, "     ARG  = Einzelne Datei oder durch `"RC_FNAME_SEP
               "' Zeichen separierte Liste von Dateien");
        print_text (fp, s, INternal);
      default:
          ;   /* Void */
    }
   if (longopt_symbolic == SYM_NIL)
    {
      print_text (fp, s, INternal);
      print_text (fp, s, INternal);
      if (print_hls)
        strcpy(s, ehls2s.seq);
      sprintf(s2, "%cDATUM", RC_ADATE_CHAR);
      strcat(s, s2);
      if (print_hls)
        strcat(s, ehls2e.seq);
      print_text (fp, s, INternal);
      strcpy(s, "Vorgegebenes `DATUM' anstelle des heutigen Datums verwenden");
      print_text (fp, s, INternal);
      sprintf(s, "Datumformat:  `"Y_LIT2"[mm[tt|www[N]]]', `"Y_LIT2"%c%c|dvar[["ASC_LIT"|"
              DES_LIT"]N[www]]', `"Y_LIT2"%cdN[www]'", RC_HDY_CHAR, RC_EASTER_CHAR, RC_NWD_CHAR);
      print_text (fp, s, INternal);
      sprintf(s, "              `"Y_LIT2"%cwN[www]', `Monatsname[tt]', `Wochentagsname[N]'"
              " oder `tt'", RC_NWD_CHAR);
      print_text (fp, s, INternal);
    }
#  endif /* USE_RC */
   if (longopt_symbolic == SYM_NIL)
    {
      print_text (fp, s, INternal);
      print_text (fp, s, INternal);
      if (print_hls)
        strcpy(s, ehls2s.seq);
      sprintf(s2, "%cDATEI", RSP_CHAR);
      strcat(s, s2);
      if (print_hls)
        strcat(s, ehls2e.seq);
      print_text (fp, s, INternal);
      strcpy(s, "L"AE"dt Optionen und Kommandos aus `DATEI' vor");
      print_text (fp, s, INternal);
      print_text (fp, s, INternal);
      print_text (fp, s, INternal);
      if (print_hls)
        strcpy(s, ehls2s.seq);
      strcat(s, "KOMMANDO");
      if (print_hls)
        strcat(s, ehls2e.seq);
      print_text (fp, s, INternal);
      sprintf(s, "mm       = Monat im Bereich:  %d...%d", MONTH_MIN, MONTH_MAX);
      print_text (fp, s, INternal);
      strcpy (s, "                       oder:  Monatsname | "MONTH3_LIT" | "
              MONTH3_LIT""MONTH3_LIT" | "MONTH3_LIT""ASC_LIT" | "MONTH3_LIT""DES_LIT);
      print_text (fp, s, INternal);
      print_text (fp, s, INternal);
      strcpy(s, "           Liste:    mm["YEAR_SEP""Y_LIT2"]"
             MLIST_SEP"..."MLIST_SEP"mm["YEAR_SEP""Y_LIT2"]");
      print_text (fp, s, INternal);
      strcpy(s, "           Bereich:  mm["YEAR_SEP""Y_LIT2"]"
             MRANGE_SEP"mm["YEAR_SEP""Y_LIT2"]");
      print_text (fp, s, INternal);
      print_text (fp, s, INternal);
      sprintf(s, Y_LIT2"     = Jahr  im Bereich:  %d...%d", YEAR_MIN, YEAR_MAX);
      print_text (fp, s, INternal);
      print_text (fp, s, INternal);
      strcpy(s, "           Liste:    [mm"FYEAR_SEP"]"Y_LIT2
             ""YLIST_SEP"..."YLIST_SEP"[mm"FYEAR_SEP"]"Y_LIT2);
      print_text (fp, s, INternal);
      strcpy(s, "           Bereich:  [mm"FYEAR_SEP"]"Y_LIT2
             ""YRANGE_SEP"[mm"FYEAR_SEP"]"Y_LIT2);
      print_text (fp, s, INternal);
      print_text (fp, s, INternal);
      print_text (fp, s, INternal);
      sprintf(s, "   +++ Bei zweistelliger Jahresangabe wird NICHT"
              " von %2d"Y_LIT" ausgegangen +++", act_year/100);
    }
#else /* !USE_GER */
   switch (longopt_symbolic)
    {
      case SYM_NIL:
      case SYM_HELP:
        sprintf(s, SWITCH"?        %s", get_longopt_description (SYM_HELP, TRUE));
        print_text (fp, s, INternal);
        sprintf(s, SWITCH"h        %s", get_longopt_description (SYM_HELP, TRUE));
        print_text (fp, s, INternal);
        strcpy(s, "          Display help text and quit program");
        print_text (fp, s, INternal);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s, INternal);
      case SYM_LONG_HELP1:
      case SYM_LONG_HELP2:
        sprintf(s, SWITCH"??       %s", get_longopt_description (SYM_LONG_HELP1, TRUE));
        print_text (fp, s, INternal);
        sprintf(s, SWITCH"hh       %s", get_longopt_description (SYM_LONG_HELP1, TRUE));
        print_text (fp, s, INternal);
        sprintf(s, "          %s", get_longopt_description (SYM_LONG_HELP2, TRUE));
        print_text (fp, s, INternal);
        strcpy(s, "          Display extended help text and quit program");
        print_text (fp, s, INternal);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s, INternal);
      case SYM_LICENSE1:
      case SYM_LICENSE2:
      case SYM_LICENSE3:
        sprintf(s, SWITCH"L        %s", get_longopt_description (SYM_LICENSE1, TRUE));
        print_text (fp, s, INternal);
        sprintf(s, "          %s", get_longopt_description (SYM_LICENSE2, TRUE));
        print_text (fp, s, INternal);
        sprintf(s, "          %s", get_longopt_description (SYM_LICENSE3, TRUE));
        print_text (fp, s, INternal);
        strcpy(s, "          Display software license and quit program");
        print_text (fp, s, INternal);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s, INternal);
      case SYM_VERSION:
        sprintf(s, SWITCH"V        %s", get_longopt_description (SYM_VERSION, TRUE));
        print_text (fp, s, INternal);
        strcpy(s, "          Display version number and quit program");
        print_text (fp, s, INternal);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s, INternal);
      case SYM_RESPONSE_FILE:
        sprintf(s, SWITCH"R ARG    %s", get_longopt_description (SYM_RESPONSE_FILE, TRUE));
        print_text (fp, s, INternal);
        sprintf(s, "          Create response file for the `%cFILE' option", RSP_CHAR);
        print_text (fp, s, INternal);
        strcpy(s, "   ARG    = Store arguments of command line in file ARG");
        print_text (fp, s, INternal);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s, INternal);
#  ifdef GCAL_SHELL
      case SYM_SCRIPT_FILE:
        sprintf(s, SWITCH"S ARG    %s", get_longopt_description (SYM_SCRIPT_FILE, TRUE));
        print_text (fp, s, INternal);
        sprintf(s, "          Create shell script which contains the arguments of command line");
        print_text (fp, s, INternal);
        strcpy(s, "   ARG    = File name of the shell script");
        print_text (fp, s, INternal);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s, INternal);
#endif
#  if USE_RC
      case SYM_DATE_VARIABLE1:
      case SYM_DATE_VARIABLE2:
        sprintf(s, SWITCH"v ARG    %s", get_longopt_description (SYM_DATE_VARIABLE1, TRUE));
        print_text (fp, s, INternal);
        sprintf(s, "          %s", get_longopt_description (SYM_DATE_VARIABLE2, TRUE));
        print_text (fp, s, INternal);
        strcpy(s, "          Define global date variable(s) \"dvar->a|b|c|d|f|...|z\"");
        print_text (fp, s, INternal);
        strcpy(s, "   ARG    = Definition of `dvar"RC_DVAR_ASSIGN
               "mmdd' separated by `"SEP"' characters");
        print_text (fp, s, INternal);
        strcpy(s, "            e.g.  "SWITCH"v a"RC_DVAR_ASSIGN"1127"SEP"b"RC_DVAR_ASSIGN
               "054   Set `a' to Nov 27 and `b' to May 4");
        print_text (fp, s, INternal);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s, INternal);
#  endif
      case SYM_DEBUG:
        sprintf(s, "          %s", get_longopt_description (SYM_DEBUG, TRUE));
        print_text (fp, s, INternal);
        strcpy(s, "          Display some debug informations");
        print_text (fp, s, INternal);
        strcpy(s, "  [ARG]   = internal    Warnings if program internal maximums are reached");
        print_text (fp, s, INternal);
        strcpy(s, "          = handled     Like `internal' and file names which are handled");
        print_text (fp, s, INternal);
        strcpy(s, "          = unhandled   Like `internal' und file names which are unhandled");
        print_text (fp, s, INternal);
        strcpy(s, "          = all         Like `handled' and `unhandled' together");
        print_text (fp, s, INternal);
        strcpy(s, "          = abort       Like `all' and abort if file name can't be handled");
        print_text (fp, s, INternal);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s, INternal);
      case SYM_TYPE_OF_CALENDAR:
        sprintf(s, SWITCH"i[MOD]   %s", get_longopt_description (SYM_TYPE_OF_CALENDAR, TRUE));
        print_text (fp, s, INternal);
        strcpy(s, "          Use special format for calendar sheet");
        print_text (fp, s, INternal);
        strcat(s, "  [MOD]   = -   Use standard format for calendar sheet");
        print_text (fp, s, INternal);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s, INternal);
      case SYM_SUPPRESS_CALENDAR:
        sprintf(s, SWITCH"u        %s", get_longopt_description (SYM_SUPPRESS_CALENDAR, TRUE));
        print_text (fp, s, INternal);
        strcpy(s, "          Suppress output of calendar sheet explicitly");
        print_text (fp, s, INternal);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s, INternal);
#  if USE_PAGER
      case SYM_PAGER:
        sprintf(s, SWITCH"p        %s", get_longopt_description (SYM_PAGER, TRUE));
        print_text (fp, s, INternal);
#    ifdef GCAL_EPAGER
        if (ext_pager != (char *)NULL)
          sprintf(s, "          Pass output thru external `%s' pager",
                  (*ext_pager == *DIR_SEP) ? strrchr(ext_pager, *DIR_SEP)+1 : ext_pager);
        else
          strcpy(s, "          Pass output thru simple, internal pager");
#    else /* !GCAL_EPAGER */
        strcpy(s, "          Pass output thru simple, internal pager");
#    endif /* !GCAL_EPAGER */
        print_text (fp, s, INternal);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s, INternal);
#  endif
      case SYM_DISABLE_HIGHLIGHTING:
        sprintf(s, SWITCH"H no     %s", get_longopt_description (SYM_DISABLE_HIGHLIGHTING, TRUE));
        print_text (fp, s, INternal);
        sprintf(s, "          %s=no",  get_longopt_description (SYM_HIGHLIGHTING, FALSE));
        print_text (fp, s, INternal);
        strcpy(s, "          Disable highlighting of text, holiday resp., actual day");
        print_text (fp, s, INternal);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s, INternal);
      case SYM_FORCE_HIGHLIGHTING:
        sprintf(s, SWITCH"H yes    %s", get_longopt_description (SYM_FORCE_HIGHLIGHTING, TRUE));
        print_text (fp, s, INternal);
        sprintf(s, "          %s=yes",  get_longopt_description (SYM_HIGHLIGHTING, FALSE));
        print_text (fp, s, INternal);
        strcpy(s, "          Forces highlighting sequences if output is redirected/piped");
        print_text (fp, s, INternal);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s, INternal);
      case SYM_HIGHLIGHTING:
        sprintf(s, SWITCH"H ARG    %s", get_longopt_description (SYM_HIGHLIGHTING, TRUE));
        print_text (fp, s, INternal);
        strcpy(s, "          Set highlighting sequence pairs 1 (=actual day) and 2 (=holiday)");
        print_text (fp, s, INternal);
        strcpy(s, "   ARG    = Highlighting sequence pairs separated by `"SEP"' characters");
        print_text (fp, s, INternal);
        strcpy(s, "            e.g.  "SWITCH"H \\x2"SEP"\\x"
               "AE   Use hex values 2 and AE for sequence 1");
        print_text (fp, s, INternal);
        strcpy(s, "            e.g.  "SWITCH"H "SEP""SEP"*"SEP
               "*      Use characters `*' and `*' for sequence 2");
        print_text (fp, s, INternal);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s, INternal);
      case SYM_BLOCKS:
        sprintf(s, SWITCH"b ARG    %s", get_longopt_description (SYM_BLOCKS, TRUE));
        print_text (fp, s, INternal);
        strcpy(s, "          Modify format of year calendar");
        print_text (fp, s, INternal);
        strcpy(s, "   ARG    = 1|2|3|4|6|12   Number of blocks");
        print_text (fp, s, INternal);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s, INternal);
      case SYM_CALENDAR_DATES:
        sprintf(s, SWITCH"j[MOD]   %s", get_longopt_description (SYM_CALENDAR_DATES, TRUE));
        print_text (fp, s, INternal);
        strcpy(s, "          Use Julian dates in calendar sheet");
        print_text (fp, s, INternal);
        strcpy(s, "  [MOD]   = b   Use both date notations (standard + Julian dates)");
        print_text (fp, s, INternal);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s, INternal);
      case SYM_HOLIDAY_DATES:
        sprintf(s, SWITCH"jn[MOD]  %s", get_longopt_description (SYM_HOLIDAY_DATES, TRUE));
        print_text (fp, s, INternal);
        strcpy(s, "          Use Julian dates in eternal holiday list");
        print_text (fp, s, INternal);
        strcpy(s, "   [MOD]  = b   Use both date notations (standard + Julian dates)");
        print_text (fp, s, INternal);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s, INternal);
#if USE_RC
      case SYM_FIXED_DATES:
        sprintf(s, SWITCH"jc[MOD]  %s", get_longopt_description (SYM_FIXED_DATES, TRUE));
        print_text (fp, s, INternal);
        strcpy(s, "          Use Julian dates in fixed date warning list");
        print_text (fp, s, INternal);
        strcpy(s, "   [MOD]  = b   Use both date notations (standard + Julian dates)");
        print_text (fp, s, INternal);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s, INternal);
#endif
      case SYM_STARTING_DAY:
        sprintf(s, SWITCH"s ARG    %s", get_longopt_description (SYM_STARTING_DAY, TRUE));
        print_text (fp, s, INternal);
        strcpy(s, "          Set starting day of week");
        print_text (fp, s, INternal);
        sprintf(s, "   ARG    = 0 | %d|%s|%d|%s|...|%d|%s",
                DAY_MIN, short3_day_name (DAY_MIN),
                DAY_MIN+1, short3_day_name (DAY_MIN+1),
                DAY_MAX, short3_day_name (DAY_MAX));
        print_text (fp, s, INternal);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s, INternal);
#  ifdef GCAL_EMAIL
      case SYM_MAIL:
        sprintf(s, SWITCH"m ARG    %s", get_longopt_description (SYM_MAIL, TRUE));
        print_text (fp, s, INternal);
        strcpy(s, "          Send output via `"MAIL_PRGR"' program to user");
        print_text (fp, s, INternal);
        strcpy(s, "   ARG    = Email Address");
        print_text (fp, s, INternal);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s, INternal);
#  endif
      case SYM_DESC_HOLIDAY_LIST:
      case SYM_HOLIDAY_LIST:
        sprintf(s, SWITCH"n|N[MOD] %s", get_longopt_description (SYM_DESC_HOLIDAY_LIST, TRUE));
        print_text (fp, s, INternal);
        sprintf(s, "          %s", get_longopt_description (SYM_HOLIDAY_LIST, TRUE));
        print_text (fp, s, INternal);
        sprintf(s, "          Display eternal holiday list "
                "(Year in range: %d...%d)", EASTER_MIN, EASTER_MAX);
        print_text (fp, s, INternal);
        strcpy(s, " n        = Legal days and memorial days");
        print_text (fp, s, INternal);
        strcpy(s, "   N      = Legal days only");
        print_text (fp, s, INternal);
        strcpy(s, "    [MOD] = "DES_LIT"   Descending sort order");
        print_text (fp, s, INternal);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s, INternal);
      case SYM_EXCLUDE_HD_TITLE:
        sprintf(s, SWITCH"X        %s", get_longopt_description (SYM_EXCLUDE_HD_TITLE, TRUE));
        print_text (fp, s, INternal);
        strcpy(s, "          Exclude title of eternal holiday list");
        print_text (fp, s, INternal);
      default:
        ;   /* Void */
    }
#  if USE_RC
   if (longopt_symbolic == SYM_NIL)
    {
      print_text (fp, s, INternal);
      sprintf(s, "+++ FIXED DATE WARNINGS +++");
      print_text (fp, s, INternal);
      print_text (fp, s, INternal);
    }
   switch (longopt_symbolic)
    {
      case SYM_NIL:
      case SYM_LIST_OF_FIXED_DATES:
        sprintf(s, SWITCH"c|C[MOD] %s", get_longopt_description (SYM_LIST_OF_FIXED_DATES, TRUE));
        print_text (fp, s, INternal);
        strcpy(s, "          Use standard resource file `"PRGR_RC_NAME"' for fixed dates list");
        print_text (fp, s, INternal);
        strcpy(s, "          Implies warning period:  Today");
        print_text (fp, s, INternal);
        strcpy(s, " c        = Display only those dates, for which fixed dates exists");
        print_text (fp, s, INternal);
        strcpy(s, "   C      = Display those dates, for which fixed dates doesn't exit, too");
        print_text (fp, s, INternal);
      default:
        ;   /* Void */
    }
   if (longopt_symbolic == SYM_NIL)
    {
      strcpy(s, "    [MOD] = One or more of the following modifiers which are marked by #");
      print_text (fp, s, INternal);
      print_text (fp, s, INternal);
    }
   switch (longopt_symbolic)
    {
      case SYM_NIL:
      case SYM_GROUPING_TEXT:
        sprintf(s, "          %s", get_longopt_description (SYM_GROUPING_TEXT, TRUE));
        print_text (fp, s, INternal);
        strcpy(s, "          # g[MOD]       = Group fixed date warnings by day using text MOD");
        print_text (fp, s, INternal);
        print_text (fp, s, INternal);
      default:
        ;   /* Void */
    }
   if (longopt_symbolic == SYM_NIL)
    {
      print_text (fp, s, INternal);
      strcpy(s, "          1. Sorting oder of text");
      print_text (fp, s, INternal);
    }
   switch (longopt_symbolic)
    {
      case SYM_NIL:
      case SYM_DESC_FIXED_DATES:
        sprintf(s, "          %s", get_longopt_description (SYM_DESC_FIXED_DATES, TRUE));
        print_text (fp, s, INternal);
        strcpy(s, "          # "DES_LIT"            = Descending sort order");
        print_text (fp, s, INternal);
      default:
        ;   /* Void */
    }
   if (longopt_symbolic == SYM_NIL)
    {
      print_text (fp, s, INternal);
      strcpy(s, "          2. Representation of text");
      print_text (fp, s, INternal);
    }
   switch (longopt_symbolic)
    {
      case SYM_NIL:
      case SYM_INCLUDE_FILENAME:
        sprintf(s, "          %s", get_longopt_description (SYM_INCLUDE_FILENAME, TRUE));
        print_text (fp, s, INternal);
        strcpy(s, "          # a            = Display origin of fixed date warning");
        print_text (fp, s, INternal);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s, INternal);
      case SYM_INCLUDE_HOLIDAY:
        sprintf(s, "          %s", get_longopt_description (SYM_INCLUDE_HOLIDAY, TRUE));
        print_text (fp, s, INternal);
        strcpy(s, "          # e            = Include legal days and memorial days");
        print_text (fp, s, INternal);
        strcpy(s, "          # E            = Include legal days only");
        print_text (fp, s, INternal);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s, INternal);
      case SYM_INCLUDE_WEEK_NO:
        sprintf(s, "          %s", get_longopt_description (SYM_INCLUDE_WEEK_NO, TRUE));
        print_text (fp, s, INternal);
        strcpy(s, "          # k            = Display ISO week number");
        print_text (fp, s, INternal);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s, INternal);
      case SYM_OMIT_DATE_PART:
        sprintf(s, "          %s", get_longopt_description (SYM_OMIT_DATE_PART, TRUE));
        print_text (fp, s, INternal);
        strcpy(s, "          # o            = Omit repeating date part of fixed date warnings");
        print_text (fp, s, INternal);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s, INternal);
      case SYM_EXCLUDE_RC_TITLE:
        sprintf(s, "          %s", get_longopt_description (SYM_EXCLUDE_RC_TITLE, TRUE));
        print_text (fp, s, INternal);
        strcpy(s, "          # x            = Exclude title of fixed date warning list");
        print_text (fp, s, INternal);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s, INternal);
      case SYM_INCLUDE_CONS_NO:
        sprintf(s, "          %s", get_longopt_description (SYM_INCLUDE_CONS_NO, TRUE));
        print_text (fp, s, INternal);
        strcpy(s, "          # z            = Display consecutive number of fixed date warnings");
        print_text (fp, s, INternal);
      default:
        ;   /* Void */
    }
   if (longopt_symbolic == SYM_NIL)
    {
      print_text (fp, s, INternal);
      strcpy(s, "          3. Respected warning period");
      print_text (fp, s, INternal);
    }
   switch (longopt_symbolic)
    {
      case SYM_NIL:
      case SYM_INCLUDE_TODAY:
        sprintf(s, "          %s", get_longopt_description (SYM_INCLUDE_TODAY, TRUE));
        print_text (fp, s, INternal);
        strcpy(s, "          # d            = Include actual date if list of periods is generated");
        print_text (fp, s, INternal);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s, INternal);
      case SYM_LIST_MODE:
        sprintf(s, "          %s", get_longopt_description (SYM_LIST_MODE, TRUE));
        print_text (fp, s, INternal);
        strcpy(s, "          # l            = Generate list of periods instead of a single period");
        print_text (fp, s, INternal);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s, INternal);
      default:
        ;   /* Void */
    }
   switch (longopt_symbolic)
    {
      case SYM_NIL:
      case SYM_PERIOD:
        sprintf(s, "          %s", get_longopt_description (SYM_PERIOD, TRUE));
        print_text (fp, s, INternal);
        strcpy(s, "          # Nd           = Single absolute day N");
        print_text (fp, s, INternal);
        sprintf(s, "          # %cdN          = Single absolute day N",
                RC_NWD_CHAR);
        print_text (fp, s, INternal);
        print_text (fp, s, INternal);
        strcpy(s, "          # NMOD         = Single day N relative to today");
        print_text (fp, s, INternal);
        strcpy(s, "             MOD           = "ASC_LIT"   Forwards");
        print_text (fp, s, INternal);
        strcpy(s, "                           = "DES_LIT"   Backwards");
        print_text (fp, s, INternal);
        print_text (fp, s, INternal);
        strcpy(s, "          # Nw           = Complete week N");
        print_text (fp, s, INternal);
        strcpy(s, "                           N = 0        1'st week / last week of previous year");
        print_text (fp, s, INternal);
        strcpy(s, "                           N = 1...52   1'st...52'nd week (always)");
        print_text (fp, s, INternal);
        strcpy(s, "                           N = 53       53'rd week (sometimes)");
        print_text (fp, s, INternal);
        strcpy(s, "                           N = 99       Last week");
        print_text (fp, s, INternal);
        print_text (fp, s, INternal);
        strcpy(s, "          # `mmdd'       = Single day `dd' of month `mm'");
        print_text (fp, s, INternal);
        print_text (fp, s, INternal);
        strcpy(s, "          # `mmwww'N     = Single N'th weekday `www' of month `mm'");
        print_text (fp, s, INternal);
        strcpy(s, "                           N = 1...4   1'st...4'th weekday `www' (always)");
        print_text (fp, s, INternal);
        strcpy(s, "                           N = 5       5'th weekday `www' (sometimes)");
        print_text (fp, s, INternal);
        strcpy(s, "                           N = 9       Last weekday `www'");
        print_text (fp, s, INternal);
        print_text (fp, s, INternal);
        sprintf(s, "          # %cdN`www'     = Single N'th weekday `www'",
                RC_NWD_CHAR);
        print_text (fp, s, INternal);
        strcpy(s, "                           N = 1...51   1'st...51'st weekday `www' (always)");
        print_text (fp, s, INternal);
        strcpy(s, "                           N = 52|53    52|53'rd weekday `www' (sometimes)");
        print_text (fp, s, INternal);
        strcpy(s, "                           N = 99       Last weekday `www'");
        print_text (fp, s, INternal);
        print_text (fp, s, INternal);
        sprintf(s, "          # %cwN`www'     = Single weekday `www' of N'th week",
                RC_NWD_CHAR);
        print_text (fp, s, INternal);
        strcpy(s, "                           N = 0        `www' which isn't located in 1'st week");
        print_text (fp, s, INternal);
        strcpy(s, "                           N = 1...51   `www' of 1'st...51'st week (always)");
        print_text (fp, s, INternal);
        strcpy(s, "                           N = 52|53    `www' of 52|53'rd week (sometimes)");
        print_text (fp, s, INternal);
        strcpy(s, "                           N = 99       `www' of last week");
        print_text (fp, s, INternal);
        print_text (fp, s, INternal);
        sprintf(s, "          # %ce[["ASC_LIT"|"DES_LIT"]N]   = "
                "Single day N relative to Easter Sunday", RC_HDY_CHAR);
        print_text (fp, s, INternal);
        print_text (fp, s, INternal);
        sprintf(s, "          # %ce["ASC_LIT"|"DES_LIT"]N`www'= "
                "Single N'th weekday relative to Easter Sunday", RC_HDY_CHAR);
        print_text (fp, s, INternal);
        print_text (fp, s, INternal);
        sprintf(s, "          # %cv[["ASC_LIT"|"DES_LIT"]N]   = "
                "Single day N relative to date variable", RC_HDY_CHAR);
        print_text (fp, s, INternal);
        print_text (fp, s, INternal);
        sprintf(s, "          # %cv["ASC_LIT"|"DES_LIT"]N`www'= "
                "Single N'th weekday relative to date variable", RC_HDY_CHAR);
        print_text (fp, s, INternal);
        print_text (fp, s, INternal);
        strcpy(s, "          # t|T          = List tomorrow");
        print_text (fp, s, INternal);
        print_text (fp, s, INternal);
        strcpy(s, "          # w|W[MOD]     = List complete week");
        print_text (fp, s, INternal);
        strcpy(s, "               [MOD]       = "ASC_LIT"   List tomorrow until ending day of week");
        print_text (fp, s, INternal);
        strcpy(s, "                           = "DES_LIT"   List yesterday until starting day of week");
        print_text (fp, s, INternal);
        print_text (fp, s, INternal);
        strcpy(s, "          # m|M[MOD]     = List complete month");
        print_text (fp, s, INternal);
        strcpy(s, "               [MOD]       = "ASC_LIT"   List tomorrow until starting day of month");
        print_text (fp, s, INternal);
        strcpy(s, "                           = "DES_LIT"   List yesterday until starting day of month");
        print_text (fp, s, INternal);
        print_text (fp, s, INternal);
        strcpy(s, "          # y|Y[MOD]     = List complete year");
        print_text (fp, s, INternal);
        strcpy(s, "               [MOD]       = "ASC_LIT"   List tomorrow until starting day of year");
        print_text (fp, s, INternal);
        strcpy(s, "                           = "DES_LIT"   List yesterday until ending day of year");
        print_text (fp, s, INternal);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s, INternal);
      case SYM_RESOURCE_FILE:
        sprintf(s, SWITCH"f|F ARG  %s", get_longopt_description (SYM_RESOURCE_FILE, TRUE));
        print_text (fp, s, INternal);
        strcpy(s, "          Use alternative file(s) instead of standard resource file");
        print_text (fp, s, INternal);
        strcpy(s, "          Implies warning period:  Today");
        print_text (fp, s, INternal);
        strcpy(s, " f        = Display only those dates, for which fixed dates exists");
        print_text (fp, s, INternal);
        strcpy(s, "   F      = Display those dates, for which fixed dates doesn't exit, too");
        print_text (fp, s, INternal);
        strcpy(s, "     ARG  = Single file or list of files separated by `"RC_FNAME_SEP"' character");
        print_text (fp, s, INternal);
      default:
          ;   /* Void */
    }
   if (longopt_symbolic == SYM_NIL)
    {
      print_text (fp, s, INternal);
      print_text (fp, s, INternal);
      if (print_hls)
        strcpy(s, ehls2s.seq);
      sprintf(s2, "%cDATE", RC_ADATE_CHAR);
      strcat(s, s2);
      if (print_hls)
        strcat(s, ehls2e.seq);
      print_text (fp, s, INternal);
      strcpy(s, "Use given `DATE' instead of todays date");
      print_text (fp, s, INternal);
      sprintf(s, "Date format:  `"Y_LIT2"[mm[dd|www[N]]]', `"Y_LIT2"%c%c|dvar[["ASC_LIT"|"
              DES_LIT"]N[www]]', `"Y_LIT2"%cdN[www]'", RC_HDY_CHAR, RC_EASTER_CHAR, RC_NWD_CHAR);
      print_text (fp, s, INternal);
      sprintf(s, "              `"Y_LIT2"%cwN[www]', `month name[dd]', `weekday name[N]'"
              " or `dd'", RC_NWD_CHAR);
      print_text (fp, s, INternal);
    }
#  endif /* USE_RC */
   if (longopt_symbolic == SYM_NIL)
    {
      print_text (fp, s, INternal);
      print_text (fp, s, INternal);
      if (print_hls)
        strcpy(s, ehls2s.seq);
      sprintf(s2, "%cFILE", RSP_CHAR);
      strcat(s, s2);
      if (print_hls)
        strcat(s, ehls2e.seq);
      print_text (fp, s, INternal);
      strcpy(s, "Preload options and commands from `FILE'");
      print_text (fp, s, INternal);
      print_text (fp, s, INternal);
      print_text (fp, s, INternal);
      if (print_hls)
        strcpy(s, ehls2s.seq);
      strcat(s, "COMMAND");
      if (print_hls)
        strcat(s, ehls2e.seq);
      print_text (fp, s, INternal);
      sprintf(s, "mm        = Month in range:  %d...%d", MONTH_MIN, MONTH_MAX);
      print_text (fp, s, INternal);
      strcpy (s, "                        or:  month name | "MONTH3_LIT" | "
              MONTH3_LIT""MONTH3_LIT" | "MONTH3_LIT""ASC_LIT" | "MONTH3_LIT""DES_LIT);
      print_text (fp, s, INternal);
      print_text (fp, s, INternal);
      strcpy(s, "            List:   mm["YEAR_SEP""Y_LIT2"]"
             MLIST_SEP"..."MLIST_SEP"mm["YEAR_SEP""Y_LIT2"]");
      print_text (fp, s, INternal);
      strcpy(s, "            Range:  mm["YEAR_SEP""Y_LIT2"]"
             MRANGE_SEP"mm["YEAR_SEP""Y_LIT2"]");
      print_text (fp, s, INternal);
      print_text (fp, s, INternal);
      sprintf(s, Y_LIT2"      = Year  in range:  %d...%d", YEAR_MIN, YEAR_MAX);
      print_text (fp, s, INternal);
      print_text (fp, s, INternal);
      strcpy(s, "            List:   [mm"FYEAR_SEP"]"Y_LIT2
             ""YLIST_SEP"..."YLIST_SEP"[mm"FYEAR_SEP"]"Y_LIT2);
      print_text (fp, s, INternal);
      strcpy(s, "            Range:  [mm"FYEAR_SEP"]"Y_LIT2
             ""YRANGE_SEP"[mm"FYEAR_SEP"]"Y_LIT2);
      print_text (fp, s, INternal);
      print_text (fp, s, INternal);
      print_text (fp, s, INternal);
      sprintf(s, "    +++ If you specify two digits for the year"
              " I DON'T ASSUME %2d"Y_LIT" +++", act_year/100);
    }
#endif /* !USE_GER */
   if (longopt_symbolic == SYM_NIL)
    {
      print_text (fp, s, INternal);
      my_help_tail_txt (fp);
    }
}



#ifdef ANSI_PROTO
PUBLIC void
my_basic_help (FILE *fp)
#else /* !ANSI_PROTO */
   PUBLIC void
my_basic_help (fp)
   FILE *fp;
#endif /* !ANSI_PROTO */
/*
   Prints the basic help text to file `fp' using the central
     output function `print_text()' and uses global text buffer
     `s' internally.
*/
{
   my_help_head_txt (fp);
#if USE_GER
   strcpy(s, SWITCH"h|hh   = Hilfetext; "SWITCH"L = Lizenz; "
          SWITCH"V = Version; "SWITCH"u = Kalender unterdr"UE"cken");
   print_text (fp, s, INternal);
   strcpy(s, SWITCH"i[-]   = Spezial-Kalenderformat; ");
#  if USE_PAGER
   strcat(s, SWITCH"p = Paginierer; ");
#  endif
   strcat(s, SWITCH"H yes = Mit Hervorhebungen");
   print_text (fp, s, INternal);
   strcpy(s, SWITCH"b ARG  = Jahreskalender in "
          "1|2|3|4|6|12 Bl"OE"cken; "SWITCH"H no = Ohne Hervorhebungen");
   print_text (fp, s, INternal);
   strcpy(s, SWITCH"j[]    = Ausgabe als Julianisches Datum (Modifizierer: ");
#  if USE_RC
   strcat(s, "[b n nb c cb])");
#  else /* !USE_RC */
   strcat(s, "[b n nb])");
#  endif /* !USE_RC */
   print_text (fp, s, INternal);
   sprintf(s, SWITCH"s ARG  = Starttag der Woche "
           "(Bereich: 0 | %d|%s|%d|%s|...|%d|%s)",
           DAY_MIN, short_day_name (DAY_MIN),
           DAY_MIN+1, short_day_name (DAY_MIN+1),
           DAY_MAX, short_day_name (DAY_MAX));
   print_text (fp, s, INternal);
   sprintf(s, SWITCH"n|N["DES_LIT"] = Ewige Feiertagsliste ausgeben "
           "(Jahr im Bereich: %d...%d)", EASTER_MIN, EASTER_MAX);
   print_text (fp, s, INternal);
#  if USE_RC
   strcpy(s, SWITCH"c|C[]  = Terminliste aus Datei `"PRGR_RC_NAME"'; "
          SWITCH"f|F ARG["RC_FNAME_SEP"ARG+...]=Benutze Datei ARG");
   print_text (fp, s, INternal);
   strcpy(s, "    ^^--> [g[] | ["DES_LIT"adeEkloxz][N[d|w|"ASC_LIT
          "|"DES_LIT"]|`mmtt'|`mmwww'N|t|[w|m|y["ASC_LIT"|"DES_LIT"]]]]");
   print_text (fp, s, INternal);
#  endif
   sprintf(s, "mm   = Monat im Bereich: %d...%d               "
           "Liste:   mm["YEAR_SEP""Y_LIT2"]"MLIST_SEP"..."MLIST_SEP
           "mm["YEAR_SEP""Y_LIT2"]", MONTH_MIN, MONTH_MAX);
   print_text (fp, s, INternal);
   strcpy(s, "                   oder: Monatsname|"MONTH3_LIT"["MONTH3_LIT"|"ASC_LIT"|"DES_LIT"]  "
          "Bereich: mm["YEAR_SEP""Y_LIT2"]"MRANGE_SEP"mm["YEAR_SEP""Y_LIT2"]");
   print_text (fp, s, INternal);
   sprintf(s, Y_LIT2" = Jahr  im Bereich: %d...%d%*s       "
           "Liste:   [mm"FYEAR_SEP"]"Y_LIT2""YLIST_SEP"..."YLIST_SEP
           "[mm"FYEAR_SEP"]"Y_LIT2, YEAR_MIN, YEAR_MAX, 6-len_year_max+4, "");
   print_text (fp, s, INternal);
   strcpy(s, "                                              "
          "Bereich: [mm"FYEAR_SEP"]"Y_LIT2""YRANGE_SEP"[mm"FYEAR_SEP"]"Y_LIT2);
   print_text (fp, s, INternal);
   sprintf(s, "   +++ Bei zweistelliger Jahresangabe wird NICHT"
           " von %2d"Y_LIT" ausgegangen +++", act_year/100);
#else /* !USE_GER */
   strcpy(s, SWITCH"h|hh   = Help screen; "SWITCH"L = License; "
          SWITCH"V = Version; "SWITCH"u = Suppress calendar sheet");
   print_text (fp, s, INternal);
   strcpy(s, SWITCH"i[-]   = Special calendar format; ");
#  if USE_PAGER
   strcat(s, SWITCH"p = Simple pager; ");
#  endif
   strcat(s, SWITCH"H yes = Use highlighting");
   print_text (fp, s, INternal);
   strcpy(s, SWITCH"b ARG  = Year calendar with 1|2|3|4|6|12 blocks; "
          SWITCH"H no = Disable highlighting");
   print_text (fp, s, INternal);
   strcpy(s, SWITCH"j[]    = Output of Julian dates (Modifiers: ");
#  if USE_RC
   strcat(s, "[b n nb c cb])");
#  else /* !USE_RC */
   strcat(s, "[b n nb])");
#  endif /* !USE_RC */
   print_text (fp, s, INternal);
   sprintf(s, SWITCH"s ARG  = Starting day of week "
           "(Range: 0 | %d|%s|%d|%s|...|%d|%s)",
           DAY_MIN, short3_day_name (DAY_MIN),
           DAY_MIN+1, short3_day_name (DAY_MIN+1),
           DAY_MAX, short3_day_name (DAY_MAX));
   print_text (fp, s, INternal);
   sprintf(s, SWITCH"n|N["DES_LIT"] = Display eternal holiday list "
           "(Year in range: %d...%d)", EASTER_MIN, EASTER_MAX);
   print_text (fp, s, INternal);
#  if USE_RC
   strcpy(s, SWITCH"c|C[]  = Fixed dates list of file `"PRGR_RC_NAME"'; "
          SWITCH"f|F ARG["RC_FNAME_SEP"ARG+...]=Use file ARG");
   print_text (fp, s, INternal);
   strcpy(s, "    ^^--> [g[] | ["DES_LIT"adeEkloxz][N[d|w|"ASC_LIT
          "|"DES_LIT"]|`mmdd'|`mmwww'N|t|[w|m|y["ASC_LIT"|"DES_LIT"]]]]");
   print_text (fp, s, INternal);
#  endif
   sprintf(s, "mm    = Month in range: %d...%d                 "
           "List:  mm["YEAR_SEP""Y_LIT2"]"MLIST_SEP"..."MLIST_SEP
           "mm["YEAR_SEP""Y_LIT2"]", MONTH_MIN, MONTH_MAX);
   print_text (fp, s, INternal);
   strcpy(s, "                    or: month name|"MONTH3_LIT"["MONTH3_LIT"|"ASC_LIT"|"DES_LIT"]    "
          "Range: mm["YEAR_SEP""Y_LIT2"]"MRANGE_SEP"mm["YEAR_SEP""Y_LIT2"]");
   print_text (fp, s, INternal);
   sprintf(s, Y_LIT2"  = Year  in range: %d...%d%*s         "
           "List:  [mm"FYEAR_SEP"]"Y_LIT2""YLIST_SEP"..."YLIST_SEP
           "[mm"FYEAR_SEP"]"Y_LIT2, YEAR_MIN, YEAR_MAX, 6-len_year_max+4, "");
   print_text (fp, s, INternal);
   strcpy(s, "                                               "
          "Range: [mm"FYEAR_SEP"]"Y_LIT2""YRANGE_SEP"[mm"FYEAR_SEP"]"Y_LIT2);
   print_text (fp, s, INternal);
   sprintf(s, "    +++ If you specify two digits for the year"
           " I DON'T assume %2d"Y_LIT" +++", act_year/100);
#endif /* !USE_GER */
   my_help_tail_txt (fp);
}



#ifdef ANSI_PROTO
PUBLIC void
my_license (      FILE *fp,
            const char *prgr_id)
#else /* !ANSI_PROTO */
   PUBLIC void
my_license (fp, prgr_id)
         FILE *fp;
   const char *prgr_id;
#endif /* !ANSI_PROTO */
/*
   Prints program-id and the license text to file `fp' using the central
     output function `print_text()', uses global text buffer `s' internally.
*/
{
   my_copyright (fp, prgr_id);
#if USE_GER
   strcpy(s, "   Diese Software erhebt keinen Anspruch auf Vollst"AE"ndigkeit,");
   print_text (fp, s, INternal);
   strcpy(s, "   Verwendungsf"AE"higkeit oder Korrektheit. F"UE"r jedwede Sch"AE"den oder");
   print_text (fp, s, INternal);
   strcpy(s, "   Verluste (implizit oder explizit), die aus Nutzung oder Handhabung");
   print_text (fp, s, INternal);
   strcpy(s, "   meiner Software hervorgehen, wird grunds"AE"tzlich keine Haftung");
   print_text (fp, s, INternal);
   strcpy(s, "   "UE"bernommen. Bei Verwendung dieser Software erkl"AE"rt sich der Benutzer");
   print_text (fp, s, INternal);
   strcpy(s, "   mit dieser Vereinbarung in vollem Umfang einverstanden.");
   print_text (fp, s, INternal);
   print_text (fp, s, INternal);
   strcpy(s, "   Dieses Programm ist freie Software; Sie k"OE"nnen es weitervertreiben");
   print_text (fp, s, INternal);
   strcpy(s, "   und/oder ver"AE"ndern innerhalb der Bestimmungen der `GNU General Public");
   print_text (fp, s, INternal);
   strcpy(s, "   License'; herausgegeben von der `Free Software Foundation';");
   print_text (fp, s, INternal);
   strcpy(s, "   in der Version 2 oder jeder sp"AE"teren Version.");
   print_text (fp, s, INternal);
   print_text (fp, s, INternal);
   strcpy(s, "   Sie sollten eine Kopie der `GNU General Public License' zusammen mit");
   print_text (fp, s, INternal);
   strcpy(s, "   diesem Programm erhalten haben; falls nicht, schreiben Sie an die:");
#else /* !USE_GER */
   strcpy(s, "   This software doesn't claim completeness, correctness or usability.");
   print_text (fp, s, INternal);
   strcpy(s, "   On principle I will not be liable for any damages or losses (implicit");
   print_text (fp, s, INternal);
   strcpy(s, "   or explicit), which result from using or handling my software.");
   print_text (fp, s, INternal);
   strcpy(s, "   If you use this software, you agree without any exception to this");
   print_text (fp, s, INternal);
   strcpy(s, "   agreement, which binds you LEGALLY !!");
   print_text (fp, s, INternal);
   print_text (fp, s, INternal);
   strcpy(s, "   This program is free software; you can redistribute it and/or modify");
   print_text (fp, s, INternal);
   strcpy(s, "   it under the terms of the `GNU General Public License' as published by");
   print_text (fp, s, INternal);
   strcpy(s, "   the `Free Software Foundation'; either version 2, or (at your option)");
   print_text (fp, s, INternal);
   strcpy(s, "   any later version.");
   print_text (fp, s, INternal);
   print_text (fp, s, INternal);
   strcpy(s, "   You should have received a copy of the `GNU General Public License'");
   print_text (fp, s, INternal);
   strcpy(s, "   along with this program; if not, write to the:");
#endif /* !USE_GER */
   print_text (fp, s, INternal);
   print_text (fp, s, INternal);
   strcpy(s, "      Free Software Foundation");
   print_text (fp, s, INternal);
   strcpy(s, "      59 Temple Place, Suite 330");
   print_text (fp, s, INternal);
   strcpy(s, "      Boston, MA 02111-1307  USA");
   print_text (fp, s, INternal);
}



#ifdef ANSI_PROTO
PUBLIC void
my_version (      FILE *fp,
            const char *prgr_id)
#else /* !ANSI_PROTO */
   PUBLIC void
my_version (fp, prgr_id)
         FILE *fp;
   const char *prgr_id;
#endif /* !ANSI_PROTO */
/*
   Prints program-id and all compilation flags to file `fp' using the central
     output function `print_text()', uses global text buffer `s' internally.
*/
{
   register int  i=0;


   my_copyright (fp, prgr_id);
#if USE_GER
   strcpy(s, "   Kompilations-Optionen:");
#else /* !USE_GER */
   strcpy(s, "   Compilation options:");
#endif /* !USE_GER */
   print_text (fp, s, INternal);
#if HAVE_ASSERT_H && DEBUG
   strcpy(s, "      DEBUG");
   print_text (fp, s, INternal);
#endif
   strcpy(s, "     ");
#if USE_CATH
   strcat(s, " USE_CATH");
   i++;
#endif
#if USE_EASC
   strcat(s, " USE_EASC");
   i++;
#endif
#if USE_GER
   strcat(s, " USE_GER");
   i++;
#endif
#if USE_HLS
   strcat(s, " USE_HLS");
   i++;
#endif
#if USE_PAGER
   strcat(s, " USE_PAGER");
   i++;
#endif
#if USE_RC
   strcat(s, " USE_RC");
   i++;
#endif
#if !USE_GER && USE_USHDY
   strcat(s, " USE_USHDY");
   i++;
#endif
   if (i)
     print_text (fp, s, INternal);
   sprintf(s, "      EXIT_STAT_HELP=%d", EXIT_STAT_HLP);
   print_text (fp, s, INternal);
   sprintf(s, "      GREG_%d (%d-%d %s)", GREG_YEAR,
           GREG_F_DAY, GREG_L_DAY, short_month_name (GREG_MONTH));
   print_text (fp, s, INternal);
   sprintf(s, "      GCAL_SYS_LIBDIR=%s", GCAL_SYS_LIBDIR);
   print_text (fp, s, INternal);
   sprintf(s, "      GCAL_USR_LIBDIR=%s", GCAL_USR_LIBDIR);
   print_text (fp, s, INternal);
}



#ifdef ANSI_PROTO
PUBLIC VOID_PTR
my_malloc (const int   amount,
           const int   exit_status,
           const char *module_name,
           const int   module_line,
           const char *var_name,
           const int   var_contents)
#else /* !ANSI_PROTO */
   PUBLIC VOID_PTR
my_malloc (amount, exit_status, module_name, module_line, var_name, var_contents)
   const int   amount;
   const int   exit_status;
   const char *module_name;
   const int   module_line;
   const char *var_name;
   const int   var_contents;
#endif /* !ANSI_PROTO */
/*
   Allocate AMOUNT bytes of memory dynamically, with error checking.
     calls `my_error()' and terminates program if any errors occur.
     AMOUNT is limited to `int' instead of `size_t'...
*/
{
   auto VOID_PTR  ptr_memblock=(VOID_PTR)malloc((int)amount);


   if (ptr_memblock == (VOID_PTR)NULL)
     /*
        Error, `malloc()' have failed
     */
     my_error (exit_status, module_name, module_line, var_name, var_contents);

   return(ptr_memblock);
}



#ifdef ANSI_PROTO
PUBLIC VOID_PTR
my_realloc (      VOID_PTR  ptr_memblock,
            const int       amount,
            const int       exit_status,
            const char     *module_name,
            const int       module_line,
            const char     *var_name,
            const int       var_contents)
#else /* !ANSI_PROTO */
   PUBLIC VOID_PTR
my_realloc (ptr_memblock, amount, exit_status, module_name, module_line, var_name, var_contents)
         VOID_PTR  ptr_memblock;
   const int       amount;
   const int       exit_status;
   const char     *module_name;
   const int       module_line;
   const char     *var_name;
   const int       var_contents;
#endif /* !ANSI_PROTO */
/*
   Change the size of an allocated block of memory PTR_MEMBLOCK to AMOUNT
     bytes, with error checking.  calls `my_error()' and terminates program
     if any errors occur.  AMOUNT is limited to `int' instead of `size_t'...
     If PTR_MEMBLOCK is NULL, run my_malloc().
*/
{
   if (ptr_memblock == (VOID_PTR)NULL)
     return(my_malloc (amount, exit_status, module_name, module_line, var_name, var_contents));
   ptr_memblock = (VOID_PTR)realloc(ptr_memblock, (int)amount);
   if (ptr_memblock == (VOID_PTR)NULL)
     /*
        Error, `realloc()' have failed
     */
     my_error (exit_status, module_name, module_line, var_name, var_contents);

   return(ptr_memblock);
}



#ifdef ANSI_PROTO
PUBLIC void
my_error (const int   exit_status,
          const char *module_name,
          const int   module_line,
          const char *var_name,
          const int   var_contents)
#else /* !ANSI_PROTO */
   PUBLIC void
my_error (exit_status, module_name, module_line, var_name, var_contents)
   const int   exit_status;
   const char *module_name;
   const int   module_line;
   const char *var_name;
   const int   var_contents;
#endif /* !ANSI_PROTO */
/*
   Displays a specific error message on stderr channel
     and terminates the program with status `exit_status'
*/
{
#if USE_GER
   fprintf(stderr, "\n%s: Abbruch, ", prgr_name);
#else /* !USE_GER */
   fprintf(stderr, "\n%s: Abort, ", prgr_name);
#endif /* !USE_GER */
   switch(exit_status)
    {
#if USE_GER
      case 125:
        fprintf(stderr, "unzul"AE"ssiges Jahr f"UE"r Ostertagsberechnung\n"
                "Jahr mu"SZ" im Bereich (%d...%d) sein", EASTER_MIN, EASTER_MAX);
        break;
      case 124:
        fprintf(stderr, "`%s' Zeile %d: Virtueller Speicher ersch"OE"pft (%s=%d)",
                module_name, module_line, var_name, var_contents);
        break;
#  if USE_RC
#    define  TMP_TXT  " in Resourcen-Datei `%s'\n"
      case 123:
        fprintf(stderr, "unzul"AE"ssiger Datumeintrag"TMP_TXT
                "Zeile %d: %s", module_name, module_line, var_name);
        break;
      case 122:
        fprintf(stderr, "ung"UE"ltiger Monat(%02d)"TMP_TXT
                "Zeile %d: %s", var_contents, module_name, module_line, var_name);
        break;
      case 121:
        fprintf(stderr, "ung"UE"ltiger Tag(%02d)"TMP_TXT
                "Zeile %d: %s", var_contents, module_name, module_line, var_name);
        break;
      case 120:
        fprintf(stderr, "mi"SZ"gebildetes "RC_INCL_STMENT""TMP_TXT
                "Zeile %d: %s", module_name, module_line, var_name);
        break;
      case 119:
        fprintf(stderr, "unzul"AE"ssiges Sub-"RC_INCL_STMENT""TMP_TXT
                "Zeile %d: %s", module_name, module_line, var_name);
        break;
      case 118:
        fprintf(stderr, "Datei `%s' nicht gefunden", module_name);
        break;
      case 117:
        fprintf(stderr, "ung"UE"ltiges n'ter Wochentagfeld(%01d)"TMP_TXT
                "Zeile %d: %s", var_contents, module_name, module_line, var_name);
        break;
      case 116:
        fprintf(stderr, "fehlendes Leerzeichen nach Datumteil"TMP_TXT
                "Zeile %d: %s", module_name, module_line, var_name);
        break;
      case 115:
        fprintf(stderr, "kann Antwortdatei `%s' nicht schreiben", module_name);
        break;
      case 114:
        if (*module_name)
          fprintf(stderr, "illegale Datumvariablen-Operation"TMP_TXT
                  "Zeile %d: %s", module_name, module_line, var_name);
        else
         {
           fprintf(stderr, "illegale Datumvariablen-Operation (%s)\n", var_name);
           fputs(usage_msg (), stderr);
           S_NEWLINE(stderr);
           put_longopt_description (stderr);
         }
        break;
#  endif /* USE_RC */
#  ifdef GCAL_EMAIL
      case 111:
        fprintf(stderr, "versenden der Email an `%s' hat versagt", var_name);
        break;
#  endif
#  ifdef GCAL_EPAGER
      case 110:
        fprintf(stderr, "`%s' Zeile %d: %s hat versagt",
                module_name, module_line, var_name);
        break;
#  endif
      case 109:
        fprintf(stderr, "Lesefehler in Datei `%s' ", module_name);
      default:
        fprintf(stderr, "unbehandelter interner Fehler (%d)", exit_status);
#else /* !USE_GER */
      case 125:
        fprintf(stderr, "invalid year for computing Easter Sunday\n"
                "Year must be in range (%d...%d)", EASTER_MIN, EASTER_MAX);
        break;
      case 124:
        fprintf(stderr, "`%s' line %d: virtual memory exhausted (%s=%d)",
                module_name, module_line, var_name, var_contents);
        break;
#  if USE_RC
#    define  TMP_TXT  " in resource file `%s'\n"
      case 123:
        fprintf(stderr, "invalid date part"TMP_TXT
                "Line %d: %s", module_name, module_line, var_name);
        break;
      case 122:
        fprintf(stderr, "invalid month field(%02d)"TMP_TXT
                "Line %d: %s", var_contents, module_name, module_line, var_name);
        break;
      case 121:
        fprintf(stderr, "invalid day field(%02d)"TMP_TXT
                "Line %d: %s", var_contents, module_name, module_line, var_name);
        break;
      case 120:
        fprintf(stderr, "malformed "RC_INCL_STMENT""TMP_TXT
                "Line %d: %s", module_name, module_line, var_name);
        break;
      case 119:
        fprintf(stderr, "invalid sub-"RC_INCL_STMENT""TMP_TXT
                "Line %d: %s", module_name, module_line, var_name);
        break;
      case 118:
        fprintf(stderr, "file `%s' not found", module_name);
        break;
      case 117:
        fprintf(stderr, "invalid n'th weekday field(%01d)"TMP_TXT
                "Line %d: %s", var_contents, module_name, module_line, var_name);
        break;
      case 116:
        fprintf(stderr, "missing whitespace after date part"TMP_TXT
                "Line %d: %s", module_name, module_line, var_name);
        break;
      case 115:
        fprintf(stderr, "response file `%s' can't be written", module_name);
        break;
      case 114:
        if (*module_name)
          fprintf(stderr, "illegal date variable operation"TMP_TXT
                  "Line %d: %s", module_name, module_line, var_name);
        else
         {
           fprintf(stderr, "illegal date variable operation (%s)\n", var_name);
           fputs(usage_msg (), stderr);
           S_NEWLINE(stderr);
           put_longopt_description (stderr);
         }
        break;
#  endif /* USE_RC */
#  ifdef GCAL_EMAIL
      case 111:
        fprintf(stderr, "sending Email to `%s' fails", var_name);
        break;
#  endif
#  ifdef GCAL_EPAGER
      case 110:
        fprintf(stderr, "`%s' line %d: %s fails",
                module_name, module_line, var_name);
        break;
#  endif
      case 109:
        fprintf(stderr, "read error in file `%s' ", module_name);
      default:
        fprintf(stderr, "unmanaged internal error (%d)", exit_status);
#endif /* !USE_GER */
    }
   S_NEWLINE(stderr);
   exit(exit_status);
}



#ifdef ANSI_PROTO
PUBLIC int
my_atoi (const char *s)
#else /* !ANSI_PROTO */
   PUBLIC int
my_atoi (s)
   const char *s;
#endif /* !ANSI_PROTO */
/*
   Converts given string `s' to a positiv integer value
     skipping leading zeros and returns values in
     range 0...YEAR_MAX only (invalid values are set to 0)
*/
{
   while (*s == '0')
     s++;
   if (   *s == '-'
       || (int)strlen(s) > len_year_max)
     return(0);

   return(atoi(s));
}



#ifdef ANSI_PROTO
PUBLIC Bool
get_actual_date (void)
#else /* !ANSI_PROTO */
   PUBLIC Bool
get_actual_date ()
#endif /* !ANSI_PROTO */
/*
   Gets the actual date from the system resp.,
     evaluates the "actual" date from global `rc_adate'-ptr to string
*/
{
   auto   struct tm         *sys_date;
   auto          MY_TIME_T   sys_time;
   static Bool               got_time=FALSE;


   sys_time  = time((MY_TIME_T *)NULL);
   sys_date  = localtime(&sys_time);
   if (!got_time)
    {
      got_time = TRUE;
      act_sec  = sys_date->tm_sec;
      act_min  = sys_date->tm_min;
      act_hour = sys_date->tm_hour;
    }
   buf_ad=act_day   = sys_date->tm_mday;
   buf_am=act_month = sys_date->tm_mon + 1;
   act_year  = sys_date->tm_year;
   if (act_year < CENTURY)
     act_year += CENTURY;
   buf_ay = act_year;
#if USE_RC
   if (rc_adate != (char *)NULL)
    {
      auto int    d=0;
      auto int    m=0;
      auto int    y=0;
      auto int    n=0;
      auto int    hn=0;
      auto int    hwd=0;
      auto int    i_dummy;
      auto char   hc='\0';
      auto char  *c_dummy=(char *)NULL;
      auto Bool   b_dummy;


      if (   !*rc_adate
          || *rc_adate == RC_HDY_CHAR)
        return(FALSE);
      /*
         Pre-initialize month and year to actual date
      */
      m = act_month;
      y = act_year;
      /*
         Check if numeric date is given
      */
      if (isdigit(*rc_adate))
       {
         /*
            Check if numeric day in month is given
         */
         if ((int)strlen(rc_adate) <= 2)
          {
            d = atoi(rc_adate);
            if (!d)
              /*
                 Error, invalid day number given
              */
              return(FALSE);
          }
         else
           (void)rc_get_date (rc_adate, &b_dummy, &d, &m, &y, &n, &i_dummy,
                              &hc, &hn, &hwd, c_dummy, i_dummy, c_dummy, FALSE);
       }
      else
       {
         /*
            Check if textual weekday name is given
         */
         d = compare_d_m_name (rc_adate, DAy);
         if (d)
          {
            /*
               If a digit (1...5, 9) trails the textual weekday name,
                 generate "n'th weekday of month" date
            */
            c_dummy = rc_adate;
            while (   isupper(*c_dummy)
                   || islower(*c_dummy))
              c_dummy++;
            if (*c_dummy)
             {
               n = atoi(c_dummy);
               if (!n)
                 /*
                    Invalid "n'th weekday of month" given (must be 1...5, 9)
                 */
                 return(FALSE);
             }
            else
             {
               /*
                  Only textual weekday name found, so compute absolute day
                    in month of that weekday (of current week)
               */
               hn = act_day;
               i_dummy = weekday_of_date (act_day, act_month, act_year);
               if (d > i_dummy)
                 do
                  {
                    next_date (&hn, &m, &y);
                  } while (d != weekday_of_date (hn, m, y));
               else
                 if (d < i_dummy)
                   do
                    {
                      prev_date (&hn, &m, &y);
                    } while (d != weekday_of_date (hn, m, y));
               d = hn;
             }
          }
         else
          {
            /*
               Check if short month name is given
            */
            m = compare_d_m_name (rc_adate, MOnth);
            if (!m)
              /*
                 Error, invalid month name given
              */
              return(FALSE);
            /*
               Check if day number trails textual month name
            */
            c_dummy = rc_adate;
            while (   isupper(*c_dummy)
#  if USE_EASC
                   || *c_dummy == *AE
                   || *c_dummy == *OE
                   || *c_dummy == *UE
                   || *c_dummy == *AAE
                   || *c_dummy == *OOE
                   || *c_dummy == *UUE
#  else /* !USE_EASC */
                   || *c_dummy == '"'
#  endif /* !USE_EASC */
                   || islower(*c_dummy))
              c_dummy++;
            if (*c_dummy)
             {
               d = atoi(c_dummy);
               if (!d)
                 /*
                    Error, invalid trailing day number given
                 */
                 return(FALSE);
             }
            else
              d = act_day;
          }
       }
      if (y >= 0)
       {
         if (!y)
           y = act_year;
         if (!m)
           m = act_month;
         if (n)
          {
            if (d > DAY_MAX)
              return(FALSE);
            if (!d)
              d = weekday_of_date (act_day, m, y);
            if (m == 2)
              i_dummy = days_of_february (y);
            else
              i_dummy = dvec[m-1];
            if (n == 9)
              d = eval_holiday (i_dummy, m, y, d, FALSE);
            else
              if (   (n >= 1)
                  && (n <= 5))
               {
                 d = eval_holiday (DAY_MIN, m, y, d, TRUE);
                 d += (DAY_MAX * (n - 1));
                 /*
                    The "n'th weekday of month" doesn't occur in month:
                      generate no "actual" date
                 */
                 if (d > i_dummy)
                   return(FALSE);
               }
              else
                return(FALSE);
          }
         else
           if (hc)
            {
              /*
                 If no explicit year is given in actual date modifier
                   %0@<e|`dvar'>[[-]<n>[`ww[w]']] resp., %0*d|w<n>[`ww[w]'],
                   compute date respecting the displacement, which was returned
                   by function `rc_get_date()' in variable `hn' an `hwd'
              */
              if (hc == RC_EASTER_CHAR)
               {
                 if (!precomp_date (hn, hwd, &d, &m, y, EAster))
                   return(FALSE);
               }
              else
                if (islower(hc))
                 {
                   if (!precomp_date (hn, hwd, &d, &m, y, DVar))
                     return(FALSE);
                 }
                else
                  if (   hc == 'D'
                      || hc == 'W')
                   {
                     if (!precomp_nth_wd (hn, hwd, &n, &d, &m, &y, ((hc == 'D') ? DAy : WEek)))
                       return(FALSE);
                   }
                  else
                    return(FALSE);
            }
           else
             if (!d)
               d = act_day;
             else
               if (d == 99)
                {
                  /*
                     Assume last day of month
                  */
                  if (m == 2)
                    d = days_of_february (y);
                  else
                    d = dvec[m-1];
                }
         if (valid_date (d, m, y))
          {
            act_day = d;
            act_month = m;
            act_year = y;
          }
         else
           return(FALSE);
       }
      else
        return(FALSE);
    }
#endif /* USE_RC */

  return(TRUE);
}



#ifdef ANSI_PROTO
PUBLIC int
compare_d_m_name (const char       *s,
                  const Cmode_enum  mode)
#else /* !ANSI_PROTO */
   PUBLIC int
compare_d_m_name (s, mode)
   const char       *s;
   const Cmode_enum  mode;
#endif /* !ANSI_PROTO */
/*
   Compares given day/month name string `s' with built-in names and
     returns (1...7|12) either if `s' matches partitially (until `\0'
     or first digit found in `s') or `s' matches complete.
     If string doesn't match, function returns 0.
   Depending on mode:
     mode==DAy:
       Compares delivered day name `s' with the built-in day names
         and returns: 1...7 == dayname 1...7 found ; 0 otherwise
     mode==MOnth:
       Compares delivered month name `s' with the built-in month names
         and returns: 1...12 == monthname 1...12 found ; 0 otherwise
*/
{
   register       int    len=(int)strlen(s);
   register       int    i=(mode==DAy) ? DAY_MIN : MONTH_MIN ;
   register       int    imax=(mode==DAy) ? DAY_MAX : MONTH_MAX;
   register       int    j;
   auto     const char  *ptr_char;


   if (len)
     for ( ; i <= imax ; i++)
      {
        ptr_char = (mode==DAy) ? day_name (i) : month_name (i);
        j = 0;
        while (   *(ptr_char + j)
               && s[j])
#if USE_EASC
          if (   (   (   s[j] == *AE
                      || s[j] == *AAE)
                  && (   *(ptr_char + j) == *AE
                      || *(ptr_char + j) == *AAE))
              || (   (   s[j] == *OE
                      || s[j] == *OOE)
                  && (   *(ptr_char + j) == *OE
                      || *(ptr_char + j) == *OOE))
              || (   (   s[j] == *UE
                      || s[j] == *UUE)
                  && (   *(ptr_char + j) == *UE
                      || *(ptr_char + j) == *UUE)))
            j++;
          else
#endif
            if (tolower(*(ptr_char+j)) == tolower(s[j]))
              j++;
            else
              break;
        if (   j == len
            || !*(ptr_char + j)
            || (   j
                && isdigit(s[j])))
          return(i);
      }

   return(0);
}



#ifdef ANSI_PROTO
PUBLIC int
asc_sort (const char **a,
          const char **b)
#else /* !ANSI_PROTO */
   PUBLIC int
asc_sort (a, b)
   const char **a;
   const char **b;
#endif /* !ANSI_PROTO */
/*
   The (q)sort compare function; ascending order
*/
{
   return(strcmp(*a, *b));
}



#ifdef ANSI_PROTO
PUBLIC int
des_sort (const char **a,
          const char **b)
#else /* !ANSI_PROTO */
   PUBLIC int
des_sort (a, b)
   const char **a;
   const char **b;
#endif /* !ANSI_PROTO */
/*
   The (q)sort compare function; descending order
*/
{
   return(strcmp(*b, *a));
}



#ifdef ANSI_PROTO
PUBLIC Bool
is_presorted (char **table,
              int    elems)
#else /* !ANSI_PROTO */
   PUBLIC Bool
is_presorted (table, elems)
   char **table;
   int    elems;
#endif /* !ANSI_PROTO */
/*
   Checks whether the textual entries in `table' are presorted in
      ascending sort order.  returns TRUE if the entries in `table'
      are presorted, otherwise FALSE.
*/
{
   if (--elems > 0)
    {
      register int  i=0;
      register int  j=0;


      while (elems--)
       {
         j++;
         if (strcmp(table[i], table[j]) > 0)
           return(FALSE);
         i++;
       }
    }

  return(TRUE);
}



#ifdef ANSI_PROTO
PUBLIC void
resort (      char **table,
        const int    elems)
#else /* !ANSI_PROTO */
   PUBLIC void
resort (table, elems)
   const char **table;
         int    elems;
#endif /* !ANSI_PROTO */
/*
   Rearranges (reverts) the sort order of the textual entries in `table' from
     ascending sort order to descending sort order by pointer swapping.
*/
{
   register int  right=elems-1;


   if (right > 0)
    {
      register int    left=0;
      auto     char  *ptr_elem;


      while (left < right)
       {
         ptr_elem = table[left];
         table[left++] = table[right];
         table[right--] = ptr_elem;
       }
    }
}



#if !USE_GER
#  ifdef ANSI_PROTO
PUBLIC const char *
day_suffix (int day)
#  else /* !ANSI_PROTO */
   PUBLIC const char *
day_suffix (day)
   int day;
#  endif /* !ANSI_PROTO */
/*
   Returns the ordinal suffix (st, nd, rd or th) which is
     added to a single day number using the format %-3s
*/
{
   static   const char  *suffix[]={"'th", "'st", "'nd", "'rd"};
   register       int    i=0;


/*
   Necessary for numbers > [9]9999

   if (day > 10000)
     day %= 10000;
   if (day > 1000)
     day %= 1000;
*/
   if (day > 100)
     day %= 100;
   if (   day < 11
       || day > 13)
     i = day % 10;
   if (i > 3)
     i = 0;

   return(suffix[i]);
}



#  ifdef ANSI_PROTO
PUBLIC const char *
short3_day_name (const int day)
#  else /* !ANSI_PROTO */
   PUBLIC const char *
short3_day_name (day)
   const int day;
#  endif /* !ANSI_PROTO */
/*
   Returns the short name of the day using the format %-3s
*/
{
   static const char  *name[]={
                                "invalid day",
                                "Mon", "Tue", "Wed", "Thu", "Fri", "Sat", "Sun"
                              };


   return(((day<DAY_MIN)||(day>DAY_MAX)) ? name[0] : name[day]);
}
#endif /* !USE_GER */



#ifdef ANSI_PROTO
PUBLIC const char *
short_day_name (const int day)
#else /* !ANSI_PROTO */
   PUBLIC const char *
short_day_name (day)
   const int day;
#endif /* !ANSI_PROTO */
/*
   Returns the short name of the day using the format %-2s
*/
{
#if USE_GER
   static const char  *name[]={
                                "ung"UE"ltiger Tag",
                                "Mo", "Di", "Mi", "Do", "Fr", "Sa", "So"
                              };
#else /* !USE_GER */
   static const char  *name[]={
                                "invalid day",
                                "Mo", "Tu", "We", "Th", "Fr", "Sa", "Su"
                              };
#endif /* !USE_GER */

   return(((day<DAY_MIN)||(day>DAY_MAX)) ? name[0] : name[day]);
}



#ifdef ANSI_PROTO
PUBLIC const char *
day_name (const int day)
#else /* !ANSI_PROTO */
   PUBLIC const char *
day_name (day)
   const int day;
#endif /* !ANSI_PROTO */
/*
   Returns the complete name of the day
*/
{
#if USE_GER
   static const char  *name[]={
                                "ung"UE"ltiger Tag",
                                "Montag",  "Dienstag", "Mittwoch", "Donnerstag",
                                "Freitag", "Samstag",  "Sonntag"
                              };
#else /* !USE_GER */
   static const char  *name[]={
                                "invalid day",
                                "Monday", "Tuesday",  "Wednesday", "Thursday",
                                "Friday", "Saturday", "Sunday"
                              };
#endif /* !USE_GER */

   return(((day<DAY_MIN)||(day>DAY_MAX)) ? name[0] : name[day]);
}



#ifdef ANSI_PROTO
PUBLIC const char *
short_month_name (const int month)
#else /* !ANSI_PROTO */
   PUBLIC const char *
short_month_name (month)
   const int month;
#endif /* !ANSI_PROTO */
/*
   Returns the short name of the month using the format %-3s
*/
{
#if USE_GER
   static const char  *name[]={
                                "ung"UE"ltiger Monat",
                                "Jan", "Feb",
#  if USE_EASC
                                "M"AE"r",
#  else /* !USE_EASC */
                                "M"AE,
#  endif /* !USE_EASC */
                                "Apr", "Mai", "Jun", "Jul", "Aug",
                                "Sep", "Okt", "Nov", "Dez"
                              };
#else /* !USE_GER */
   static const char  *name[]={
                                "invalid month",
                                "Jan", "Feb", "Mar", "Apr", "May", "Jun",
                                "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"
                              };
#endif /* !USE_GER */

   return(((month<MONTH_MIN)||(month>MONTH_MAX)) ? name[0] : name[month]);
}



#ifdef ANSI_PROTO
PUBLIC const char *
month_name (const int month)
#else /* !ANSI_PROTO */
   PUBLIC const char *
month_name (month)
   const int month;
#endif /* !ANSI_PROTO */
/*
   Returns the complete name of the month
*/
{
#if USE_GER
   static const char  *name[]={
                                "ung"UE"ltiger Monat",
                                "Januar",  "Februar",  "M"AE"rz",
                                "April",   "Mai",      "Juni",
                                "Juli",    "August",   "September",
                                "Oktober", "November", "Dezember"
                              };
#else /* !USE_GER */
   static const char  *name[]={
                                "invalid month",
                                "January", "February", "March",
                                "April",   "May",      "June",
                                "July",    "August",   "September",
                                "October", "November", "December"
                              };
#endif /* !USE_GER */

   return(((month<MONTH_MIN)||(month>MONTH_MAX)) ? name[0] : name[month]);
}



#ifdef ANSI_PROTO
PUBLIC Ulint
date2num (const int day,
          const int month,
          const int year)
#else /* !ANSI_PROTO */
   PUBLIC Ulint
date2num (day, month, year)
   const int day;
   const int month;
   const int year;
#endif /* !ANSI_PROTO */
/*
   Computes the absolute number of days of delivered date since 00010101(==`yyyymmdd')
     respecting the missing period of the Gregorian reformation
*/
{
   auto Ulint  julian_days=(Ulint)((year-1)*(Ulint)(DAY_LAST)+((year-1)>>2));


   if (   year > GREG_YEAR
       || (   (year == GREG_YEAR)
           && (   month > GREG_MONTH
               || (   (month == GREG_MONTH)
                   && (day > GREG_L_DAY)))))
     julian_days -= (Ulint)(GREG_L_DAY - GREG_F_DAY + 1);
   if (year > GREG_YEAR)
    {
      julian_days += (((year - 1) / 400) - (GREG_YEAR / 400));
      julian_days -= (((year - 1) / 100) - (GREG_YEAR / 100));
    }
   julian_days += (Ulint)mvec[month-1];
   julian_days += day;
   if (   (days_of_february (year) == 29)
       && (month > 2))
     julian_days++;

   return(julian_days);
}



#ifdef ANSI_PROTO
PUBLIC Bool
jdate2sdate (      int  jdate,
             const int  is_leap_year,
                   int *day,
                   int *month)
#else /* !ANSI_PROTO */
   PUBLIC Bool
jdate2sdate (jdate, is_leap_year, day, month)
         int  jdate;
   const int  is_leap_year;
         int *day;
         int *month;
#endif /* !ANSI_PROTO */
/*
   Converts a delivered Julian date of a year to a standard date
     (returned in &day and &month) and returns:
       TRUE in case julian date is valid;
       FALSE otherwise
*/
{
   register       int   i;
   auto           Bool  decrement_date;


   if (   jdate > DAY_LAST+is_leap_year
       || jdate < DAY_MIN)
     return(FALSE);
   decrement_date = (Bool)(   is_leap_year
                           && (jdate > 59));
   if (decrement_date)
     jdate--;
   for (i=MONTH_MIN ; i < MONTH_MAX ; i++)
    {
      jdate -= dvec[i-1];
      if (jdate <= 0)
       {
         jdate += dvec[i-1];
         break;
       }
    }
   *month = i;
   *day = jdate;
   if (   decrement_date
       && (*month == 2)
       && (*day == 28))
     (*day)++;

   return(TRUE);
   /*
      Alternative floating-point algorithm for managing this stuff:
      ...
      if (jdate-is_leap_year > 59)
       {
         month = (int)((63 + jdate - is_leap_year) / 30.61) - 1;
         day = (int)(63 + jdate - is_leap_year - abs((int)((month + 1) * 30.61)));
       }
      else
       {
         month = (int)((428 + jdate) / 30.61) - 13;
         day = (int)(428 + jdate - abs((int)((month + 13) * 30.61)));
       }
      ...
   */
}



#ifdef ANSI_PROTO
PUBLIC int
weekday_of_date (const int day,
                 const int month,
                 const int year)
#else /* !ANSI_PROTO */
   PUBLIC int
weekday_of_date (day, month, year)
   const int day;
   const int month;
   const int year;
#endif /* !ANSI_PROTO */
/*
   Computes the weekday of a Gregorian/Julian date (month must be 1...12)
     and returns 1...7 ; 1==mo, 2==tu...7==su
*/
{
   auto Ulint  julian_days=date2num (day, month, year)%DAY_MAX;

   return((julian_days>2) ? (int)(julian_days-2) : (int)(julian_days+5));
}



#ifdef ANSI_PROTO
PUBLIC int
day_of_year (const int day,
             const int month,
             const int year)
#else /* !ANSI_PROTO */
   PUBLIC int
day_of_year (day, month, year)
   const int day;
   const int month;
   const int year;
#endif /* !ANSI_PROTO */
/*
   Computes the day of the year of a Gregorian/Julian date (month must be 1...12)
     and returns the 1...365|366
*/
{
   register int  i;


   if (month < 3)
     i = mvec[month-1] + day;
   else
     i = mvec[month-1] + day + (days_of_february (year) == 29);
   if (   (year == GREG_YEAR)
       && (   month > GREG_MONTH
           || (   (month == GREG_MONTH)
               && (day > GREG_L_DAY))))
     i -= (GREG_L_DAY - GREG_F_DAY + 1);

   return(i);
}



#ifdef ANSI_PROTO
PUBLIC int
days_of_february (const int year)
#else /* !ANSI_PROTO */
   PUBLIC int
days_of_february (year)
   const int year;
#endif /* !ANSI_PROTO */
/*
   Computes the number of days in february and returns them
*/
{
   return((year>GREG_YEAR)
          ? (year&3) ? 28 : ((!(year%100)&&(year%400)) ? 28 : 29)
          : (year&3) ? 28 : 29);
}



#ifdef ANSI_PROTO
PUBLIC Bool
valid_date (const int day,
            const int month,
            const int year)
#else /* !ANSI_PROTO */
   PUBLIC Bool
valid_date (day, month, year)
   const int day;
   const int month;
   const int year;
#endif /* !ANSI_PROTO */
/*
   Checks whether a delivered date is valid
*/
{
   if (   day < 0
       || month < MONTH_MIN
       || month > MONTH_MAX
       || (   (month != 2)
           && (day > dvec[month-1]))
       || (   (month == 2)
           && (day > days_of_february (year))))
     return(FALSE);

   return(TRUE);
}



#ifdef ANSI_PROTO
PUBLIC int
week_number (const int day,
             const int month,
             const int year)
#else /* !ANSI_PROTO */
   PUBLIC int
week_number (day, month, year)
   const int day;
   const int month;
   const int year;
#endif /* !ANSI_PROTO */
/*
   Returns the real ISO-8601:1988 standard week number of delivered date,
     0 in case date occurs both in last week of previous year and
     first week of year (week starts with monday(1) and ends with sunday(7))
*/
{
   register int  i=raw_week_number (day, month, year);
   register int  j;
   register int  wmax=WEEK_MAX;


   if (year == GREG_YEAR)
     wmax = ((DAY_LAST + (days_of_february (GREG_YEAR) == 29)
            - (GREG_L_DAY - GREG_F_DAY + 1)) / DAY_MAX) + 1;
   if (i == wmax+1)
    {
      if (month == MONTH_MIN)
       {
         j = raw_week_number (dvec[MONTH_MAX-1], MONTH_MAX, year-1);
         if (i != j)
           i = 0;
       }
      else
       {
         j = raw_week_number (DAY_MIN, MONTH_MIN, year+1);
         if (i != j)
           i = 0;
       }
    }
   else
     if (i == 1)
      {
        if (weekday_of_date (DAY_MIN, MONTH_MIN, year) <= 4)
         {
           j = raw_week_number (dvec[MONTH_MAX-1], MONTH_MAX, year-1);
           if (year-1 == GREG_YEAR)
             wmax = ((DAY_LAST + (days_of_february (GREG_YEAR) == 29)
                    - (GREG_L_DAY - GREG_F_DAY + 1)) / DAY_MAX) + 1;
           if (   (j != wmax)
               && (year != GREG_YEAR))
             i = 0;
         }
      }

   return(i);
}



#ifdef ANSI_PROTO
PUBLIC int
weekno2jday (      int week,
             const int year)
#else /* !ANSI_PROTO */
   PUBLIC int
weekno2jday (week, year)
         int week;
   const int year;
#endif /* !ANSI_PROTO */
/*
   Returns that day number of (Julian or Gregorian)year, the delivered
   ISO-8601:1988 week number starts at.
     week number may be:
       (a)  0           == returns jdate of first week of year resp.,
                             that dates, which occur both in last week of
                             previous year and first week of year
                             (in this case, the function return value is -5...0)
       (b)  1...52      == returns jdate always
       (c) 53           == returns jdate or if year owns NO 53'rd week,
                             returns -WEEK_MAX [=special value])
       (d) 99           == returns jdate of last week of year
     range of return value is:
           -5...0       == in case event (a) has occured and the first days
                             of year occur both in last week of previous year
                             and first week of year
            1...365|366 == events (b), (c) and (d)
*/
{
   register int  wd=weekday_of_date (DAY_MIN, MONTH_MIN, year);
   register int  ww=week_number (DAY_MIN, MONTH_MIN, year);
   register int  wm=week_number (dvec[MONTH_MAX-1], MONTH_MAX, year);
   register int  wmax=WEEK_MAX;
   register int  i=1;


   if (year == GREG_YEAR)
     wmax = ((DAY_LAST + (days_of_february (GREG_YEAR) == 29)
            - (GREG_L_DAY - GREG_F_DAY + 1)) / DAY_MAX) + 1;
   if (ww > 1)
     i += (DAY_MAX - wd + 1);
   else
     if (!ww)
       i -= (wd - 1);
   if (   wm
       && (wm != wmax+1)
       && (week == wmax+1))
     return(-WEEK_MAX);
   else
     if (week == 99)
      {
        week = wm;
        if (!wm)
          week = wmax + 1;
        i += ((week - 1) * DAY_MAX);
      }
     else
      {
        i += ((week - 1) * DAY_MAX);
        if (   !week
            && (i <= -(DAY_MAX-1)))
          i += DAY_MAX;
      }
   if (year == GREG_YEAR)
     if (i >= day_of_year (GREG_L_DAY+1, GREG_MONTH, GREG_YEAR))
       i += (GREG_L_DAY - GREG_F_DAY + 1);
   if (i > DAY_LAST+(days_of_february (year)==29))
     return(-WEEK_MAX);

   return(i);
}



#ifdef ANSI_PROTO
PUBLIC int
knuth_easter_formula (const int year)
#else /* !ANSI_PROTO */
   PUBLIC int
knuth_easter_formula (year)
   const int year;
#endif /* !ANSI_PROTO */
/*
   This procedure calculates the day and month of Easter giving the year.
   It returns the "actual day_of_year date" of Western Eastern (not the
   Eastern Easter of the Eastern Orthodox churches) after A.D.463.
   `golden_number' is the number of the year in the Metonic cycle, used
   to determine the position of the calendar moon.
   `gregorian_correction' is the number of preceding years like 1700, 1800,
   1900 when leap year was not held.
   `clavian_correction' is a correction for the Metonic cycle of about
   8 days every 2500 years.
   `epact' is the age of the calendar moon at the beginning of the year.
   `extra_days' specifies when Sunday occurs in March. `epact' specifies
   when full moon occurs. Easter is the first Sunday following the first
   full moon which occus on or after March 21. (Ref.: De Morgan, A Budget
   of Paradoxes)
   This Algorithm was given by Don Knuth in CACM 5(1962), 209-210.
*/
{
   register int  golden_number;
   register int  century;
   register int  gregorian_correction;
   register int  clavian_correction;
   register int  extra_days;
   register int  epact;
   register int  day;
   register int  month;


   golden_number = (year % 19) + 1;
   if (year <= GREG_REFORM)
    {
      /*
         Computation for Julian years
      */
      extra_days = (5 * year) / 4;
      epact = ((11 * golden_number - 4) % 30) + 1;
    }
   else
    {
      /*
         Computation for Gregorian years
      */
      century = year / 100 + 1;
      gregorian_correction = (3 * century) / 4 - 12;
/*
      clavian_correction = (century - 16 - (century - 18) / 25) / 3;
*/
      clavian_correction = ((8 * century + 5) / 25) - 5;
      extra_days = (5 * year) / 4 - gregorian_correction - 10;
      epact = (11 * golden_number + 20 + clavian_correction - gregorian_correction) % 30;
      if (epact <= 0)
        epact += 30;
      if (   (   (epact == 25)
              && (golden_number > 11))
          || epact == 24)
        epact++;
    }
   day = 44 - epact;
   if (day < 21)
     day += 30;
   day += 7 - ((extra_days + day) % 7);
   if (day > 31)
    {
      day -= 31;
      month = 4;
    }
   else
     month = 3;

   return(day_of_year (day, month, year));
}



#ifdef ANSI_PROTO
PUBLIC int
julian_gregor_diff (const int day,
                    const int month,
                    const int year)
#else /* !ANSI_PROTO */
   PUBLIC int
julian_gregor_diff (day, month, year)
   const int day;
   const int month;
   const int year;
#endif /* !ANSI_PROTO */
/*
   Returns the day difference between given Gregorian date
     and according Julian date, i.e. the amount of days,
     the Julian calendar is past the Gregorian calendar.
*/
{
   auto Ulint  julian_days=(Ulint)((year-1)*(Ulint)(DAY_LAST)+((year-1)>>2));


   julian_days += (Ulint)(mvec[month-1] + day);
   if (   !(year & 3)
       && (month > 2))
     julian_days++;

   return((int)(julian_days-date2num (day, month, year)));
}



#ifdef ANSI_PROTO
PUBLIC const char *
usage_msg (void)
#else /* !ANSI_PROTO */
   PUBLIC const char *
usage_msg (void)
#endif /* !ANSI_PROTO */
/*
   Copies the constructed preprocessor text `USAGE_MSG'
     to usage text `usage_txt' and includes the actual program name
*/
{
   static char  *usg_txt;
   static Bool   is_initialized=FALSE;


   if (!is_initialized)
    {
      usg_txt = (char *)my_malloc (strlen(USAGE_MSG)-2+len_prgr_name+1,
                                   124, __FILE__, __LINE__ -1,
                                   "usg_txt", 0);
      sprintf(usg_txt, USAGE_MSG, prgr_name);
      is_initialized = TRUE;
    }

   return(usg_txt);
}



#ifdef ANSI_PROTO
PUBLIC void
put_longopt_description (FILE *fp)
#else /* !ANSI_PROTO */
   PUBLIC void
put_longopt_description (fp)
   FILE *fp;
#endif /* !ANSI_PROTO */
/*
   Puts a description text of long options to file `fp'
*/
{
#if USE_GER
   fprintf(fp, "Versuche `%s %s' oder ",
           prgr_name, get_longopt_description (SYM_HELP, TRUE));
   fprintf(fp, "`%s %s' f"UE"r mehr Information.",
           prgr_name, get_longopt_description (SYM_LONG_HELP2, TRUE));
#else /* !USE_GER */
   fprintf(fp, "Try `%s %s' or ",
           prgr_name, get_longopt_description (SYM_HELP, TRUE));
   fprintf(fp, "`%s %s' for more information.",
           prgr_name, get_longopt_description (SYM_LONG_HELP2, TRUE));
#endif /* !USE_GER */
}



#ifdef ANSI_PROTO
LOCAL const char *
get_longopt_description (const int  longopt_symbolic,
                         const Bool with_larglist)
#else /* !ANSI_PROTO */
   LOCAL const char *
get_longopt_description (longopt_symbolic, with_larglist)
   const int  longopt_symbolic;
   const Bool with_larglist;
#endif /* !ANSI_PROTO */
/*
   Returns a description text of given `longopt_symbolic' long option in global
     text buffer `s2'.  If `with_larglist' is TRUE, the returned description
     text contains the argument list text (if any) too, otherwise the returned
     description text contains the complete name of the long option only!
*/
{
   auto     const Lopt_struct  *ptr_lopt=&lopt[0];
   register       int           i;


   while (   (ptr_lopt->symbolic_name != longopt_symbolic)
          && (ptr_lopt->long_name != NULL))
     ptr_lopt++;
   if (ptr_lopt->long_name != NULL)
    {
      i = 0;
      sprintf(s2, SWITCH""SWITCH"%s", ptr_lopt->long_name);
      if (   with_larglist
          && (ptr_lopt->larg_mode != LARG_NO))
       {
         if (ptr_lopt->larg_mode == LARG_NO_OR_ONE)
          {
            strcat(s2, "[");
            strcat(s2, LARG_SEP);
          }
         else
           strcat(s2, LARG_SEP);
         if (   (ptr_lopt->larg_mode == LARG_ONE)
             && (ptr_lopt->largs[0] == NULL))
           strcat(s2, LARG_TXT);
         else
          {
            if (ptr_lopt->largs[0] == NULL)
              strcat(s2, LARG_TXT);
            else
              while (ptr_lopt->largs[i] != NULL)
               {
                 strcat(s2, ptr_lopt->largs[i]);
                 if (ptr_lopt->largs[i+1] != NULL)
                   strcat(s2, "|");
                 i++;
               }
          }
         if (ptr_lopt->larg_mode == LARG_NO_OR_ONE)
           strcat(s2, "]");
       }
    }
   else
     *s2 = '\0';

   return(s2);
}



#ifdef ANSI_PROTO
LOCAL void
my_copyright (      FILE *fp,
              const char *prgr_id)
#else /* !ANSI_PROTO */
   LOCAL void
my_help_head_txt (fp, prgr_id)
         FILE *fp;
   const char *prgr_id;
#endif /* !ANSI_PROTO */
/*
   Prints the id and copyright text to file `fp' using the central output
     function `print_text()' and uses global text buffer `s' internally.
*/
{
   strcpy(s, prgr_id);
   print_text (fp, s, INternal);
   print_text (fp, s, INternal);
   strcpy(s, "   "COPYRIGHT_TXT);
   print_text (fp, s, INternal);
   print_text (fp, s, INternal);
}



#ifdef ANSI_PROTO
LOCAL void
my_help_head_txt (FILE *fp)
#else /* !ANSI_PROTO */
   LOCAL void
my_help_head_txt (fp)
   FILE *fp;
#endif /* !ANSI_PROTO */
/*
   Prints the help header text to file `fp' using the central
     output function `print_text()' and uses global text buffer
     `s' and `s2' internally.
*/
{
   auto Bool  print_hls=(Bool)(is_tty&&highlight_flag&&!emu_hls);


   *s = '\0';
   if (print_hls)
     strcpy(s, ehls2s.seq);
   strcat(s, prgr_name);
   if (print_hls)
     strcat(s, ehls2e.seq);
#if USE_GER
   sprintf(s2, ":%*s Das GNU Kalenderprogramm  (", 6-len_prgr_name, "");
#else /* !USE_GER */
   sprintf(s2, ":%*s The GNU calendar program  (", 6-len_prgr_name, "");
#endif /* !USE_GER */
   strcat(s, s2);
   if (print_hls)
     strcat(s, ehls2s.seq);
   strcat(s, VERSION_NO);
   if (print_hls)
     strcat(s, ehls2e.seq);
   strcat(s, ")  "COPYRIGHT_TXT);
   print_text (fp, s, INternal);
   print_text (fp, s, INternal);
   strcpy(s, usage_msg ());
   print_text (fp, s, INternal);
   print_text (fp, s, INternal);
}



#ifdef ANSI_PROTO
LOCAL void
my_help_tail_txt (FILE *fp)
#else /* !ANSI_PROTO */
   LOCAL void
my_help_tail_txt (fp)
   FILE *fp;
#endif /* !ANSI_PROTO */
/*
   Prints the help tail text to file `fp' using the central
     output function `print_text()' and uses global text buffer
     `s' internally.
*/
{
   auto Bool  print_hls=(Bool)(is_tty&&highlight_flag&&!emu_hls);


   print_text (fp, s, INternal);
   print_text (fp, s, INternal);
#if USE_GER
   sprintf(s, "`%s' ist `freie Software'     %*s", prgr_name, 6-len_prgr_name, "");
#else /* !USE_GER */
   sprintf(s, "`%s' is `free software'       %*s", prgr_name, 6-len_prgr_name, "");
#endif /* !USE_GER */
   if (print_hls)
     strcat(s, ehls2s.seq);
   strcat(s, "\\\\\\_''/'");
   if (print_hls)
     strcat(s, ehls2e.seq);
#if USE_GER
#  if USE_EASC
   strcat(s, " ");
#  endif
   strcat(s, "          Viel Spa"SZ" damit   =8^)");
#else /* !USE_GER */
   strcat(s, "                  Have fun   =8^)");
#endif /* !USE_GER */
   print_text (fp, s, INternal);
   if (print_hls)
     strcpy(s, ehls2s.seq);
   strcat(s, "---------------------------oOO    (/o-o\\) "
          "   OOo---------------------------");
   if (print_hls)
     strcat(s, ehls2e.seq);
   print_text (fp, s, INternal);
   if (print_hls)
     strcpy(s, ehls2s.seq);
   strcat(s, "  Thomas Esken                o  (.  \"  .)"
          "  o   Internet :                 ");
   if (print_hls)
     strcat(s, ehls2e.seq);
   print_text (fp, s, INternal);
   if (print_hls)
     strcpy(s, ehls2s.seq);
   strcat(s, "  Im Hagenfeld 84              \\___) ~ (__"
          "_/      <esken@uni-muenster.de>  ");
   if (print_hls)
     strcat(s, ehls2e.seq);
   print_text (fp, s, INternal);
   if (print_hls)
     strcpy(s, ehls2s.seq);
   strcat(s, "  D-48147 M\"unster; GERMANY               "
          "      Phone : (+49) 0251 232585  ");
   if (print_hls)
     strcat(s, ehls2e.seq);
   print_text (fp, s, INternal);
}



#ifdef ANSI_PROTO
LOCAL int
raw_week_number (const int day,
                 const int month,
                 const int year)
#else /* !ANSI_PROTO */
   LOCAL int
raw_week_number (day, month, year)
   const int day;
   const int month;
   const int year;
#endif /* !ANSI_PROTO */
/*
   Returns the raw ISO-8601:1988 standard week number of delivered date ONLY
     (week starts with monday(1) and ends with sunday(7))
*/
{
   register int  jd=day_of_year (day, month, year);
   register int  sd=weekday_of_date (DAY_MIN, MONTH_MIN, year);
   register int  ww;


   /*
      Correct the computed Julian day of year number of delivered date
   */
   if (sd > 4)
     /*
        Starting day of year is friday...sunday
     */
     jd -= ((DAY_MAX - sd) + 1);
   else
     /*
        Starting day of year is monday...thursday
     */
     jd += (sd - 1);
   /*
      Compute week number of delivered date
   */
   if (jd > 0)
     /*
        Date has consecutive week number of current year:
          compute it
     */
     ww = (jd - 1) / DAY_MAX + 1;
   else
     /*
        Date has week number of last week of previous year:
          detect that week number by calling this function recursivly  ;)
     */
     ww = raw_week_number (dvec[MONTH_MAX-1], MONTH_MAX, year-1);

   return (ww);
}
