#ifndef __GCAL_TAI_H
#  define __GCAL_TAI_H
/*
*  gcal_tai.h:  Machine/target dependent definitions
*
*
*  Copyright (C) 1994, 1995 Thomas Esken
*
*  This software doesn't claim completeness, correctness or usability.
*  On principle I will not be liable for any damages or losses (implicit
*  or explicit), which result from using or handling my software.
*  If you use this software, you agree without any exception to this
*  agreement, which binds you LEGALLY !!
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the `GNU General Public License' as published by
*  the `Free Software Foundation'; either version 2, or (at your option)
*  any later version.
*
*  You should have received a copy of the `GNU General Public License'
*  along with this program; if not, write to the:
*    Free Software Foundation
*    59 Temple Place, Suite 330
*    Boston, MA 02111-1307  USA
*/



/*
*  $Id: gcal_tai.h 0.39 1995/12/17 00:03:09 tom Exp $
*/



/*
*  Include definitions (sub)header files  ;<
*/
#include "gcal_def.h"
#if HAVE_CONFIG_H
#  include <gcal_cfg.h>
#endif


/*
*  Detect the machine / os
*/
/*
*  Define the symbol MSDOS for MS-DOS machines
*/
#if defined(__MSDOS__) || defined(__MSDOS) || defined(_MSDOS)
#  ifndef MSDOS
#    define MSDOS     /* Now let's define the symbol MSDOS generally */
#  endif
#endif
#if defined(__TURBOC__) || defined(__ZTC__) || defined(M_I86)
#  ifndef MSDOS
#    define MSDOS     /* Now let's define the symbol MSDOS generally */
#  endif
#endif
/*
*  Define the symbol OS2 for OS/2 machines
*/
#if defined(__OS2__) || defined(__OS2) || defined(_OS2)
#  ifndef OS2
#    define OS2       /* Now let's define the symbol OS2 generally */
#  endif
#endif
/*
*  Microsoft-C or Borland-C or Waterloo-C under OS/2
*/
#if defined(OS2)
#  if defined(MSDOS) || defined(__TURBOC__)
#    ifdef MSDOS
#      undef MSDOS
#    endif
#  endif
#endif
/*
*  Define the symbol LINUX for Linux machines
*/
#if defined(__LINUX__) || defined(__LINUX) || defined(_LINUX) || defined(LINUX)
#  ifndef LINUX
#    define LINUX     /* Now let's define the symbol LINUX generally */
#  endif
#endif
#if defined(__linux__) || defined(__linux) || defined(_linux) || defined(linux)
#  ifndef LINUX
#    define LINUX     /* Now let's define the symbol LINUX generally */
#  endif
#endif
/*
*  Define the symbol UNIX for UN*X machines
*/
#if defined(__UNIX__) || defined(__UNIX) || defined(_UNIX)
#  ifndef UNIX
#    define UNIX      /* Now let's define the symbol UNIX generally */
#  endif
#endif
#if defined(__unix__) || defined(__unix) || defined(_unix) || defined(unix)
#  ifndef UNIX
#    define UNIX      /* Now let's define the symbol UNIX generally */
#  endif
#endif
#ifdef MSDOS
#  ifdef UNIX
#    if defined(__GNUC__) || defined(__GO32__)
#      ifndef DJG
#        define DJG   /* Now let's define the symbol DJG (DJ-GCC under MSDOS) for these machines */
#      endif
#      undef MSDOS
#    endif
#  else /* !UNIX */
#    if defined(__i386) || defined(i386)
#      ifndef SCO
#        define SCO   /* Now let's define the symbol SCO for these machines, too */
#      endif
#      define UNIX    /* Now let's define the symbol UNIX for these machines, too */
#      undef MSDOS
#    endif
#  endif /* !UNIX */
#else /* !MSDOS */
#  if (!defined(LINUX) && defined(__i386)) || defined(i386)
#    ifndef SCO
#      define SCO     /* Now let's define the symbol SCO for these machines, too */
#    endif
#  endif
#endif /* !MSDOS */



/*
*  Target specific predefines
*/
#if defined(MSDOS) || defined(DJG) || defined(WIN32)
#  define  STDC_HEADERS 1
#  define  HAVE_ASSERT_H 1
#  define  HAVE_CTYPE_H 1
#  define  HAVE_ISDIGIT 1
#  define  HAVE_ISALNUM 1
#  define  HAVE_UPPER_LOWER 1
#  define  HAVE_STRTOL 1
#  define  HAVE_STRSTR 1
#  define  HAVE_TIME_T 1
#  define  HAVE_VOID 1
#  ifdef DJG
#    define  HAVE_UNISTD_H 1
#    define  DIR2_SEP      "/"         /* Directory/folder separator */
#  else /* !DJG */
#    include <io.h>
#  endif /* !DJG */
#  if USE_PAGER
#    define  SCREEN_ROWS   25          /* Default number of terminal rows */
#  endif
#  define  DIR_SEP       "\\"        /* Directory/folder separator */
#  define  PATH_SEP      ";"         /* Path separator */
#  define  ENV_VAR_DPATH "PATH"      /* Name of data search path environment variable */
#elif defined(OS2)
#  define  STDC_HEADERS 1
#  define  HAVE_ASSERT_H 1
#  define  HAVE_CTYPE_H 1
#  define  HAVE_ISDIGIT 1
#  define  HAVE_ISALNUM 1
#  define  HAVE_UPPER_LOWER 1
#  define  HAVE_STRTOL 1
#  define  HAVE_STRSTR 1
#  define  HAVE_TIME_T 1
#  define  HAVE_VOID 1
#  include <io.h>
#  if USE_PAGER
#    define  SCREEN_ROWS   25          /* Default number of terminal rows */
#  endif
#  define  DIR_SEP       "\\"        /* Directory/folder separator */
#  define  PATH_SEP      ";"         /* Path separator */
#  define  ENV_VAR_DPATH "DPATH"     /* Name of data search path environment variable */
#  ifdef __GNUC__
#    define  ENV_VAR_TCAP  "TERMCAP"      /* Env-var holding path to termcap data base file */
#    define  FNAME_TCAP    "termcap.dat"  /* Name of termcap database file */
#    define  DFLT_TERM     "ansi"         /* Name of default terminal type */
#  endif
#elif defined(ACORN)
#  define  STDC_HEADERS 1
#  define  HAVE_ASSERT_H 1
#  define  HAVE_CTYPE_H 1
#  define  HAVE_ISDIGIT 1
#  define  HAVE_ISALNUM 1
#  define  HAVE_UPPER_LOWER 1
#  define  HAVE_STRTOL 1
#  define  HAVE_STRSTR 1
#  define  HAVE_TIME_T 1
#  define  HAVE_VOID 1
#  define  PATH_SEP      ","         /* Path separator */
#  define  ENV_VAR_PATH  "Run$Path"  /* Name of program search path environment variable */
#  define  ENV_VAR_DPATH "Run$Path"  /* Name of data search path environment variable */
#  ifdef __GNUC__
#    define  HAVE_UNISTD_H 1
#  endif
#elif defined(AMIGA)
#  define  STDC_HEADERS 1
#  define  HAVE_ASSERT_H 1
#  define  HAVE_CTYPE_H 1
#  define  HAVE_ISDIGIT 1
#  define  HAVE_ISALNUM 1
#  define  HAVE_UPPER_LOWER 1
#  define  HAVE_STRTOL 1
#  define  HAVE_STRSTR 1
#  define  HAVE_TIME_T 1
#  define  HAVE_VOID 1
#  ifdef __GNUC__
#    define  HAVE_UNISTD_H 1
#  endif
#elif defined(ATARI)
#  ifdef __GNUC__
#    ifndef STDC_HEADERS
#      define  STDC_HEADERS 1
#    endif
#    define  HAVE_UNISTD_H 1
#  else
#    define  STDC_HEADERS 1
#  endif /* !__GNUC__ */
#  define  HAVE_ASSERT_H 1
#  define  HAVE_CTYPE_H 1
#  define  HAVE_ISDIGIT 1
#  define  HAVE_ISALNUM 1
#  define  HAVE_UPPER_LOWER 1
#  define  HAVE_STRTOL 1
#  define  HAVE_STRSTR 1
#  define  HAVE_TIME_T 1
#  define  HAVE_VOID 1
#  define  DIR_SEP       "\\"        /* Directory/folder separator */
#  define  PATH_SEP      ","         /* Path separator */
#elif defined(__50SERIES)            /* Prime/PRIMOS */
#  define  STDC_HEADERS 1
#  define  HAVE_ASSERT_H 1
#  define  HAVE_CTYPE_H 1
#  define  HAVE_ISDIGIT 1
#  define  HAVE_ISALNUM 1
#  define  HAVE_UPPER_LOWER 1
#  define  HAVE_STRTOL 1
#  define  HAVE_STRSTR 1
#  define  HAVE_TIME_T 1
#  define  HAVE_VOID 1
#  define  DIR_SEP       ">"         /* Directory/folder separator */
#elif defined(VAXC) || defined(VMS)  /* DEC Vax */
#  ifndef UNIX
#    define  UNIX     /* Now let's define the symbol UNIX for default */
#  endif
#  define  STDC_HEADERS 1
#  define  HAVE_ASSERT_H 1
#  define  HAVE_CTYPE_H 1
#  define  HAVE_ISDIGIT 1
#  define  HAVE_ISALNUM 1
#  define  HAVE_UPPER_LOWER 1
#  define  HAVE_STRTOL 1
#  define  HAVE_STRSTR 1
#  define  HAVE_TIME_T 1
#  define  HAVE_VOID 1
#  ifdef VAXC
#    include <unixio.h>
#  endif
#  define  DIR_SEP        "]"        /* Directory/folder separator */
#  define  SUFFIX_SEP     ";"        /* Suffix (version number) separator */
#  define  ENV_VAR_GCAL   "GCAL_OPT" /* Name of programs default options variable */
#else /* default: UNIX */
#  ifndef UNIX
#    define  UNIX     /* Now let's define the symbol UNIX for default */
#  endif
#endif /* default: UNIX */



/*
*  More precise attributes
*/
#define  LOCAL           static
#define  PUBLIC       /* Public */
#define  IMPORT          extern
#define  EXPORT          PUBLIC



/*
*  Compiler specific macro for prototyping
*/
#ifndef __P_
#  if __STDC__ || defined(__cplusplus) || STDC_HEADERS
#    define  ANSI_PROTO
#    define  __P_(gc_proto)  gc_proto
#  else /* !__STDC__ && !__cplusplus && !STDC_HEADERS */
#    define  __P_(gc_proto)  ()
#  endif /* !__STDC__ && !__cplusplus && !STDC_HEADERS */
#endif



/*
   Action specific preprocessor constants
*/
/*
   Termcap action is only allowed for these systems
*/
#ifndef DJG
#  if defined(UNIX) || (defined(OS2) && defined(__GNUC__))
#    if HAVE_LIBTERMCAP || HAVE_LIBTERMLIB
#      define  GCAL_TCAP
#    endif
#  endif
#endif
/*
*  Writing a shell script is only allowed on these systems
*/
#if defined(UNIX) && !defined(DJG)
#  define  GCAL_SHELL
#endif
/*
*  Using an external pager is only allowed on these systems
*/
#if defined(UNIX) && !defined(DJG) && USE_PAGER
#  define  GCAL_EPAGER
#endif
/*
   Email option is only allowed for these systems
*/
#if defined(__GNUC__) || defined(UNIX) || defined(OS2) || defined(MSDOS) || defined(DJG) || defined(WIN32)
#  define  GCAL_EMAIL
#endif



/*
*  Target specific preprocessor statements
*/
#ifdef GCAL_TCAP
#  ifndef ENV_VAR_TERM
#    define  ENV_VAR_TERM  "TERM"           /* Name of terminal mode/type environment varable */
#  endif
#endif
#ifdef GCAL_SHELL
#  define  SHL_REM       "#"              /* The comment character of the shell */
#  ifndef CHMOD_PRGR
#    define  CHMOD_PRGR    "chmod"          /* Name of default `chmod' program */
#  endif
#  define  CHMOD_OPTS    "+x"            /* Make created shell script executable for all users */
#  if USE_RC
#    define  PRGR_RC_NAME  "."PRGR_NAME"rc" /* Default name of resource file */
#  endif
#else /* !GCAL_SHELL */
#  if USE_RC
#    define  PRGR_RC_NAME  PRGR_NAME"rc"    /* Default name of resource file */
#  endif
#endif /* !GCAL_SHELL */
#if defined(GCAL_SHELL) && HAVE_SYS_INTERPRETER
#  ifndef SHELL
#    define  SHELL         SHL_REM"! /bin/sh"     /* Id for the first line of a shell script */
#  endif
#endif
#ifdef GCAL_EMAIL
#  ifndef REDIRECT
#    define REDIRECT       "<"              /* Input redirection symbol */
#  endif
#  ifndef MAIL_PRGR
#    define  MAIL_PRGR     "mail"           /* Name of default mailer, mostly mail */
#  endif
#endif /* GCAL_EMAIL */
#if USE_PAGER
#  ifndef SCREEN_ROWS
#    define SCREEN_ROWS    24               /* Default number of terminal rows */
#  endif
#  ifndef SCREEN_COLS
#    define  SCREEN_COLS   80               /* Default number of terminal columns */
#  endif
#  ifdef GCAL_EPAGER
#    define  ENV_VAR_PAGER "PAGER"          /* Name of external pager program environment variable */
#    ifndef PAGER_PROG
#      define  PAGER_PROG    "less"           /* Name of first default pager program */
#    endif
#    ifndef PAGER2_PROG
#      define  PAGER2_PROG   "more"           /* Name of second default pager program */
#    endif
#  endif /* GCAL_EPAGER */
#endif /* USE_PAGER */
#ifndef DIR_SEP
#  define  DIR_SEP       "/"              /* Default directory/folder separator */
#endif
#ifndef PATH_SEP
#  define  PATH_SEP      ":"              /* Default path separator */
#endif
#ifndef ENV_VAR_HOME
#  define  ENV_VAR_HOME  "HOME"           /* Name of home directory environment variable */
#endif
#ifndef ENV_VAR_PATH
#  define  ENV_VAR_PATH  "PATH"           /* Name of program search path environment variable */
#endif
#ifndef ENV_VAR_DPATH
#  define  ENV_VAR_DPATH "GCALPATH"       /* Name of data search path environment variable */
#endif
#ifndef ENV_VAR_GCAL
#  define  ENV_VAR_GCAL  "GCAL"           /* Name of programs default options variable */
#endif
#ifndef ENV_VAR_GCALANSI
#  define  ENV_VAR_GCALANSI  "GCALANSI"   /* Name of variable for setting ANSI-sequences to default */
#endif
/*
*  Now define the user- and system library directories of gcal's resource files
*/
#if USE_RC
#  ifndef  GCAL_USR_LIBDIR
#    define  GCAL_USR_LIBDIR  "lib"DIR_SEP"gcal-lib"                      /* relative to $HOME dir */
#  endif
#  ifndef  GCAL_SYS_LIBDIR
#    define  GCAL_SYS_LIBDIR  DIR_SEP"usr"DIR_SEP"lib"DIR_SEP"gcal-lib"   /* absolute to root dir */
#  endif
#endif /* USE_RC */



/*
*  Define the lower case representation of the german `umlaute'
*/
#if USE_EASC
#  if USE_GER && defined(LINUX)
#    define  AE          "\344"   /* \xe4 */
#    define  OE          "\366"   /* \xf6 */
#    define  UE          "\374"   /* \xfc */
#    define  SZ          "\337"   /* \xdf */
#    define  AAE         "\304"   /* \xc4 */
#    define  OOE         "\326"   /* \xd6 */
#    define  UUE         "\334"   /* \xdc */
#  else /* !USE_GER || !LINUX */
#    define  AE          "\204"   /* \x84 */
#    define  OE          "\224"   /* \x94 */
#    define  UE          "\201"   /* \x81 */
#    define  SZ          "\341"   /* \xe1 */
#    define  AAE         "\216"   /* \x8e */
#    define  OOE         "\231"   /* \x99 */
#    define  UUE         "\232"   /* \x9a */
#  endif /* !USE_GER || !LINUX */
#else /* !USE_EASC */
#  define  AE          "\"a"
#  define  OE          "\"o"
#  define  UE          "\"u"
#  define  SZ          "\"s"
#  define  AAE         "\"A"
#  define  OOE         "\"O"
#  define  UUE         "\"U"
#endif /* !USE_EASC */



/*
*  Define the default highlighting sequences
*/
#if USE_EASC
#  define  BUF_HLS1S    "\021"       /* \x11 Highlighting sequence 1 start (current day) */
#  define  BUF_HLS1E    "\020"       /* \x10 Highlighting sequence 1 end (current day) */
#  define  BUF_HLS2S    "\256"       /* \xae Highlighting sequence 2 start (holiday) */
#  define  BUF_HLS2E    "\257"       /* \xaf Highlighting sequence 2 end (holiday) */
#else /* !USE_EASC */
#  define  BUF_HLS1S    "<"          /* Highlighting sequence 1 start (current day) */
#  define  BUF_HLS1E    ">"          /* Highlighting sequence 1 end (current day) */
#  define  BUF_HLS2S    ":"          /* Highlighting sequence 2 start (holiday) */
#  define  BUF_HLS2E    ":"          /* Highlighting sequence 2 end (holiday) */
#endif /* !USE_EASC */
#if USE_HLS
#  if defined(MSDOS) || defined(OS2) || defined(LINUX) || defined(DJG)
#    define  HLS1S        "\033[1m"    /* Highlighting sequence 1 start (current day) */
#    define  HLS2S        "\033[36m"   /* Highlighting sequence 2 start (holiday) */
#  else /* !MSDOS && !OS2 && !LINUX && !DJG */
#    define  HLS1S        "\033[7m"    /* Highlighting sequence 1 start (current day) */
#    define  HLS2S        "\033[1m"    /* Highlighting sequence 2 start (holiday) */
#  endif /* !MSDOS && !OS2 && !LINUX && !DJG */
#  define  HLS1E        "\033[0m"    /* Highlighting sequence 1 end (current day) */
#  define  HLS2E        "\033[0m"    /* Highlighting sequence 2 end (holiday) */
#  define  TC_MC_HL1S   "mr"         /* Termcap mode character HL 1 start (current day) */
#  define  TC_MC_HL1E   "me"         /* Termcap mode character HL 1 end (current day) */
#  define  TC_MC_HL2S   "md"         /* Termcap mode character HL 2 start (holiday) */
#  define  TC_MC_HL2E   "me"         /* Termcap mode character HL 2 end (holiday) */
#else /* !USE_HLS */
#  define  HLS1S        BUF_HLS1S    /* Highlighting sequence 1 start (current day) */
#  define  HLS1E        BUF_HLS1E    /* Highlighting sequence 1 end (current day) */
#  define  HLS2S        BUF_HLS2S    /* Highlighting sequence 2 start (holiday) */
#  define  HLS2E        BUF_HLS2E    /* Highlighting sequence 2 end (holiday) */
#endif /* !USE_HLS */
#define  TC_MC_MAX    4            /* Maximum number of termcap mode chars/single HL sequences used */
#define  NO_HLS       " "          /* Print blank character if highlighting is disabled */
#endif /* __GCAL_TAI_H */
