/*
*  gcal_rcc.c:  Checks whether date entry in file is valid.
*
*
*  Copyright (C) 1994, 1995 Thomas Esken
*
*  This software doesn't claim completeness, correctness or usability.
*  On principle I will not be liable for any damages or losses (implicit
*  or explicit), which result from using or handling my software.
*  If you use this software, you agree without any exception to this
*  agreement, which binds you LEGALLY !!
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the `GNU General Public License' as published by
*  the `Free Software Foundation'; either version 2, or (at your option)
*  any later version.
*
*  You should have received a copy of the `GNU General Public License'
*  along with this program; if not, write to the:
*    Free Software Foundation
*    59 Temple Place, Suite 330
*    Boston, MA 02111-1307  USA
*/



/*
*  Include definition header file to see whether USE_RC is defined there.
*    compile this module only if USE_RC is defined, otherwise skip it.
*/
#include "gcal_tai.h"



#if USE_RC
#  ifdef RCSID
static char rcsid[]="$Id: gcal_rcc.c 0.39 1995/12/20 00:03:09 tom Exp $";
#  endif



/*
*  Include header files
*/
#if HAVE_ASSERT_H
#  include <assert.h>
#endif
#  if HAVE_CTYPE_H
#    include <ctype.h>
#  endif
#  include "gcal.h"



/*
*  Function prototypes
*/
#  if __cplusplus
extern "C"
{
#  endif
/*
************************************************** Defined in `gcal_rc.c'
*/
IMPORT char *
rc_get_date __P_((      char *ptr_char,
                        Bool *is_weekday_mode,
                        int  *d,
                        int  *m,
                        int  *y,
                        int  *n,
                        int  *len,
                        char *hc,
                        int  *hn,
                        int  *hwd,
                  const char *filename,
                  const int   line,
                  const char *line_buffer,
                  const Bool  on_error_exit));
IMPORT Bool
precomp_nth_wd __P_((      int         diff,
                     const int         wd,
                           int        *n,
                           int        *day,
                           int        *month,
                           int        *year,
                     const Cmode_enum  mode));
IMPORT Bool
precomp_date __P_((      int         diff,
                   const int         wd,
                         int        *day,
                         int        *month,
                   const int         year,
                   const Cmode_enum  mode));
IMPORT void
nth_weekday_of_month __P_((      int  *d,
                                 int  *m,
                                 int  *y,
                           const int  *n,
                                 Bool *is_weekday_mode));
IMPORT void
prev_date __P_((int *day,
                int *month,
                int *year));
IMPORT void
next_date __P_((int *day,
                int *month,
                int *year));
IMPORT void
num2date __P_((Ulint  julian_days,
               int   *day,
               int   *month,
               int   *year));
IMPORT Slint
d_between __P_((const int d1,
                const int m1,
                const int y1,
                const int d2,
                const int m2,
                const int y2));
IMPORT Slint
w_between __P_((const int d1,
                const int m1,
                const int y1,
                const int d2,
                const int m2,
                const int y2));
IMPORT Slint
m_between __P_((const int m1,
                const int y1,
                const int m2,
                const int y2));
/*
************************************************** Defined in `gcal_utl.c'
*/
IMPORT VOID_PTR
my_malloc __P_((const int   amount,
                const int   exit_status,
                const char *module_name,
                const int   module_line,
                const char *var_name,
                const int   var_contents));
IMPORT VOID_PTR
my_realloc __P_((      VOID_PTR  ptr_memblock,
                 const int       amount,
                 const int       exit_status,
                 const char     *module_name,
                 const int       module_line,
                 const char     *var_name,
                 const int       var_contents));
IMPORT void
my_error __P_((const int   exit_status,
               const char *module_name,
               const int   module_line,
               const char *var_name,
               const int   var_contents));
IMPORT Bool
get_actual_date __P_((void));
#  if !USE_GER
IMPORT const char *
day_suffix __P_((int day));
#  endif
IMPORT const char *
short_month_name __P_((const int month));
IMPORT Ulint
date2num __P_((const int day,
               const int month,
               const int year));
IMPORT Bool
jdate2sdate __P_((      int  jdate,
                  const int  is_leap_year,
                        int *day,
                        int *month));
IMPORT int
weekday_of_date __P_((const int day,
                      const int month,
                      const int year));
IMPORT int
day_of_year __P_((const int day,
                  const int month,
                  const int year));
IMPORT int
days_of_february __P_((const int year));
IMPORT Bool
valid_date __P_((const int day,
                 const int month,
                 const int year));
IMPORT int
week_number __P_((const int day,
                  const int month,
                  const int year));
IMPORT int
knuth_easter_formula __P_((const int year));
/*
************************************************** Defined in `gcal_rcc.c'
*/
EXPORT void
rc_check __P_((      char *line_buffer,
               const char *filename,
                     int  *line,
                     int  *rc_elems,
                     int   day,
                     int   ed,
               const int   wd));
#  if __cplusplus
}
#  endif



/*
*  Declare public(extern) variables
*/
IMPORT const int    dvec[MONTH_MAX];          /* Amount of days in months' */
IMPORT Hls_struct   ehls1s;                   /* Effective hls 1 start (current day) */
IMPORT Hls_struct   ehls1e;                   /* Effective hls 1 end (current day) */
IMPORT Dvar_struct  rc_dvar[RC_DVAR_MAX];     /* Date variables a[=`mmdd']...z[] (`yyyy'@{a|b|...|z}[[-]<n>]) */
#if HAVE_ASSERT_H
IMPORT Uint         testval;                  /* Set to INT_MAX for checking the maximum table range */
#endif
IMPORT int          len_year_max;             /* String length of the maximum year able to compute */
IMPORT int          start_day;                /* -s<0,1...7|day name> */
IMPORT int          month;                    /* Current month */
IMPORT int          year;                     /* Current year */
IMPORT int          rc_elems_max;             /* Actual size of `rc_table' */
IMPORT int          rc_have_today_in_list;    /* [-c]d */
IMPORT int          act_min;                  /* Actual minute */
IMPORT int          act_hour;                 /* Actual hour */
IMPORT int          act_day;                  /* Actual day */
IMPORT int          act_month;                /* Actual month */
IMPORT int          act_year;                 /* Actual year */
IMPORT int          fiscal_month;             /* Starting month of a fiscal year */
IMPORT int          is_leap_year;             /* Is current year a leap year? */
IMPORT int          len_fil_wt;               /* Filler length of week number text */
IMPORT char         s[MAXLEN+1];              /* General purpose text buffer */
IMPORT char         s2[MAXLEN+1];             /* General purpose text buffer */
IMPORT char       **rc_table;                 /* Stores the valid fixed date texts */
IMPORT Bool         rc_enable_fn_flag;        /* [-c]a */
IMPORT Bool         rc_weekno_flag;           /* [-c]k */
IMPORT Bool         rc_period_list;           /* [-c]l */
IMPORT Bool         rc_period_flag;           /* [-c]<<<<n>>[<d|w|+|-]>|`mmdd'|`mmww[w]'<n>> */
IMPORT Bool         rc_tomorrow_flag;         /* [-c]t */
IMPORT Bool         rc_week_flag;             /* [-c]w */
IMPORT Bool         rc_month_flag;            /* [-c]m */
IMPORT Bool         rc_year_flag;             /* [-c]y */
IMPORT Bool         rc_week_year_flag;        /* [-c<<n>>]w */
IMPORT Bool         rc_forwards_flag;         /* [-c<<n>|w|m|y>]+ */
IMPORT Bool         rc_backwards_flag;        /* [-c<<n>|w|m|y>]- */
IMPORT Bool         is_date_given;            /* Is a date given in the command line? */
IMPORT Bool         highlight_flag;           /* -H<yes> or -H<no> */
IMPORT Bool         is_3month_mode;           /* Argument is "." or ".+" or ".-" */
IMPORT Bool         is_3month_mode2;          /* Argument is ".." -> current quarter of actual year */
IMPORT Bool         adate_set;                /* [-c]<n>w and actual date modified */



#  ifdef ANSI_PROTO
EXPORT void
rc_check (      char *line_buffer,
          const char *filename,
                int  *line,
                int  *rc_elems,
                int   day,
                int   ed,
          const int   wd)
#  else /* !ANSI_PROTO */
   EXPORT void
rc_check (line_buffer, filename, line, rc_elems, day, ed, wd)
         char *line_buffer;
   const char *filename;
         int  *line;
         int  *rc_elems;
         int   day;
         int   ed;
   const int   wd;
#  endif /* !ANSI_PROTO */
/*
   Checks whether a single line of resource file resp.,
     eternal holiday must be displayed
*/
{
   register int    i;
   register int    j;
   register int    incr_year=0;
   register int    decr_year=0;
   register int    print_twice;
   register int    tmp_month=month;
   auto     int    d;
   auto     int    m;
   auto     int    y;
   auto     int    n;
   auto     int    hn;
   auto     int    hhn;
   auto     int    hwd;
   auto     int    hhwd;
   auto     int    len;
   auto     int    dd;
   auto     int    mm;
   auto     int    yy;
   auto     int    nn;
   auto     int    d2;
   auto     int    m2;
   static   char   str[MAXLEN+1];
   auto     char  *ptr_char;
   auto     char   hc;
   auto     char   hhc;
   auto     Bool   print_line;
   auto     Bool   is_weekday_mode;
   auto     Bool   is_2dvar=FALSE;
   auto     Bool   is_2easter=FALSE;
   auto     Bool   is_valid_date=TRUE;
   auto     Bool   change_month=FALSE;


   ptr_char = rc_get_date (line_buffer, &is_weekday_mode, &d, &m, &y, &n, &len,
                           &hc, &hn, &hwd, filename, *line, line_buffer, TRUE);
   if (len < 1)
     /*
        Error, invalid date field given
     */
     my_error (123, filename, *line, line_buffer, 0);
   if (!month)
    {
      month = act_month;
      change_month = TRUE;
    }
   if (d)
    {
      /*
         If special value 99 for day `d' is given,
           set day to last day of month
      */
      if (d == 99)
       {
         if (m)
          {
            if (m == 2)
              d = days_of_february ((y) ? y : year);
            else
              d = dvec[m-1];
          }
         else
          {
            if (month == 2)
              d = days_of_february ((y) ? y : year);
            else
              d = dvec[month-1];
          }
       }
      is_valid_date = valid_date (d, (m) ? m : month, (y) ? y : year);
    }
   if (!is_valid_date)
    {
      if (   y == -1
          || (   !y
              && (   (   (   m == 2
                          || (   !m
                              && (month == 2)))
                      && (d == 29))
                  || (   !m
                      && (d <= 31))))
          || (   y
              && !m
              && (d <= 31)))
        is_valid_date = TRUE;   /* If no month/year entry encoded, ignore that date */
      else
        /*
           Invalid date field given
        */
        my_error (121, filename, *line, line_buffer, 0);
    }
   /*
      If "n'th weekday of month" field is encoded, compute the according date
   */
   if (n)
     nth_weekday_of_month (&d, &m, &y, &n, &is_weekday_mode);
   else
     /*
        If @e... Easter holiday date part is given, compute the according date
     */
     if (hc == RC_EASTER_CHAR)
      {
        register int  epy=knuth_easter_formula (year-1);   /* Date of Easter Sunday in previous year */
        register int  eay=knuth_easter_formula (year);     /* Date of Easter Sunday in current year */
        register int  eny=knuth_easter_formula (year+1);   /* Date of Easter Sunday in next year */


        if (fiscal_month > MONTH_MIN)
         {
           /*
              Precalculate number of days in last month of fiscal year
           */
           if (fiscal_month-1 == 2)
             i = days_of_february (year+1);
           else
             i = dvec[fiscal_month-2];
           /*
              Manage fiscal year request
           */
           if (year == EASTER_MIN-1)
            {
              j = day_of_year (i, fiscal_month-1, year+1);
              if (hn+eny <= j)
               {
                 if (!precomp_date (hn, hwd, &d, &m, year+1, EAster))
                   y = -1;
               }
              else
                y = -1;
            }
           else
            {
              j = day_of_year (DAY_MIN, fiscal_month, year);
              if (hn+eay >= j)
               {
                 if (!precomp_date (hn, hwd, &d, &m, year, EAster))
                   y = -1;
                 else
                  {
                    /*
                       Check whether event occurs in next year, too
                    */
                    j = day_of_year (i, fiscal_month-1, year+1);
                    if (   !is_3month_mode
                        && !is_3month_mode2
                        && (hn+eny <= j))
                      is_2easter = TRUE;
                  }
               }
              else
               {
                 if (   is_3month_mode
                     || is_3month_mode2)
                  {
                    if (fiscal_month >= MONTH_MAX-1)
                     {
                       j = dvec[MONTH_MIN-1];
                       if (fiscal_month == MONTH_MAX)
                         j += days_of_february (year+1) + is_leap_year;
                       if (hn+eny <= j)
                        {
                          if (!precomp_date (hn, hwd, &d, &m, year+1, EAster))
                            y = -1;
                        }
                       else
                         y = -1;
                     }
                    else
                      y = -1;
                  }
                 else
                  {
                    j = day_of_year (i, fiscal_month-1, year+1);
                    if (hn+eny <= j)
                     {
                       if (!precomp_date (hn, hwd, &d, &m, year+1, EAster))
                         y = -1;
                     }
                    else
                      y = -1;
                  }
               }
            }
         }
        else
          /*
             Manage -c0w request resp.,
               -cw in case date is in first days of january
          */
          if (day < DAY_MIN)
           {
             j = DAY_LAST + (days_of_february (year-1) == 29);
             if (   (hn+epy >= j+day)
                 && (hn+epy <= j))
              {
                if (!precomp_date (hn, hwd, &d, &m, year-1, EAster))
                  y = -1;
              }
             else
              {
                if (hn+eay < ed)
                 {
                   if (!precomp_date (hn, hwd, &d, &m, year, EAster))
                     y = -1;
                 }
                else
                  y = -1;
              }
           }
          else
            /*
               Manage -c99w (-c52w | -c53w) request resp.,
                 -ct or -cw in case date is in last days of december
            */
            if (ed > DAY_LAST+is_leap_year+1)
             {
               j = DAY_LAST + is_leap_year;
               if (   (hn+eay >= day)
                   && (hn+eay <= j))
                {
                  if (!precomp_date (hn, hwd, &d, &m, year, EAster))
                    y = -1;
                }
               else
                {
                  if (hn+eny < ed-j)
                   {
                     if (!precomp_date (hn, hwd, &d, &m, year+1, EAster))
                       y = -1;
                   }
                  else
                    y = -1;
                }
             }
            else
              /*
                 All other "ordinary" requests...
              */
              if (!precomp_date (hn, hwd, &d, &m, year, EAster))
                y = -1;
      }
     else
       /*
          If @`dvar'... date part is given, compute the according date
       */
       if (islower(hc))
        {
          if (fiscal_month > MONTH_MIN)
           {
             register int  date_dvar=day_of_year (d, m, year);


             /*
                Precalculate number of days in last month of fiscal year
             */
             if (fiscal_month-1 == 2)
               i = days_of_february (year+1);
             else
               i = dvec[fiscal_month-2];
             /*
                Manage fiscal year request
             */
             j = day_of_year (DAY_MIN, fiscal_month, year);
             /*
                Buffer day and month
             */
             d2 = d;
             m2 = m;
             if (hn+date_dvar >= j)
              {
                if (!precomp_date (hn, hwd, &d, &m, year, DVar))
                  y = -1;
                else
                 {
                   /*
                      Check whether event occurs in next year, too
                   */
                   j = day_of_year (i, fiscal_month-1, year+1);
                   if (   !is_3month_mode
                       && !is_3month_mode2
                       && (hn+date_dvar <= j))
                     is_2dvar = TRUE;
                 }
              }
             else
              {
                if (   is_3month_mode
                    || is_3month_mode2)
                 {
                   if (fiscal_month >= MONTH_MAX-1)
                    {
                      j = dvec[MONTH_MIN-1];
                      if (fiscal_month == MONTH_MAX)
                        j += days_of_february (year+1) + is_leap_year;
                      if (hn+date_dvar <= j)
                       {
                         if (!precomp_date (hn, hwd, &d, &m, year+1, DVar))
                           y = -1;
                       }
                      else
                        y = -1;
                    }
                   else
                     y = -1;
                 }
                else
                 {
                   j = day_of_year (i, fiscal_month-1, year+1);
                   if (hn+date_dvar <= j)
                    {
                      if (!precomp_date (hn, hwd, &d, &m, year+1, DVar))
                        y = -1;
                    }
                   else
                     y = -1;
                 }
              }
           }
          else
            /*
               All other "ordinary" requests...
            */
            if (!precomp_date (hn, hwd, &d, &m, year, DVar))
              y = -1;
        }
       else
         /*
            If 0*d|w<n>[ww[w]] date part is given, compute the according date
         */
         if (   hc == 'D'
             || hc == 'W')
          {
            y = year;
            if (precomp_nth_wd (hn, hwd, &hn, &d, &m, &y,
                                ((hc == 'D') ? DAy : WEek)))
             {
               register int  date_dvar=day_of_year (d, m, y);


               if (fiscal_month > MONTH_MIN)
                {
                  /*
                     Precalculate number of days in last month of fiscal year
                  */
                  if (fiscal_month-1 == 2)
                    i = days_of_february (year+1);
                  else
                    i = dvec[fiscal_month-2];
                  /*
                     Manage fiscal year request
                  */
                  j = day_of_year (DAY_MIN, fiscal_month, year);
                  /*
                     Buffer day and month
                  */
                  d2 = d;
                  m2 = m;
                  if (hn+date_dvar >= j)
                   {
                     /*
                        Check whether event occurs in next year, too
                     */
                     j = day_of_year (i, fiscal_month-1, year+1);
                     if (   !is_3month_mode
                         && !is_3month_mode2
                         && (hn+date_dvar <= j))
                       is_2dvar = TRUE;
                   }
                  else
                   {
                     if (   is_3month_mode
                         || is_3month_mode2)
                      {
                        if (fiscal_month >= MONTH_MAX-1)
                         {
                           j = dvec[MONTH_MIN-1];
                           if (fiscal_month == MONTH_MAX)
                             j += days_of_february (year+1) + is_leap_year;
                           if (hn+date_dvar <= j)
                            {
                              y++;
                              (void)precomp_nth_wd (hn, hwd, &hn, &d, &m, &y,
                                                    ((hc == 'D') ? DAy : WEek));
                            }
                           else
                             y = -1;
                         }
                        else
                          y = -1;
                      }
                     else
                      {
                        j = day_of_year (i, fiscal_month-1, year+1);
                        if (hn+date_dvar <= j)
                         {
                           y++;
                           (void)precomp_nth_wd (hn, hwd, &hn, &d, &m, &y,
                                                 ((hc == 'D') ? DAy : WEek));
                         }
                        else
                          y = -1;
                      }
                   }
                }
             }
          }
   /*
      Check whether current line must be displayed
   */
   print_line = FALSE;
   print_twice = 1;
   if (y >= 0)
    {
      if (   is_date_given
          || (   (year != act_year)
              && (day > 0))
          || (   (   month
                  && (month != act_month))
              && (year == act_year)))
       {
         /*
            NOT in simple month-/year mode (an explicit date is given in command line):
              manage -c[...] arguments
         */
         if (   d
             && !is_weekday_mode)
          {
            incr_year = (   (fiscal_month > MONTH_MIN)
                         && (m < fiscal_month)
                         && (   !y
                             || y == year+1));
            if (   is_date_given
                && month
                && !change_month
                && !m)
             {
               m = month;
               is_valid_date = valid_date (d, m, (y) ? y : year);
             }
            if (   is_valid_date
                && (   !y
                    || y-incr_year == year)
                && m
                && d)
             {
               if (   month
                   && !change_month)
                {
                  if (m == month)
                   {
                     if (   !is_leap_year
                         && (m == 2)
                         && (d == 29))
                       ;   /* If year is no leap year, ignore that date */
                     else
                       print_line = TRUE;
                   }
                }
               else
                {
                  if (fiscal_month > MONTH_MIN)
                   {
                     if (   (   incr_year
                             && (year < YEAR_MAX))
                         || (   (m >= fiscal_month)
                             && (   !y
                                 || y == year)))
                      {
                        if (   !(days_of_february (year+incr_year)==29)
                            && (m == 2)
                            && (d == 29))
                          ;   /* If year is no leap year, ignore that date */
                        else
                          print_line = TRUE;
                      }
                   }
                  else
                   {
                     if (   !is_leap_year
                         && (m == 2)
                         && (d == 29))
                       ;   /* If year is no leap year, ignore that date */
                     else
                       print_line = TRUE;
                   }
                }
             }
          }
       }
      else
       {
         /*
            Simple month-/year mode (NO explicit date is given in command line):
              manage [-c[...]]w|m|y[+|-] arguments
         */
         if (   (   rc_period_flag
                 || rc_week_flag
                 || rc_month_flag
                 || rc_year_flag)
             && !is_date_given
             && (   !y
                 || y == year
                 || (   rc_week_flag
                     && (   (   (year+1 <= YEAR_MAX)
                             && (ed > DAY_LAST+is_leap_year+1))
                         || (   (year-1 >= YEAR_MIN)
                             && (day < DAY_MIN))))))
          {
            register int  td;


            if (   m
                && d)
             {
               if (   rc_week_flag
                   && !y
                   && (m != month))
                {
                  if (   (ed > DAY_LAST+is_leap_year+1)
                      && !adate_set
                      && (   rc_forwards_flag
                          || (   !rc_forwards_flag
                              && !rc_backwards_flag)))
                    y = year + 1;
                  else
                    if (   (day < DAY_MIN)
                        && !adate_set
                        && (   rc_backwards_flag
                            || (   !rc_forwards_flag
                                && !rc_backwards_flag)))
                      y = year - 1;
                }
               if (   y < YEAR_MIN
                   || y > YEAR_MAX)
                {
                  if (adate_set)
                   {
                     if (m == month)
                      {
                        if (day < DAY_MIN)
                          y = year - 1;
                      }
                     else
                      {
                        if (ed > DAY_LAST+is_leap_year+1)
                          y = year + 1;
                      }
                     if (   y < YEAR_MIN
                         || y > YEAR_MAX)
                       y = year;
                   }
                  else
                    y = year;
                }
             }
            if (   (   rc_week_flag
                    && is_weekday_mode)
                || (   !is_weekday_mode
                    && (   y
                        || m
                        || d)))
             {
               /*
                  Respect short day name entry `yyyymmww[w]' ... (ww[w]==short dayname)
               */
               if (   rc_week_flag
                   && is_weekday_mode)
                {
                  static struct {
                                  char day[DAY_MAX];
                                  char dst[DAY_MAX];
                                } wday_list;
                  static Bool     fill_wday_list=FALSE;


                  j = 0;
                  if (!fill_wday_list)
                   {
                     if (   rc_forwards_flag
                         || (   !rc_forwards_flag
                             && !rc_backwards_flag))
                      {
                        i = wd;
                        LOOP
                         {
                           wday_list.day[i-1] = (char)i;
                           wday_list.dst[i-1] = (char)j++;
                           i++;
                           if (i > DAY_MAX)
                             i = DAY_MIN;
                           if (i == start_day)
                             break;
                         }
                      }
                     j = 0;
                     if (   rc_backwards_flag
                         || (   !rc_forwards_flag
                             && !rc_backwards_flag))
                      {
                        i = wd;
                        LOOP
                         {
                           if (i < DAY_MIN)
                             i = DAY_MAX;
                           wday_list.day[i-1] = (char)i;
                           wday_list.dst[i-1] = (char)++j;
                           if (i == start_day)
                             break;
                           i--;
                         }
                      }
                     fill_wday_list = TRUE;
                   }
                  if (wday_list.day[d-1])
                   {
                     yy = year;
                     if (rc_week_year_flag)
                      {
                        j = day;
                        if (day < 1)
                         {
                           yy = year - 1;
                           j += (DAY_LAST + (days_of_february (yy) == 29));
                         }
                        (void)jdate2sdate (j, (days_of_february (yy)==29), &dd, &mm);
                      }
                     else
                      {
                        dd = act_day;
                        mm = month;
                      }
                     if (rc_forwards_flag)
                       for (i=0 ; i < wday_list.dst[d-1] ; i++)
                         next_date (&dd, &mm, &yy);
                     else
                       if (rc_backwards_flag)
                         for (i=1 ; i < wday_list.dst[d-1] ; i++)
                           prev_date (&dd, &mm, &yy);
                       else
                        {
                          i = SYEAR(d, start_day);
                          j = SYEAR(wd, start_day);
                          if (i-j <= 0)
                            for (i=1 ; i < wday_list.dst[d-1] ; i++)
                              prev_date (&dd, &mm, &yy);
                          else
                            for (i=0 ; i < wday_list.dst[d-1] ; i++)
                              next_date (&dd, &mm, &yy);
                        }
                     if (   (   !m
                             || m == mm)
                         && (   !y
                             || y == yy))
                      {
                        d = dd;
                        m = mm;
                        y = yy;
                      }
                     else
                       y = -1;
                   }
                  else
                    y = -1;
                }
               if (   rc_week_flag
                   && (y >= 0)
                   && (   day < DAY_MIN
                       || ed > DAY_LAST+is_leap_year+1))
                {
                  if (   (   rc_backwards_flag
                          || (   !rc_forwards_flag
                              && !rc_backwards_flag))
                      && (y == year-1)
                      && m
                      && d)
                   {
                     ed = DAY_LAST + (days_of_february (y) == 29);
                     day = ed + day;
                     td = day_of_year (d, m, y);
                     if (   (td <= ed)
                         && (td >= day))
                      {
                        decr_year = 1;
                        print_line = TRUE;
                      }
                   }
                  else
                    if (   (   rc_forwards_flag
                            || (   !rc_forwards_flag
                                && !rc_backwards_flag))
                        && (y == year+1)
                        && m
                        && d)
                     {
                       td = day_of_year (d, m, y) + DAY_LAST + is_leap_year;
                       if (   (td < ed)
                           && (td >= day))
                        {
                          incr_year = 1;
                          print_line = TRUE;
                        }
                     }
                    else
                     {
                       if (   (   y == year
                               || (   (y == year-1)
                                   && !rc_forwards_flag)
                               || (   (y == year+1)
                                   && !rc_backwards_flag))
                           && m
                           && d)
                        {
                          td = day_of_year (d, m, y);
                          if (   (td < ed)
                              && (td >= day))
                            print_line = TRUE;
                        }
                       else
                         if (d)
                          {
                            td = 0;
                            m = month;
                            if (day < DAY_MIN)
                             {
                               if (   !y
                                   || y == year
                                   || y == year-1)
                                {
                                  if (adate_set)
                                    i = dvec[MONTH_MAX-1] + day - 1;
                                  else
                                    i = dvec[MONTH_MAX-1] + act_day - (SYEAR(wd, start_day));
                                  if (d > i)
                                   {
                                     m = MONTH_MAX;
                                     if (!y)
                                       y = year - 1;
                                     if (y == year)
                                       td = day_of_year (d, m, year);
                                     else
                                      {
                                        ed = DAY_LAST + (days_of_february (y) == 29);
                                        day = ed + day;
                                        td = day_of_year (d, m, y);
                                        decr_year = 1;
                                      }
                                   }
                                  else
                                    if (   !y
                                        || y == year)
                                     {
                                       if (adate_set)
                                        {
                                          m = MONTH_MIN;
                                          td = day_of_year (d, m, year) + 1;
                                        }
                                       else
                                         td = day_of_year (d, m, year) + 1;
                                     }
                                    else
                                      td = ed + 1;
                                  if (   (td <= ed)
                                      && (td >= day))
                                    print_line = TRUE;
                                }
                             }
                            else
                              if (   !y
                                  || y == year
                                  || y == year+1)
                               {
                                 i = act_day - (SYEAR(wd, start_day));
                                 if (d < i)
                                  {
                                    m = MONTH_MIN;
                                    if (!y)
                                      y = year + 1;
                                    if (y == year+1)
                                     {
                                       td = day_of_year (d, m, y) + DAY_LAST + is_leap_year;
                                       incr_year = 1;
                                     }
                                  }
                                 else
                                   if (   !y
                                       || y == year)
                                     td = day_of_year (d, m, year);
                                 if (   (td < ed)
                                     && (td >= day))
                                   print_line = TRUE;
                               }
                          }
                     }
                }
               else
                 if (   y >= 0
                     || y == year)
                  {
                    if (   (   (   rc_month_flag
                                || rc_week_flag
                                || rc_period_flag)
                            && m
                            && !d)
                        || (   (   rc_month_flag
                                || rc_week_flag)
                            && !m
                            && !d)
                        || (   (   rc_year_flag
                                || rc_period_list)
                            && (   !m
                                || !d)))
                      ;   /* Ignore those entries !! */
                    else
                     {
                       if (!y)
                         y = year;
                       if (!m)
                        {
                          m = month;
                          (void)jdate2sdate (day, is_leap_year, &dd, &mm);
                          if (   (dd > d)
                              && (mm == m))
                            m++;
                          else
                            if (   (dd < d)
                                && (mm < m))
                              m--;
                        }
                       if (valid_date (d, m, y))
                        {
                          td = day_of_year (d, m, y);
                          if (   (td >= day)
                              && (td < ed))
                            print_line = TRUE;
                        }
                     }
                  }
             }
          }
         else
           if (   !rc_period_flag
               && !rc_week_flag
               && !rc_month_flag
               && !rc_year_flag)
            {
              /*
                 Simple month-/year month mode (NO explicit date is given in command line):
                   manage -c[...]t arguments
              */
              dd = act_day;
              mm = month;
              yy = year;
              if (rc_tomorrow_flag)
                next_date (&dd, &mm, &yy);
              if (   (   !y
                      || y == year
                      || (   rc_tomorrow_flag
                          && (ed > DAY_LAST+is_leap_year+1)
                          && (y == year+1)
                          && (   !m
                              || m == mm)))
                  && (   !m
                      || m == month
                      || (   rc_tomorrow_flag
                          && (m == mm)
                          && (   !y
                              || (   (ed > DAY_LAST+is_leap_year+1)
                                  && (y == year+1))
                              || (   (ed <= DAY_LAST+is_leap_year+1)
                                  && (y == year))))))
               {
                 if (is_weekday_mode)
                  {
                    /*
                       Respect short day name entry `yyyymmww[w]' ... (ww[w]==short dayname)
                    */
                    i = weekday_of_date (act_day, month, year);
                    j = 0;
                    if (rc_tomorrow_flag)
                      j = (d == weekday_of_date (dd, mm, yy));
                    if (   (   (d == i)
                            && (ed <= DAY_LAST+is_leap_year+1)
                            && (   !m
                                || m == month))
                        || (   (d == i)
                            && (   (ed > DAY_LAST+is_leap_year+1)
                                && (   (   !y
                                        && (   !m
                                            || m == month))
                                    || y == year)))
                        || (   j
                            && (   !m
                                || m == month+1
                                || m == mm)
                            && (   !y
                                || (   (ed > DAY_LAST+is_leap_year+1)
                                    && (y == year+1))
                                || (   (ed <= DAY_LAST+is_leap_year+1)
                                    && (y == year)))))
                     {
                       if (j)
                        {
                          m = mm;
                          d = dd;
                          if (   rc_tomorrow_flag
                              && (yy != year))
                            incr_year = 1;
                        }
                       else
                        {
                          m = month;
                          d = act_day;
                        }
                       if (   rc_tomorrow_flag
                           && !rc_have_today_in_list
                           && (d != dd))
                         ;   /* Void, skip those entries */
                       else
                         print_line = TRUE;
                     }
                  }
                 else
                   if (   !d
                       || (   (d == act_day)
                           && (   !m
                               || m == month)
                           && (   !y
                               || y == year))
                       || (   (d == dd)
                           && (   mm == month
                               || (   rc_tomorrow_flag
                                   && (   (   !m
                                           && (ed <= DAY_LAST+is_leap_year+1)
                                           && (   !y
                                               || y == year))
                                       || m == month+1
                                       || m == mm)))))
                    {
                      if (rc_tomorrow_flag)
                       {
                         if (   !d
                             && (   !m
                                 || (   mm == month
                                     || m == month+1
                                     || m == mm)))
                          {
                            if (   (yy > year)
                                && (   d
                                    || m
                                    || y))
                             {
                               if (   !y
                                   || y == yy)
                                {
                                  m = mm;
                                  d = dd;
                                  incr_year = 1;
                                }
                             }
                            else
                              if (   m
                                  || y != year
                                  || ed <= DAY_LAST+is_leap_year+1)
                               {
                                 if (   !d
                                     && m
                                     && (mm != month)
                                     && (   !y
                                         || y == year))
                                  {
                                    m = mm;
                                    d = dd;
                                  }
                                 else
                                  {
                                    if (rc_have_today_in_list)
                                      print_twice++;
                                    else
                                     {
                                       m = mm;
                                       d = dd;
                                       if (yy != year)
                                         incr_year = 1;
                                     }
                                  }
                               }
                          }
                         else
                          {
                            if (   (d == dd)
                                && (   !m
                                    || m == mm))
                             {
                               m = mm;
                               if (ed > DAY_LAST+is_leap_year+1)
                                 incr_year = 1;
                             }
                          }
                       }
                      if (!m)
                        m = month;
                      if (!d)
                        d = act_day;
                      if (   rc_tomorrow_flag
                          && !rc_have_today_in_list
                          && (d != dd))
                        ;   /* Void, skip those entries */
                      else
                        print_line = TRUE;
                    }
               }
            }
       }
    }
   /*
      Avoid incorrect assignment in case fixed date mentioned occurred
        during the missing period in month of Gregorian reformation
   */
   if (   print_line
       && (year+incr_year-decr_year == GREG_YEAR)
       && (m == GREG_MONTH)
       && (   (d >= GREG_F_DAY)
           && (d <= GREG_L_DAY)))
     print_line = FALSE;
   /*
      If 3-month mode is wanted, insert only those fixed date warnings
        which occur in that period
   */
   if (   print_line
       && (   is_3month_mode
           || is_3month_mode2))
    {
      register int  m2=fiscal_month+1;
      register int  m3=fiscal_month+2;


      if (fiscal_month >= MONTH_MAX-1)
       {
         m3 = MONTH_MIN;
         if (fiscal_month == MONTH_MAX)
          {
            m2 = MONTH_MIN;
            m3++;
          }
       }
      if (   (m != fiscal_month)
          && (m != m2)
          && (m != m3))
        print_line = FALSE;
    }
   /*
      Insert current line into `rc_table' now!
        (lines with no `text'-part are valid and are displayed)
   */
   if (   is_2easter
       || is_2dvar)
     print_twice++;
   if (print_line)
    {
      auto     Slint  num=0L;
      register int    k;
      register int    len_fn=len_year_max+5;
      register int    tmp_year=year;
      auto     Bool   ok;


      if (rc_enable_fn_flag)
        len_fn += (int)strlen(filename) + 3;
      /*
         Buffer fixed date text
      */
      if (print_twice > 1)
        strcpy(str, ptr_char);
      do
       {
         /*
            Check current line for %... macros
         */
         j=k = 0;
         while (MY_ISSPACE(*ptr_char))
           ptr_char++;
         ok = FALSE;
         while (!ok)
          {
            while (   *(ptr_char + j)
                   && (k < MAXLEN-len_fn))
             {
               if (*(ptr_char + j) == RC_MACRO_CHAR)
                {
                  if (j)
                   {
                     /*
                        Check if %... macro is quoted
                     */
                     if (*(ptr_char + (j - 1)) == QUOTE_CHAR)
                       k--;
                     else
                       break;
                   }
                  else
                    break;
                }
               s[k++] = *(ptr_char + j++);
             }
            if (k >= MAXLEN-len_fn)
              ok = TRUE;
            if (   !ok
                && *(ptr_char + j))
             {
               auto Bool  is_b;
               auto Bool  is_s;
               auto Bool  is_e;
               auto Bool  is_t;
               auto Bool  is_d;
               auto Bool  is_w;
               auto Bool  is_m;
               auto Bool  is_y;
               auto Bool  is_n;


               /*
                  `%'-character (macro prefix) found!
               */
               j++;
               is_b = (Bool)(tolower(*(ptr_char+j)) == RC_BYEAR_CHAR);
               is_s = (Bool)(tolower(*(ptr_char+j)) == RC_SDATE_CHAR);
               is_e = (Bool)(tolower(*(ptr_char+j)) == RC_EDATE_CHAR);
               is_t = (Bool)(tolower(*(ptr_char+j)) == RC_TIME_CHAR);
               is_d = (Bool)(tolower(*(ptr_char+j)) == RC_DAY_CHAR);
               is_w = (Bool)(tolower(*(ptr_char+j)) == RC_WEEK_CHAR);
               is_m = (Bool)(tolower(*(ptr_char+j)) == RC_MONTH_CHAR);
               is_y = (Bool)(tolower(*(ptr_char+j)) == RC_YEAR_CHAR);
               is_n = (Bool)(tolower(*(ptr_char+j)) == RC_DATE_CHAR);
               /*
                  Check for
                    %n[[+|-]<n>] or
                    %s[`yyyy'[`mm'[`dd'|`ww[w]'[<n>]]]], %s`yyyy'@..., %s`yyyy'*... or
                    %e[`yyyy'[`mm'[`dd'|`ww[w]'[<n>]]]], %e`yyyy'@..., %e`yyyy'*... or
                    %b[`yyyy'[`mm'[`dd'|`ww[w]'[<n>]]]], %b`yyyy'@..., %b`yyyy'*... or
                    %y[`yyyy'[`mm'[`dd'|`ww[w]'[<n>]]]], %y`yyyy'@..., %y`yyyy'*... macros
               */
               if (   is_n
                   || is_s
                   || is_e
                   || is_b
                   || (   is_y
                       && *(ptr_char + j + 1)
                       && !MY_ISSPACE(*(ptr_char+j+1))))
                {
                  j++;
                  if (!is_n)
                   {
                     (void)rc_get_date (ptr_char+j, &is_weekday_mode, &dd, &mm, &yy, &nn, &len,
                                        &hhc, &hhn, &hhwd, filename, *line, line_buffer, TRUE);
                     j += len;
                     if (!yy)
                      {
                        if (fiscal_month > MONTH_MIN)
                          yy = y;
                        else
                          yy = year;
                      }
                     /*
                        Respect possible fiscal year
                     */
                     if (yy != -1)
                      {
                        yy -= incr_year;
                        yy += decr_year;
                      }
                     /*
                        If @... date part is given,
                          compute the according date
                     */
                     if (hhc == RC_EASTER_CHAR)
                      {
                        if (fiscal_month > MONTH_MIN)
                         {
                           if (!precomp_date (hhn, hhwd, &dd, &mm, yy+incr_year, EAster))
                             yy = -1;
                         }
                        else
                          if (!precomp_date (hhn, hhwd, &dd, &mm, yy, EAster))
                            yy = -1;
                      }
                     else
                       if (islower(hhc))
                        {
                          if (rc_dvar[IDX(hhc)].l.month)
                           {
                             mm = (int)rc_dvar[IDX(hhc)].l.month;
                             dd = (int)rc_dvar[IDX(hhc)].l.day;
                           }
                          else
                            if (rc_dvar[IDX(hhc)].g.month)
                             {
                               mm = (int)rc_dvar[IDX(hhc)].g.month;
                               dd = (int)rc_dvar[IDX(hhc)].g.day;
                             }
                          if (fiscal_month > MONTH_MIN)
                           {
                             if (!precomp_date (hhn, hhwd, &dd, &mm, yy+incr_year, DVar))
                               yy = -1;
                           }
                          else
                            if (!precomp_date (hhn, hhwd, &dd, &mm, yy, DVar))
                              yy = -1;
                        }
                       else
                         if (   hhc == 'D'
                             || hhc == 'W')
                          {
                            if (fiscal_month > MONTH_MIN)
                             {
                               auto int  yyy=yy+incr_year;


                               if (!precomp_nth_wd (hhn, hhwd, &hhn, &dd, &mm, &yyy,
                                                    ((hhc == 'D') ? DAy : WEek)))
                                 yy = yyy;
                             }
                            else
                              (void)precomp_nth_wd (hhn, hhwd, &hhn, &dd, &mm, &yy,
                                                    ((hhc == 'D') ? DAy : WEek));
                          }
                     if (len > len_year_max)
                       len -= len_year_max;
                     else
                       len = 0;
                     /*
                        %s[`yyyy'[`mm'[`dd'|`ww[w]'[<n>]]]], %s`yyyy'@... or %s`yyyy'*...
                          starting year macro found
                     */
                     if (is_s)
                      {
                        /*
                           Assume current/first month of year
                        */
                        if (!mm)
                         {
                           if (len >= 1)
                            {
                              mm = m;
                              if (len == 2)
                                len -= 2;
                              else
                                len--;
                            }
                           else
                             mm = MONTH_MIN;
                         }
                        else
                         {
                           if (len == 2)
                             len -= 2;
                           else
                             len--;
                         }
                        /*
                           Assume current/first day of month
                        */
                        if (!dd)
                         {
                           if (len >= 1)
                             dd = d;
                           else
                             dd = DAY_MIN;
                         }
                      }
                     else
                       /*
                          %e[`yyyy'[`mm'[`dd'|`ww[w]'[<n>]]]], %s`yyyy'@... or %s`yyyy'*...
                            ending year macro found
                       */
                       if (is_e)
                        {
                          /*
                             Assume current/last month of year
                          */
                          if (!mm)
                           {
                             if (len >= 1)
                              {
                                mm = m;
                                if (len == 2)
                                  len -= 2;
                                else
                                  len--;
                              }
                             else
                               mm = MONTH_MAX;
                           }
                          else
                           {
                             if (len == 2)
                               len -= 2;
                             else
                               len--;
                           }
                          /*
                             Assume current/last day of month
                          */
                          if (!dd)
                           {
                             if (len >= 1)
                               dd = d;
                             else
                              {
                                if (mm == 2)
                                 {
                                   if (fiscal_month > MONTH_MIN)
                                     dd = days_of_february (yy+incr_year);
                                   else
                                     dd = days_of_february (yy);
                                 }
                                else
                                  dd = dvec[mm-1];
                              }
                           }
                        }
                       else
                        /*
                           %b[`yyyy'[`mm'[`dd'|`ww[w]'[<n>]]]], %s`yyyy'@... or %s`yyyy'*...
                             birth year macro or
                           %y[`yyyy'[`mm'[`dd'|`ww[w]'[<n>]]]], %s`yyyy'@... or %s`yyyy'*...
                             year macro found
                        */
                        {
                          /*
                             Assume current month/day
                          */
                          if (!mm)
                            mm = m;
                          if (!dd)
                            dd = d;
                        }
                     /*
                        If special value 99 for day `dd' is given,
                          set day to last day of month
                     */
                     if (dd == 99)
                      {
                        /*
                           Assume last day of month
                        */
                        if (mm == 2)
                         {
                           if (   is_e
                               && (fiscal_month > MONTH_MIN))
                             dd = days_of_february (yy+incr_year);
                           else
                             dd = days_of_february (yy);
                         }
                        else
                          dd = dvec[mm-1];
                      }
                     /*
                        If "n'th weekday of month" entry set,
                          compute the according date
                     */
                     if (nn)
                       nth_weekday_of_month (&dd, &mm, &yy, &nn, &is_weekday_mode);
                     /*
                        Compute the day difference of the two dates
                     */
                     if (yy >= 0)
                      {
                        if (   !nn
                            && (   fiscal_month > MONTH_MIN
                                || (   incr_year
                                    && (   rc_tomorrow_flag
                                        || rc_week_flag))))
                          yy += incr_year;
                        num = d_between (dd, mm, yy, d, m, (y) ? y : year+incr_year);
                        /*
                           Starting date of event greater current date resp.,
                             ending date of event smaller current date:
                             --> avoid displaying of fixed date text
                        */
                        if (is_s)
                         {
                           if (num < 0L)
                            {
                              ok = TRUE;
                              print_line = FALSE;
                            }
                         }
                        else
                          if (is_e)
                           {
                             if (num > 0L)
                              {
                                ok = TRUE;
                                print_line = FALSE;
                              }
                           }
                          else
                           /*
                              Manage
                                %b[`yyyy'[`mm'[`dd'|`ww[w]'[<n>]]]], %s`yyyy'@... or %s`yyyy'*...
                                  birth year macros and
                                %y[`yyyy'[`mm'[`dd'|`ww[w]'[<n>]]]], %s`yyyy'@... or %s`yyyy'*...
                                  year macros
                           */
                           {
                             if (is_b)
                              {
                                yy = ((y) ? y : year+incr_year) - yy;
                                if (   m < mm
                                    || (   (m == mm)
                                        && (d < dd)))
                                  yy--;
                              }
                             else
                              {
                                /*
                                   is_y
                                */
                                yy = yy - ((y) ? y : year+incr_year);
                                if (   m < mm
                                    || (   (m == mm)
                                        && (d < dd)))
                                 {
                                   if (yy < 1)
                                     yy++;
                                   else
                                     if (yy > 1)
                                       yy--;
                                 }
                              }
                             if (   is_b
                                 && (yy < 1))
                               ;   /* Void, don't manage resp., suppress such dates */
                             else
                              {
                                /*
                                   Print year difference
                                */
                                sprintf(s2, "%d", yy);
                                i = 0;
                                while (   s2[i]
                                       && (k < MAXLEN-len_fn))
                                  s[k++] = s2[i++];
#  if !USE_GER
                                if (is_b)
                                 {
                                   sprintf(s2, "%s", day_suffix (yy));
                                   i = 0;
                                   while (   s2[i]
                                          && (k < MAXLEN-len_fn))
                                     s[k++] = s2[i++];
                                 }
#  endif /* !USE_GER */
                              }
                           }
                        if (!*(ptr_char + j))
                          ok = TRUE;
                        else
                          if (   (*(ptr_char + j) == ' ')
                              && (s[k-1] == ' '))
                            k--;
                      }
                     else
                       if (   (*(ptr_char + j) == ' ')
                           && (s[k-1] == ' '))
                         k--;
                   }
                  else
                   {
                     auto Slint  jdate;


                     /*
                        %n[[+|-]<n>] macro found
                     */
                     i = 0;
                     while (   *(ptr_char + j) == *ASC_LIT
                            || *(ptr_char + j) == *DES_LIT
                            || isdigit(*(ptr_char+j)))
                      {
                        if (i < MAXLEN)
                          s2[i++] = *(ptr_char + j);
                        j++;
                      }
                     s2[i] = '\0';
                     num = atol(s2);
                     y = year + incr_year - decr_year;
                     jdate = (Slint)date2num (d, m, y);
                     if (   (jdate+num <= (Slint)date2num (dvec[MONTH_MAX-1], MONTH_MAX, YEAR_MAX))
                         && (jdate+num >= 1L))
                      {
                        num2date (jdate+num, &dd, &mm, &yy);
#  if USE_GER
                        sprintf(s2, "%02d-%s-%0*d", dd,
                                short_month_name (mm), len_year_max, yy);
#  else /* !USE_GER */
                        sprintf(s2, "%s-%02d-%0*d", short_month_name (mm),
                                dd, len_year_max, yy);
#  endif /* !USE_GER */
                        i = 0;
                        while (   s2[i]
                               && (k < MAXLEN-len_fn))
                          s[k++] = s2[i++];
                      }
                     else
                       if (   (*(ptr_char + j) == ' ')
                           && (s[k-1] == ' '))
                         k--;
                   }
                }
               else
                {
                  /*
                     %-character (macro prefix) found:
                       check for simple %t[12|24], %d, %w, %m and %y macros
                  */
                  if (   is_t
                      || is_d
                      || is_w
                      || is_m
                      || is_y)
                   {
                     if (is_t)
                      {
                        register int   tmp_ah=act_hour;
                        auto     char  time_suffix[3];
                        auto     Bool  is_12_hours_format=FALSE;


                        /*
                           Simple %t[12|24] macro found:
                             replace it by the current system time hh:mm[am|pm]
                        */
                        j++;
                        if (isdigit(*(ptr_char+j)))
                         {
                           if (*(ptr_char + j) == '1')
                             is_12_hours_format = TRUE;
                           while (isdigit(*(ptr_char+j)))
                             j++;
                         }
                        j--;
                        if (is_12_hours_format)
                         {
                           /*
                              Copy trailing "am" resp., "pm" to text
                           */
                           if (tmp_ah >= 12)
                            {
                              strcpy(time_suffix, RC_PM_TXT);
                              if (tmp_ah > 12)
                                tmp_ah -= 12;
                            }
                           else
                             strcpy(time_suffix, RC_AM_TXT);
                         }
                        else
                          *time_suffix = '\0';
                        sprintf(s2, "%s%02d"TIME_SEP"%02d%s%s",
                                (!highlight_flag) ? "" : ehls1s.seq,
                                tmp_ah, act_min, time_suffix,
                                (!highlight_flag) ? "" : ehls1e.seq);
                      }
                     else
                      {
                        auto Slint  diff;


                        /*
                           Simple %d, %w, %m or %y macros found:
                             replace it by the according, computed number
                        */
                        dd = act_day;
                        mm = act_month;
                        yy = act_year;
                        (void)get_actual_date ();
                        y = year + incr_year - decr_year;
                        /*
                           Now compute the differences:
                             date1 == actual (base)date (act_day, act_month, act_year)
                             date2 == reported date (d, m, y)
                        */
                        if (is_d)
                          diff = d_between (act_day, act_month, act_year, d, m, y);
                        else
                          if (is_w)
                            diff = w_between (act_day, act_month, act_year, d, m, y);
                          else
                            if (is_m)
                              diff = m_between (act_month, act_year, m, y);
                            else
                              /*
                                 Simple %y macro found
                              */
                              diff = (Slint)y - act_year;
                        sprintf(s2, "%ld", diff);
                        act_day = dd;
                        act_month = mm;
                        act_year = yy;
                      }
                     i = 0;
                     while (   s2[i]
                            && (k < MAXLEN-len_fn))
                       s[k++] = s2[i++];
                     j++;
                   }
                  else
                   {
                     j--;
                     s[j] = *(ptr_char + j);
                     k = ++j;
                   }
                }
             }
            else
              ok = TRUE;
            if (   ok
                || k >= MAXLEN-len_fn)
             {
               ok = TRUE;
               s[k] = '\0';
               strcpy(line_buffer, s);
               ptr_char = line_buffer;
             }
          }
         if (print_line)
          {
            if (rc_enable_fn_flag)
              sprintf(s, "%0*d%02d%02d (%s) %s",
                      len_year_max, year+incr_year-decr_year, m, d, filename, ptr_char);
            else
              sprintf(s, "%0*d%02d%02d %s",
                      len_year_max, year+incr_year-decr_year, m, d, ptr_char);
            /*
               Now compute whether a filler text for a week entry is needed:
                 week 53/1   == 7 chars text "|53/1| "  -> no filler text
                 week 1...53 == 5 chars text "|nn| "    -> 2 chars filler text
            */
            if (rc_weekno_flag)
              if (!week_number (d, m, year+incr_year-decr_year))
                len_fil_wt = 2;
            /*
               Now place the fixed date into vector;
                 only if previous fixed date is equal to actual fixed date,
                 avoid insertation of actual fixed date!
            */
            k = 1;
            if (*rc_elems)
              k = strcmp(s, rc_table[*rc_elems-1]);
            /*
               Store the constructed "raw" line in `rc_table[]'
            */
            if (k)
             {
                if (*rc_elems >= rc_elems_max)
                 {
#if HAVE_ASSERT_H
                   /*
                      Check if value for maximum number of table entries
                        fits to the positive range of a signed int(INT_MAX)!!
                   */
                   assert((Uint)rc_elems_max+RC_ELEMS_MAX<=testval);
#endif
                   /*
                      Resize the table
                   */
                   rc_elems_max += RC_ELEMS_MAX;
                   rc_table = (char **)my_realloc (rc_table, rc_elems_max*sizeof(char *),
                                                   124, __FILE__, __LINE__ -1,
                                                   "rc_elems", rc_elems_max);
                 }
               rc_table[*rc_elems] = (char *)my_malloc (strlen(s)+1,
                                                        124, __FILE__, __LINE__ -1,
                                                        "rc_elems", *rc_elems);
               strcpy(rc_table[(*rc_elems)++], s);
             }
          }
         /*
            Must we construct line more than once?
         */
         if (print_twice > 1)
          {
            /*
               Restore fixed date text
                 cause it's possible that we must evaluate the %... macros
                 again and the year has changed...
            */
            ptr_char = str;
            if (is_2easter)
             {
               /*
                  Precalculate next date relative to Easter Sunday
               */
               incr_year = 1;
               precomp_date (hn, hwd, &d, &m, year+incr_year, EAster);
             }
            else
              if (is_2dvar)
               {
                 /*
                    Precalculate next date relative to date variable
                      and use original date of `dvar', i.e. use buffer of day an month
                 */
                 incr_year = 1;
                 if (islower(hc))
                   (void)precomp_date (hn, hwd, &d2, &m2, year+incr_year, DVar);
                 else
                  {
                    y = year + incr_year;
                    (void)precomp_nth_wd (hn, hwd, &hn, &d2, &m2, &y,
                                          ((hc == 'D') ? DAy : WEek));
                  }
                 d = d2;
                 m = m2;
               }
              else
                /*
                   Compute tomorrows date
                */
                next_date (&d, &m, &year);
            print_line = TRUE;
          }
       } while (--print_twice); /* I don't like the GNU-coding scheme for do-whiles */
      year = tmp_year;
    }
   month = tmp_month;
}
#endif /* USE_RC */
