#ifndef __GCAL_H
#  define __GCAL_H
/*
*  gcal.h:  Program specific macros, typedefs, prototypes...
*
*
*  Copyright (C) 1994, 1995 Thomas Esken
*
*  This software doesn't claim completeness, correctness or usability.
*  On principle I will not be liable for any damages or losses (implicit
*  or explicit), which result from using or handling my software.
*  If you use this software, you agree without any exception to this
*  agreement, which binds you LEGALLY !!
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the `GNU General Public License' as published by
*  the `Free Software Foundation'; either version 2, or (at your option)
*  any later version.
*
*  You should have received a copy of the `GNU General Public License'
*  along with this program; if not, write to the:
*    Free Software Foundation
*    59 Temple Place, Suite 330
*    Boston, MA 02111-1307  USA
*/



/*
*  $Id: gcal.h 0.38 1995/12/09 00:03:08 tom Exp $
*/



/*
*  Include (sub)header files   ;<
*/
#if HAVE_STDIO_H || STDC_HEADERS
#  include <stdio.h>
#endif
#if HAVE_STDLIB_H || STDC_HEADERS
#  include <stdlib.h>
#endif
#if HAVE_STRING_H || STDC_HEADERS
#  include <string.h>
#else /* !HAVE_STRING_H && !STDC_HEADERS */
#  include <strings.h>
#  if !HAVE_STRCHR
#    define strchr       index
IMPORT char *strchr __P_((const char *s, int c));
#  endif /* !HAVE_STRCHR */
#  if !HAVE_STRRCHR
#    define strrchr      rindex
IMPORT char *strrchr __P_((const char *s, int c));
#  endif /* !HAVE_STRRCHR */
#endif
#ifdef __50SERIES
IMPORT char *getenv __P_((const char *env_var));
#endif


/*
*  Basic preprocessor statements and macros
*/
#ifndef NULL
#  define  NULL          0
#endif
#ifndef TRUE
#  define  TRUE          (0==0)
#endif
#ifndef FALSE
#  define  FALSE         (!TRUE)
#endif
#define  LOOP            for(;;)
#if HAVE_VOID
#  define  VOID_PTR      void *
#else /* !HAVE_VOID */
#  define  VOID_PTR      char *
#  define  void          int
#endif /* !HAVE_VOID */
#if !HAVE_STRSTR
#  define  strstr        my_strstr
#endif
#if HAVE_TIME_T
#  define  MY_TIME_T     time_t
#else /* !HAVE_TIME_T */
#  define  MY_TIME_T     long
#endif /* !HAVE_TIME_T */
#if !HAVE_ISDIGIT
#  define  isdigit(gc_c) (((gc_c) >= '0') && ((gc_c) <= '9'))
#endif
#if !HAVE_ISALNUM
#  define  isalnum(gc_c) (   isdigit(gc_c) \
                          || isupper(gc_c) \
                          || islower(gc_c))
#endif
#if !HAVE_UPPER_LOWER
#  define  islower(gc_c) (((gc_c) >= 'a') && ((gc_c) <= 'z'))
#  define  isupper(gc_c) (((gc_c) >= 'A') && ((gc_c) <= 'Z'))
#  define  tolower(gc_c) ((isupper(gc_c)) \
                           ? (gc_c) - 'A' + 'a' \
                           : (gc_c))
#  define  toupper(gc_c) ((islower(gc_c)) \
                           ? (gc_c) - 'a' + 'A' \
                           : (gc_c))
#endif



/*
*  Program specific preprocessor statements
*/
#ifndef BUF_LEN
#  define BUF_LEN        16384         /* Maximum length of file block buffer */
#endif
#ifndef MAXLEN
#  define  MAXLEN        1024          /* Maximum length of string text buffer */
#endif
#ifndef MY_ARGC_MAX
#  define  MY_ARGC_MAX   64            /* Default number of command line arguments in `my_argv[]' table */
#endif
#ifndef  EXIT_STAT_HLP
#  define  EXIT_STAT_HLP  0            /* Programs exit status on: help, version, license */
#endif
#define  HD_ELEMS_MAX  100           /* Maximum amount of eternal holidays */
#define  LEN_HD_NAME   29            /* Maximum length of a holiday name inclusive `\0' */
#define  WARN_LVL_MAX  4             /* Maximum amount of debug/warning levels */
/*
*  Preprocessor statements for long options `Lopt_struct' field `symbolic_name'
*/
#define  SYM_NIL                    0
#define  SYM_BLOCKS                 1
#define  SYM_CALENDAR_DATES         2
#define  SYM_DEBUG                  3
#define  SYM_DESC_HOLIDAY_LIST      4
#define  SYM_DISABLE_HIGHLIGHTING   5
#define  SYM_EXCLUDE_HD_TITLE       6
#define  SYM_FORCE_HIGHLIGHTING     7
#define  SYM_HELP                   8
#define  SYM_HIGHLIGHTING           9
#define  SYM_HOLIDAY_DATES          10
#define  SYM_HOLIDAY_LIST           11
#define  SYM_LICENSE1               12
#define  SYM_LICENSE2               13
#define  SYM_LICENSE3               14
#define  SYM_LONG_HELP1             15
#define  SYM_LONG_HELP2             16
#define  SYM_MAIL                   17
#define  SYM_RESPONSE_FILE          18
#define  SYM_STARTING_DAY           19
#define  SYM_SUPPRESS_CALENDAR      20
#define  SYM_TYPE_OF_CALENDAR       21
#define  SYM_VERSION                22
#if USE_PAGER
#  define  SYM_PAGER                  100
#endif
#ifdef GCAL_SHELL
#  define  SYM_SCRIPT_FILE            101
#endif
#if USE_RC
#  define  SYM_DATE_VARIABLE1         200
#  define  SYM_DATE_VARIABLE2         201
#  define  SYM_DESC_FIXED_DATES       202
#  define  SYM_EXCLUDE_RC_TITLE       203
#  define  SYM_FIXED_DATES            204
#  define  SYM_GROUPING_TEXT          205
#  define  SYM_HIDDEN                 206
#  define  SYM_INCLUDE_CONS_NO        207
#  define  SYM_INCLUDE_FILENAME       208
#  define  SYM_INCLUDE_HOLIDAY        209
#  define  SYM_INCLUDE_TODAY          210
#  define  SYM_INCLUDE_WEEK_NO        211
#  define  SYM_LIST_MODE              212
#  define  SYM_LIST_OF_FIXED_DATES    213
#  define  SYM_OMIT_DATE_PART         214
#  define  SYM_PERIOD                 215
#  define  SYM_RESOURCE_FILE          216
#endif
/*
*  Preprocessor statements for long options `Lopt_struct' field `larg_mode'
*/
#define  LARG_NO         0          /* --foo */
#define  LARG_NO_OR_ONE  1          /* --foo or --foo=BAR */
#define  LARG_ONE        2          /* --foo=BAR */
/*
*  Further preprocessor statements used for long options
*/
#define  LARG_MAX        6          /* Maximum number of arguments a long option my have */
#define  LARG_SEP        "="        /* Argument separator of a long option, e.g. --foo=BAR */
#define  LARG_TXT        "ARG"      /* Text of a symbolic long option argument shown if --long-help is given */
/*
*  Further preprocessor statements
*/
#if USE_PAGER
#  define  ENV_VAR_LI    "LINES"       /* Name of number of terminal rows environment variable */
#  define  ENV_VAR_CO    "COLUMNS"     /* Name of number of terminal columns environment variable */
#  define  ENV_VAR_LI2   "LI"          /* Name of number of terminal rows environment variable */
#  define  ENV_VAR_CO2   "CO"          /* Name of number of terminal columns environment variable */
#endif
#define  SEP           ":"           /* Separator char of user defined sequences -H<> -v<> */
#define  REM_CHAR      ';'           /* Comment character of a resource/response file line */
#define  RSP_CHAR      '@'           /* Marker character of a response file (@response file) */
#define  QUOTE_CHAR    '\\'          /* Character for quoting NL_CHAR etc. */
#define  SWITCH        "-"           /* Default switch char, which defines an command line option */
#define  SWITCH2       "/"           /* First additional switch char */
#define  MLIST_SEP     ","           /* Separator of a month list (mm,mm) */
#define  MRANGE_SEP    "-"           /* Separator of a month range (mm-mm) */
#define  YLIST_SEP     ";"           /* Separator of a year list (yyyy;yyyy) */
#define  YRANGE_SEP    "+"           /* Separator of a year range (yyyy+yyyy) */
#define  YEAR_SEP      "/"           /* Separator of a standard year (mm/yyyy) */
#define  FYEAR_SEP     ":"           /* Separator of a fiscal year (mm:yyyy) */
#define  MONTH3_LIT    "."           /* Command for enabling 3-month mode (.|..|.+|.-) */
#define  DIS_HLS_PREF  "*"           /* Prefix to disable highlighting of a holiday */
#define  TIME_SEP      ":"           /* Time separator hh:mm */
#define  ASC_LIT       "+"           /* Modifier for going ascending/forwards in date */
#define  DES_LIT       "-"           /* Modifier for going descending/backwards in date */
#define  S_OUT_ROWS    3             /* Number of standard calsheet format default rows standard date */
#define  S_OUT_COLS    4             /* Number of standard calsheet format default columns standard date */
#define  J_OUT_ROWS    4             /* Number of standard calsheet format default rows Julian date */
#define  J_OUT_COLS    3             /* Number of standard calsheet format default columns Julian date */
#define  B_OUT_ROWS    12            /* Number of standard calsheet format default rows both dates */
#define  B_OUT_COLS    1             /* Number of standard calsheet format default columns both dates */
#define  SI_OUT_ROWS   4             /* Number of special calsheet format default rows standard date */
#define  SI_OUT_COLS   3             /* Number of special calsheet format default columns standard date */
#define  JI_OUT_ROWS   6             /* Number of special calsheet format default rows Julian date */
#define  JI_OUT_COLS   2             /* Number of special calsheet format default columns Julian date */
#define  BI_OUT_ROWS   B_OUT_ROWS    /* Number of special calsheet format default rows both dates */
#define  BI_OUT_COLS   B_OUT_COLS    /* Number of special calsheet format default columns both dates */
#if USE_RC
#  define  A2_OUT_ROWS   1             /* No of default 2-month mode rows Julian and standard dates */
#  define  A2_OUT_COLS   2             /* No of default 2-month mode columns Julian and standard dates */
#  define  B2_OUT_ROWS   2             /* No of default 2-month mode rows both dates */
#  define  B2_OUT_COLS   1             /* No of default 2-month mode columns both dates */
#endif
#define  S3_OUT_ROWS   1             /* No of standard calsheet format default 3-month mode rows standard date */
#define  S3_OUT_COLS   3             /* No of standard calsheet format default 3-month mode columns standard date */
#define  J3_OUT_ROWS   S3_OUT_ROWS   /* No of standard calsheet format default 3-month mode rows Julian date */
#define  J3_OUT_COLS   S3_OUT_COLS   /* No of standard calsheet format default 3-month mode columns Julian date */
#define  B3_OUT_ROWS   3             /* No of standard calsheet format default 3-month mode rows both dates */
#define  B3_OUT_COLS   1             /* No of standard calsheet format default 3-month mode columns both dates */
#define  SI3_OUT_ROWS  S3_OUT_ROWS   /* No of special calsheet format default 3-month mode rows standard date */
#define  SI3_OUT_COLS  S3_OUT_COLS   /* No of special calsheet format default 3-month mode columns standard date */
#define  JI3_OUT_ROWS  B3_OUT_ROWS   /* No of special calsheet format default 3-month mode rows Julian date */
#define  JI3_OUT_COLS  B3_OUT_COLS   /* No of special calsheet format default 3-month mode columns Julian date */
#define  BI3_OUT_ROWS  B3_OUT_ROWS   /* No of special calsheet format default 3-month mode rows both dates */
#define  BI3_OUT_COLS  B3_OUT_COLS   /* No of special calsheet format default 3-month mode columns both dates */
#define  CENTURY       1900          /* Operating system standard starting century, DON'T change ! */
/*
*  Set preprocessor symbols to requested period of Gregorian reformation
*/
#ifdef GREG_1582
#  if !GREG_1582
#    undef GREG_1582
#  endif
#endif
#ifdef GREG_1752
#  if !GREG_1752
#    undef GREG_1752
#  endif
#endif
#if GREG_1582 && GREG_1752
#  undef GREG_1582
#  undef GREG_1752
#endif
#if !GREG_1582 && !GREG_1752
#  if USE_GER
#    ifdef GREG_1582
#      undef GREG_1582
#    endif
#    define GREG_1582  1
#  else /* !USE_GER */
#    ifdef GREG_1752
#      undef GREG_1752
#    endif
#    define GREG_1752  1
#  endif /* !USE_GER */
#endif
#define  GREG_REFORM   1582          /* Real year of Gregorian reformation */
#if GREG_1582
#  define  GREG_YEAR   GREG_REFORM     /* Year of Gregorian reformation in most parts of germany */
#  define  GREG_MONTH  10              /* Month of ... */
#  define  GREG_F_DAY  5               /* First missing day/date in oct 1582 */
#  define  GREG_L_DAY  14              /* Last missing day/date ... */
#endif
#if GREG_1752
#  define  GREG_YEAR   1752            /* Year of Gregorian reformation in most parts of uk/usa */
#  define  GREG_MONTH  9               /* Month of ... */
#  define  GREG_F_DAY  3               /* First missing day/date in sep 1752 */
#  define  GREG_L_DAY  13              /* Last missing day/date ... */
#endif
/*
*  Language dependent preprocessor statements
*/
#if USE_GER
#  define  USAGE       "Aufruf: "
#  define  Y_LIT       "jj"
#  if USE_PAGER
#    define  PAGER_QUIT  "q"             /* Quits the internal pager */
#  endif
#  define  HD_LIST_TITLE "Ewige Feiertagsliste"
#  define  RESPONSE_TXT  "Antwortdatei"
#  ifdef GCAL_SHELL
#    define  SCRIPT_TXT    "shell script"
#  endif
#else /* !USE_GER */
#  define  USAGE       "Usage:  "
#  define  Y_LIT       "yy"
#  if USE_PAGER
#    define  PAGER_QUIT  "q"             /* Quits the internal pager */
#  endif
#  define  HD_LIST_TITLE "Eternal holiday list"
#  define  RESPONSE_TXT  "response file"
#  ifdef GCAL_SHELL
#    define  SCRIPT_TXT    "shell script"
#  endif
#endif /* !USE_GER */
#define  Y_LIT2      Y_LIT""Y_LIT    /* Metatext for year */
#define  DAY_LAST    365             /* Last day in a NON leap year */
#define  DAY_MIN     1               /* Minimum day of week/month/year */
#define  DAY_MAX     7               /* Maximum day/amount of days of week */
#define  WEEK_MAX    52              /* Maximum week number of year */
#define  MONTH_MIN   1               /* Minimum month of year */
#define  MONTH_MAX   12              /* Maximum month of year */
#define  YEAR_MIN    1               /* Minimum year able to compute */
#define  YEAR_MAX    9999            /* Maximum year able to compute */
#define  EASTER_MIN  463+1           /* Minimum year for computing Easter Sunday */
#define  EASTER_MAX  YEAR_MAX        /* Maximum year for computing Easter Sunday */
#define  MONTH_COLS  6               /* Maximum number of columns of a month */
#define  VEC_BLOCK   42              /* Maximum number of elements per month (7*6) */
#define  VEC_ELEMS   504             /* Maximum number of elements per year (42*12) */
/*
*  Fixed date warnings/resource file specific preprocessor statements
*/
#if USE_RC
#  ifndef RC_ELEMS_MAX
#    define  RC_ELEMS_MAX       1024      /* Default number of `rc_table[]' entries */
#  endif
#  define  RC_DVAR_MAX        26        /* Maximum number of date variables */
#  define  RC_ADATE_CHAR      '%'       /* Leading char of modified actual date %... */
#  define  RC_HDY_CHAR        '@'       /* RC-file holiday/date-variable prefix in date part */
#  define  RC_NWD_CHAR        '*'       /* RC-file n'th weekday prefix in date part */
#  define  RC_EASTER_CHAR     'e'       /* Leading char of a @easter date part */
#  define  RC_NL_CHAR         '~'       /* Inserts a real newline \n if found */
#  define  RC_MACRO_CHAR      '%'       /* RC-file macro prefix */
#  define  RC_BYEAR_CHAR      'b'       /* Leading char of a %birthyear macro */
#  define  RC_SDATE_CHAR      's'       /* Leading char of a %starting date macro */
#  define  RC_EDATE_CHAR      'e'       /* Leading char of a %ending date macro */
#  define  RC_TIME_CHAR       't'       /* Leading char of a %time macro */
#  define  RC_DAY_CHAR        'd'       /* Leading char of a %day macro */
#  define  RC_WEEK_CHAR       'w'       /* Leading char of a %week macro */
#  define  RC_MONTH_CHAR      'm'       /* Leading char of a %month macro */
#  define  RC_YEAR_CHAR       'y'       /* Leading char of a %year macro */
#  define  RC_DATE_CHAR       'n'       /* Leading char of a %effective date macro */
#  define  RC_FNAME_SEP       "+"       /* Additional RC-file list separator -f|F<NAME[+NAME+...]>*/
#  define  RC_DVAR_ASSIGN     "="       /* Assignment operator of a date variable (var=mmdd) */
#  define  RC_DVAR_ADD        "+"       /* Add operator of a date variable (var++ | var+=<n>) */
#  define  RC_DVAR_SUB        "-"       /* Subtract operator of a date variable (var-- | var-=<n>) */
#  define  RC_GROUP_SEP       ""        /* Default grouping `txt' of fixed date list [-c]g */
#  define  RC_AM_TXT          "am"      /* Trailing "after midnight" text of %time12 macro */
#  define  RC_PM_TXT          "pm"      /* Trailing "past midnight" text of %time12 macro */
#  define  RC_INCL_STMENT     "#include"         /* Name of RC-file include statement (upper) */
#  define  RC_INCL_USR_ID     "\""               /* User include file name starts with */
#  define  RC_INCL_USR_OD     RC_INCL_USR_ID     /* User include file name ends with */
#  define  RC_INCL_SYS_ID     "<"                /* System include file name start with */
#  define  RC_INCL_SYS_OD     ">"                /* System include file name ends with */
#  define  ENV_VAR_USR_LIBDIR "GCAL_USR_LIBDIR"  /* Environment variable name of user lib dir */
#  define  ENV_VAR_SYS_LIBDIR "GCAL_SYS_LIBDIR"  /* Environment variable name of system lib dir */
#  if USE_GER
#    define  RC_LIST_TITLE      "Terminliste"      /* Title of fixed date list */
#    define  RC_INTERNAL_TXT    "Intern"           /* */
#  else /* !USE_GER */
#    define  RC_LIST_TITLE      "Fixed date list"  /* Title of fixed date list */
#    define  RC_INTERNAL_TXT    "Internal"         /* */
#  endif /* !USE_GER */
#  define  USAGE_RC1          " c f"          /* Additional usage text */
#  define  USAGE_RC2          " v"            /* Additional usage text */
#else /* !USE_RC */
#  define  USAGE_RC1          ""
#  define  USAGE_RC2          ""
#endif /* !USE_RC */
#if USE_PAGER
#  define  USAGE_PAGER        " p"            /* Additional usage text */
#else /* !USE_PAGER */
#  define  USAGE_PAGER        ""
#endif /* !USE_PAGER */
#ifdef GCAL_EMAIL
#  define USAGE_MAIL          " m"            /* Additional usage text */
#else /* !GCAL_EMAIL */
#  define USAGE_MAIL          ""
#endif /* !GCAL_EMAIL */
#ifdef GCAL_SHELL
#  define USAGE_SHELL         " S"            /* Additional usage text */
#else /* !GCAL_SHELL */
#  define USAGE_SHELL         ""
#endif /* !GCAL_SHELL */
/*
*  Now define the usage text
*/
#define  USAGE_MSG  USAGE"%s ["SWITCH"|"SWITCH2"{[h|hh|L|V]|" \
                    "{H R"USAGE_SHELL" X b"USAGE_RC1" i j"USAGE_MAIL \
                    " n"USAGE_PAGER" s u"USAGE_RC2"}}]  [[mm] ["Y_LIT2"]]"
  

/*
*  And last but not least...
*/
#define  COPYRIGHT_TXT  "Copyright (C) 1994, 1995 Thomas Esken"


/*
*  Common preprocessor macros
*/
#define  S_NEWLINE(gc_fp)    fputc('\n', (gc_fp))
#if USE_RC
#  define IDX(gc_ch)         (tolower((gc_ch)) - 'a')
#endif
#define  MY_ISSPACE(gc_ch)   ((   (gc_ch) == ' ' \
                               || (gc_ch) == '\f' \
                               || (gc_ch) == '\n' \
                               || (gc_ch) == '\r' \
                               || (gc_ch) == '\t' \
                               || (gc_ch) == '\v') \
                               ? TRUE \
                               : FALSE)
#define  SYEAR(gc_d, gc_s)   (((gc_d)-(gc_s)+1) < DAY_MIN) \
                               ? ((gc_d)-(gc_s)+(DAY_MAX+1)) \
                               : ((gc_d)-(gc_s)+1)
#define  SMONTH(gc_d, gc_s)  (((gc_d)+(gc_s)-1) > MONTH_MAX) \
                               ? ((gc_d)+(gc_s)-(MONTH_MAX+1)) \
                               : ((gc_d)+(gc_s)-1)
#define  SDAY(gc_d, gc_s)    (((gc_d)+(gc_s)-1) > DAY_MAX) \
                               ? ((gc_d)+(gc_s)-(DAY_MAX+1)) \
                               : ((gc_d)+(gc_s)-1)



#ifdef CUT_LONGNAMES
/*
*  Cut resp., replace some long variable or function names to 6 significant
*    places so ANY linker should be able to bind an executable file
*/
#  define compare_d_m_name             F_cdm
#  define comparemode                  V_cm
#  if !USE_RC
#    define days_of_feb                  V_dof
#  endif
#  define days_of_february             F_dof
#  if USE_HLS || USE_PAGER
#    define get_termcap_hls              F_ghl
#    define get_termcap_scr_attrib       F_gsc
#  endif
#  define get_tty_hls                  F_gth
#  if USE_PAGER
#    define get_tty_scr_size             F_gts
#  endif
#  define hd_title_flag                V_htf
#  define hd_title_shown               V_hts
#  define holiday_flag                 V_hf
#  define holiday_name                 V_hn
#  define holiday_prefix               V_hp
#  define holiday_vector               V_hv
#  define is_3month_mode               V_3m
#  define is_3month_mode2              V_3m2
#  define is_ext_list                  V_iel
#  define is_ext_range                 V_ier
#  define is_ext_year                  V_iey
#  define is_tty                       V_it
#  define is_tty1                      V_it1
#  define is_tty2                      V_it2
#  define julian_days                  V_jd
#  define julian_flag                  V_jf
#  define julian_vector                V_jv
#  define longopt                      V_lo
#  define longopt_symbolic             V_los
#  define module_line                  V_mdl
#  define module_name                  V_mdn
#  define month_list                   V_ml
#  define month_name                   F_mn
#  define month_set                    V_ms
#  define my_argc                      V_mac
#  define my_argc_max                  V_max
#  define my_argv                      V_mav
#  define my_help_head_txt             F_mhh
#  define my_help_tail_txt             F_mht
#  if USE_RC
#    define precomp_date                 F_pd
#    define precomp_nth_wd               F_pwd
#  endif
#  define print_all_holidays           F_pah
#  define print_calendar               F_pc
#  define print_highlighted_date       F_phd
#  if USE_HLS
#    define print_hls                    V_phl
#  endif
#  if USE_RC
#    define print_line                   V_pl
#  endif
#  define print_single_date            F_psd
#  define print_single_holiday         F_psh
#  define print_text                   F_ptx
#  if USE_RC
#    define print_twice                  V_ptw
#    define rc_elems                     V_re
#    define rc_elems_max                 V_rem
#    define rc_enable_fn_flag            V_rfn
#    define rc_enable_hda_flag           V_rha
#    define rc_enable_hdl_flag           V_rhl
#    define rc_period                    V_rp
#    define rc_period_flag               V_rpf
#    define rc_period_list               V_rpl
#    if HAVE_ASSERT_H
#      define rc_table_range_checked       V_rrc
#    endif
#    define rc_table_initialized         V_ri
#    define rc_use                       F_ru
#    define rc_use_flag                  V_ruf
#    define rc_week_flag                 V_rwf
#    define rc_weekno_flag               V_rwn
#    define rc_week_year_flag            V_rwy
#  endif
#  define short_day_name               F_sdn
#  define short_month_name             F_smn
#endif /* CUT_LONGNAMES */



/*
*  Type definitions
*/
typedef
  unsigned char
  Uchar;
typedef
  unsigned int
  Uint;
typedef
#if __STDC__
  signed long int
#else /* !__STDC__ */
  long
#endif /* !__STDC__ */
  Slint;
typedef
#if __STDC__
  unsigned long int
#else /* !__STDC__ */
  unsigned long
#endif /* !__STDC__ */
  Ulint;
typedef
  char
  Bool;
/*
*  (quick)sort function type
*/
typedef
  int
  (*Func_cmp)(const VOID_PTR, const VOID_PTR);
/*
*  The long option record
*/
typedef
  struct long_option_type
   {
     int    symbolic_name;
     char  *long_name;
     char  *short_name[LARG_MAX];
     int    larg_mode;
     char  *largs[LARG_MAX];
   }
  Lopt_struct;
/*
*  The highlighting sequence record
*/
typedef
  struct   hls_type
   {
     const char  *seq;
           int    len;
   }
  Hls_struct;
#if USE_RC
/*
*  The date variable records
*/
typedef
  struct  dvar_base_type
   {
     char  month;
     char  day;
   }
  Dvar_base_struct;
typedef
  struct  dvar_type
   {
     Dvar_base_struct  g;   /* globals */
     Dvar_base_struct  l;   /* locals */
   }
  Dvar_struct;
#endif /* USE_RC */
/*
*  The month/year list/range record
*/
typedef
  struct  ml_type
   {
     int  month[MONTH_MAX+1];
     int  year[MONTH_MAX+1];
   }
  Ml_struct;
/*
*  General purpose enumerations types
*/
typedef
  enum compare_mode
   {
       DAy=1,
#if USE_RC
       DVar,
       EAster,
       WEek,
#endif
       MOnth
   }
  Cmode_enum;
typedef
  enum display_mode
   {
       CAlendar=1,
       INternal
   }
  Dmode_enum;
typedef
  enum file_mode
   {
       REsponse=1,
#if USE_RC
       USr_include,
       SYs_include,
       REsource,
#endif
#ifdef GCAL_SHELL
       SCript,
#endif
       COmmon
   }
  Fmode_enum;
#if USE_RC
typedef
  enum dvar_mode
   {
       GLobal=1,
       LOcal
   }
  Dvar_enum;
#endif
#endif /* __GCAL_H */
