#  $Id: 2umlaut.pl 0.03 1995/09/18 00:00:03 tom Exp $
#
#  2umlaut.pl:  Very simple and silly `Perl' script for converting
#                 "a "o "u "s "A "O "U  character sequences found
#                 in a German text to sequences, the TeX formatter
#                 should be able to typeset as German "Umlaute".
#
#
#  Public domain.
#

#
#  Write:       if (/\@node|\@chapter|\@section|\@subsection|\@subsubsection/) {
#
#  instead of:  if (/\@chapter|\@section|\@subsection|\@subsubsection/) {
#
#  if you want to change the replacement characters ("a "o "u...) in the
#  gcal-de.texi file to (ae oe ue...) characters for the info-file!
#

$[ = 1;			# set array base to 1
$, = ' ';		# set output field separator
$\ = "\n";		# set output record separator

line: while (<>) {
    chop;	# strip record separator
    if (/\@chapter|\@section|\@subsection|\@subsubsection/) {
	$len = length($_);
	$tmptxt = '';
	if ($_ =~ /"/) {
	    $found = 0;
	    for ($i = 1; $i <= $len; $i++) {
		$tmpchr = substr($_, $i, 1);
		if ($tmpchr eq '"') {
		    if ($found == 1) {
			$found = 0;
			$tmptxt = $tmptxt . $tmpchr . $tmpchr;
		    }
		    else {
			$found = 1;
		    }
		}
		else {
		    if ($found == 1) {
			$found = 0;
			if ($tmpchr eq 'a') {
			    $tmptxt = $tmptxt . 'ae';
			}
			else {
			    if ($tmpchr eq 'o') {
				$tmptxt = $tmptxt . 'oe';
			    }
			    else {
				if ($tmpchr eq 'u') {
				    $tmptxt = $tmptxt . 'ue';
				}
				else {
				    if ($tmpchr eq 's') {
					$tmptxt = $tmptxt . 'ss';
				    }
				    else {
					if ($tmpchr eq 'A') {
					    $tmptxt = $tmptxt . 'Ae';
					}
					else {
					    if ($tmpchr eq 'O') {
						$tmptxt = $tmptxt . 'Oe';
					    }
					    else {
						if ($tmpchr eq 'U') {
						    $tmptxt = $tmptxt . 'Ue';
						}
						else {
						    $tmptxt = $tmptxt . "\"" .
						      $tmpchr;
						}
					    }
					}
				    }
				}
			    }
			}
		    }
		    else {
			$tmptxt = $tmptxt . $tmpchr;
		    }
		}
	    }
	    if ($found == 1) {
		print $tmptxt . $tmpchr;
	    }
	    else {
		print $tmptxt;
	    }
	}
	else {
	    print $_;
	}
	next line;
    }

#
#  Write:       $tmptxt = $tmptxt . "";      <-- "a Umlaut character
#
#  instead of:  $tmptxt = $tmptxt . "@\"a";   and so forth...
#
#  if you want to change the replacement characters ("a "o "u...) in the
#  gcal-de.texi file to real German "Umlaute" characters for the info-file!
#

    $len = length($_);
    $tmptxt = '';
    if ($_ =~ /"/) {
	$found = 0;
	for ($i = 1; $i <= $len; $i++) {
	    $tmpchr = substr($_, $i, 1);
	    if ($tmpchr eq '"') {
		if ($found == 1) {
		    $found = 0;
		    $tmptxt = $tmptxt . $tmpchr . $tmpchr;
		}
		else {
		    $found = 1;
		}
	    }
	    else {
		if ($found == 1) {
		    $found = 0;
		    if ($tmpchr eq 'a') {
			$tmptxt = $tmptxt . "@\"a";
		    }
		    else {
			if ($tmpchr eq 'o') {
			    $tmptxt = $tmptxt . "@\"o";
			}
			else {
			    if ($tmpchr eq 'u') {
				$tmptxt = $tmptxt . "@\"u";
			    }
			    else {
				if ($tmpchr eq 's') {
				    if ($i == $len) {
					$tmptxt = $tmptxt . '@ss ';
				    }
				    else {
					if (substr($_, $i+1, 1) eq ' ') {
					    $tmptxt = $tmptxt . '@ss@ ';
					}
					else {
					    $tmptxt = $tmptxt . '@ss ';
					}
				    }
				}
				else {
				    if ($tmpchr eq 'A') {
					$tmptxt = $tmptxt . "@\"A";
				    }
				    else {
					if ($tmpchr eq 'O') {
					    $tmptxt = $tmptxt . "@\"O";
					}
					else {
					    if ($tmpchr eq 'U') {
						$tmptxt = $tmptxt . "@\"U";
					    }
					    else {
						$tmptxt = $tmptxt . "\"" .
						  $tmpchr;
					    }
					}
				    }
				}
			    }
			}
		    }
		}
		else {
		    $tmptxt = $tmptxt . $tmpchr;
		}
	    }
	}
	if ($found == 1) {
	    print $tmptxt . $tmpchr;
	}
	else {
	    print $tmptxt;
	}
    }
    else {
	print $_;
    }
}
