;
; $Header: D:/ext2-os2/vfs/RCS/strat2.asm,v 1.3 1995/12/27 17:26:39 Willm Exp Willm $
;

; Linux ext2 file system driver for OS/2 2.x and WARP - Allows OS/2 to
; access your Linux ext2fs partitions as normal drive letters.
; OS/2 implementation : Copyright (C) 1995  Matthieu WILLM
;
; This program is free software; you can redistribute it and/or modify
; it under the terms of the GNU General Public License as published by
; the Free Software Foundation; either version 2 of the License, or
; (at your option) any later version.
;
; This program is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; GNU General Public License for more details.
;
; You should have received a copy of the GNU General Public License
; along with this program; if not, write to the Free Software
; Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

       .286p
       .model large


       .code

       extrn _request_completed       : far
       extrn _request_list_completed  : far

       public _stub_request_completed
       public _stub_request_list_completed

;
; Routine called by OS2DASD after completion of a strat 2 request
; This is a stub asm routine calling the C routine request_completed()
;
; On entry es:bx points to the request header
; On exit the carry flag is set if an error occured
;
_stub_request_completed proc far
        push bp
        mov bp, sp
;        push ds
;        push si
;        push di
        push es
        push bx
        call _request_completed
        add sp, 4
;        pop di
;        pop si
;        pop ds
        neg ax                              ; cf = 1 if ax != 0
        leave
        ret
_stub_request_completed endp

;
; Routine called by OS2DASD after completion of a strat 2 request list
; This is a stub asm routine calling the C routine request_list_completed()
;
; On entry es:bx points to the request list header
; On exit the carry flag is set if an error occured
;
_stub_request_list_completed proc far
        push bp
        mov bp, sp
;        push ds
;        push si
;        push di
        push es
        push bx
        call _request_list_completed
        add sp, 4
;        pop di
;        pop si
;        pop ds
        neg ax                              ; cf = 1 if ax != 0
        leave
        ret
_stub_request_list_completed endp


end
