//
// $Header: D:/ext2-os2/vfs/RCS/misc.c,v 4.2 1995/12/27 17:26:28 Willm Exp Willm $
//

// Linux ext2 file system driver for OS/2 2.x and WARP - Allows OS/2 to     
// access your Linux ext2fs partitions as normal drive letters.
// OS/2 implementation : Copyright (C) 1995  Matthieu WILLM
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#define INCL_DOSERRORS
#define INCL_NOPMAPI
#include <os2.h>		// From the "Developer Connection Device Driver Kit" version 2.0

#include <fsh.h>

#include <os2/types.h>
#include <os2/os2proto.h>
#include <linux/sched.h>
#include <linux/resource.h>
#include <linux/fs.h>

//
//  Linux block device read_ahead capabilities
//
long read_ahead[1] = {8};

struct task_struct current[1] = {
                                 { // current[0]
                                  { // current[0].rlim
                                    {0, 0},                            // current[0].rlim[0]
                                    {(long)(~0UL>>1UL), (long)(~0UL>>1UL)},
                                    {0, 0},
                                    {0, 0},
                                    {0, 0},
                                    {0, 0},
                                    {0, 0},
                                    {0, 0}
                                   }
                                  } // end current[0]
                                 };



#if 0
void wait_on_super(struct super_block * sb)
{
    int rc = ERROR_INTERRUPT;
#ifdef FS_TRACE_LOCKS
    kernel_printf("wait_on_super()");
#endif

    while (rc == ERROR_INTERRUPT) {
        if ((rc = FSH_SEMWAIT(&(sb->s_wait), TO_INFINITE)) != NO_ERROR) {
            kernel_printf("wait_on_super() - Erreur FSH_SEMWAIT - rc = %d", rc);
        }
    }
}

void lock_super(struct super_block * sb)
{
    int rc = ERROR_INTERRUPT;
#ifdef FS_TRACE_LOCKS
    kernel_printf("lock_super()");
#endif

    while (rc == ERROR_INTERRUPT) {
        if ((rc = FSH_SEMREQUEST(&(sb->s_wait), TO_INFINITE)) != NO_ERROR) {
            kernel_printf("lock_super() - Erreur FSH_SEMREQUEST - rc = %d", rc);
        }
    }
}

void unlock_super(struct super_block * sb)
{
    int rc;

#ifdef FS_TRACE_LOCKS
    kernel_printf("unlock_super()");
#endif
        if ((rc = FSH_SEMCLEAR(&(sb->s_wait))) != NO_ERROR) {
            kernel_printf("unlock_super() - Erreur FSH_SEMCLEAR - rc = %d", rc);
        }
}

#endif
