//
// $Header: \\ext2-os2\\console\\RCS/nb.c,v 1.2 1995/12/29 23:28:34 Willm Exp Willm $
//

// Linux ext2 file system driver for OS/2 2.x and WARP - Allows OS/2 to
// access your Linux ext2fs partitions as normal drive letters.
// OS/2 implementation : Copyright (C) 1995  Matthieu WILLM
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#ifdef __IBMC__
#pragma strings(readonly)
#endif

#define INCL_DOS
#define INCl_DOSERRORS
#define INCL_WIN
#include <os2.h>

#include <stdlib.h>

#include <os2/vfsapi.h>

#include "nb.h"

HAB   hab;
HMQ   hmq;
QMSG  qmsg;
HWND  hwndFrame;         /* main window       */
HWND  hwndNb;            /* notebook window   */

HWND  hwndpage1;         /* dialog for page 1 */
ULONG p1;                 /* page 1 handle     */

HWND  hwndpage2;         /* dialog for page 2 */
ULONG p2;                 /* page 2 handle     */

HWND  hwndpage3;         /* dialog for page 3 */
ULONG p3;                 /* page 3 handle     */

/*
 * Window handles for static text fields on page 1 (Disk cache info)
 */
HWND hwnd_cache_size;
HWND hwnd_max_cache_size;
HWND hwnd_nr_buffer_heads;

HWND hwnd_clean;
HWND hwnd_nonshared;
HWND hwnd_locked1;
HWND hwnd_locked2;
HWND hwnd_dirty;
HWND hwnd_shared;
HWND hwnd_free;

/*
 * Window handles for static text fields on page 2 (I-node info)
 */
HWND hwnd_nr_inodes;
HWND hwnd_nr_free_inodes;
HWND hwnd_nr_used_inodes;

HWND hwnd_nhfiles;
HWND hwnd_nfreehfiles;
HWND hwnd_nusedhfiles;


/*
 * Window handles for static text fields on page 3 (ext2-os2.ifs output)
 */
HWND hwnd_output;

char scratchbuf[256];

extern int init_output(void);
extern HEV hev;

#if 0
MRESULT EXPENTRY DlgProc1(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{

    switch(msg) {
        default:
            return (WinDefDlgProc(hwnd, msg, mp1, mp2));
   } /* end switch */

   return (MRESULT)NULL;

}
#endif

MRESULT EXPENTRY MainWinProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2) {
    switch(msg) {
        case WM_CREATE :
            /*
             * Starts the update timer.
             */
            WinStartTimer(hab, hwnd, 0x10, 1000);
            break;

        case WM_SIZE :
            {
                RECTL rect;
                WinQueryWindowRect(hwnd, &rect);
                WinSetWindowPos(
                                hwndNb,
                                HWND_TOP,
                                0,0,rect.xRight - rect.xLeft,rect.yTop - rect.yBottom ,
                                (ULONG)SWP_SIZE|(ULONG)SWP_MOVE|(ULONG)SWP_ACTIVATE|(ULONG)SWP_SHOW
                               );
            }
            break;
        case WM_TIMER :
            {
                struct ext2_os2_data d;
                long   nr_free;
                ULONG  dataio = sizeof(struct ext2_os2_data);
                ULONG  parmio = 0;

                DosFSCtl(
                         &d, dataio, &dataio,
                         NULL, 0, &parmio,
                         EXT2_OS2_GETDATA,  "ext2",
                         (HFILE)-1,  FSCTL_FSDNAME
                        );

                WinSetWindowText(hwnd_cache_size, _itoa(d.b.buffer_mem, scratchbuf, 10));
                WinSetWindowText(hwnd_max_cache_size, _itoa(d.b.cache_size, scratchbuf, 10));
                WinSetWindowText(hwnd_nr_buffer_heads, _itoa(d.b.nr_buffer_heads, scratchbuf, 10));

                nr_free = d.b.nr_free[0] +
                          d.b.nr_free[1] +
                          d.b.nr_free[2] +
                          d.b.nr_free[3];

                WinSetWindowText(hwnd_free, _itoa(nr_free, scratchbuf, 10));


                WinSetWindowText(hwnd_clean, _itoa(d.b.nr_buffers_type[0], scratchbuf, 10));
                WinSetWindowText(hwnd_nonshared, _itoa(d.b.nr_buffers_type[1], scratchbuf, 10));
                WinSetWindowText(hwnd_locked1, _itoa(d.b.nr_buffers_type[2], scratchbuf, 10));
                WinSetWindowText(hwnd_locked2, _itoa(d.b.nr_buffers_type[3], scratchbuf, 10));
                WinSetWindowText(hwnd_dirty, _itoa(d.b.nr_buffers_type[4], scratchbuf, 10));
                WinSetWindowText(hwnd_shared, _itoa(d.b.nr_buffers_type[5], scratchbuf, 10));

                WinSetWindowText(hwnd_nr_inodes, _itoa(d.i.nr_inodes, scratchbuf, 10));
                WinSetWindowText(hwnd_nr_free_inodes, _itoa(d.i.nr_free_inodes, scratchbuf, 10));
                WinSetWindowText(hwnd_nr_used_inodes, _itoa(d.i.nr_inodes - d.i.nr_free_inodes, scratchbuf, 10));

                WinSetWindowText(hwnd_nhfiles, _itoa(d.f.nhfiles, scratchbuf, 10));
                WinSetWindowText(hwnd_nfreehfiles, _itoa(d.f.nfreehfiles, scratchbuf, 10));
                WinSetWindowText(hwnd_nusedhfiles, _itoa(d.f.nusedhfiles, scratchbuf, 10));

            }
            break;

        default :
            return WinDefWindowProc(hwnd,msg,mp1,mp2);
    } /* end switch */
    return (MRESULT)FALSE;
}

main() {
    RECTL rect;
    ULONG flCtlData;



    /*
     * Initalizes ext2-os2 output
     */
     if (init_output()) {
         return 1;
     }

    /*
     * Initializes PM and creates the message queue
     */
    hab = WinInitialize(0);
    hmq = WinCreateMsgQueue(hab, 0);

    /*
     * Registers the main window class
     */
    WinRegisterClass(hab, "glop",MainWinProc, 0, 0);

    /*
     * Creates the main window
     */
    flCtlData = (ULONG)FCF_SIZEBORDER|
                (ULONG)FCF_TASKLIST|
                (ULONG)FCF_TITLEBAR|
                (ULONG)FCF_SYSMENU | FCF_MINMAX;
    hwndFrame = WinCreateStdWindow(
                                   HWND_DESKTOP,
                                   0,
                                   &flCtlData,
                                   "glop",
                                   "ext2-os2 console window",
                                   WS_VISIBLE | WS_ANIMATE,
                                   0,
                                   10,
                                   0
                                  );

    /*
     * Creates the notebook window
     */
    hwndNb = WinCreateWindow(
                             WinWindowFromID(hwndFrame, FID_CLIENT),
                             WC_NOTEBOOK,
                             NULL,
                             BKS_BACKPAGESBR | BKS_MAJORTABRIGHT | BKS_SQUARETABS |
                             BKS_STATUSTEXTRIGHT | BKS_TABTEXTLEFT | WS_GROUP |
                             WS_TABSTOP | WS_VISIBLE | BKS_SPIRALBIND,
                             0, 0,
                             100, 100,
                             WinWindowFromID(hwndFrame, FID_CLIENT),
                             HWND_TOP,
                             16,
                             NULL,
                             NULL
                            );

    /*
     * Sets the size of the main window
     */
    WinSetWindowPos(
                    hwndFrame,
                    0,
                    100,100,500,500,
                    (ULONG)SWP_SIZE|(ULONG)SWP_MOVE|(ULONG)SWP_ACTIVATE|(ULONG)SWP_SHOW
                   );

    /*
     * Adjusts the size of the notebook to the size of the main window's client area
     */
    WinQueryWindowRect(WinWindowFromID(hwndFrame, FID_CLIENT), &rect);
    WinSetWindowPos(
                    hwndNb,
                    HWND_TOP,
                    0,0,rect.xRight - rect.xLeft,rect.yTop - rect.yBottom ,
                    (ULONG)SWP_SIZE|(ULONG)SWP_MOVE|(ULONG)SWP_ACTIVATE|(ULONG)SWP_SHOW
                   );

    /*
     * Creates the first notebook page (Disk cache info) and loads it from the resources
     */
    p1 = LONGFROMMR(WinSendMsg(hwndNb, BKM_INSERTPAGE, MPFROMLONG(0), MPFROM2SHORT(BKA_AUTOPAGESIZE | BKA_MAJOR | BKA_STATUSTEXTON, BKA_LAST)));
    hwndpage1 = WinLoadDlg(
                           hwndNb,
                           hwndFrame,
                           WinDefDlgProc,
                           NULLHANDLE,
                           id_cache_dialog,
                           NULL
                          );
    hwnd_cache_size       = WinWindowFromID(hwndpage1, id_cache_size);
    hwnd_max_cache_size   = WinWindowFromID(hwndpage1, id_max_cache_size);
    hwnd_nr_buffer_heads  = WinWindowFromID(hwndpage1, id_nr_buffer_heads);

    hwnd_clean            = WinWindowFromID(hwndpage1, id_clean);
    hwnd_nonshared        = WinWindowFromID(hwndpage1, id_nonshared);
    hwnd_locked1          = WinWindowFromID(hwndpage1, id_locked1);
    hwnd_locked2          = WinWindowFromID(hwndpage1, id_locked2);
    hwnd_dirty            = WinWindowFromID(hwndpage1, id_dirty);
    hwnd_shared           = WinWindowFromID(hwndpage1, id_shared);
    hwnd_free             = WinWindowFromID(hwndpage1, id_free);

    WinSendMsg(hwndNb, BKM_SETPAGEWINDOWHWND, MPFROMLONG(p1), MPFROMLONG(hwndpage1));
    WinSendMsg(hwndNb, BKM_SETTABTEXT, MPFROMLONG(p1), MPFROMP("Cache"));
    WinSendMsg(hwndNb, BKM_SETDIMENSIONS, MPFROM2SHORT(80,30), MPFROMSHORT(BKA_MAJORTAB));

    /*
     * Creates the second notebook page (Inode info) and loads it from the resources
     */
    p2 = LONGFROMMR(WinSendMsg(hwndNb, BKM_INSERTPAGE, MPFROMLONG(0), MPFROM2SHORT(BKA_AUTOPAGESIZE | BKA_MAJOR | BKA_STATUSTEXTON, BKA_LAST)));
    hwndpage2 = WinLoadDlg(
                           hwndNb,
                           hwndFrame,
                           WinDefDlgProc,
                           NULLHANDLE,
                           id_inode_dialog,
                           NULL
                          );

    hwnd_nr_inodes      = WinWindowFromID(hwndpage2, id_total_inode);
    hwnd_nr_free_inodes = WinWindowFromID(hwndpage2, id_free_inodes);
    hwnd_nr_used_inodes = WinWindowFromID(hwndpage2, id_used_inodes);

    hwnd_nhfiles      = WinWindowFromID(hwndpage2, id_total_files);
    hwnd_nfreehfiles  = WinWindowFromID(hwndpage2, id_free_files);
    hwnd_nusedhfiles  = WinWindowFromID(hwndpage2, id_used_files);

    WinSendMsg(hwndNb, BKM_SETPAGEWINDOWHWND, MPFROMLONG(p2), MPFROMLONG(hwndpage2));
    WinSendMsg(hwndNb, BKM_SETTABTEXT, MPFROMLONG(p2), MPFROMP("Inodes"));
    WinSendMsg(hwndNb, BKM_SETDIMENSIONS, MPFROM2SHORT(80,30), MPFROMSHORT(BKA_MAJORTAB));

    /*
     * Creates the third notebook page (ext2-os2.ifs output) and loads it from the resources
     */
    p3 = LONGFROMMR(WinSendMsg(hwndNb, BKM_INSERTPAGE, MPFROMLONG(0), MPFROM2SHORT(BKA_AUTOPAGESIZE | BKA_MAJOR | BKA_STATUSTEXTON, BKA_LAST)));
    hwndpage3 = WinLoadDlg(
                           hwndNb,
                           hwndFrame,
                           WinDefDlgProc,
                           NULLHANDLE,
                           id_output_dialog,
                           NULL
                          );

    hwnd_output      = WinWindowFromID(hwndpage3, id_ext2_os2_output);

    WinSendMsg(hwndNb, BKM_SETPAGEWINDOWHWND, MPFROMLONG(p3), MPFROMLONG(hwndpage3));
    WinSendMsg(hwndNb, BKM_SETTABTEXT, MPFROMLONG(p3), MPFROMP("Output"));
    WinSendMsg(hwndNb, BKM_SETDIMENSIONS, MPFROM2SHORT(80,30), MPFROMSHORT(BKA_MAJORTAB));

    /*
     * Unblocks the output thread.
     */
    DosPostEventSem(hev);
    DosCloseEventSem(hev);

    /*
     * Enters the PM message loop
     */
    while (WinGetMsg(hab,&qmsg, 0, 0, 0)) {
        WinDispatchMsg(hab, &qmsg);
    } /* endwhile */

    /*
     * Destroys the message queue and exits from PM
     */
    WinDestroyMsgQueue(hmq);
    WinTerminate(hab);

    return 0;
}


