//
// $Header: D:/ext2-os2/rcs/attr.c,v 5.0 1995/12/29 23:02:14 Willm Exp Willm $
//

// Linux ext2 file system driver for OS/2 2.x and WARP - Allows OS/2 to     
// access your Linux ext2fs partitions as normal drive letters.
// OS/2 implementation : Copyright (C) 1995  Matthieu WILLM
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#define INCL_DOSERRORS
#define INCL_NOPMAPI
#include <os2.h>		// From the "Developer Connection Device Driver Kit" version 2.0

#include <os2/types.h>
#include <os2/os2proto.h>
#include <linux/fs.h>
#include <linux/stat.h>

#define FILE_NONFAT     0x0040		// File is non 8.3 compliant

//
// Maps DOS SHRA attributes to Linux rwxrwxrwx file modes
//
// Handles only DOS SHRA attributes
// 	A - ignored
//	S - ignored
//	H - ignored
//	R - S_IWUSR, S_IWGRP and S_IWOTH cleared
void DOS_To_Linux_Attrs(struct inode *inode, unsigned short DOS_attrs) {
    if (DOS_attrs & FILE_READONLY) {
        inode->i_mode &= ~(S_IWUSR | S_IWGRP | S_IWOTH);
	inode->i_dirt  = 1;
    }
}

//
// Maps Linux file modes to DOS DSHRA attributes
//
unsigned short Linux_To_DOS_Attrs(struct inode *inode, char *component) {
    unsigned short mapped;

    mapped = FILE_NORMAL;

    if ((S_ISLNK(inode->i_mode))  ||
        (S_ISBLK(inode->i_mode))  ||
        (S_ISCHR(inode->i_mode))  ||
        (S_ISFIFO(inode->i_mode)) ||
        (S_ISSOCK(inode->i_mode))) {
        mapped |= FILE_SYSTEM;     /*** UNIXish special files are seen as SYSTEM files ***/
    } /* endif */

    if (S_ISDIR(inode->i_mode)) {
        mapped |= FILE_DIRECTORY;
    } /* endif */

    if ((!(inode->i_mode & S_IWUSR)) && 
        (!(inode->i_mode & S_IWGRP)) &&
        (!(inode->i_mode & S_IWOTH))) {
        mapped |= FILE_READONLY;
    }

    if (!isfat(component)) {
        mapped |= FILE_NONFAT;		// Non 8.3 file name
    }

    return mapped;
}