//Key Board Functions ver 2
//(C) 1994 freeware by Marty A. Lineberry
//Written in Borland's C++ ver 3.0
//Does not support Extended Keyboard

#include <string.h>
#include <dos.h>
#include <iostream.h>
#include <conio.h>
#include <stdio.h>
#include <bios.h>
#include <ctype.h>
#include <stdlib.h>
#include <time.h>
#include <graphics.h>



#define	KEYBOARD_INTERRUPT 0x16
#define LEFT 19200
#define SPACEBAR 14624
#define ESC 283
#define UP 18432
#define DOWN 20480
#define RIGHT 19712
#define TAB 3849
#define ENTER 7181
#define F1 15104
#define F2 15360
#define F3 15616
#define F4 15872
#define F5 16128
#define F6 16384
#define F7 16640
#define F8 16896
#define F9 17152
#define F10 17408
#define PAGE_UP 18688
#define PAGE_DOWN 20736
#define HOME 18176
#define END 20224
#define DELETE 21248
#define INSERT 20992
#define RIGHT_SHIFT  0x01
#define LEFT_SHIFT   0x02
#define CTRL   0x04
#define ALT    0x08
#define TRUE 1
#define FALSE 0
#define OR ||
#define AND &&


int Key_Press(char *);
void Pause(int t_f);
char ascii(int num);
int key();
int C_Break(void);

void main()
{

ctrlbrk(C_Break);

clrscr();

//Used for Keystroke processing
int int_ch = 0;
char char_ch;

cout << "This is a Demo of complete Keyboard Trapping\n";
cout << "Press ESC to Quit\n";
cout << "Press some keys\n";



while(TRUE)
	{

//******************************************
//****** Action Game goes here *************
//******************************************

	//Gets Keystrokes in buffer******************************************
	int_ch=Key_Press(&char_ch);
	//If a Key was pressed then process it's Variables
	if (int_ch)
		{
		//Exits loop Never Ending Loop
		if(int_ch == ESC) break;
		switch(int_ch)
			{
			case UP: cout << " UP ";break;
			case DOWN: cout << " DOWN ";break;
			case LEFT: cout << " LEFT ";break;
			case RIGHT: cout << " RIGHT ";break;
			case F1: cout << " F1 ";break;
			case F2: cout << " F2 ";break;
			case F3: cout << " F3 ";break;
			case F4: cout << " F4 ";break;
			case F5: cout << " F5 ";break;
			case F6: cout << " F6 ";break;
			case F7: cout << " F7 ";break;
			case F8: cout << " F8 ";break;
			case F9: cout << " F9 ";break;
			case F10: cout << " F10 ";break;
			case ENTER: cout << " ENTER ";break;
			case TAB: cout << " TAB ";break;
			case SPACEBAR: cout << " SPACEBAR ";break;
			case PAGE_UP: cout << " PAGE UP ";break;
			case PAGE_DOWN: cout << " PAGE DOWN ";break;
			case HOME: cout << " HOME ";break;
			case END: cout << " END ";break;
			case DELETE: cout << " DELETE ";break;
			case INSERT: cout << " INSERT ";break;
			default:cout << " " << char_ch << "  ";
			}
		}

	if(key() == ALT)
		{
		 cout << " ALT ";
		}
	else if(key() == CTRL)
		{
		 cout << " CTRL ";
		}
	else if(key() == RIGHT_SHIFT)
		{
		 cout << " RIGHT SHIFT ";
		}
	else if(key() == LEFT_SHIFT)
		{
		 cout << " LEFT_SHIFT ";
		}

	}
return;
}


int C_Break(void)
{
cout << "Ctrl Break Pressed.....Program aborted";
return FALSE; //FALSE ENDS The Program
}

int key()
{
REGS InRegister;
REGS OutRegister;
InRegister.x.ax =  0x0200;   //Reads Flags
if(getvect(KEYBOARD_INTERRUPT))  //Checks for error
 {
	int86(KEYBOARD_INTERRUPT,&InRegister,&OutRegister);
	if (OutRegister.x.ax & RIGHT_SHIFT) return  RIGHT_SHIFT;
	if (OutRegister.x.ax & LEFT_SHIFT)  return  LEFT_SHIFT;
	if (OutRegister.x.ax & CTRL)  return  CTRL;
	if (OutRegister.x.ax & ALT)   return  ALT;

	return OutRegister.x.ax;
 }
return FALSE;
}




//********************************************************************
//*********************** Test for Keyboard Events *******************
//********************************************************************
int Key_Press(char *char_ch)
{
  int Key_Pressed = bioskey(1);
  if (Key_Pressed) Key_Pressed = bioskey(0);
	*char_ch = ascii(Key_Pressed);    //char_1;
	return Key_Pressed;
}


//*******************************************************************
//*********** Converts an ascii number to character *****************
//*******************************************************************
char ascii(int num)
{
char asc_char;
asc_char = (char)num;
return (asc_char);
}

//*****************************************************************
//Routine to pause until a key is pressed and then to clear buffer
//******************************************************************
void Pause(int t_f)
{
int temp;
if(t_f == TRUE)
	{
	cout << "\nPause Press a Key\n";
	}
while(!kbhit());
temp = bioskey(0);
temp++;
return;
}

