#include <dos.h>
#include <conio.h>
#include <stdio.h>

#ifndef __MOUSE_H
	#include "c:\tc\mouse.h"
#endif


union REGS MouseInRegister,MouseOutRegister;
struct SREGS segregs;

int MousePresent = FALSE;
int JoyStickPresent = FALSE;

//To change the default Hot_Spots
//Mouse_Hot_Spot_Sw = TRUE;
//Then just change the number X and Y
//After that change Mouse_Hot_Spot_Sw back to FALSE
//You will have to do this each time for the cursor slection
//if you change it say a hourglass then change the hot spot,
//then set switch back to false, then change to a arrow cursor using
//the default hot spot. You then go back to the hourglass you
//will have to set sw true and the change the number again or
//it will use default settings.
//These are global variables!
int Mouse_Hot_Spot_X,Mouse_Hot_Spot_Y;
int Mouse_Hot_Spot_Sw = FALSE;

///////////////////////////////////////////////////////////////////////////
//*************************************************************************
//*************************************************************************
//********************** Joystick Routines ********************************
//*************************************************************************
//*************************************************************************
///////////////////////////////////////////////////////////////////////////

//******************************************************
//********* JoyStick Function XY ***********************
//******************************************************
int JoyStick_XY(int *A_X,int *A_Y,int *B_X,int *B_Y)
{
MouseInRegister.x.ax = JOYSTICK_RESET;
MouseInRegister.x.dx = JOYSTICK_XY;
int86(JOYSTICK_INTERRUPT, &MouseInRegister, &MouseOutRegister);
if (MouseOutRegister.x.cflag)
	{
	return FALSE;
	}
*A_X = MouseOutRegister.x.ax;
*A_Y = MouseOutRegister.x.bx;
*B_X = MouseOutRegister.x.cx;
*B_Y = MouseOutRegister.x.dx;
return TRUE;
}

//******************************************************
//********* JoyStick Function Buttons ******************
//******************************************************
int JoyStick_Switches(int *switch_0,int *switch_1,int *switch_2,int *switch_3)
{
MouseInRegister.x.ax = JOYSTICK_RESET;
MouseInRegister.x.dx = JOYSTICKBUTTONS;
int86(JOYSTICK_INTERRUPT, &MouseInRegister, &MouseOutRegister);
if (MouseOutRegister.x.cflag)
	{
	 return FALSE;
	}
*switch_0 = BOOL(MouseOutRegister.h.al & 0x10);
*switch_1 = BOOL(MouseOutRegister.h.al & 0x20);
*switch_2 = BOOL(MouseOutRegister.h.al & 0x40);
*switch_3 = BOOL(MouseOutRegister.h.al & 0x80);
return TRUE;
}




///////////////////////////////////////////////////////////////////////////
//*************************************************************************
//*************************************************************************
//********************** Mouse Routines ***********************************
//*************************************************************************
//*************************************************************************
///////////////////////////////////////////////////////////////////////////


//***********************************************************
//********** Determine's rather a mouse is present **********
//***********************************************************
int Detect_Mouse(void)
{

//Check to see if an interrupt is ready
if(getvect(MOUSE_INTERRUPT))
	{
	MouseInRegister.x.ax = RESETMOUSE;  //assigns 0x0000 to variable
				       //in ax register
	//Turns on mouse and gets info
	//sends reset into Register ax
	int86(MOUSE_INTERRUPT,&MouseInRegister,&MouseOutRegister);


	if(MouseOutRegister.x.ax != FALSE)            //Mouse     present = -1
		{                                 //Mouse not present = 0
		MousePresent = TRUE;
		return TRUE;
		}
	else
		{
		printf("MOUSE NOT INSTALLED");
		while (!kbhit()) /* do nothing */ ;
		return FALSE;
		}

	}
else
	{
	printf("No Mouse Present");
	while (!kbhit()) /* do nothing */ ;
	}
return FALSE;
}


//****************************************************
//******** Set's Mouse's Sensitivity *****************
//****************************************************
void Mouse_Sens(int Speed_X,int Speed_Y,int threshold)
{
if(MousePresent == FALSE)return;
MouseInRegister.x.ax = SETMOUSESENSITIVITY;  //0x1A
MouseInRegister.x.bx = Speed_X;
MouseInRegister.x.cx = Speed_Y;
MouseInRegister.x.dx = threshold;

if(getvect(MOUSE_INTERRUPT))
	{
	int86(MOUSE_INTERRUPT,&MouseInRegister,&MouseOutRegister);
	}
return;
}



//****************************************************
//******** Get's Mouse's Sensitivity *****************
//****************************************************
void Mouse_Sens(int *Speed_X,int *Speed_Y,int *threshold)
{
if(MousePresent == FALSE)return;
MouseInRegister.x.ax = GETMOUSESENSITIVITY;  //0x1B

if(getvect(MOUSE_INTERRUPT))
	{
	int86(MOUSE_INTERRUPT,&MouseInRegister,&MouseOutRegister);
	*Speed_X = MouseOutRegister.x.bx;
	*Speed_Y = MouseOutRegister.x.cx;
	*threshold = MouseOutRegister.x.dx;
	}
return;
}


//*********************************************************************
//******** Mouse Movement since last Call to this function ************
//*********************************************************************
void Mouse_Motion(int *Mickeys_X,int *Mickeys_Y)
{
if(MousePresent == FALSE)return;
MouseInRegister.x.ax = MOUSEMOTION; //0x0B
if(getvect(MOUSE_INTERRUPT))
	{
	int86(MOUSE_INTERRUPT,&MouseInRegister,&MouseOutRegister);
	*Mickeys_X = MouseOutRegister.x.cx;
	*Mickeys_Y = MouseOutRegister.x.dx;
	}
return;
}

void Hide_Mouse_XY(int left_X,int right_X,int top_Y,int bottom_Y)
{
if(MousePresent == FALSE)return;
MouseInRegister.x.ax = HIDEMOUSEXY; //0x10
MouseInRegister.x.cx = left_X;
MouseInRegister.x.si = right_X;
MouseInRegister.x.dx = top_Y;
MouseInRegister.x.di = bottom_Y;
if(getvect(MOUSE_INTERRUPT))
	{
	int86(MOUSE_INTERRUPT,&MouseInRegister,&MouseOutRegister);
	}
return;
}


//******************************************************
//******* Moves Mouse to New Position ******************
//******************************************************
void Move_Mouse(int Mouse_X,int Mouse_Y)
{
if(MousePresent == FALSE)return;
MouseInRegister.x.ax = MOVEMOUSE; //0x04
MouseInRegister.x.cx = Mouse_X;
MouseInRegister.x.dx = Mouse_Y;
if(getvect(MOUSE_INTERRUPT))
	{
	int86(MOUSE_INTERRUPT,&MouseInRegister,&MouseOutRegister);
	}
return;
}


//****************************************************
//***** Sets Mouse Horiz min and max movement ********
//****************************************************

void Horiz_Mouse_Limit(int Mouse_X_Min,int Mouse_X_Max)
{
if(MousePresent == FALSE)return;
MouseInRegister.x.ax = MOUSELIMITX;  //0x07
MouseInRegister.x.cx = Mouse_X_Min;
MouseInRegister.x.dx = Mouse_X_Max;

if(getvect(MOUSE_INTERRUPT))
	{
	int86(MOUSE_INTERRUPT,&MouseInRegister,&MouseOutRegister);
	}
return;
}


//****************************************************
//***** Returns Mouse X & Y at Button Press   ********
//****************************************************

int Button_Press_XY(int *Mouse_X,int *Mouse_Y,int Button_Check)
{
if(MousePresent == FALSE)return 0;
MouseInRegister.x.ax = BUTTON_PRESS_XY; //0x05
MouseInRegister.x.bx = Button_Check;

if(getvect(MOUSE_INTERRUPT))
	{
	int86(MOUSE_INTERRUPT,&MouseInRegister,&MouseOutRegister);
	*Mouse_X = MouseOutRegister.x.cx;
	*Mouse_Y = MouseOutRegister.x.dx;
	}
return MouseOutRegister.x.ax;
;
}


//****************************************************
//***** Returns Mouse X & Y at Button Release  ********
//****************************************************

int Button_Release_XY(int *Mouse_X,int *Mouse_Y,int Button_Check)
{
if(MousePresent == FALSE)return 0;
MouseInRegister.x.ax = BUTTON_RELEASE_XY;  //0x06
MouseInRegister.x.bx = Button_Check;

if(getvect(MOUSE_INTERRUPT))
	{
	int86(MOUSE_INTERRUPT,&MouseInRegister,&MouseOutRegister);
	*Mouse_X = MouseOutRegister.x.cx;
	*Mouse_Y = MouseOutRegister.x.dx;
	}
return MouseOutRegister.x.ax;
;
}



//****************************************************
//***** Sets Mouse Vert min and max movement ********
//****************************************************

void Vert_Mouse_Limit(int Mouse_Y_Min,int Mouse_Y_Max)
{
if(MousePresent == FALSE)return;
MouseInRegister.x.ax = MOUSELIMITY; //0x08
MouseInRegister.x.cx = Mouse_Y_Min;
MouseInRegister.x.dx = Mouse_Y_Max;

if(getvect(MOUSE_INTERRUPT))
	{
	int86(MOUSE_INTERRUPT,&MouseInRegister,&MouseOutRegister);
	}
return;
}

////////////////////////////////////////////////////////////////////////
//****************************************************
//***** Returns the mouse X and Y position   *********
//****************************************************
int Mouse_Position(int *Mouse_X,int *Mouse_Y)
{
int Button;
if(MousePresent == FALSE)return 0;
MouseInRegister.x.ax = MOUSEPOSITION;   //0x03
if(getvect(MOUSE_INTERRUPT))
	{
	int86(MOUSE_INTERRUPT,&MouseInRegister,&MouseOutRegister);
	Button   = MouseOutRegister.x.bx;
	*Mouse_X = MouseOutRegister.x.cx;
	*Mouse_Y = MouseOutRegister.x.dx;
	}
if(Button)
	return Button;
else
	return FALSE;
}


////////////////////////////////////////////////////////////
//*************************************
//* Loop till no buttons held down    *
//*************************************
void Button_Up(void)
{
if(MousePresent == FALSE)return;
int Button = TRUE;
while(Button)
	{
	MouseInRegister.x.ax = MOUSEPOSITION;
	if(getvect(MOUSE_INTERRUPT))
		{
		int86(MOUSE_INTERRUPT,&MouseInRegister,&MouseOutRegister);
		Button   = MouseOutRegister.x.bx;
		}
	}
return;
}



//****************************************************
//***** Returns the mouse button held down ************
//****************************************************
int Mouse_Status(void)
{
if(MousePresent == FALSE)return FALSE;
MouseInRegister.x.ax = MOUSEPOSITION; //0x03
if(getvect(MOUSE_INTERRUPT))
	{
	int86(MOUSE_INTERRUPT,&MouseInRegister,&MouseOutRegister);
	return MouseOutRegister.x.bx;
	}

return FALSE;
}





//////////////////////////////////

//***********************************************************
//********** Determine's rather a mouse is present **********
//********** & the number of buttons on mouse      **********
//***********************************************************
int Number_Of_Buttons(void)
{
if(MousePresent == FALSE)return FALSE;
//Check to see if an interrupt is ready
if(getvect(MOUSE_INTERRUPT))
	{
	MouseInRegister.x.ax = RESETMOUSE;  //assigns 0x0000 to variable
				       //in ax register
	//Turns on mouse and gets info
	//sends reset into Register ax
	int86(MOUSE_INTERRUPT,&MouseInRegister,&MouseOutRegister);
	return MouseOutRegister.x.bx;
	}
return FALSE;
}


//*********************************************************
//********** Displays Mouse cursor arrow on screen ********
//*********************************************************
void Display_Mouse()
{
if(MousePresent == FALSE)return;
MouseInRegister.x.ax = SHOWMOUSE;   //0x01
if(getvect(MOUSE_INTERRUPT))
		{
		int86(MOUSE_INTERRUPT,&MouseInRegister,&MouseOutRegister);
		}
return;
}
//*************************************************************
//************* Hides mouse cursor ****************************
//*************************************************************
void Hide_Mouse()
{
if(MousePresent == FALSE)return;
MouseInRegister.x.ax = HIDEMOUSE; //0x02
if(getvect(MOUSE_INTERRUPT))
	{
	int86(MOUSE_INTERRUPT,&MouseInRegister,&MouseOutRegister);
	}
return;
}



//***********************************************************
//*********** Cursor Shape Change ***************************
//***********************************************************
void Cursor_Shape(int cursor_select)
{

if(MousePresent == TRUE)
{
  switch(cursor_select)
	{
	case 1: //Space Ship
		{
		  static int curs1[32] =  /* Screen Mask SPACE */
				 { 	 0xfe7f, 0xfc3f, 0xfc3f, 0xe817,
					 0xe817, 0xe817, 0xe817, 0xe007,
					 0xe247, 0xe247, 0xc663, 0xc423,
					 0x8ff1, 0x8001, 0x8db1, 0x07e0,
					 /* Cursor Mask */
					 0x0180, 0x03c0, 0x03c0, 0x17e8,
					 0x17e8, 0x17e8, 0x17e8, 0x1ff8,
					 0x1e78, 0x1db8, 0x399c, 0x3bdc,
					 0x700e, 0x7ffe, 0x724e, 0xf81f       };
			       //	  }
		  /* Use the new cursor shape and attributes... */
		  MouseInRegister.x.ax = 9;
		  if(!Mouse_Hot_Spot_Sw)
			{
			  Mouse_Hot_Spot_X = 8;
			  Mouse_Hot_Spot_Y = 10;
			 }
		  MouseInRegister.x.bx = Mouse_Hot_Spot_X;  /* X position hotspot */
		  MouseInRegister.x.cx = Mouse_Hot_Spot_Y;  /* Y position hotspot */
		  MouseInRegister.x.dx = (int)curs1;
		  segread(&segregs);
		  segregs.es = segregs.ds;
		  int86x(0x33,&MouseInRegister,&MouseOutRegister,&segregs);
		  break;
		}

	case 2:  //Car
		{
		  static int curs2[32] =  /* Screen Mask CAR */
				 { 	 0xe007, 0x2004, 0x0000, 0x07e0,
					 0x27e4, 0xe007, 0xe007, 0xe007,
					 0xe007, 0xe007, 0xe007, 0x27e4,
					 0x07e0, 0x0000, 0x2004, 0xe007,
					 /* Cursor Mask */
					 0x1ff8, 0xdffb, 0xffff, 0xf81f,
					 0xd81b, 0x1ff8, 0x1ff8, 0x1ff8,
					 0x1ff8, 0x1ff8, 0x1ff8, 0xd81b,
					 0xf81f, 0xffff, 0xdffb, 0x1ff8
				    };

		    /* Use the new cursor shape and attributes... */
		  MouseInRegister.x.ax = 9;
		  if(!Mouse_Hot_Spot_Sw)
			{
			  Mouse_Hot_Spot_X = 8;
			  Mouse_Hot_Spot_Y = 10;
			}
		  MouseInRegister.x.bx = Mouse_Hot_Spot_X;  /* X position hotspot */
		  MouseInRegister.x.cx = Mouse_Hot_Spot_Y;  /* Y position hotspot */
		  MouseInRegister.x.dx = (int)curs2;
		  segread(&segregs);
		  segregs.es = segregs.ds;
		  int86x(0x33,&MouseInRegister,&MouseOutRegister,&segregs);
		  break;
		}//end case




	case 3:
		{  //Hand Cursor
		  static int curs3[32] =
		    {0xE1FF, 0xE1FF, 0xE1FF, 0xE1FF,
		    0xE1FF, 0xE000, 0xE000, 0xE000,
		    0x0000, 0x0000, 0x0000, 0x0000,
		    0x0000, 0x0000, 0x0000, 0x0000,
		   /*  Define cursor mask  */
		    0x1E00, 0x1200, 0x1200, 0x1200,
		    0x1200, 0x13FF, 0x1249, 0x1249,
		    0xF249, 0x9001, 0x9001, 0x9001,
		    0x8001, 0x8001, 0x8001, 0xFFFF};
		    /* Use the new cursor shape and attributes... */
		  MouseInRegister.x.ax = 9;
		  if(!Mouse_Hot_Spot_Sw)
			{
			  Mouse_Hot_Spot_X = 8;
			  Mouse_Hot_Spot_Y = 10;
			}
		  MouseInRegister.x.bx = Mouse_Hot_Spot_X;  /* X position hotspot */
		  MouseInRegister.x.cx = Mouse_Hot_Spot_Y;  /* Y position hotspot */
		  MouseInRegister.x.dx = (int)curs3;
		  segread(&segregs);
		  segregs.es = segregs.ds;
		  int86x(0x33,&MouseInRegister,&MouseOutRegister,&segregs);
		  break;
		}//end case

       case 4://Hour Glass
		{
		   static int curs4[32] =  /* Screen Mask */
			 { 	 0x0000, 0x3ffc, 0x4002, 0xaff5,
				 0xd00b, 0xe817, 0xf42f, 0xfa5f,
				 0xf5af, 0xf5af, 0xebd7, 0xd66b,
				 0xac35, 0x4002, 0x3ffc, 0x0000,
				 /* Cursor Mask */
				 0xffff, 0xc003, 0xbffd, 0x500a,
				 0x2ff4, 0x17e8, 0x0bd0, 0x05a0,
				 0x05a0, 0x0a50, 0x1428, 0x2994,
				 0x53ca, 0xbffd, 0xc003, 0xffff       };

		  /* Use the new cursor shape and attributes... */
		  MouseInRegister.x.ax = 9;
		  if(!Mouse_Hot_Spot_Sw)
			{
			  Mouse_Hot_Spot_X = 7;
			  Mouse_Hot_Spot_Y = 7;
			}
		  MouseInRegister.x.bx = Mouse_Hot_Spot_X;  /* X position hotspot */
		  MouseInRegister.x.cx = Mouse_Hot_Spot_Y;  /* Y position hotspot */
		  MouseInRegister.x.dx = (int)curs4;
		  segread(&segregs);
		  segregs.es = segregs.ds;
		  int86x(0x33,&MouseInRegister,&MouseOutRegister,&segregs);
		  break;
		}



       case 5://Text
		{
		  static int curs5[32] =  /* Screen Mask */
			 { 	 0xffff, 0xffff, 0xffff, 0xffff,
				 0xffff, 0xffff, 0xffff, 0xffff,
				 0x0000, 0x0000, 0xffff, 0x88a8,
				 0xdbad, 0xd8dd, 0xdbad, 0xd8ad,
				 /* Cursor Mask */
				 0x0000, 0x0000, 0x0000, 0x0000,
				 0x0000, 0x0000, 0x0000, 0x0000,
				 0xffff, 0xffff, 0x0000, 0x7757,
				 0x2452, 0x2722, 0x2452, 0x2752       };

		  /* Use the new cursor shape and attributes... */
		  MouseInRegister.x.ax = 9;
		  if(!Mouse_Hot_Spot_Sw)
			{
			  Mouse_Hot_Spot_X = 7;
			  Mouse_Hot_Spot_Y = 7;
			  }
		  MouseInRegister.x.bx = Mouse_Hot_Spot_X;  /* X position hotspot */
		  MouseInRegister.x.cx = Mouse_Hot_Spot_Y;  /* Y position hotspot */
		  MouseInRegister.x.dx = (int)curs5;
		  segread(&segregs);
		  segregs.es = segregs.ds;
		  int86x(0x33,&MouseInRegister,&MouseOutRegister,&segregs);
		  break;
		}

       case 6://Pencil
		{

		  static int curs6[32] =  /* Screen Mask */
			 { 	 0xffff, 0xffff, 0xffff, 0xffff,
				 0xff87, 0xff03, 0xfe21, 0xfc11,
				 0xf087, 0xf087, 0xe10f, 0xc21f,
				 0x843f, 0x807f, 0x80ff, 0x81ff,
				 /* Cursor Mask */
				 0x0000, 0x0000, 0x0000, 0x0000,
				 0x0000, 0x0030, 0x0058, 0x00e8,
				 0x01f0, 0x0360, 0x06c0, 0x0d80,
				 0x1b00, 0x1e00, 0x1c00, 0x0000       };

		  /* Use the new cursor shape and attributes... */
		  MouseInRegister.x.ax = 9;
		  if(!Mouse_Hot_Spot_Sw)
			{
			  Mouse_Hot_Spot_X = 1;
			  Mouse_Hot_Spot_Y = 16;
			  }
		  MouseInRegister.x.bx = Mouse_Hot_Spot_X;  /* X position hotspot */
		  MouseInRegister.x.cx = Mouse_Hot_Spot_Y;  /* Y position hotspot */
		  MouseInRegister.x.dx = (int)curs6;
		  segread(&segregs);
		  segregs.es = segregs.ds;
		  int86x(0x33,&MouseInRegister,&MouseOutRegister,&segregs);
		  break;
		}




       default://Arrow
		{


		  static int curs0[32] =  /* Screen Mask */
			 { 	 0x1fff, 0x0fff, 0x07ff, 0x03ff,
				 0x01ff, 0x00ff, 0x007f, 0x003f,
				 0x001f, 0x001f, 0x00ff, 0x10ff,
				 0x387f, 0xf87f, 0xf87f, 0xffff,
				 /* Cursor Mask */
				 0x4000, 0x6000, 0x7000, 0x7800,
				 0x7c00, 0x7e00, 0x7f00, 0x7f80,
				 0x7fc0, 0x7e00, 0x6600, 0x4600,
				 0x0300, 0x0300, 0x0000, 0x0000       };


		  /* Use the new cursor shape and attributes... */
		  MouseInRegister.x.ax = 9;
		  if(!Mouse_Hot_Spot_Sw)
			{
			  Mouse_Hot_Spot_X = 7;
			  Mouse_Hot_Spot_Y = 7;
			  }
		  MouseInRegister.x.bx = Mouse_Hot_Spot_X;  /* X position hotspot */
		  MouseInRegister.x.cx = Mouse_Hot_Spot_Y;  /* Y position hotspot */
		  MouseInRegister.x.dx = (int)curs0;
		  segread(&segregs);
		  segregs.es = segregs.ds;
		  int86x(0x33,&MouseInRegister,&MouseOutRegister,&segregs);
		  break;
		}

	}//end switch
//Display_Mouse();
}//end if
return;
}


    /*   Function 9:  Set Graphics Cursor Block  */
//    MouseInRegister.x.ax = CURSORSHAPE;  //0x09
//    MouseInRegister.x.bx = X_Hot_Spot;
//    MouseInRegister.x.cx = Y_Hot_Spot;
//    MouseInRegister.x.dx = (unsigned short)*cursor;
//    segread(&segregs);
//    segregs.es = segregs.ds;
//    int86x (MOUSE_INTERRUPT, &MouseInRegister, &MouseOutRegister, &segregs);
//    segread(&segregs);
//}
//return;
//}

