#ifndef __BIOS21_
	#include "C:\tc\bios21.h"
#endif



int Change_Name(char far *oldfilename,char far *newfilename)
 {
    union REGS regs; struct SREGS sregs;
    int ret;
    regs.h.ah = 0x56;                      /* delete file */
    regs.x.dx = FP_OFF(oldfilename);
    sregs.ds = FP_SEG(oldfilename);
    regs.x.di = FP_OFF(newfilename);
    sregs.es = FP_SEG(newfilename);
    ret = intdosx(&regs, &regs, &sregs);

    /* if carry flag is set, there was an error */
    return(regs.x.cflag ? ret : 0);
 }






// attrib = 0x0000 Normal read/write
//          0x0001 Read Only
//          0x0002 Hidden
//          0x0004 System
//          0x0008 Volume
//          0x0010 Directory, not file
//          0x0020 Archive
int set_attrib(char far *filename,int attrib)
 {
    union REGS regs; struct SREGS sregs;
    int ret;
    regs.h.ah = 0x43;                      /* create Directory */
    regs.h.al = 0x01;
    regs.h.ch = 0x00;
    regs.h.cl = attrib;
    regs.x.dx = FP_OFF(filename);
    sregs.ds = FP_SEG(filename);
    ret = intdosx(&regs, &regs, &sregs);
    /* if carry flag is set, there was an error */
    return(regs.x.cflag ? ret : 0);
 }




//attrib = 16 directory; 32 for normal file....test for rest?
int get_attrib(char far *filename,int *attrib)
 {
    union REGS regs; struct SREGS sregs;
    int ret;
    regs.h.ah = 0x43;                      /* create Directory */
    regs.h.al = 0x00;
    regs.x.dx = FP_OFF(filename);
    sregs.ds = FP_SEG(filename);
    ret = intdosx(&regs, &regs, &sregs);
    *attrib = regs.h.cl;
    /* if carry flag is set, there was an error */
    return(regs.x.cflag ? ret : 0);
 }


// err = create_dir("DOS"); Has to be a subdirectory of current dir
int create_dir(char far *dirname)
 {
    union REGS regs; struct SREGS sregs;
    int ret;
    regs.h.ah = 0x39;                      /* create Directory */
    regs.x.dx = FP_OFF(dirname);
    sregs.ds = FP_SEG(dirname);
    ret = intdosx(&regs, &regs, &sregs);

    /* if carry flag is set, there was an error */
    return(regs.x.cflag ? ret : 0);
 }





// err = change_dir("DOS"); Has to be a subdirectory of current dir
int change_dir(char far *dirname)
 {
    union REGS regs; struct SREGS sregs;
    int ret;
    regs.h.ah = 0x3B;                      /* change Directory */
    regs.x.dx = FP_OFF(dirname);
    sregs.ds = FP_SEG(dirname);
    ret = intdosx(&regs, &regs, &sregs);

    /* if carry flag is set, there was an error */
    return(regs.x.cflag ? ret : 0);
 }



// err = delete_dir("DOS"); Has to be a subdirectory of current dir
//Also has to be no files in it
int delete_dir(char far *dirname)
 {
    union REGS regs; struct SREGS sregs;
    int ret;
    regs.h.ah = 0x3A;                      /* delete Directory */
    regs.x.dx = FP_OFF(dirname);
    sregs.ds = FP_SEG(dirname);
    ret = intdosx(&regs, &regs, &sregs);

    /* if carry flag is set, there was an error */
    return(regs.x.cflag ? ret : 0);
 }



// err = delete_file("TC0008.SWP");
int delete_file(char far *filename)
 {
    union REGS regs; struct SREGS sregs;
    int ret;
    regs.h.ah = 0x41;                      /* delete file */
    regs.x.dx = FP_OFF(filename);
    sregs.ds = FP_SEG(filename);
    ret = intdosx(&regs, &regs, &sregs);

    /* if carry flag is set, there was an error */
    return(regs.x.cflag ? ret : 0);
 }





//INT 21H AH = 54h Get Verify Flag
//flag set to TRUE Verify on
int Get_Verify(void)
{
   union REGS regs;
   regs.h.ah = 0x54;
   int86(0x21, &regs, &regs);
return regs.h.al;  //0 Verify off
}




//INT 21H AH = 33h AL = 06h Get Dos Version
//	printf("%1.2f",(Get_Dos_Version() / 100) );
float Get_Dos_Version(void)
{
   union REGS regs;
   regs.h.al = 0x06;
   regs.h.ah = 0x33;
   int86(0x21, &regs, &regs);
return( (regs.h.bl * 100) + regs.h.bh);
}



//INT 21H AH = 33h AL = 05h Get Startup Drive
//Returns.....0 = A; 1 = B; etc
int Get_Boot_Drive(void)
{
   union REGS regs;
   regs.h.al = 0x05;
   regs.h.ah = 0x33;
   int86(0x21, &regs, &regs);
return regs.h.dl - 1;
}


//INT 21H AH = 33h AL = 01h Set CTRL+C Check Flag
void Set_CTRL_C(int checking)
{
   union REGS regs;
   switch(checking)
      {
      case TRUE:
      regs.h.dl = 1;
      break;
      case FALSE:
      regs.h.dl = 0;
      break;
      }
   regs.h.al = 0x01;
   regs.h.ah = 0x33;
   int86(0x21, &regs, &regs);
return;
}


//INT 21H AH = 33h AL = 00h Get CTRL+C Check Flag
int Get_CTRL_C(void)
{
   union REGS regs;
   regs.h.al = 0x00;
   regs.h.ah = 0x33;
   int86(0x21, &regs, &regs);
return regs.h.dl;  //Returns 0 if disabled
}



//INT 21H AH = 2Eh Set/Reset Verify Flag
//flag set to TRUE Verify on
void Set_Verify(int flag)
{
   union REGS regs;
   switch(flag)
	{
	case TRUE:
	regs.h.al = 1;
	break;

	case FALSE:
	regs.h.al = 0;
	break;
	}
   regs.h.ah = 0x2E;
   int86(0x21, &regs, &regs);
return;
}




//INT 21H AH = 2Dh Set Time
int Set_Time(int Hour,int Min,int Sec)
{
   union REGS regs;
   regs.h.ah = 0x2B;
   regs.h.ch = Hour;
   regs.h.cl = Min;
   regs.h.dh = Sec;
   int86(0x21, &regs, &regs);
return regs.h.al;  //Returns 0 if valid
}




//INT 21H AH = 2Ch Get Hour
int Get_Hour(void)
{
   union REGS regs;
   regs.h.ah = 0x2C;
   int86(0x21, &regs, &regs);
return regs.h.ch;
}
//INT 21H AH = 2Ch Get Min
int Get_Min(void)
{
   union REGS regs;
   regs.h.ah = 0x2C;
   int86(0x21, &regs, &regs);
return regs.h.cl;
}
//INT 21H AH = 2Ch Get Sec
int Get_Sec(void)
{
   union REGS regs;
   regs.h.ah = 0x2C;
   int86(0x21, &regs, &regs);
return regs.h.dh;
}
//INT 21H AH = 2Ch Get Hundredths of sec
int Get_Hund_Sec(void)
{
   union REGS regs;
   regs.h.ah = 0x2C;
   int86(0x21, &regs, &regs);
return regs.h.dl;
}



//INT 21H AH = 2Bh Set Date
int Set_Date(int year,int month,int day)
{
   union REGS regs;
   regs.h.ah = 0x2B;
   regs.x.cx = year;
   regs.h.dh = month;
   regs.h.dl = day;
   int86(0x21, &regs, &regs);
return regs.h.al;  //Returns 0 if valid
}



//INT 21H AH = 2Ah Get Date
//See Date structure
void Get_Date(void)
{
   union REGS regs;
   regs.h.ah = 0x2A;
   int86(0x21, &regs, &regs);
   Date.year  = regs.x.cx;
   Date.month = regs.h.dh;
   Date.day   = regs.h.dl;
   switch (regs.h.al)
	{
	case 0:
	strcpy(Date.day_string,"SUNDAY");
	break;

	case 1:
	strcpy(Date.day_string,"MONDAY");
	break;

	case 2:
	strcpy(Date.day_string,"TUESDAY");
	break;

	case 3:
	strcpy(Date.day_string,"WEDNESDAY");
	break;

	case 4:
	strcpy(Date.day_string,"THURSDAY");
	break;

	case 5:
	strcpy(Date.day_string,"FRIDAY");
	break;

	case 6:
	strcpy(Date.day_string,"SATURDAY");
	break;
	}
return;
}

//INT 21H AH = 19h Get Current Drive
//drive_num.......0=A, 1=B etc
int Get_Current_Drive(void)
{
   union REGS regs;
   regs.h.ah = 0x19;
   int86(0x21, &regs, &regs);
return regs.h.al;
}


//INT 21H AH = 0Dh Set Default Drive
//drive_num.......0=A, 1=B etc
//if drive doesn't exist nothing happens no error's etc
void Set_Default_Drive(int drive_num)
{
   union REGS regs;
   regs.h.ah = 0x0E;
   regs.h.dl = drive_num;
   int86(0x21, &regs, &regs);
return;
}

//INT 21H AH = 0Dh Reset Drive
//Flushes all file buffers to disk
//It's necessary to close all files to update directory
void Reset_Drive(void)
{
   union REGS regs;
   regs.h.ah = 0x0D;
   int86(0x21, &regs, &regs);
return;
}





//INT 21H AH = 0Ch Flush Buffer, Read Keyboard
//Waits on a KeyPress before continue
//Doesn't have to press Enter
int Flush_Buffer_Read_Key(int select = 1)//Default to 1
{
union REGS regs;
switch(select)
	{
	case 0:
	regs.h.al = 0x01;  //Read Keyboard with Echo
	break;

	case 1:
	regs.h.al = 0x08;  //Read Keyboard without Echo
	break;
	}
regs.h.ah = 0x0C;
int86(0x21, &regs, &regs);
return regs.h.al;
}




//INT 21H AH = 0Bh Check Keyboard Status
//Does not get Key from buffer!!!!!!!!!!
//Will continue TRUE until char has been gotten out
int Check_Keyboard(void)
{
   union REGS regs;
   regs.h.ah = 0x0B;
   int86(0x21, &regs, &regs);
   if(regs.h.al != 0x00) return TRUE;
return FALSE;
}




//INT 21H AH = 0Bh Check Keyboard Status
//Does not get Key from buffer!!!!!!!!!!
//Will continue TRUE until char has been gotten out
void Kill_Key(void)
{
union REGS regs;
int buff = FALSE;
while(!buff)
   {
   regs.h.ah = 0x08;
   int86(0x21, &regs, &regs);
   buff = regs.h.al;
   if(buff) getch();
   }
return;
}


//int 21h Ah = 00H Terminate Program
//Closes all File Buffers
//Frees all memaory from calling program
void terminate(void)
{
   union REGS regs;
   regs.h.ah = 0x00;
   int86(0x21, &regs, &regs);
}


//int 21h Ah = 01H Read Keyboard with echo
//Control-C enabled
//Returns ASCII the number
//Waits till a key is pressed!!!!!!!!!!!!!!
//Displays key and removes it from the keyboard buffer
int Read_Key_Echo_int()
{
   union REGS regs;
   regs.h.ah = 0x01;
   int86(0x21, &regs, &regs);
return regs.h.al;
}
//Returns Character same as above
char Read_Key_Echo_char()
{
char ASCII;
   union REGS regs;
   regs.h.ah = 0x01;
   int86(0x21, &regs, &regs);
   ASCII = regs.h.al;
return ASCII;
}

//INT 21 Ah = 02H Display Character
//Cursor position updated
//if Backspace cursor moves to left but char isn't erased.
void Display_Char(int ASCII)
{
   union REGS regs;
   regs.h.ah = 0x02;
   regs.h.dl = ASCII;
   int86(0x21, &regs, &regs);
return;
}
//INT 21 Ah = 02H Display Character
//Cursor position updated
//if Backspace cursor moves to left but char isn't erased.
void Display_Char(char ASCII)
{
   union REGS regs;
   regs.h.ah = 0x02;
   regs.h.dl = ASCII;
   int86(0x21, &regs, &regs);
return;
}


//INT 21 Ah = 06H Direct Console I/O   STDIN  STDOUT
//if IO_Switch set to IN it will return FALSE if no key is in buffer
//it does not wait to return the key,so of moniters the keyboard.
//If a key is available it will set ASCII varialble to the
//ASCII character number for the keypress
//If IO_Switch is set to OUT I have no ideal?
int Direct_Console_IO(int IO_Switch,int *ASCII)
{
   int SS;
   if(IO_Switch == IN)
	{
	SS = 0xFF;
	}
   else if(IO_Switch == OUT)   //???????????????????????????????
	{
	SS = 0x00;
	}

   union REGS regs;
   regs.h.ah = 0x06;
   regs.h.dl = SS;
   int86(0x21, &regs, &regs);
   *ASCII = regs.h.al; //set to 00H if no char avail
   if(regs.x.flags == 13015) return FALSE;
//No return value if OUT requested
return regs.x.flags; //set to 0 if no char available
}                    //& IO_Switch set to IN



//INT 21 Ah = 07H Direct Console Input
//Does not echo char or check for CTRL+C
//WILL WAIT FOR KEYPRESS!!!!!!!!!!!!!!!!!!!!!!!!!1
//Extended ASCII codes require 2 function calls?????????
//RETURNS the ASCII, works with all keys except CTRL,ALT,SHIFT
//But will return ALT+keypress!!!!!!!!!!!!!!!!!!!
int Console_Input(void)
{
   union REGS regs;
   regs.h.ah = 0x07;
   int86(0x21, &regs, &regs);
return regs.h.al;
}


//INT 21 Ah = 08H Read Keyboard without echo
//Works same as above, waits for keypress
int Read_Key_No_Echo_int(void)
{
   union REGS regs;
   regs.h.ah = 0x08;
   int86(0x21, &regs, &regs);
return regs.h.al;
}
//INT 21 Ah = 08H Read Keyboard without echo
char Read_Key_No_Echo_char(void)
{
   union REGS regs;
   regs.h.ah = 0x08;
   int86(0x21, &regs, &regs);
return regs.h.al;
}

