#ifndef __BIOS10_
	#define __BIOS10_

#include <dos.h>
#include <stdlib.h>
#include <time.h>
#include <math.h>

#if !defined(__COLORS__)
	#define __COLORS__
	#define BLACK1 0
	#define BLUE1 1
	#define GREEN1 2
	#define CYAN1 3
	#define RED1 4
	#define MAGENTA1 5
	#define BROWN1 6
	#define LGRAY1 7
	#define DGRAY1 8
	#define LBLUE1 9
	#define LGREEN1 10
	#define LCYAN1 11
	#define LRED1 12
	#define LMAGENTA1 13
	#define YELLOW1 14
	#define WHITE1 15
#endif

#define VGA256     0x13
#define ROM_CHAR_SET_SEG 0xF000  // segment of 8x8 ROM character set
#define ROM_CHAR_SET_OFF 0xFA6E  // begining offset of 8x8 ROM character set
#define CHAR_WIDTH        8      // size of characters
#define CHAR_HEIGHT       8
#define SCREEN_WIDTH      (unsigned int)320 // mode 13h screen dimensions
#define SCREEN_HEIGHT     (unsigned int)200
#define TEXT_MODE  0x03
#define PALETTE_MASK        0x3c6
#define PALETTE_REGISTER_RD 0x3c7
#define PALETTE_REGISTER_WR 0x3c8
#define PALETTE_DATA        0x3c9
#define PI          (float)3.14159
#define IN 1
#define OUT 0
#define FALSE 0
#define TRUE -1
#define BLOCKCURSOR 7,0
#define NORMALCURSOR 6,6
#define ABOVECURSOR 0,0
#define NOCURSOR 5,0
#define NOCURSOR2 0,20
//#define offset offset2=((row*width)+column*2
/////////////////////////////////////////////////////////
///////////////////////////////////////////////////////
// I used  regs.h.al = (unsigned char)mode
// For Mode use the 0x    for it!!!!!!!!!!!!!!!!!
// mode  type Max_Colors  Text Format  Max_Pages   Buffer_Start
// 0x00	  T	16	     40x25	  8	     B8000
// 0x01   T	16	     40x25	  8	     " "
// 0x02   T	16	     80x25	  8	     " "
// 0x03   T	16	     80x25	  8	     " "
// 0x04   G      4           40x25	  1          " "
// 0x05   G	 4	     40x25	  1	     " "
// 0x06   G	 2           80x25        1          " "
// 0x07   T     mono         80x25        1          B0000
// 0x08   G     16           20x25        1          " "
// 0x09   G     16           40x25        1          " "
// 0x0A   G      4           80x25        1          " "
// 0x0D   G     16           40x25        8          A0000
// 0x0E   G     16           80x25        4          A0000
// 0x0F   G     mono         80x25        2          A0000
// 0x10   G     16           80x25        2          A0000
// 0x11   G      2           80x30        1          A0000
// 0x12   G     16           80x30        1          A0000
// 0x13   G    256           40x25        1          A0000
//INT 10H AH = 00h Set Video Mode
unsigned int Get_Current_Mode(void);
//void Set_Mode(0x0E); //Must be 0x format

void Set_Mode(int mode); //Must be 0x format
void VGA13_Mode(void);
void TEXT_Mode(void);

void Set_Cursor(int cl,int ch);
void BLOCK_Cursor(void);
void NORMAL_Cursor(void);
void HIDDEN_Cursor(void);

void Move_Cursor(int X,int Y,int page);
void Move_Cursor(int X,int Y);//current page slower than above
void Cursor_Home(void);//page 0, Home 1,1 or 0,0

void Get_Cursor_Type(int *cl,int *ch,int page);

void Get_CursorXY(int page,int *,int *);
int Get_CursorX(int page);
int Get_CursorY(int page);

unsigned int Get_Current_Page(void);

unsigned int Get_Current_Mode_Col(void);

void Select_Page(int page);


void Border_Color(int color);
char Read_Char_Page(int page, int *);  //<<<attribute)
char Read_Char(int *); //at current page attribute
void Write_Pixel_XOR(int X,int Y,int color,int page);//?????????????
void Write_Pixel(int X,int Y,int color,int page);    //Bit 7 of color???
void Write_Pixel(int X,int Y,int color);//Current page
void Write_Pixel(int X,int Y);//Current page       COLOR???????????????
int Read_Pixel(int X,int Y,int page);
int Read_Pixel(int X,int Y);//Current page
void Write_Teletype(char ch,int color,int page);
void Write_Teletype(int ch,int color,int page);
void Write_Teletype(char ch,int color);//Current page
void Write_Char_Page(char chr,int page,int num,int color);
void Write_Char_Page2(char chr,int page,int num);


// G L O B A L S /////////////////////////////////////////////////////////////

void Plot_Pixel_Fast(int x,int y,unsigned char color);
void Desolve_256(void);



unsigned char far *video_buffer = (char far *)0xA0000000L; // vram byte ptr
unsigned char far *rom_char_set = (char far *)0xF000FA6EL; // rom characters 8x8
int Get_Tick(void);
void Write_Pixel2(int X,int Y,int color);
#endif
#include "C:\tc\bios10.cpp"
