{
                                 

           INPUT.CH  include module for CHESS.PAS
             Last modified:  10/29/85

    This module contains keyboard input routines.

                                 
}

type
  MenuType = ( MainMenu, LevelMenu, EditMenu );
    { a variable of this type indicates the current Menu which tells
      the input routine what type options are permissable }
var
  CurMenu : MenuType;

procedure GetKey(var ch : char);
begin
  Read(KBD, ch);
end;

const
  MaxLen = 64;
type
  MaxString = string[MaxLen];

procedure Abort;
begin
  GoToXY(1,25);
  Halt;
end; { Abort }

procedure QuitProgram; forward;

procedure HScroll(var S : MaxString; Width : byte);
{ Reads a string using a one line window that scrolls
  horizontally }
var
  ch          : char;
  i, StartCol : byte;
begin
  s := '';
  StartCol := WhereX;
  TextBackground(LightGray);
  TextColor(0);
  Write(' ': Width);
  GoToXY(StartCol, WhereY);
  repeat
    GetKey(ch);
    ch := UpCase(ch);
    case ch of
      ^C        : Abort;
      ^[        : if KeyPressed then    { function or arrow: ignrore }
                  begin
                    GetKey(ch);
                    ch := ' ';
                  end
                  else;                 { ignore Esc }
    #32..#127   : if Length(s) < MaxLen then
                  begin
                    s := s + ch;
                    if Length(s) >= Width then
                    begin
                      GoToXY(StartCol, WhereY);
                      for i := Length(s) - Width + 1 to Length(s) do
                        Write(s[i]);
                    end
                    else Write(ch);
                  end;
      #8        : if Length(s) > 0 then
                  begin
                    Delete(s, Length(s), 1);
                    GoToXY(WhereX - 1, WhereY);
                    Write(' ');
                    GoToXY(WhereX - 1, WhereY);
                    if Length(s) >= Width then
                    begin
                      GoToXY(StartCol, WhereY);
                      for i := Length(s) - Width + 1 to Length(s) do
                        Write(s[i]);
                    end
                  end;
    end; { case }
  until (ch = #13);
end; { HScroll }

{ Saves a representation of the Board to the specified file }
procedure SaveIt(var SaveCode : byte); { returns Code:  0 = not saved }
const                                     {                1 = Saved     }
  Width = 14;                             {               -1 = Error     }
var
  SaveFile : MaxString;

function SaveBoard(SaveFile : MaxString) : boolean;
var
  GameBoard : Text;

procedure SaveHeader(var Save : Text);
begin
  if Player = White then
    Writeln(Save,'WHITE to play')
  else
    Writeln(Save,'BLACK to play');
  if Turned then
    Writeln(Save,'WHITE=Program')
  else
    Writeln(Save,'BLACK=Program');
end; { SaveHeader }

procedure SaveEachPiece(var Save : Text);
var
  Square : SquareType;

function PieceToChar(Piece : PieceType) : char;
{ Convert game Piece to its Character equivalent }
begin
  case Piece of
    King   : PieceToChar := 'K';
    Queen  : PieceToChar := 'Q';
    Rook   : PieceToChar := 'R';
    Bishop : PieceToChar := 'B';
    Knight : PieceToChar := 'N';
    Pawn   : PieceToChar := 'P'
  end;
end; { PieceToChar }

procedure SavePiece(CurSquare : BoardType);
{ Writes the representation of a Piece to the file
  in the form : <Color> <Piece > ' ' < Location > }
begin
  with CurSquare do
  begin
    if Color = White then
      Write(Save,'W')
    else
      Write(Save,'B');
    Write(Save,PieceToChar(Piece));
    Write(Save,' ');
    { Now write out squares: a1=0, b1=1,..., a2=$10,..., h8=$77 }
    Write(Save,Chr( ord('A') + Square MOD 16));
    Writeln(Save,Chr( ord('1') + Square DIV 16));
  end;
end; { SavePiece }

begin { SaveEachPiece }
  for Square := 0 to $77 do
  begin
    with Board[Square] do
      if Piece <> Empty then SavePiece(Board[Square]);
  end;
end; { SaveEachPiece }

begin { SaveBoard }
  Assign(GameBoard, SaveFile);
  {$I-}
  ReWrite(GameBoard);
  {$I+}
  if IOresult = 0 then
  begin
    SaveBoard := true;
    SaveHeader(GameBoard);
    SaveEachPiece(GameBoard);
    Close(GameBoard);
  end
  else SaveBoard := False;
end; { SaveBoard }

begin { SaveIt }
  ClearMenu;
  GoToPos(MenuPos,0,2);
  Write('SAVE THE BOARD');
  GoToPos(MenuPos,0,4);
  Write('File name: ');
  HScroll(SaveFile, Width);
  if Length(SaveFile) > 0 then
  begin
    if SaveBoard(SaveFile) then SaveCode := 1     { saved     }
    else
    begin
      SaveCode := -1;                             { Error     }
      Error('Error during Save');
      Delay(1500);
    end
  end
  else
  begin
    SaveCode := 0;                                { not saved }
    Error('Game not saved');
    Delay(1500);
  end;
  GoToPos(MenuPos,0,5);
  ClearMenu;
  DispEditMenu;
end; { SaveIt }

procedure QuitProgram;
{ Conditionally saves the current Board,  and aborts the program }
var
  SaveCode : byte;
  Choice : char;
begin
  ClearMenu;
  GoToPos(MenuPos,0,3);
  Write('Save this board (Y/N)? ');
  repeat
    GetKey(Choice);
    Choice := UpCase(Choice);
  until Choice in ['Y','N', ^C];
  if Choice = 'Y' then
  begin
    Write('Yes');
    SaveIt(SaveCode);
    LowVideo;
    GoToXY(1,25);
    ClrEOL;
    if SaveCode = 1 then  { Codes: 0=not saved, -1=Write Error, 1=Saved }
    begin
      Write('Board saved.  Re-load using the Edit function.')
    end;
  end
  else
  begin
    Write('No');
    LowVideo;
    GoToXY(1,25);
    ClrEOL;
  end;
  Abort;
end; { QuitProgram }

function Editing : boolean;
{ Used by GetCommand to determine if we are getting an Edit Command }
begin
  Editing := (CurMenu = EditMenu);
end;

function CalcSquare(a,b : char) : EdgeSquareType;
{ Converts the Square indicator from its input from to a
  form that the Analysis part of the program understands  }
begin
   if (a in ['A'..'H']) and (b in ['1'..'8']) then
      CalcSquare := (ord(b) - ord('1')) * 16 +
                  (ord(a) - ord('A'))
   else
      CalcSquare := -1;
end; { CalcSquare }

type
{ The following types and procedures allow input by cursor movement
  keys to be implemented }
  Character = record    { represents a Character On the Screen }
    c : char;
    Attribute : byte
  end; { Character }

  ScreenBuf = array[1..25, 1..80] of Character;
  ScreenPtr = ^ScreenBuf;

var
  Screen : ScreenPtr;    { pointer to the beginning of the Screen }


procedure SetScreen( var Screen : ScreenPtr );
{ Determines whether the Screen is Color or MonoChrome
  by invoking a DOS call and then sets the screen pointer
  to the correct memory address }
const
  MonoChrome = 7;
type
  Regs = record
           AX,BX,CX,DX,BP,SI,DI,DS,ES,Flags : integer;
         end;
 var
   IntRec : Regs;
   StartSeg : integer;

begin
  with IntRec do
  begin
    AX := $0F00;
    Intr($10,IntRec );
    if (Lo(AX) = MonoChrome) then
    begin
      StartSeg := $B000;
      MenuPos.Color := 7;
      MenuPos.Background := 0;
      LightColor.Color := 10;
      LightColor.Background := 0;
    end
    else
      StartSeg := $B800;
  end;
  Screen := Ptr( StartSeg,$00 );
end; { SetScreen }

procedure FirstSquare(var a,b : char);
{ Checks to see if the Board is Turned and accordingly
  sets where the arrow indicator will Start so that is
  On the same Rank as the King }
begin
  if Turned then
  begin
    a := 'D';
    b := '5';
  end
  else
  begin
    a := 'E'; b := '4';               { Start @ D4 }
  end;
end; { FirstSquare }

var
  LastA, LastB : char; { Last place where a piece was edited }

procedure SetLastSquare;
begin
  FirstSquare(LastA, LastB);
end; { SetLastSquare }

procedure GetCommand(var Command : CommandString);
{ Multi-purpose input routine that gets the user Command
  from the Main Menu, the Edit Menu, and the Level set Menu }
var
  ch : char;

procedure GetSquare(var BlinkingSquare : integer;
                    var a, b           : char;
                    var Command : CommandString);
{ Gets arrow input and goes to the indicated Square }

var
  OldLine : array[0..3] of Character;
  ch : char;

procedure BlinkSquare(SquareNumber : integer; On : boolean);
{ Blinks arrow indicator On the current Square }
const
  BlinkLine : array[0..5] of Character =
                                   ((c : #31; Attribute : 142), { Down arrow }
                                    (c : #31; Attribute : 142), { Down arrow }
                                    (c : #31; Attribute : 142), { Down arrow }
                                    (c : #31; Attribute : 142), { Down arrow }
                                    (c : #31; Attribute : 142), { Down arrow }
                                    (c : #31; Attribute : 142)  { Down arrow }
                                    );
begin { BlinkSquare }
  GoToSquare(SquareNumber, 0, 0);
  if On then   { Blink this Square }
  begin
    Move(Screen^[WhereY, WhereX + 1], OldLine, SizeOf(OldLine));
    Move(BlinkLine, Screen^[WhereY, WhereX + 1], SizeOf(OldLine));
  end
  else        { Restore this Square }
  begin
    Move(OldLine, Screen^[WhereY, WhereX + 1], SizeOf(OldLine));
  end;
end; { BlinkSquare }

procedure GetArrow( ch : char; var a,b : char );
{ Reads Arrow and changes characters that will be put in the
  Command Line to reflect the equivalent keyed in Move }

function Up(b : char ) : char;
begin
  if Turned then
    Up := Pred(b)
  else
    Up := Succ(b);
end; { Up }

function Down(b : char) : char;
begin
  if Turned then
    Down := Succ(b)
  else
    Down := Pred(b);
end;  { Down }

function Right(a : char) : char;
begin
  if Turned then
    Right := Pred(a)
  else
    Right := Succ(a);
end;  { Right }

function Left(a : char) : char;
begin
  if Turned then
    Left := Succ(a)
  else
    Left := Pred(a);
end; { Left }

begin { GetArrow }
  case ch of                   { cursor movement keys: }
    'G' : begin
            a := Left(a);      { Up Left }
            b := Up(b);
          end;
    'H' : begin
            b := Up(b);        { Up }
          end;
    'I' : begin
            a := Right(a);     { Up Right }
            b := Up(b);
          end;
    'K' : begin                { Left }
            a := Left(a)
          end;
    'M' : begin                { Right }
            a := Right(a);
          end;
    'P' : begin                { Down }
            b := Down(b);
          end;
    'O' : begin                { Down Left }
            a := Left(a);
            b := Down(b);
          end;
    'Q' : begin                { Down Right }
            a := Right(a);
            b := Down(b);
          end;
  end; { case }
  { The following Code implements wrap around for arrows
    On the Screen }
  if ch in ['G', 'H', 'I', 'K', 'M', 'P', 'O', 'Q'] then
  begin
    if a < 'A' then a := 'H'
    else
      if a > 'H' then a := 'A';
    if b > '8' then b := '1'
    else
      if b < '1' then b := '8';
  end;
end; { GetArrow }

begin { GetSquare }
  BlinkingSquare := CalcSquare(a, b);
  BlinkSquare(BlinkingSquare, true);
  repeat
    GoToPos(CommandPos, 8, 0);
    Write(Command + a + b);
    GetKey(ch);
    case ch of
      ^C : Abort;
      ^[ : if KeyPressed then
           begin
             GetKey(ch);
             GetArrow(ch,a,b);
             if ch in ['G', 'H', 'I', 'K', 'M', 'P', 'O', 'Q'] then
             begin
               BlinkSquare(BlinkingSquare, False);   { Turn Old off }
               BlinkingSquare := CalcSquare(a, b);   { calc new Sq  }
               BlinkSquare(BlinkingSquare, true);    { Turn new On  }
             end
           end
           else;                                     { ignore Esc   }
      #8        : begin
                    Command := '';
                    BlinkSquare(BlinkingSquare, False);   { Turn Old off }
                    GoToPos(CommandPos,8,0);
                    Write(Command + '    ');
                    GoToPos(CommandPos,8,0);
                    if Editing then
                      PieceMessage
                    else
                      MoveMessage;
                    Exit;
                  end;
      ' ' : begin
              Command := Command + a + b;
              BlinkSquare(BlinkingSquare, False);
            end;
    end; { case }
  until (ch = ' ') ;
end; { GetSquare }

procedure GetMove(var Command : CommandString);
var
  BlinkingSquare : integer;
  a, b      : char;

begin  { GetMove }
  FirstSquare(a,b);
  Command := '';
  PieceArrowMsg;
  GetSquare(BlinkingSquare, a, b, Command);
  if (Length(Command) = 2) then
  begin
    DestArrowMsg;
    GetSquare(BlinkingSquare, a, b, Command);
    if Length(Command) = 4 then
      ClearMessage;
  end
end; { GetMove }

procedure GetPosition(var Command : CommandString);
var
  BlinkingSquare : integer;
  a, b: char;

procedure LastSquare(var a,b : char);
begin
  a := LastA;
  b := LastB;
end; { LastSquare }

begin  { GetPosition }
  LastSquare(a, b);
  EdArrowMsg;
  GetSquare(BlinkingSquare, a, b, Command);
  PieceMessage;
  LastA := a;
  LastB := b;
end; { GetPosition }

function ValidPiece : boolean;
{ Used in Editing, determines whether a valid game Piece
  has been entered which will then allow arrow input }
begin
  ValidPiece := False;
  if (Length(Command) = 1) then
    if Command[1] in ['P','N','B','R','Q','K',' '] then
      ValidPiece := True;
end; { ValidPiece }

{ Used in Editing, determines which help window is appropriate
  and displays it }
procedure NewMenu;
begin
  if Editing then
    if ValidPiece then
      SquareMessage
    else
      PieceMessage;
end;  { NewMenu }

function ArrowAllowed : boolean;
{ Returns true if at this point in getting a
  Command an arrow is valid for input }
begin
  ArrowAllowed := False;
  if (CurMenu = MainMenu) then
    ArrowAllowed := true;
  if (CurMenu = EditMenu) and ValidPiece then
    ArrowAllowed := true;
end; { ArrowAllowed }

begin { GetCommand }
  Command := '';
  repeat
    GetKey(ch);
    ClearErrMsg;
    ch := UpCase(ch);
    case ch of
      ^C        : Abort;                               { Abort program }
      ^[        : if KeyPressed then               { function or arrow key }
                  begin
                     GetKey(ch);
                     if ArrowAllowed then
                     begin
                       if Editing then
                         GetPosition(Command)
                       else
                         GetMove(Command);   { get Move w/ arrow keys }
                       if Length(Command) > 0 then Exit  { Done with input }
                     end;
                  end
                  else;                                       { ignore Esc }
      #8        : if Length(Command) > 0 then
                  begin
                    Delete(Command, Length(Command) , 1);
                    GoToXY(WhereX - 1, WhereY);
                    TextBackground(CommandPos.Background);
                    Write(' ');
                    GoToXY(WhereX - 1, WhereY);
                    if Editing then
                      PieceMessage
                    else
                      MoveMessage;
                  end;
      #32..#127 : if (Length(Command) < CommandLength) and
                     ((CurMenu <> LevelMenu) or   { accept only letters }
                     (ch in ['A'..'Z'])) then     { when setting Level  }
                  begin
                    Command := Command + ch;     { add Character to string }
                    NewMenu;
                    GoToPos(CommandPos, 8 + Length(Command) - 1,0);
                    Write(ch);                   { Display it              }
                  end;
    end; { case }
  until ch in [#13];
end; { GetCommand }

procedure ReadInput;
begin
  ReturnCursor;
  GetCommand(Command);
  ReturnCursor;
  ClearEOL;
end; { ReadInput }

procedure ScanKeys;
{ Scan the keyboard, and Read input }
begin
   Command :='';
   CurMenu := MainMenu;
   { We will be scanning for keys only when the game is
     playing so we will be taking input from the Main Menu }
   if KeyPressed then ReadInput;
end; { ScanKeys }

{ The following constants represent all of the user options;
  by using these constants in procedures MainOption, LevelOption
  and EditOption case statements can been used in input parsing
  routines.  These options are also used in displaying menus }
const
  Unknown     =  0;
  Multi       =  1;       { Options from the Main Menu }
  Single      =  2;
  Auto        =  3;
  Hint        =  4;
  LevelSet    =  5;
  BackOne     =  6;
  ForwardOne  =  7;
  Turn        =  8;
  EditBoard   =  9;
  Value       = 10;
  Move        = 11;
  NewOne      = 12;
  PlayIt      = 13;
  QuitMain    = 14;

  WhiteOpt    = 15;       { Edit option }
  BlackOpt    = 16;
  Clear       = 17;
  Load        = 18;
  Save        = 19;
  QuitEdit    = 20;

  NormalSet   = 21;       { Level options chosen by SetLevel }
  FullSet     = 22;
  DemoSet     = 23;
  InfiniteSet = 24;
  PlySet      = 25;
  MateSet     = 26;
  QuitLevel   = 27;

var
  CurOpt : Unknown..QuitLevel;

type
  MenuString = string[10];

const
  MainOpts  : array[Multi..QuitMain] of MenuString =
                ('MultiMove','SingleStep','AutoPlay', 'Hint',
                 'Level','Back','Forward','Turn', 'Edit',
                 'Value','Move','NewGame','Play','Quit');

  LevelOpts : array[NormalSet..QuitLevel] of MenuString =
                 ('Normal','Fulltime','Demo','Infinite',
                   'PlySearch','MateSearch','Quit');

  EditOpts  : array[WhiteOpt..QuitEdit] of MenuString =
                 ('White', 'Black', 'Clear', 'LoadBoard',
                  'SaveBoard', 'Quit');

function ThisOpt(MenuOpt : Str80) : boolean;

function UpperCase(s : Str80) : Str80;
{ function is true if the current option tested for
  is On the Command Line }
var  i : byte;
begin
  for i := 1 to Length(s) do
    s[i] := UpCase(s[i]);
  UpperCase := s;
end; { UpperCase }

begin
  ThisOpt := Pos(UpperCase(Command),UpperCase(MenuOpt)) = 1
end;

procedure MainOption;
{ Parses options from Main Menu and sets the global CurOpt to
  the current option }
var
  Opt : byte;
begin
  CurOpt := Unknown;
  Opt := Unknown;
  repeat
    if ThisOpt(MainOpts[Opt]) then
    begin
      CurOpt := Opt;
      Exit;
    end;
    Opt := Succ(Opt);
  until (Opt > QuitMain);
end; { MainOption }

procedure LevelOption;
{ Parses options from the Level Menu and sets the global
  CurOpt to the current option }
var
  Opt : byte;
begin
  CurOpt := Unknown;
  Opt := NormalSet;
  repeat
    if ThisOpt(LevelOpts[Opt]) then
    begin
      CurOpt := Opt;
      Exit;
    end;
    Opt := Succ(Opt);
  until Opt > QuitLevel;
end; { LevelOption }

procedure EditOption;
var
  Opt   : byte;
begin
  CurOpt := Unknown;
  Opt := WhiteOpt;
  repeat
    if ThisOpt( EditOpts[Opt]) then
    begin
      CurOpt := Opt;
      Exit;
    end;
    Opt := Succ(Opt);
  until Opt > QuitEdit
end; { EditOption }

procedure ReadCom(CommandStr : str80; Menu : MenuType);
{ Ask a question and Read input and determine option }
begin { ReadCom }
  CurMenu := Menu;
  Ask(CommandStr);
  ReadInput;
  case CurMenu of
    { These cases are seperated out so that there will
      not be a conflict between options that start with
      the same letter }
    MainMenu  : MainOption;
    LevelMenu : LevelOption;
    EditMenu  : EditOption;
  end;
  ClearMessage;
end; { ReadCom }

procedure SingleStepMenu;
{ Displays single step menu }
begin
  ClearMenu;
  GoToPos(SearchPos,4,-3);
  SetColor(LightColor);
  Write('<CR>');
  GoToPos(SearchPos,8,- 3);
  Write(' single steps');
  GoToPos(SearchPos,5,- 2);
  LightFirst('Quit to main menu', SearchPos);
end;  { SingleStepMenu }

procedure DisplayMove(var SingleStep : boolean;
                            MaxDepth : DepthType;
                          Evaluation : MaxType;
                              Cutoff : boolean);
{ Prints search depth, analysed move and eventually the whole
  search on the screen }
var
  Dep : DepthType;
begin  { DisplayMove }
  if Depth = 0 then
  begin
     GoToPos(DepthPos,0,0);
     Write('Depth :',MaxDepth : 7,MoveStr(MovTab[Depth]) : 7);
     ReturnCursor;
  end;
  if SingleStep then
  begin
    if (Depth < 8) then       { Singlestep mode ? }
    begin
      for Dep := Depth + 1 to 8 do
      begin
       GoToPos(SearchPos,0,Dep);
       ClrEOL;
      end;
      GoToPos(SearchPos,Depth,Depth);
      Write(MoveStr(MovTab[Depth]));
      if Cutoff then Write('   Cutoff')
      else Write(Evaluation / 256 : 9 : 2);
      Delay(250);
      PrintBoard;
      if SingleStep then
      begin
        ReadCom('',MainMenu);
        SingleStep := UpCase(Command[1]) <> 'Q';
        if not SingleStep then PrintMenu;
      end; { if }
    end { if }
    else;                                         { Depth >= 8 }
  end { if }
  else;                                       { not SingleStep }
end; { DisplayMove }