/*
	window.C

	Copyright (C) 1987-1995, Geoff Friesen 
	All rights reserved.
*/

#define INCL_WINDOW

#ifndef INCL_VBORDER
#include "vborder.C"
#endif

#ifndef INCL_VCPUTS
#include "vcputs.C"
#endif

#ifndef INCL_VGETATTR
#include "vgetattr.C"
#endif

#ifndef INCL_VGOTOXY
#include "vgotoxy.C"
#endif

#ifndef INCL_VPAINT
#include "vpaint.C"
#endif

#ifndef INCL_VPUTCH
#include "vputch.C"
#endif

#ifndef INCL_VSCREEN
#include "vscreen.C"
#endif

#ifndef INCL_VSCROLL
#include "vscroll.C"
#endif

#ifndef INCL_VSETATTR
#include "vsetattr.C"
#endif

#ifndef INCL_VWHEREX                         
#include "vwherex.C"
#endif

#ifndef INCL_VWHEREY
#include "vwherey.C"
#endif

/* -------------------------------------------------------------- */
/* void w_create (WINDOW *w);                                     */
/*                                                                */
/* Create a window using data supplied in the window structure w. */
/* The contents of the screen underlying the window is saved and  */
/* the current cursor position is saved.  A single line border is */
/* drawn.  The title is drawn along with a close box.  Optional   */
/* horizontal and vertical scroll bars are drawn.  Finally, the   */
/* interior is blanked and the cursor positioned to the upper-    */
/* left corner of the window's interior.                          */
/* -------------------------------------------------------------- */

void w_create (WINDOW *w)
{
   int i;

   v_screen (SCREEN_SAVE, w->x, w->y, w->nx, w->ny, w->scrn_buffer); 
   w->scrn_x = v_wherex ();
   w->scrn_y = v_wherey ();

   v_setattr (w->bdattr);

   v_border (SINGLE_LINE, w->x, w->y, w->nx, w->ny);

   v_setattr (w->tlattr);
   v_gotoxy (w->x+6, w->y);
   v_cputs (w->title);

   v_setattr (LIGHTGRAY);

   v_gotoxy (w->x+1, w->y);
   v_cputs ("[]");

   if (w->flags & WINF_HBAR)
   {
       v_gotoxy (w->x+1, w->y+w->ny-1);
       v_putch (0x1b, 1);
       v_putch ('', 1);
       v_putch ('', w->nx-5);
       v_putch (0x1a, 1);
   }

   if (w->flags & WINF_VBAR)
   {
       v_gotoxy (w->x+w->nx-1, w->y+1);
       v_putch (0x18, 1);

       v_gotoxy (w->x+w->nx-1, w->y+2);
       v_putch ('', 1);

       for (i = 2; i <= w->ny-4; i++)
       {
	    v_gotoxy (w->x+w->nx-1, w->y+1+i);
	    v_putch ('', 1);
       }

       v_gotoxy (w->x+w->nx-1, w->y+w->ny-2);
       v_putch (0x19, 1);
   }

   v_setattr (w->txattr);
   v_paint (' ', w->x+1, w->y+1, w->nx-2, w->ny-2);
}

/* ---------------------------------------------------------------- */
/* void w_destroy (WINDOW *w);                                      */
/*                                                                  */
/* Destroy the window specified by the window structure w.  This is */
/* accomplished by restoring the underlying screen contents and the */
/* cursor position.  It is important to destroy windows in the      */
/* opposite order to which they were created.                       */
/* ---------------------------------------------------------------- */

void w_destroy (WINDOW *w)                           
{
   v_screen (SCREEN_RESTORE, w->x, w->y, w->nx, w->ny, w->scrn_buffer); 
   v_gotoxy (w->scrn_x, w->scrn_y);
}

/* -------------------------------------------------------------- */
/* void w_gotoxy (WINDOW *w, int x, int y);                       */
/*                                                                */
/* Set the cursor position within the window specified by w.  The */
/* x (horizontal) and y (vertical) coordinates should be relative */
/* to 1.                                                          */
/* -------------------------------------------------------------- */

void w_gotoxy (WINDOW *w, int x, int y)
{
   w->curx = x;
   w->cury = y;
}

/* ------------------------------------------------------------ */
/* void w_puts (WINDOW *w, char *text);                         */
/*                                                              */
/* Draw text in the window specified by w.  The cursor is first */
/* positioned to its most recent location  and then text is     */
/* drawn one character at a time.  Care is taken to ensure that */
/* text does not scroll past the right side.  When the right    */
/* side is reached, text wraps around to the next line.  If     */
/* the cursor is in the lower-right position then the window is */
/* scrolled up one line before the next character is displayed. */
/* The current cursor position is updated to the position after */
/* the last character is displayed.                             */
/* ------------------------------------------------------------ */

void w_puts (WINDOW *w, char *text)
{
   v_gotoxy (w->curx+w->x, w->cury+w->y);

   while (*text)
   {
      v_putch (*text, 1);
      if (v_wherex () > w->x+w->nx-2)
      {
	  v_gotoxy (w->x+1, v_wherey ()+1);
	  if (v_wherey () > w->y+w->ny-2)
	  {
	      v_scroll (w->x+1, w->y+1, w->nx-2, w->ny-2, SCROLL_UP, 1,
			w->txattr);
	      v_gotoxy (w->x+1, w->y+w->ny-2);
	  }
      }
      text++;
   }

   w->curx = v_wherex ();
   w->cury = v_wherey ();
}

/* ---------------------------------------------------------------- */
/* void w_scroll (WINDOW *w, int dir);                              */
/*                                                                  */
/* Scroll the window specified by w up or down one line (specified) */
/* by the dir argument.                                             */
/* ---------------------------------------------------------------- */

void w_scroll (WINDOW *w, int dir)
{
   v_scroll (w->x+1, w->y+1, w->nx-2, w->ny-2, dir, 1, w->txattr); 
}

/* --------------------------------------------------------------- */
/* void w_setscrollpos (WINDOW *w, int bar, int pos);              */
/*                                                                 */
/* Set the position of the thumb character on either the horizonal */
/* or vertical scrollbar (as specified by bar - use the WINF_HBAR  */
/* or WINF_VBAR constants defined in TSRLIB.H).  The position, as  */
/* specified by pos, is relative to 0.                             */
/* --------------------------------------------------------------- */

void w_setscrollpos (WINDOW *w, int bar, int pos)
{
   int i;

   if (bar == WINF_HBAR)
   {
       v_gotoxy (w->x+2, w->y+w->ny-1);
       v_putch ('', w->nx-4);
       v_gotoxy (w->x+2+pos, w->y+w->ny-1);
       v_putch ('', 1);
   }
   else
   {
	for (i = 1; i <= w->ny-4; i++)
	{
	     v_gotoxy (w->x+w->nx-1, w->y+1+i);
	     v_putch ('', 1);
	}

	v_gotoxy (w->x+w->nx-1, w->y+2+pos);
	v_putch ('', 1);
   } 
}
