/*
	vscreen.C

	Copyright (C) 1987-1995, Geoff Friesen 
	All rights reserved.
*/

#define INCL_VSCREEN

void v_screen (int cmd, int x, int y, int nx, int ny, void *buffer)
{
   int cols;
   char mode, page;

   asm push ds

   asm mov ah, 15
   VIDEO_INT

   asm mov mode, al
   asm mov BYTE PTR cols, ah
   asm mov BYTE PTR cols [1], 0
   asm shl WORD PTR cols, 1
   asm mov page, bh

   asm push ds
   asm pop es

   asm mov ax, 0b000h
   asm cmp BYTE PTR mode, MONO
   asm jz v_screen0

   asm add ah, page
   asm add ah, 8

v_screen0:

   asm mov si, ax

   asm cmp BYTE PTR cmd, 0
   asm jnz v_screen1

   asm mov ds, si
   asm sub si, si
   asm mov di, buffer
   asm jmp SHORT v_screen2

v_screen1:

   asm mov es, si
   asm sub di, di
   asm mov si, buffer

v_screen2:

   asm mov ax, y
   asm dec ax
   asm mov cx, cols
   asm mul cx
   asm mov cx, x
   asm dec cx
   asm shl cx, 1
   asm add ax, cx

   asm cmp BYTE PTR cmd, 0
   asm jnz v_screen3

   asm add si, ax
   asm jmp SHORT v_screen4

v_screen3:

   asm add di, ax

v_screen4:

   asm mov bx, ny
   asm mov cx, nx
   asm cld

v_screen5:

   asm rep movsw

   asm dec bx
   asm jz v_screen7

   asm cmp BYTE PTR cmd, 0
   asm jnz v_screen6

   asm sub si, nx
   asm sub si, nx
   asm add si, cols
   asm mov cx, nx
   asm jmp SHORT v_screen5

v_screen6:

   asm sub di, nx
   asm sub di, nx
   asm add di, cols
   asm mov cx, nx
   asm jmp SHORT v_screen5

v_screen7:

   asm pop ds
}
