/*
	vcprintf.C

	Copyright (C) 1987-1995, Geoff Friesen 
	All rights reserved.
*/

#define INCL_VCPRINTF

#ifndef INCL_FORMAT
#include "format.C"
#endif

#ifndef INCL_VPUTCH
#include "vputch.C"
#endif

void v_cprintf_putc (int c);

/* ---------------------------------------------------------- */
/* int v_cprintf (const char *fmt, ...);                      */
/*                                                            */
/* Output a formatted string to the screen.  The fmt argument */
/* specifies a string of literal characters and format speci- */
/* fiers.  A variable number of arguments (depending upon the */
/* number of format specifiers) follows.  This function calls */
/* the format function to perform the actual formatting.  The */
/* local function is used to output to the screen.  The fol-  */
/* lowing format specifiers are valid: c (character), d or i  */
/* (integer), u (unsigned integer), X (uppercase hex) or x    */
/* (lowercase hex).  The return value specifies the number of */
/* characters output.                                         */
/* ---------------------------------------------------------- */

int v_cprintf (const char *fmt, ...)
{
   return format (v_cprintf_putc, fmt, (void *) ...);
}

void v_cprintf_putc (int c)
{
   v_putch (c, 1);
}
