/*
	vborder.C

	Copyright (C) 1987-1995, Geoff Friesen 
	All rights reserved.
*/

#define INCL_VBORDER

#ifndef INCL_VGOTOXY
#include "vgotoxy.C"
#endif

#ifndef INCL_VPUTCH
#include "vputch.C"
#endif

void v_border (int style, int x, int y, int nx, int ny)
{
   int i, hline, llcorner, lrcorner, ulcorner, urcorner, vline;

   if (style == NOBORDER)
       return;

   ulcorner = "" [style];
   urcorner = "" [style];
   llcorner = "" [style];
   lrcorner = "ټ" [style];
   hline = "" [style];
   vline = "" [style];

   v_gotoxy (x, y);
   v_putch (ulcorner, 1);
   v_putch (hline, nx-2);
   v_putch (urcorner, 1);

   for (i = 0; i < ny-2; i++)
   {
	v_gotoxy (x, y+1+i);
	v_putch (vline, 1);
	v_gotoxy (x+nx-1, y+1+i);
	v_putch (vline, 1);
   }

   v_gotoxy (x, y+ny-1);
   v_putch (llcorner, 1);
   v_putch (hline, nx-2);
   v_putch (lrcorner, 1);
}
